/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.internal.data.geography.infrastructure.transportation.specifications;

import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.emf.common.util.URI;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.EdgeLabel;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.LabelValue;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.impl.EdgeImpl;
import org.eclipse.stem.data.geography.ISOKey;
import org.eclipse.stem.definitions.labels.LabelsFactory;
import org.eclipse.stem.definitions.labels.PopulationLabel;
import org.eclipse.stem.definitions.labels.RelativePhysicalRelationship;
import org.eclipse.stem.definitions.labels.RelativePhysicalRelationshipLabel;
import org.eclipse.stem.definitions.labels.RelativePhysicalRelationshipLabelValue;
import org.eclipse.stem.definitions.labels.TransportRelationshipLabel;
import org.eclipse.stem.definitions.labels.TransportRelationshipLabelValue;
import org.eclipse.stem.definitions.transport.PipeStyleTransportSystem;
import org.eclipse.stem.definitions.transport.PipeTransportEdge;
import org.eclipse.stem.definitions.transport.PipeTransportEdgeLabel;
import org.eclipse.stem.definitions.transport.PipeTransportEdgeLabelValue;
import org.eclipse.stem.definitions.transport.TransportFactory;
import org.eclipse.stem.internal.data.geography.infrastructure.transportation.propertydata.AirTransportGeographicRelationshipPropertyData;
import org.eclipse.stem.internal.data.geography.infrastructure.transportation.specifications.TransportationGeographicRelationshipPropertyFileSpecification;
import org.eclipse.stem.internal.data.propertydata.PropertyData;
import org.eclipse.stem.internal.data.propertydata.RelationshipPropertyData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AirTransportationGeographicRelationshipPropertyFileSpecification
extends TransportationGeographicRelationshipPropertyFileSpecification {
    public static final String AIR_TRANSPORTATION_EDGE_NAME = "air";
    public static final String TRANSPORTATION_MODE_PROPERTY = "TRANSPORT_MODE";
    public static final String POPULATION_ID_PROPERTY = "POPULATION_IDENTIFIER";
    public static final String RATE_TIME_PERIOD_PROPERTY = "RATE_TIME_PERIOD";
    public static final String AVG_TIME_IN_SYSTEM_PROPERTY = "AVG_TIME_IN_SYSTEM";
    private String transportationMode;
    private String populationIdentifier;
    private int rateTimePeriod;
    private double averageTimeInSystem;

    protected void collectPropertyDataSet(Properties properties) {
        this.collectNonDataProperties(properties);
        this.transportationMode = properties.getProperty(TRANSPORTATION_MODE_PROPERTY).trim();
        this.populationIdentifier = properties.getProperty(POPULATION_ID_PROPERTY).trim();
        this.rateTimePeriod = Integer.parseInt(properties.getProperty(RATE_TIME_PERIOD_PROPERTY).trim());
        this.averageTimeInSystem = Double.parseDouble(properties.getProperty(AVG_TIME_IN_SYSTEM_PROPERTY).trim());
        properties.remove(TRANSPORTATION_MODE_PROPERTY);
        properties.remove(POPULATION_ID_PROPERTY);
        properties.remove(RATE_TIME_PERIOD_PROPERTY);
        properties.remove(AVG_TIME_IN_SYSTEM_PROPERTY);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String string = (String)entry.getKey();
            PropertyData propertyData = this.createPropertyDataInstanceFromProperty(string, ((String)entry.getValue()).trim());
            if (propertyData == null) continue;
            this.propertyDataSet.add(propertyData);
        }
    }

    protected EdgeLabel createEdgeLabel(RelationshipPropertyData relationshipPropertyData) {
        AirTransportGeographicRelationshipPropertyData airTransportGeographicRelationshipPropertyData = (AirTransportGeographicRelationshipPropertyData)relationshipPropertyData;
        TransportRelationshipLabel transportRelationshipLabel = LabelsFactory.eINSTANCE.createTransportRelationshipLabel();
        TransportRelationshipLabelValue transportRelationshipLabelValue = LabelsFactory.eINSTANCE.createTransportRelationshipLabelValue();
        transportRelationshipLabelValue.setAvailableDepartureCapacityProportion(airTransportGeographicRelationshipPropertyData.getArrivalRate());
        transportRelationshipLabel.setCurrentValue((LabelValue)transportRelationshipLabelValue);
        return transportRelationshipLabel;
    }

    protected String getRelationshipName() {
        return AIR_TRANSPORTATION_EDGE_NAME;
    }

    protected PropertyData createPropertyDataInstanceFromProperty(String string, String string2) {
        AirTransportGeographicRelationshipPropertyData airTransportGeographicRelationshipPropertyData = null;
        try {
            airTransportGeographicRelationshipPropertyData = new AirTransportGeographicRelationshipPropertyData(string, string2);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            System.err.println("Key:" + string + " Value:" + string2);
            System.err.println(parseException.getMessage());
        }
        return airTransportGeographicRelationshipPropertyData;
    }

    protected void initializeIdentifiableFromPropertyDataSet(Identifiable identifiable, List<PropertyData> list) {
        Graph graph = (Graph)identifiable;
        HashMap<ISOKey, PipeStyleTransportSystem> hashMap = new HashMap<ISOKey, PipeStyleTransportSystem>();
        HashMap<ISOKey, Double> hashMap2 = this.getTransportSystemCapacity(list);
        List<PropertyData> list2 = list;
        for (PropertyData propertyData : list2) {
            double d;
            ISOKey iSOKey;
            AirTransportGeographicRelationshipPropertyData airTransportGeographicRelationshipPropertyData = (AirTransportGeographicRelationshipPropertyData)propertyData;
            PipeStyleTransportSystem pipeStyleTransportSystem = (PipeStyleTransportSystem)hashMap.get(airTransportGeographicRelationshipPropertyData.getTransportationSystemISOKey());
            if (pipeStyleTransportSystem == null) {
                iSOKey = airTransportGeographicRelationshipPropertyData.getTransportationSystemISOKey();
                d = hashMap2.get(iSOKey);
                pipeStyleTransportSystem = this.createTransportSystem(iSOKey, 0.0, d);
                hashMap.put(iSOKey, pipeStyleTransportSystem);
                graph.putNode((Node)pipeStyleTransportSystem);
            }
            iSOKey = this.createNodeURI(airTransportGeographicRelationshipPropertyData.getTransportationSystemISOKey(), airTransportGeographicRelationshipPropertyData.getRegionISOKey());
            d = airTransportGeographicRelationshipPropertyData.getDepartureRate();
            double d2 = airTransportGeographicRelationshipPropertyData.getArrivalRate();
            PipeTransportEdge pipeTransportEdge = this.createPipeTransportEdge((URI)iSOKey, pipeStyleTransportSystem.getURI(), d);
            graph.putEdge((Edge)pipeTransportEdge);
            PipeTransportEdge pipeTransportEdge2 = this.createPipeTransportEdge(pipeStyleTransportSystem.getURI(), (URI)iSOKey, d2);
            graph.putEdge((Edge)pipeTransportEdge2);
            URI uRI = this.createTransportSystemURI(airTransportGeographicRelationshipPropertyData.getRegionISOKey());
            pipeTransportEdge = this.createPipeTransportEdge(uRI, pipeStyleTransportSystem.getURI(), d);
            graph.putEdge((Edge)pipeTransportEdge);
            pipeTransportEdge2 = this.createPipeTransportEdge(pipeStyleTransportSystem.getURI(), uRI, d2);
            graph.putEdge((Edge)pipeTransportEdge2);
        }
    }

    protected HashMap<ISOKey, Double> getTransportSystemCapacity(List<PropertyData> list) {
        HashMap<ISOKey, Double> hashMap = new HashMap<ISOKey, Double>();
        for (PropertyData propertyData : list) {
            AirTransportGeographicRelationshipPropertyData airTransportGeographicRelationshipPropertyData = (AirTransportGeographicRelationshipPropertyData)propertyData;
            ISOKey iSOKey = airTransportGeographicRelationshipPropertyData.getTransportationSystemISOKey();
            double d = (airTransportGeographicRelationshipPropertyData.getArrivalRate() + airTransportGeographicRelationshipPropertyData.getDepartureRate()) / 2.0;
            if (hashMap.containsKey(iSOKey)) {
                hashMap.put(iSOKey, hashMap.get(iSOKey) + d);
                continue;
            }
            hashMap.put(iSOKey, d);
        }
        return hashMap;
    }

    protected PipeStyleTransportSystem createTransportSystem(ISOKey iSOKey, double d, double d2) {
        PipeStyleTransportSystem pipeStyleTransportSystem = TransportFactory.eINSTANCE.createPipeStyleTransportSystem();
        String string = "node/transport/pipe/" + iSOKey.toString();
        pipeStyleTransportSystem.setURI(STEMURI.createURI((String)string));
        PopulationLabel populationLabel = LabelsFactory.eINSTANCE.createPopulationLabel();
        populationLabel.setPopulationIdentifier(this.getPopulationIdentifier());
        populationLabel.getCurrentPopulationValue().setCount(d);
        populationLabel.setIdentifiable((Identifiable)pipeStyleTransportSystem);
        populationLabel.setPopulatedArea(1.0);
        pipeStyleTransportSystem.getLabels().add((Object)populationLabel);
        pipeStyleTransportSystem.setMaxCapacity(d2);
        return pipeStyleTransportSystem;
    }

    protected URI createTransportSystemURI(ISOKey iSOKey) {
        String string = "node/transport/pipe/" + iSOKey.toString();
        URI uRI = STEMURI.createURI((String)string);
        return uRI;
    }

    public final String getPopulationIdentifier() {
        return this.populationIdentifier;
    }

    private PipeTransportEdge createPipeTransportEdge(URI uRI, URI uRI2, double d) {
        PipeTransportEdge pipeTransportEdge = TransportFactory.eINSTANCE.createPipeTransportEdge();
        pipeTransportEdge.setNodeAURI(uRI);
        pipeTransportEdge.setNodeBURI(uRI2);
        PipeTransportEdgeLabel pipeTransportEdgeLabel = TransportFactory.eINSTANCE.createPipeTransportEdgeLabel();
        PipeTransportEdgeLabelValue pipeTransportEdgeLabelValue = TransportFactory.eINSTANCE.createPipeTransportEdgeLabelValue();
        pipeTransportEdgeLabelValue.setMaxFlow(d);
        pipeTransportEdgeLabelValue.setTimePeriod((long)this.rateTimePeriod);
        pipeTransportEdgeLabel.setCurrentValue((LabelValue)pipeTransportEdgeLabelValue);
        pipeTransportEdge.setLabel((EdgeLabel)pipeTransportEdgeLabel);
        return pipeTransportEdge;
    }

    private Edge createContainmentEdge(AirTransportGeographicRelationshipPropertyData airTransportGeographicRelationshipPropertyData, PipeStyleTransportSystem pipeStyleTransportSystem) {
        Edge edge = EdgeImpl.createEdge((URI)this.createNodeURI(this.isoKeyB, airTransportGeographicRelationshipPropertyData.getTransportationSystemISOKey()), (URI)pipeStyleTransportSystem.getURI(), (boolean)true);
        RelativePhysicalRelationshipLabel relativePhysicalRelationshipLabel = LabelsFactory.eINSTANCE.createRelativePhysicalRelationshipLabel();
        relativePhysicalRelationshipLabel.setURIOfIdentifiableToBeLabeled(edge.getURI());
        relativePhysicalRelationshipLabel.getCurrentRelationship().setRelationship(RelativePhysicalRelationship.CONTAINS_LITERAL);
        RelativePhysicalRelationshipLabelValue relativePhysicalRelationshipLabelValue = LabelsFactory.eINSTANCE.createRelativePhysicalRelationshipLabelValue();
        relativePhysicalRelationshipLabelValue.setAdjacent(false);
        relativePhysicalRelationshipLabelValue.setRelationship(RelativePhysicalRelationship.CONTAINS_LITERAL);
        relativePhysicalRelationshipLabel.setCurrentValue((LabelValue)relativePhysicalRelationshipLabelValue);
        StringBuilder stringBuilder = new StringBuilder("edge/relationship/relativephysical/");
        stringBuilder.append(airTransportGeographicRelationshipPropertyData.getTransportationSystemISOKey());
        stringBuilder.append("_");
        stringBuilder.append(airTransportGeographicRelationshipPropertyData.getTransportationSystemISOKey());
        stringBuilder.append("-");
        stringBuilder.append(this.transportationMode);
        stringBuilder.append("/");
        stringBuilder.append(RelativePhysicalRelationship.CONTAINS_LITERAL.toString().toLowerCase());
        edge.setURI(STEMURI.createURI((String)stringBuilder.toString()));
        relativePhysicalRelationshipLabel.setURI(STEMURI.createURI((String)stringBuilder.toString()));
        edge.setLabel((EdgeLabel)relativePhysicalRelationshipLabel);
        relativePhysicalRelationshipLabel.setURIOfIdentifiableToBeLabeled(edge.getURI());
        return edge;
    }
}

