/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.internal.data.specifications;

import java.io.File;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.stem.core.Utility;
import org.eclipse.stem.core.model.Model;
import org.eclipse.stem.core.model.ModelPackage;
import org.eclipse.stem.data.geography.ISOKey;
import org.eclipse.stem.diseasemodels.standard.DiseaseModel;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.internal.data.generatedplugin.DublinCore;
import org.eclipse.stem.internal.data.geography.specifications.AdminLevelSet;
import org.eclipse.stem.internal.data.specifications.GraphPropertyFileSpecification;
import org.eclipse.stem.internal.data.specifications.ModelSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiseaseModelModelSpecification
extends ModelSpecification
implements Comparable<DiseaseModelModelSpecification> {
    private final ModelPackage modelPackage = ModelPackage.eINSTANCE;
    private final StandardPackage standardPackage = StandardPackage.eINSTANCE;
    private final DublinCore populationModelDC;
    private final DublinCore diseaseModelDC;
    private final DiseaseModel diseaseModel;
    private final ISOKey isoKey;
    private final AdminLevelSet adminLevelSet;
    private final String diseaseName;

    static {
        String string = System.getProperty("user.dir");
        String string2 = string.substring(0, string.lastIndexOf(File.separator));
        String string3 = String.valueOf(string2) + File.separator + "org.eclipse.stem.data.geography.population.human.models" + File.separator;
        String string4 = String.valueOf(string2) + File.separator + "org.eclipse.stem.diseases" + File.separator;
        Map map = EcorePlugin.getPlatformResourceMap();
        map.put("org.eclipse.stem.data.geography.population.human.models", URI.createFileURI((String)string3));
        map.put("org.eclipse.stem.diseases", URI.createFileURI((String)string4));
    }

    public DiseaseModelModelSpecification(ISOKey iSOKey, AdminLevelSet adminLevelSet, DublinCore dublinCore, DublinCore dublinCore2, DiseaseModel diseaseModel) {
        this.isoKey = iSOKey;
        this.adminLevelSet = adminLevelSet;
        this.populationModelDC = dublinCore;
        this.diseaseModelDC = dublinCore2;
        this.diseaseModel = diseaseModel;
        this.diseaseName = diseaseModel.getDiseaseName();
    }

    protected Model createIdentifiableInstance() {
        Model model = super.createIdentifiableInstance();
        model.getModels().add((Object)((Model)Utility.getIdentifiable((URI)DiseaseModelModelSpecification.getIdentifiableProjectURI((DublinCore)this.populationModelDC))));
        model.getNodeDecorators().add((Object)this.diseaseModel);
        return model;
    }

    @Override
    public int compareTo(DiseaseModelModelSpecification diseaseModelModelSpecification) {
        return this.adminLevelSet.getNumAdminLevels() > diseaseModelModelSpecification.adminLevelSet.getNumAdminLevels() ? 1 : -1;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.isoKey);
        stringBuilder.append(":");
        stringBuilder.append(this.diseaseName);
        stringBuilder.append(" ");
        stringBuilder.append(this.adminLevelSet.toString());
        return stringBuilder.toString();
    }

    protected String getRelativeSerializationPath() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("country");
        stringBuilder.append(File.separatorChar);
        stringBuilder.append(this.isoKey.toString());
        return stringBuilder.toString();
    }

    protected String getSerializationFileNameRoot() {
        StringBuilder stringBuilder = new StringBuilder(this.isoKey.toString());
        stringBuilder.append("_");
        stringBuilder.append(this.adminLevelSet.toString());
        stringBuilder.append("_disease_");
        stringBuilder.append(this.diseaseName.replace(" ", "_"));
        return stringBuilder.toString();
    }

    protected String getTargetPluginId() {
        return "org.eclipse.stem.data.diseasemodels.models";
    }

    protected String getTitleDescriptor() {
        StringBuilder stringBuilder = new StringBuilder(this.isoKey.toString());
        stringBuilder.append(" Disease ");
        stringBuilder.append(this.diseaseName);
        stringBuilder.append(this.adminLevelSet.getNumAdminLevels() > 1 ? " (Levels: " : " (Level: ");
        stringBuilder.append(this.adminLevelSet.toString(","));
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    protected String createDubinCoreCoverage() {
        return this.populationModelDC.getCoverage();
    }

    protected String createDubinCoreSubject() {
        return GraphPropertyFileSpecification.createDublinCoreSubjectString((String)ModelPackage.Literals.MODEL.getName(), (String)"disease");
    }
}

