/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.reports;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.emf.common.util.URI;
import org.eclipse.stem.ui.reports.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitorPreferences {
    Plugin plugin = Activator.getDefault();
    Preferences prefs = this.plugin.getPluginPreferences();
    private Set<String> monitorLocationPreferences = new HashSet<String>();
    private static final String DEFAULT_LOCATION_ID = "stem://org.eclipse.stem/node/geo/region/ZZZ";
    private static final String URI_PREFIX = "stem://org.eclipse.stem/node/geo/region/";
    private static final String LOCATION_KEY_SUBSTRING = "location.";
    private static final String DEFAULT_LOCATION_KEY = "default.locationID";
    public static final String REFERENCE_FILE_KEY = "reference.file";

    public MonitorPreferences() {
        String[] stringArray;
        if (this.prefs.contains(DEFAULT_LOCATION_KEY)) {
            stringArray = this.prefs.getString(DEFAULT_LOCATION_KEY);
            if (stringArray != DEFAULT_LOCATION_ID) {
                this.setDefaultLocation();
            } else {
                this.monitorLocationPreferences.add((String)stringArray);
            }
        } else {
            this.setDefaultLocation();
        }
        stringArray = this.prefs.propertyNames();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].contains(LOCATION_KEY_SUBSTRING) || stringArray[n].contains(DEFAULT_LOCATION_KEY)) {
                String string = this.prefs.getString(stringArray[n]);
                this.monitorLocationPreferences.add(string);
            }
            ++n;
        }
    }

    public void setDefaultLocation() {
        this.prefs.setValue(DEFAULT_LOCATION_KEY, DEFAULT_LOCATION_ID);
        this.monitorLocationPreferences.add(DEFAULT_LOCATION_ID);
        this.plugin.savePluginPreferences();
    }

    public Set<String> getMonitorLocationPreferences() {
        return this.monitorLocationPreferences;
    }

    public void setMonitorLocationPreferences(Set<String> set) {
        this.monitorLocationPreferences = set;
    }

    public void addLocationPref(String string) {
        if (this.prefs != null && !this.monitorLocationPreferences.contains(string)) {
            this.prefs.setValue(LOCATION_KEY_SUBSTRING + string, string);
            this.monitorLocationPreferences.add(string);
            this.plugin.savePluginPreferences();
        }
    }

    public void removeLocationPref(String string) {
        if (this.prefs != null) {
            if (!this.monitorLocationPreferences.contains(string)) {
                this.monitorLocationPreferences.remove(string);
            }
            this.plugin.savePluginPreferences();
        }
    }

    public static String getURIsuffix(String string) {
        String string2 = string.replaceAll(URI_PREFIX, "");
        return string2;
    }

    public static URI getDefaultURI() {
        return URI.createURI((String)DEFAULT_LOCATION_ID);
    }
}

