/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.reports.views;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.stem.ui.reports.Activator;
import org.eclipse.stem.ui.reports.views.AggregateFileInitializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregateReferenceFileLoader {
    private String dataFile = "";
    private static final String CSV_EXTENSION = ".csv";
    private static final String TXT_EXTENSION = ".txt";
    private List<Double> aggregateData = new ArrayList<Double>();
    private Set<String> idSet = new HashSet<String>();
    private File scenarioData = null;
    private static final String[] ignoreKeys = new String[]{"time", "iteration"};

    public AggregateReferenceFileLoader(String string) throws AggregateFileInitializationException {
        this.dataFile = string;
        this.scenarioData = new File(this.dataFile);
        if (!this.isDataFile(this.scenarioData)) {
            throw new AggregateFileInitializationException("Not a valid data file, must be .csv or .txt");
        }
        this.aggregateData = this.processFile();
    }

    private boolean isDataFile(File file) {
        boolean bl = true;
        String string = file.getName();
        if (string.indexOf(TXT_EXTENSION) < 0 && string.indexOf(CSV_EXTENSION) < 0) {
            bl = false;
        }
        return bl;
    }

    public List<Double> processFile() throws AggregateFileInitializationException {
        Object object;
        List list;
        int n = 0;
        HashMap<String, List> hashMap = new HashMap<String, List>();
        try {
            int n2 = 0;
            list = new ArrayList<String>();
            FileInputStream fileInputStream = new FileInputStream(this.scenarioData);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            String string = bufferedReader.readLine();
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken(",");
                    list.add(string2.trim());
                }
            }
            int n3 = list.size();
            int n4 = 0;
            while (n4 < n3) {
                String string3 = (String)list.get(n4);
                if (this.validate(string3)) {
                    hashMap.put(string3, new ArrayList());
                }
                ++n4;
            }
            while ((object = bufferedReader.readLine()) != null) {
                ++n2;
                StringTokenizer stringTokenizer = new StringTokenizer((String)object);
                int n5 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken(",");
                    String string5 = (String)list.get(n5);
                    if (this.validate(string5)) {
                        this.idSet.add(string5);
                        List list2 = (List)hashMap.get(string5);
                        try {
                            Double d = new Double(string4.trim());
                            list2.add(d);
                            if (list2.size() >= n) {
                                n = list2.size();
                            }
                            hashMap.put(string5, list2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            hashMap.remove(string5);
                            this.idSet.remove(string5);
                            Activator.logInformation("Not a valid number (" + string4 + ") ... Removing key " + string5, null);
                        }
                    }
                    ++n5;
                }
            }
        }
        catch (IOException iOException) {
            Activator.logError(" IOException error!", iOException);
            throw new AggregateFileInitializationException(iOException);
        }
        object = new ArrayList();
        int n6 = 0;
        while (n6 < n) {
            object.add(n6, new Double(0.0));
            ++n6;
        }
        Iterator<String> iterator = this.idSet.iterator();
        while (iterator != null && iterator.hasNext()) {
            String string = iterator.next();
            list = (List)hashMap.get(string);
            int n7 = 0;
            while (n7 < n) {
                double d = (Double)object.get(n7);
                object.set(n7, new Double(d += ((Double)list.get(n7)).doubleValue()));
                ++n7;
            }
        }
        return object;
    }

    public Map<String, List<String>> processIncidenceFile(String string) throws AggregateFileInitializationException {
        File file = new File(string);
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        try {
            String string2;
            int n = 0;
            ArrayList<String> arrayList = new ArrayList<String>();
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            String string3 = bufferedReader.readLine();
            if (string3 != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string3);
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken(",");
                    arrayList.add(string4.trim());
                }
            }
            int n2 = arrayList.size();
            int n3 = 0;
            while (n3 < n2) {
                String string5 = (String)arrayList.get(n3);
                hashMap.put(string5, new ArrayList());
                ++n3;
            }
            while ((string2 = bufferedReader.readLine()) != null) {
                ++n;
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                int n4 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    String string6 = stringTokenizer.nextToken(",");
                    String string7 = (String)arrayList.get(n4);
                    hashMap.get(string7).add(string6.trim());
                    ++n4;
                }
            }
        }
        catch (IOException iOException) {
            Activator.logError(" IOException error!", iOException);
            throw new AggregateFileInitializationException(iOException);
        }
        return hashMap;
    }

    private boolean validate(String string) {
        int n = 0;
        while (n < ignoreKeys.length) {
            String string2 = string.trim();
            if (string2.equalsIgnoreCase(ignoreKeys[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected static boolean EOF(String string) {
        return string == null || string.length() == 0;
    }

    public List<Double> getAggregateData() {
        return this.aggregateData;
    }

    public Set<String> getIdSet() {
        return this.idSet;
    }
}

