/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.reports.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProvider;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapter;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapterFactory;
import org.eclipse.stem.definitions.adapters.relativevalue.history.RelativeValueHistoryExtendedListener;
import org.eclipse.stem.definitions.adapters.relativevalue.history.RelativeValueHistoryProvider;
import org.eclipse.stem.definitions.adapters.relativevalue.history.RelativeValueHistoryProviderAdapter;
import org.eclipse.stem.definitions.adapters.relativevalue.history.RelativeValueHistoryProviderAdapterFactory;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.ISimulationListener;
import org.eclipse.stem.jobs.simulation.ISimulationListenerSync;
import org.eclipse.stem.jobs.simulation.SimulationEvent;
import org.eclipse.stem.jobs.simulation.SimulationState;
import org.eclipse.stem.ui.reports.Activator;
import org.eclipse.stem.ui.reports.views.AggregateReferenceFileLoader;
import org.eclipse.stem.ui.reports.views.AggregateTimeSeriesCanvas;
import org.eclipse.stem.ui.reports.views.Messages;
import org.eclipse.stem.ui.reports.views.ReportControl;
import org.eclipse.stem.ui.widgets.PropertySelector;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregateValueHistoryPlotter
extends ReportControl
implements ISimulationListenerSync {
    AggregateTimeSeriesCanvas aggregateSeriesCanvas;
    PropertySelector propertySelector;
    List<ItemPropertyDescriptor> selectedProperties;
    Set<ItemPropertyDescriptor> allProperties = new HashSet<ItemPropertyDescriptor>();
    Map<String, List<Double>> dataMap = new HashMap<String, List<Double>>();
    List<Double> aggregateReference = new ArrayList<Double>();
    Set<String> referenceIDs = new HashSet<String>();
    String selectedReferenceFile;
    Set<RelativeValueProviderAdapter> relativeValueProviderSet = new HashSet<RelativeValueProviderAdapter>();
    double totalPopulation = 1.0;
    Graph graph = null;
    int timeCount = 0;
    protected static final String REFERENCE_PROPERTY = "ref";
    Set<ISimulation> activeSimulations = new HashSet<ISimulation>();
    private final PropertySieve propertySieve = new PropertySieve(){

        @Override
        public List<ItemPropertyDescriptor> sieve(DynamicLabel dynamicLabel) {
            ArrayList<ItemPropertyDescriptor> arrayList = new ArrayList<ItemPropertyDescriptor>();
            RelativeValueProviderAdapter relativeValueProviderAdapter = (RelativeValueProviderAdapter)RelativeValueProviderAdapterFactory.INSTANCE.adapt((Notifier)dynamicLabel, RelativeValueProvider.class);
            if (relativeValueProviderAdapter != null) {
                relativeValueProviderAdapter.setTarget((Notifier)dynamicLabel);
                for (Object e : relativeValueProviderAdapter.getProperties()) {
                    ItemPropertyDescriptor itemPropertyDescriptor = (ItemPropertyDescriptor)e;
                    arrayList.add(itemPropertyDescriptor);
                }
            }
            return arrayList;
        }
    };

    public AggregateValueHistoryPlotter(Composite composite) {
        super(composite, 0);
        this.simulation = null;
        this.dataMap.put(REFERENCE_PROPERTY, this.aggregateReference);
        this.createContents();
    }

    private void createContents() {
        this.setLayout((Layout)new FormLayout());
        this.timeCount = 0;
        this.identifiableTitle = new Label((Composite)this, 0);
        this.aggregateSeriesCanvas = new AggregateTimeSeriesCanvas(this);
        this.aggregateSeriesCanvas.reset();
        this.propertySelector = new PropertySelector((Composite)this, 0);
        this.removeButton = new Button((Composite)this, 0);
        this.removeButton.setText("remove");
        this.addReferenceLabel = new Label((Composite)this, 2048);
        String string = Activator.getDefault().getPreferenceStore().getString("reference.file");
        if (string == null) {
            string = "";
        }
        this.selectedReferenceFile = string;
        this.addReferenceLabel.setText(string);
        this.addReferenceButton = new Button((Composite)this, 0);
        this.addReferenceButton.setText("Add Reference");
        final Shell shell = this.getShell();
        final AggregateValueHistoryPlotter aggregateValueHistoryPlotter = this;
        this.addReferenceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string;
                FileDialog fileDialog = new FileDialog(shell, 4096);
                fileDialog.setText(Messages.getString("REPORTVIEW.SELECTREFENCEFOLDER"));
                fileDialog.setFilterPath(AggregateValueHistoryPlotter.this.addReferenceLabel.getText());
                aggregateValueHistoryPlotter.selectedReferenceFile = string = fileDialog.open();
                AggregateValueHistoryPlotter.this.addReferenceLabel.setText(string);
                Activator.getDefault().getPreferenceStore().setValue("reference.file", string);
                try {
                    AggregateReferenceFileLoader aggregateReferenceFileLoader = new AggregateReferenceFileLoader(string);
                    AggregateValueHistoryPlotter.this.aggregateReference = aggregateReferenceFileLoader.getAggregateData();
                    AggregateValueHistoryPlotter.this.dataMap.put(AggregateValueHistoryPlotter.REFERENCE_PROPERTY, AggregateValueHistoryPlotter.this.aggregateReference);
                    AggregateValueHistoryPlotter.this.referenceIDs = aggregateReferenceFileLoader.getIdSet();
                }
                catch (Exception exception) {
                    System.out.println("error " + exception);
                    exception.printStackTrace();
                    Activator.logError(exception.getMessage(), exception);
                }
            }
        });
        FormData formData = new FormData();
        this.identifiableTitle.setLayoutData((Object)formData);
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        FormData formData2 = new FormData();
        this.aggregateSeriesCanvas.setLayoutData(formData2);
        formData2.top = new FormAttachment((Control)this.identifiableTitle, 0);
        formData2.bottom = new FormAttachment((Control)this.propertySelector, 0);
        formData2.left = new FormAttachment(0, 0);
        formData2.right = new FormAttachment(100, 0);
        FormData formData3 = new FormData();
        formData3.bottom = new FormAttachment(100, 0);
        formData3.left = new FormAttachment(0, 0);
        formData3.right = new FormAttachment(30, 0);
        this.propertySelector.setLayoutData((Object)formData3);
        FormData formData4 = new FormData();
        formData4.bottom = new FormAttachment(100, 0);
        formData4.left = new FormAttachment((Control)this.propertySelector, 0);
        formData4.right = new FormAttachment(60, 0);
        this.removeButton.setLayoutData((Object)formData4);
        FormData formData5 = new FormData();
        formData5.bottom = new FormAttachment((Control)this.removeButton, 0);
        formData5.left = new FormAttachment((Control)this.removeButton, 0);
        formData5.right = new FormAttachment(100, 0);
        this.addReferenceButton.setLayoutData((Object)formData5);
        FormData formData6 = new FormData();
        formData6.top = new FormAttachment((Control)this.addReferenceButton, 0);
        formData6.left = new FormAttachment((Control)this.removeButton, 0);
        formData6.right = new FormAttachment(100, 0);
        this.addReferenceLabel.setLayoutData((Object)formData6);
        this.propertySelector.addPropertySelectionListener(new PropertySelector.PropertySelectionListener(){

            public void propertySelected(PropertySelector.PropertySelectionEvent propertySelectionEvent) {
                AggregateValueHistoryPlotter.this.selectedDecorator = propertySelectionEvent.getDecorator();
                AggregateValueHistoryPlotter.this.selectedProperties = AggregateValueHistoryPlotter.this.getPropertiesToDisplay(AggregateValueHistoryPlotter.this.selectedDecorator);
                AggregateValueHistoryPlotter.this.selectedDynamicLabel = (DynamicLabel)AggregateValueHistoryPlotter.this.decoratorToLabelMap.get(AggregateValueHistoryPlotter.this.selectedDecorator);
                AggregateValueHistoryPlotter.this.switchToRVHP((RelativeValueHistoryProviderAdapter)RelativeValueHistoryProviderAdapterFactory.INSTANCE.adapt((Notifier)AggregateValueHistoryPlotter.this.selectedDynamicLabel, RelativeValueHistoryProvider.class));
            }
        });
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AggregateValueHistoryPlotter.this.fireRemoveEvent(AggregateValueHistoryPlotter.this.identifiable);
                AggregateValueHistoryPlotter.this.remove();
            }
        });
    }

    @Override
    public void remove() {
        this.removeListeners.clear();
        this.switchToRVHP(null);
        this.relativeValueHistoryExtended(null);
        this.identifiableTitle.setText("");
        this.propertySelector.setDecorators(Collections.EMPTY_LIST);
        this.dispose();
    }

    @Override
    public final void setSimulation(ISimulation iSimulation) {
        if (this.simulation == iSimulation) {
            return;
        }
        if (this.simulation != null) {
            this.simulation.removeSimulationListenerSync((ISimulationListenerSync)this);
        }
        this.simulation = iSimulation;
        this.selection = null;
        if (this.simulation != null) {
            this.simulation.addSimulationListenerSync((ISimulationListenerSync)this);
            this.initializeFromSimulation(this.simulation);
            Map<Node, Integer> map = this.getNodeLevels(iSimulation);
            int n = this.getHighestResolution(map);
            Iterator<Node> iterator = this.getNodeIterator(n, map);
            this.totalPopulation = 0.0;
            while (iterator != null && iterator.hasNext()) {
                Node node = iterator.next();
                EList eList = node.getLabels();
                int n2 = 0;
                while (n2 < eList.size()) {
                    DynamicLabel dynamicLabel;
                    RelativeValueProviderAdapter relativeValueProviderAdapter;
                    NodeLabel nodeLabel = (NodeLabel)eList.get(n2);
                    if (nodeLabel instanceof DynamicLabel && (relativeValueProviderAdapter = (RelativeValueProviderAdapter)RelativeValueProviderAdapterFactory.INSTANCE.adapt((Notifier)(dynamicLabel = (DynamicLabel)nodeLabel), RelativeValueProvider.class)) != null) {
                        relativeValueProviderAdapter.setTarget((Notifier)dynamicLabel);
                        this.totalPopulation += relativeValueProviderAdapter.getDenominator(null);
                        this.relativeValueProviderSet.add(relativeValueProviderAdapter);
                        for (Object e : relativeValueProviderAdapter.getProperties()) {
                            ItemPropertyDescriptor itemPropertyDescriptor = (ItemPropertyDescriptor)e;
                            this.allProperties.add(itemPropertyDescriptor);
                        }
                    }
                    ++n2;
                }
            }
            if (this.totalPopulation <= 0.0) {
                this.totalPopulation = 1.0;
            }
        } else {
            this.initializeFromSimulation(null);
            this.relativeValueProviderSet.clear();
            this.allProperties.clear();
        }
    }

    @Override
    public void setIdentifiable(Identifiable identifiable) {
    }

    public void relativeValueHistoryExtended(RelativeValueHistoryProviderAdapter relativeValueHistoryProviderAdapter) {
    }

    @Override
    protected void initializeFromSimulation(ISimulation iSimulation) {
        this.graph = iSimulation.getScenario().getCanonicalGraph();
        this.timeCount = 0;
        this.redraw();
    }

    @Override
    public void refresh2() {
    }

    public int getNumProperties() {
        return this.dataMap.keySet().size();
    }

    public String getProperty(int n) {
        Object[] objectArray = this.dataMap.keySet().toArray();
        Arrays.sort(objectArray);
        return (String)objectArray[n];
    }

    public double[] getValues(String string) {
        List<Double> list = this.dataMap.get(string);
        double[] dArray = new double[this.timeCount];
        int n = 0;
        while (n < this.timeCount) {
            if (list != null && n < list.size()) {
                dArray[n] = list.get(n);
                if (string.equalsIgnoreCase(REFERENCE_PROPERTY)) {
                    int n2 = n;
                    dArray[n2] = dArray[n2] / this.totalPopulation;
                }
            } else {
                dArray[n] = 1.0 / this.totalPopulation;
            }
            ++n;
        }
        return dArray;
    }

    List<ItemPropertyDescriptor> getPropertiesToDisplay(Decorator decorator) {
        ArrayList<ItemPropertyDescriptor> arrayList = new ArrayList<ItemPropertyDescriptor>();
        if (decorator != null && !decorator.getLabelsToUpdate().isEmpty()) {
            arrayList.addAll(this.propertySieve.sieve((DynamicLabel)decorator.getLabelsToUpdate().get(0)));
        }
        return arrayList;
    }

    private Graph getGraph(Node node) {
        return (Graph)node.eContainer().eContainer();
    }

    public void simulationChangedSync(SimulationEvent simulationEvent) {
        if (simulationEvent.getSimulationState() == SimulationState.RUNNING) {
            if (this.selectedReferenceFile == null) {
                this.selectedReferenceFile = Activator.getDefault().getPreferenceStore().getString("reference.file");
            }
            if (this.aggregateReference == null || this.aggregateReference.size() == 0) {
                try {
                    AggregateReferenceFileLoader aggregateReferenceFileLoader = new AggregateReferenceFileLoader(this.selectedReferenceFile);
                    this.aggregateReference = aggregateReferenceFileLoader.getAggregateData();
                    this.dataMap.put(REFERENCE_PROPERTY, this.aggregateReference);
                    this.referenceIDs = aggregateReferenceFileLoader.getIdSet();
                }
                catch (Exception exception) {
                    Activator.logError(exception.getMessage(), exception);
                }
            }
        } else if (simulationEvent.getSimulationState() == SimulationState.COMPLETED_CYCLE) {
            this.sumData();
            this.aggregateSeriesCanvas.draw();
            this.redraw();
            ++this.timeCount;
        } else if (simulationEvent.getSimulationState() == SimulationState.STOPPED) {
            if (this.simulation == simulationEvent.getSimulation()) {
                this.activeSimulations.remove(this.simulation);
                this.simulation.removeSimulationListener((ISimulationListener)this);
                this.simulation.removeSimulationListenerSync((ISimulationListenerSync)this);
                this.simulation = null;
                this.identifiableTitle.setText("");
                this.propertySelector.setDecorators(Collections.EMPTY_LIST);
                this.timeCount = 0;
            }
        } else if (this.simulation == simulationEvent.getSimulation() && simulationEvent.getSimulationState() == SimulationState.RESET) {
            this.aggregateSeriesCanvas.resetData();
            this.timeCount = 0;
        }
    }

    public void simulationChanged(SimulationEvent simulationEvent) {
        if (this.simulation == simulationEvent.getSimulation() && simulationEvent.getSimulationState() == SimulationState.RESET) {
            this.aggregateSeriesCanvas.resetData();
            this.timeCount = 0;
        }
        if (simulationEvent.getSimulationState() == SimulationState.STOPPED && this.simulation == simulationEvent.getSimulation()) {
            this.activeSimulations.remove(this.simulation);
            this.simulation.removeSimulationListener((ISimulationListener)this);
            this.simulation.removeSimulationListenerSync((ISimulationListenerSync)this);
            this.simulation = null;
            this.identifiableTitle.setText("");
            this.propertySelector.setDecorators(Collections.EMPTY_LIST);
            this.timeCount = 0;
        }
        if (simulationEvent.getSimulationState() == SimulationState.STOPPED && this.simulation == simulationEvent.getSimulation()) {
            this.activeSimulations.remove(this.simulation);
            this.simulation.removeSimulationListener((ISimulationListener)this);
            this.simulation.removeSimulationListenerSync((ISimulationListenerSync)this);
            this.simulation = null;
            this.identifiableTitle.setText("");
            this.propertySelector.setDecorators(Collections.EMPTY_LIST);
            this.timeCount = 0;
        }
    }

    public void dispose() {
        super.dispose();
        if (this.rvhp != null) {
            this.rvhp.removeExtensionListener((RelativeValueHistoryExtendedListener)this);
        }
        if (this.simulation != null) {
            this.simulation.removeSimulationListener((ISimulationListener)this);
        }
    }

    @Override
    public Identifiable getIdentifiable() {
        return null;
    }

    @Override
    public String getControlType() {
        return "SIMULATION_CONTROL_FACTORY";
    }

    public void sumData() {
        Iterator<ItemPropertyDescriptor> iterator = this.allProperties.iterator();
        while (iterator != null && iterator.hasNext()) {
            Object object;
            ItemPropertyDescriptor itemPropertyDescriptor = iterator.next();
            String string = itemPropertyDescriptor.getDisplayName((Object)itemPropertyDescriptor);
            if (!this.dataMap.containsKey(string)) {
                ArrayList<Double> arrayList = new ArrayList<Double>();
                int n = 0;
                while (n < this.timeCount) {
                    arrayList.add(n, new Double(0.0));
                    ++n;
                }
                this.dataMap.put(string, arrayList);
            }
            double d = 0.0;
            double d2 = 0.0;
            Iterator<RelativeValueProviderAdapter> iterator2 = this.relativeValueProviderSet.iterator();
            while (iterator2 != null && iterator2.hasNext()) {
                object = iterator2.next();
                double d3 = object.getDenominator(null);
                d += d3;
                d2 += d3 * object.getRelativeValue(itemPropertyDescriptor);
            }
            if (d <= 0.0) {
                d = 1.0;
            }
            this.totalPopulation = d;
            this.aggregateSeriesCanvas.setMinYscale(1.0 / this.totalPopulation);
            object = this.dataMap.get(string);
            object.add(this.timeCount, new Double(d2 /= d));
            this.dataMap.put(string, (List<Double>)object);
        }
    }

    private int getHighestResolution(Map<Node, Integer> map) {
        int n = -1;
        Collection<Integer> collection = map.values();
        for (int n2 : collection) {
            if (n2 < n) continue;
            n = n2;
        }
        return n;
    }

    private Iterator<Node> getNodeIterator(int n, Map<Node, Integer> map) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        Set<Node> set = map.keySet();
        for (Node node : set) {
            if (map.get(node) != n) continue;
            arrayList.add(node);
        }
        return arrayList.iterator();
    }

    public Map<Node, Integer> getNodeLevels(ISimulation iSimulation) {
        HashMap<Node, Integer> hashMap = new HashMap<Node, Integer>();
        Graph graph = iSimulation.getScenario().getCanonicalGraph();
        if (graph != null) {
            EMap eMap = graph.getNodes();
            Set set = eMap.keySet();
            Iterator iterator = set.iterator();
            while (iterator != null && iterator.hasNext()) {
                URI uRI = (URI)iterator.next();
                Node node = (Node)eMap.get((Object)uRI);
                String string = node.getURI().toString();
                int n = this.getAdminLevel(string);
                hashMap.put(node, n);
            }
        }
        return hashMap;
    }

    private int getAdminLevel(String string) {
        int n = 0;
        String string2 = string;
        while (string2.contains("-")) {
            String string3;
            ++n;
            int n2 = string2.indexOf("-");
            string2 = string3 = string2.substring(n2 + 1, string2.length());
        }
        return n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PropertySieve {
        public List<ItemPropertyDescriptor> sieve(DynamicLabel var1);
    }
}

