/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.reports.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.ScatterSeries;
import org.eclipse.birt.chart.model.type.impl.ScatterSeriesImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.definitions.adapters.relativevalue.history.RelativeValueHistoryProvider;
import org.eclipse.stem.definitions.adapters.relativevalue.history.RelativeValueHistoryProviderAdapter;
import org.eclipse.stem.ui.reports.Activator;
import org.eclipse.stem.ui.reports.views.Messages;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhaseSpaceCanvas
extends Canvas {
    protected IDeviceRenderer idr = null;
    protected Chart cm = null;
    private RelativeValueHistoryProvider rvhp;
    private ItemPropertyDescriptor propertyToPlotX;
    private ItemPropertyDescriptor propertyToPlotY;
    private final List<Double> relativeValuesX = new ArrayList<Double>();
    private final List<Double> relativeValuesY = new ArrayList<Double>();
    private double minLogScaleValue = 1.0;
    Generator gr = Generator.instance();
    private Axis xAxisPrimary;
    private Axis yAxisPrimary;
    private static String defaultAxisLabel_Y = "Y Axis";
    private static String defaultAxisLabel_X = "X Axis";
    boolean useLinearScales = true;
    private LinearScalesAction linearScalesAction;
    private LogarithmicScalesAction logTimeScalesAction;
    private String xAxisLabel;
    private String yAxisLabel;
    Image imgChart = null;

    public PhaseSpaceCanvas(Composite composite) {
        super(composite, 0x20000800);
        try {
            this.idr = PluginSettings.instance().getDevice("dv.SWT");
        }
        catch (ChartException chartException) {
            Activator.logError("Problem initializing chart", chartException);
            return;
        }
        this.resetData();
        this.cm = this.createPhaseSpaceLineChart(this.relativeValuesX, this.relativeValuesY, Messages.getString("PH.title"));
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                Composite composite = (Composite)paintEvent.getSource();
                Rectangle rectangle = composite.getClientArea();
                if (PhaseSpaceCanvas.this.imgChart != null) {
                    PhaseSpaceCanvas.this.imgChart.dispose();
                }
                PhaseSpaceCanvas.this.imgChart = new Image((Device)composite.getDisplay(), rectangle);
                PhaseSpaceCanvas.this.idr.setProperty("device.output.context", (Object)new GC((Drawable)PhaseSpaceCanvas.this.imgChart));
                Bounds bounds = BoundsImpl.create((double)rectangle.x, (double)rectangle.y, (double)rectangle.width, (double)rectangle.height);
                bounds.scale(72.0 / (double)PhaseSpaceCanvas.this.idr.getDisplayServer().getDpiResolution());
                try {
                    PhaseSpaceCanvas.this.gr.render(PhaseSpaceCanvas.this.idr, PhaseSpaceCanvas.this.gr.build(PhaseSpaceCanvas.this.idr.getDisplayServer(), PhaseSpaceCanvas.this.cm, bounds, null, null, null));
                    paintEvent.gc.drawImage(PhaseSpaceCanvas.this.imgChart, rectangle.x, rectangle.y);
                }
                catch (ChartException chartException) {
                    Activator.logError("Problem rendering chart", chartException);
                }
            }
        });
        this.createContextMenu((Composite)this);
    }

    public void draw() {
        if (this.rvhp != null) {
            double d = this.rvhp.getDenominator(null);
            if (d <= 0.0) {
                d = 1.0;
            }
            this.minLogScaleValue = 0.5 / d;
            STEMTime[] sTEMTimeArray = this.rvhp.getAllHistoricTimeValues();
            double[] dArray = this.rvhp.getHistoricInstances(this.propertyToPlotX, sTEMTimeArray);
            double[] dArray2 = this.rvhp.getHistoricInstances(this.propertyToPlotY, sTEMTimeArray);
            if (dArray.length > 0 && dArray2.length > 0) {
                this.clearData();
                int n = 0;
                while (n < dArray.length) {
                    Double d2 = null;
                    Double d3 = null;
                    double d4 = dArray[n];
                    double d5 = dArray2[n];
                    if (d4 <= this.minLogScaleValue) {
                        d4 = this.minLogScaleValue;
                    }
                    if (d5 <= this.minLogScaleValue) {
                        d5 = this.minLogScaleValue;
                    }
                    if (this.useLinearScales) {
                        d2 = new Double(d4);
                        d3 = new Double(d5);
                    } else {
                        d2 = new Double(Math.log(d4));
                        d3 = new Double(Math.log(d5));
                    }
                    this.relativeValuesX.add(d2);
                    this.relativeValuesY.add(d3);
                    ++n;
                }
            } else {
                this.resetData();
            }
            if (!this.isDisposed()) {
                this.redraw();
            }
        }
    }

    private void createContextMenu(Composite composite) {
        MenuManager menuManager = new MenuManager();
        this.linearScalesAction = new LinearScalesAction();
        this.logTimeScalesAction = new LogarithmicScalesAction();
        menuManager.add((IAction)this.linearScalesAction);
        menuManager.add((IAction)this.logTimeScalesAction);
        menuManager.add((IContributionItem)new Separator("additions"));
        Menu menu = menuManager.createContextMenu((Control)composite);
        composite.setMenu(menu);
    }

    public final Chart createPhaseSpaceLineChart(List<Double> list, List<Double> list2, String string) {
        ChartWithAxes chartWithAxes = ChartWithAxesImpl.create();
        defaultAxisLabel_X = Messages.getString("XAXISDEF.title");
        defaultAxisLabel_Y = Messages.getString("YAXISDEF.title");
        chartWithAxes.getBlock().setBackground((Fill)ColorDefinitionImpl.WHITE());
        Plot plot = chartWithAxes.getPlot();
        plot.getClientArea().setBackground((Fill)ColorDefinitionImpl.create((int)255, (int)255, (int)225));
        chartWithAxes.getTitle().setVisible(false);
        Legend legend = chartWithAxes.getLegend();
        legend.setVisible(false);
        this.xAxisPrimary = chartWithAxes.getPrimaryBaseAxes()[0];
        this.xAxisPrimary.setType(AxisType.LINEAR_LITERAL);
        this.yAxisPrimary = chartWithAxes.getPrimaryOrthogonalAxis(this.xAxisPrimary);
        this.xAxisPrimary.getMajorGrid().setTickStyle(TickStyle.BELOW_LITERAL);
        this.yAxisPrimary.getMajorGrid().setTickStyle(TickStyle.LEFT_LITERAL);
        this.xAxisPrimary.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        this.xAxisPrimary.getTitle().getCaption().getFont().setSize(8.0f);
        this.xAxisLabel = defaultAxisLabel_X;
        if (this.propertyToPlotX != null) {
            this.xAxisLabel = this.propertyToPlotX.getDisplayName((Object)this.propertyToPlotX);
        }
        this.xAxisPrimary.getTitle().getCaption().setValue(this.xAxisLabel);
        this.xAxisPrimary.getTitle().setVisible(true);
        this.yAxisPrimary.getTitle().getCaption().getFont().setSize(8.0f);
        this.yAxisLabel = defaultAxisLabel_Y;
        if (this.propertyToPlotY != null) {
            this.yAxisLabel = this.propertyToPlotY.getDisplayName((Object)this.propertyToPlotY);
        }
        this.yAxisPrimary.getTitle().getCaption().setValue(this.yAxisLabel);
        this.yAxisPrimary.getTitle().setVisible(true);
        NumberDataSet numberDataSet = NumberDataSetImpl.create(list);
        NumberDataSet numberDataSet2 = NumberDataSetImpl.create(list2);
        Series series = SeriesImpl.create();
        series.setDataSet((DataSet)numberDataSet);
        ScatterSeries scatterSeries = (ScatterSeries)ScatterSeriesImpl.create();
        scatterSeries.setDataSet((DataSet)numberDataSet2);
        scatterSeries.getLineAttributes().setVisible(true);
        scatterSeries.getLineAttributes().setColor(ColorDefinitionImpl.BLUE());
        scatterSeries.setSeriesIdentifier((Object)string);
        scatterSeries.getMarker().setVisible(false);
        SeriesDefinition seriesDefinition = SeriesDefinitionImpl.create();
        SeriesDefinition seriesDefinition2 = SeriesDefinitionImpl.create();
        seriesDefinition2.getSeriesPalette().update(-2);
        this.xAxisPrimary.getSeriesDefinitions().add((Object)seriesDefinition);
        this.yAxisPrimary.getSeriesDefinitions().add((Object)seriesDefinition2);
        seriesDefinition.getSeries().add((Object)series);
        seriesDefinition2.getSeries().add((Object)scatterSeries);
        this.xAxisPrimary.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
        this.xAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)1.0));
        this.xAxisPrimary.getScale().setStep(0.25);
        this.xAxisPrimary.getLabel().getCaption().getFont().setSize(9.0f);
        this.yAxisPrimary.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
        this.yAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)1.0));
        this.yAxisPrimary.getScale().setStep(0.25);
        this.yAxisPrimary.getLabel().getCaption().getFont().setSize(9.0f);
        return chartWithAxes;
    }

    public void setDataSourceAndRedraw(RelativeValueHistoryProviderAdapter relativeValueHistoryProviderAdapter, ItemPropertyDescriptor itemPropertyDescriptor, ItemPropertyDescriptor itemPropertyDescriptor2) {
        this.rvhp = relativeValueHistoryProviderAdapter;
        this.propertyToPlotX = itemPropertyDescriptor;
        this.propertyToPlotY = itemPropertyDescriptor2;
        this.xAxisLabel = defaultAxisLabel_X;
        if (itemPropertyDescriptor != null) {
            this.xAxisLabel = this.propertyToPlotX.getDisplayName((Object)itemPropertyDescriptor);
        }
        this.xAxisPrimary.getTitle().getCaption().setValue(this.xAxisLabel);
        this.xAxisPrimary.getTitle().setVisible(true);
        this.yAxisPrimary.getTitle().getCaption().getFont().setSize(8.0f);
        this.yAxisLabel = defaultAxisLabel_Y;
        if (itemPropertyDescriptor2 != null) {
            this.yAxisLabel = this.propertyToPlotY.getDisplayName((Object)itemPropertyDescriptor2);
        }
        this.yAxisPrimary.getTitle().getCaption().setValue(this.yAxisLabel);
        this.yAxisPrimary.getTitle().setVisible(true);
        this.draw();
    }

    public void setRelativeValueHistoryProvider(RelativeValueHistoryProvider relativeValueHistoryProvider) {
        this.rvhp = relativeValueHistoryProvider;
    }

    public final ItemPropertyDescriptor getPropertyToPlotX() {
        return this.propertyToPlotX;
    }

    public final ItemPropertyDescriptor getPropertyToPlotY() {
        return this.propertyToPlotY;
    }

    public final void setPropertyToPlotX(ItemPropertyDescriptor itemPropertyDescriptor) {
        this.propertyToPlotX = itemPropertyDescriptor;
    }

    public final void setPropertyToPlotY(ItemPropertyDescriptor itemPropertyDescriptor) {
        this.propertyToPlotY = itemPropertyDescriptor;
    }

    public void dispose() {
        super.dispose();
    }

    public void reset() {
        this.resetData();
        this.rvhp = null;
        this.redraw();
    }

    protected void resetData() {
        this.clearData();
        this.relativeValuesX.add(new Double(1.0));
        this.relativeValuesY.add(new Double(0.0));
    }

    private void clearData() {
        this.relativeValuesX.clear();
        this.relativeValuesY.clear();
    }

    void toggleScales() {
        if (this.useLinearScales) {
            this.logTimeScalesAction.setChecked(true);
            this.linearScalesAction.setChecked(false);
            this.xAxisPrimary.getScale().setMin(null);
            this.xAxisPrimary.getScale().setMax(null);
            this.xAxisPrimary.getScale().unsetStep();
            this.xAxisPrimary.getScale().unsetStepNumber();
            this.xAxisPrimary.getTitle().getCaption().setValue("Log(" + this.xAxisLabel + ")");
            this.yAxisPrimary.getScale().setMin(null);
            this.yAxisPrimary.getScale().setMax(null);
            this.yAxisPrimary.getScale().unsetStep();
            this.yAxisPrimary.getScale().unsetStepNumber();
            this.yAxisPrimary.getTitle().getCaption().setValue("Log(" + this.yAxisLabel + ")");
        } else {
            this.logTimeScalesAction.setChecked(false);
            this.linearScalesAction.setChecked(true);
            this.xAxisPrimary.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
            this.xAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)1.0));
            this.xAxisPrimary.getScale().setStep(0.25);
            this.xAxisPrimary.getTitle().getCaption().setValue(this.xAxisLabel);
            this.yAxisPrimary.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
            this.yAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)1.0));
            this.yAxisPrimary.getScale().setStep(0.25);
            this.yAxisPrimary.getTitle().getCaption().setValue(this.yAxisLabel);
        }
        this.useLinearScales = !this.useLinearScales;
        this.redraw();
    }

    protected class LinearScalesAction
    extends Action {
        public LinearScalesAction() {
            super(Messages.getString("ContextMenu.LinearScaling"), 2);
            this.setChecked(PhaseSpaceCanvas.this.useLinearScales);
        }

        public String getText() {
            return Messages.getString("ContextMenu.LinearScaling");
        }

        public void run() {
            if (PhaseSpaceCanvas.this.useLinearScales) {
                this.setChecked(true);
            } else {
                PhaseSpaceCanvas.this.toggleScales();
            }
        }
    }

    class LogarithmicScalesAction
    extends Action {
        public LogarithmicScalesAction() {
            super(Messages.getString("ContextMenu.LogScaling"), 2);
            this.setChecked(!PhaseSpaceCanvas.this.useLinearScales);
        }

        public String getText() {
            return Messages.getString("ContextMenu.LogScaling");
        }

        public void run() {
            if (!PhaseSpaceCanvas.this.useLinearScales) {
                this.setChecked(true);
            } else {
                PhaseSpaceCanvas.this.toggleScales();
            }
        }
    }
}

