/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.reports.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.DynamicNodeLabel;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.definitions.adapters.relativevalue.history.RelativeValueHistoryExtendedListener;
import org.eclipse.stem.definitions.adapters.relativevalue.history.RelativeValueHistoryProvider;
import org.eclipse.stem.definitions.adapters.relativevalue.history.RelativeValueHistoryProviderAdapter;
import org.eclipse.stem.definitions.adapters.relativevalue.history.RelativeValueHistoryProviderAdapterFactory;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.ISimulationListener;
import org.eclipse.stem.jobs.simulation.SimulationEvent;
import org.eclipse.stem.jobs.simulation.SimulationState;
import org.eclipse.stem.ui.reports.Activator;
import org.eclipse.stem.ui.reports.views.PhaseSpaceCanvas;
import org.eclipse.stem.ui.reports.views.ReportControl;
import org.eclipse.stem.ui.widgets.PropertySelector;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PhaseSpaceHistoryPlotter
extends ReportControl
implements RelativeValueHistoryExtendedListener,
ISimulationListener {
    PhaseSpaceCanvas phaseSpaceCanvas;
    PropertySelector propertySelectorX;
    PropertySelector propertySelectorY;
    ItemPropertyDescriptor selectedProperty1;
    ItemPropertyDescriptor selectedProperty2;
    private static final String X_AXIS_LABEL = "X Axis";
    private static final String Y_AXIS_LABEL = "Y Axis";

    public PhaseSpaceHistoryPlotter(Composite composite) {
        super(composite, 0);
        this.createContents();
    }

    private void createContents() {
        this.setLayout((Layout)new FormLayout());
        this.identifiableTitle = new Label((Composite)this, 0);
        this.phaseSpaceCanvas = new PhaseSpaceCanvas(this);
        this.propertySelectorX = new PropertySelector((Composite)this, 0);
        this.propertySelectorX.setDisplayLabel(X_AXIS_LABEL);
        this.propertySelectorY = new PropertySelector((Composite)this, 0);
        this.propertySelectorY.setDisplayLabel(Y_AXIS_LABEL);
        this.removeButton = new Button((Composite)this, 0);
        this.removeButton.setText("remove");
        FormData formData = new FormData();
        this.identifiableTitle.setLayoutData((Object)formData);
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        FormData formData2 = new FormData();
        this.phaseSpaceCanvas.setLayoutData(formData2);
        formData2.top = new FormAttachment((Control)this.identifiableTitle, 0);
        formData2.bottom = new FormAttachment((Control)this.propertySelectorY, 0);
        formData2.left = new FormAttachment(0, 0);
        formData2.right = new FormAttachment(100, 0);
        FormData formData3 = new FormData();
        formData3.bottom = new FormAttachment(100, 0);
        formData3.left = new FormAttachment(0, 0);
        formData3.right = new FormAttachment(30, 0);
        this.propertySelectorY.setLayoutData((Object)formData3);
        FormData formData4 = new FormData();
        formData4.bottom = new FormAttachment(100, 0);
        formData4.left = new FormAttachment((Control)this.propertySelectorY, 0);
        formData4.right = new FormAttachment(60, 0);
        this.propertySelectorX.setLayoutData((Object)formData4);
        FormData formData5 = new FormData();
        formData5.bottom = new FormAttachment(100, 0);
        formData5.left = new FormAttachment((Control)this.propertySelectorX, 0);
        formData5.right = new FormAttachment(90, 0);
        this.removeButton.setLayoutData((Object)formData5);
        this.propertySelectorX.addPropertySelectionListener(new PropertySelector.PropertySelectionListener(){

            public void propertySelected(PropertySelector.PropertySelectionEvent propertySelectionEvent) {
                PhaseSpaceHistoryPlotter.this.selectedDecorator = propertySelectionEvent.getDecorator();
                PhaseSpaceHistoryPlotter.this.selectedProperty2 = propertySelectionEvent.getProperty();
                PhaseSpaceHistoryPlotter.this.selectedDynamicLabel = (DynamicLabel)PhaseSpaceHistoryPlotter.this.decoratorToLabelMap.get(PhaseSpaceHistoryPlotter.this.selectedDecorator);
                PhaseSpaceHistoryPlotter.this.switchToRVHP((RelativeValueHistoryProviderAdapter)RelativeValueHistoryProviderAdapterFactory.INSTANCE.adapt((Notifier)PhaseSpaceHistoryPlotter.this.selectedDynamicLabel, RelativeValueHistoryProvider.class));
            }
        });
        this.propertySelectorY.addPropertySelectionListener(new PropertySelector.PropertySelectionListener(){

            public void propertySelected(PropertySelector.PropertySelectionEvent propertySelectionEvent) {
                PhaseSpaceHistoryPlotter.this.selectedDecorator = propertySelectionEvent.getDecorator();
                PhaseSpaceHistoryPlotter.this.selectedProperty1 = propertySelectionEvent.getProperty();
                PhaseSpaceHistoryPlotter.this.selectedDynamicLabel = (DynamicLabel)PhaseSpaceHistoryPlotter.this.decoratorToLabelMap.get(PhaseSpaceHistoryPlotter.this.selectedDecorator);
                PhaseSpaceHistoryPlotter.this.switchToRVHP((RelativeValueHistoryProviderAdapter)RelativeValueHistoryProviderAdapterFactory.INSTANCE.adapt((Notifier)PhaseSpaceHistoryPlotter.this.selectedDynamicLabel, RelativeValueHistoryProvider.class));
            }
        });
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PhaseSpaceHistoryPlotter.this.fireRemoveEvent(PhaseSpaceHistoryPlotter.this.identifiable);
                PhaseSpaceHistoryPlotter.this.remove();
            }
        });
    }

    public void remove() {
        this.removeListeners.clear();
        this.switchToRVHP(null);
        this.relativeValueHistoryExtended(null);
        this.identifiableTitle.setText("");
        this.propertySelectorX.setDecorators(Collections.EMPTY_LIST);
        this.propertySelectorY.setDecorators(Collections.EMPTY_LIST);
        this.dispose();
    }

    public void setIdentifiable(Identifiable identifiable) {
        Node node;
        if (this.identifiable == identifiable) {
            return;
        }
        this.identifiable = identifiable;
        ArrayList<Decorator> arrayList = new ArrayList<Decorator>();
        this.decoratorToLabelMap = new HashMap();
        this.identifiableTitle.setText(identifiable.getDublinCore().getTitle());
        if (identifiable instanceof Node) {
            node = (Node)identifiable;
            for (Object object : node.getLabels()) {
                if (!(object instanceof DynamicNodeLabel)) continue;
                DynamicNodeLabel dynamicNodeLabel = (DynamicNodeLabel)object;
                RelativeValueHistoryProviderAdapter relativeValueHistoryProviderAdapter = (RelativeValueHistoryProviderAdapter)RelativeValueHistoryProviderAdapterFactory.INSTANCE.adapt((Notifier)object, RelativeValueHistoryProvider.class);
                if (relativeValueHistoryProviderAdapter == null) continue;
                Decorator decorator = dynamicNodeLabel.getDecorator();
                if (decorator != null) {
                    this.decoratorToLabelMap.put(decorator, dynamicNodeLabel);
                    arrayList.add(decorator);
                    continue;
                }
                Activator.logError("DynamicLabel \"" + dynamicNodeLabel.getDublinCore().getTitle() + "\" does not have a Decorator", null);
            }
        }
        this.propertySelectorX.setDecorators(arrayList);
        this.propertySelectorY.setDecorators(arrayList);
        try {
            Object object;
            node = org.eclipse.stem.ui.Activator.getDefault().getPluginPreferences();
            object = node.getString("org.eclipse.stem.ui.initialattributename");
            String string = node.getString("org.eclipse.stem.ui.initialattributename2");
            this.propertySelectorY.setDisplayedProperty((String)object);
            this.propertySelectorX.setDisplayedProperty(string);
        }
        catch (Exception exception) {}
    }

    public void relativeValueHistoryExtended(final RelativeValueHistoryProviderAdapter relativeValueHistoryProviderAdapter) {
        Display display = Display.getDefault();
        if (!display.isDisposed()) {
            try {
                display.asyncExec(new Runnable(){

                    public void run() {
                        PhaseSpaceHistoryPlotter.this.phaseSpaceCanvas.setDataSourceAndRedraw(relativeValueHistoryProviderAdapter, PhaseSpaceHistoryPlotter.this.selectedProperty2, PhaseSpaceHistoryPlotter.this.selectedProperty1);
                    }
                });
            }
            catch (Exception exception) {}
        }
    }

    public void simulationChanged(SimulationEvent simulationEvent) {
        if (simulationEvent.getSimulationState() == SimulationState.RESET) {
            this.phaseSpaceCanvas.resetData();
        }
        if (simulationEvent.getSimulationState() == SimulationState.STOPPED) {
            this.simulation.removeSimulationListener((ISimulationListener)this);
            this.simulation = null;
            this.switchToRVHP(null);
            this.relativeValueHistoryExtended(null);
            this.identifiableTitle.setText("");
            this.propertySelectorX.setDecorators(Collections.EMPTY_LIST);
            this.propertySelectorY.setDecorators(Collections.EMPTY_LIST);
        }
    }

    protected void initializeFromSimulation(ISimulation iSimulation) {
        this.simulationNameLabel.setText(iSimulation.getName());
        this.propertySelectorX.setSimulation(iSimulation);
        this.propertySelectorY.setSimulation(iSimulation);
    }

    public void refresh2() {
    }

    public void dispose() {
        super.dispose();
        if (this.rvhp != null) {
            this.rvhp.removeExtensionListener((RelativeValueHistoryExtendedListener)this);
        }
    }

    public Identifiable getIdentifiable() {
        return this.identifiable;
    }

    public String getControlType() {
        return "IDENTIFIABLE_CONTROL_FACTORY";
    }
}

