/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.reports.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.DynamicNodeLabel;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProvider;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapter;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapterFactory;
import org.eclipse.stem.definitions.adapters.relativevalue.history.RelativeValueHistoryExtendedListener;
import org.eclipse.stem.definitions.adapters.relativevalue.history.RelativeValueHistoryProvider;
import org.eclipse.stem.definitions.adapters.relativevalue.history.RelativeValueHistoryProviderAdapter;
import org.eclipse.stem.definitions.adapters.relativevalue.history.RelativeValueHistoryProviderAdapterFactory;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.ISimulationListener;
import org.eclipse.stem.jobs.simulation.SimulationEvent;
import org.eclipse.stem.jobs.simulation.SimulationManager;
import org.eclipse.stem.jobs.simulation.SimulationState;
import org.eclipse.stem.ui.reports.views.ReportControl;
import org.eclipse.stem.ui.reports.views.TimeSeriesCanvas;
import org.eclipse.stem.ui.widgets.PropertySelector;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelativeValueHistoryPlotter
extends ReportControl
implements RelativeValueHistoryExtendedListener,
ISimulationListener {
    TimeSeriesCanvas timeSeriesCanvas;
    PropertySelector propertySelector;
    List<ItemPropertyDescriptor> selectedProperties;
    private final PropertySieve propertySieve = new PropertySieve(){

        @Override
        public List<ItemPropertyDescriptor> sieve(DynamicLabel dynamicLabel) {
            ArrayList<ItemPropertyDescriptor> arrayList = new ArrayList<ItemPropertyDescriptor>();
            RelativeValueProviderAdapter relativeValueProviderAdapter = (RelativeValueProviderAdapter)RelativeValueProviderAdapterFactory.INSTANCE.adapt((Notifier)dynamicLabel, RelativeValueProvider.class);
            if (relativeValueProviderAdapter != null) {
                relativeValueProviderAdapter.setTarget((Notifier)dynamicLabel);
                for (Object e : relativeValueProviderAdapter.getProperties()) {
                    ItemPropertyDescriptor itemPropertyDescriptor = (ItemPropertyDescriptor)e;
                    arrayList.add(itemPropertyDescriptor);
                }
            }
            return arrayList;
        }
    };

    public RelativeValueHistoryPlotter(Composite composite) {
        super(composite, 0);
        this.createContents();
    }

    private void createContents() {
        this.setLayout((Layout)new FormLayout());
        this.identifiableTitle = new Label((Composite)this, 0);
        this.timeSeriesCanvas = new TimeSeriesCanvas(this);
        this.propertySelector = new PropertySelector((Composite)this, 0);
        this.removeButton = new Button((Composite)this, 0);
        this.removeButton.setText("remove");
        FormData formData = new FormData();
        this.identifiableTitle.setLayoutData((Object)formData);
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        FormData formData2 = new FormData();
        this.timeSeriesCanvas.setLayoutData(formData2);
        formData2.top = new FormAttachment((Control)this.identifiableTitle, 0);
        formData2.bottom = new FormAttachment((Control)this.propertySelector, 0);
        formData2.left = new FormAttachment(0, 0);
        formData2.right = new FormAttachment(100, 0);
        FormData formData3 = new FormData();
        formData3.bottom = new FormAttachment(100, 0);
        formData3.left = new FormAttachment(0, 0);
        formData3.right = new FormAttachment(30, 0);
        this.propertySelector.setLayoutData((Object)formData3);
        FormData formData4 = new FormData();
        formData4.bottom = new FormAttachment(100, 0);
        formData4.left = new FormAttachment((Control)this.propertySelector, 0);
        formData4.right = new FormAttachment(60, 0);
        this.removeButton.setLayoutData((Object)formData4);
        this.propertySelector.addPropertySelectionListener(new PropertySelector.PropertySelectionListener(){

            public void propertySelected(PropertySelector.PropertySelectionEvent propertySelectionEvent) {
                RelativeValueHistoryPlotter.this.selectedDecorator = propertySelectionEvent.getDecorator();
                RelativeValueHistoryPlotter.this.selectedProperties = RelativeValueHistoryPlotter.this.getPropertiesToDisplay(RelativeValueHistoryPlotter.this.selectedDecorator);
                RelativeValueHistoryPlotter.this.selectedDynamicLabel = (DynamicLabel)RelativeValueHistoryPlotter.this.decoratorToLabelMap.get(RelativeValueHistoryPlotter.this.selectedDecorator);
                RelativeValueHistoryPlotter.this.switchToRVHP((RelativeValueHistoryProviderAdapter)RelativeValueHistoryProviderAdapterFactory.INSTANCE.adapt((Notifier)RelativeValueHistoryPlotter.this.selectedDynamicLabel, RelativeValueHistoryProvider.class));
            }
        });
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RelativeValueHistoryPlotter.this.fireRemoveEvent(RelativeValueHistoryPlotter.this.identifiable);
                RelativeValueHistoryPlotter.this.remove();
            }
        });
    }

    @Override
    public void remove() {
        this.removeListeners.clear();
        this.switchToRVHP(null);
        this.relativeValueHistoryExtended(null);
        this.identifiableTitle.setText("");
        this.propertySelector.setDecorators(Collections.EMPTY_LIST);
        this.dispose();
    }

    @Override
    public void setIdentifiable(Identifiable identifiable) {
        if (this.identifiable == identifiable) {
            return;
        }
        this.identifiable = identifiable;
        ArrayList<Decorator> arrayList = new ArrayList<Decorator>();
        this.decoratorToLabelMap = new HashMap();
        this.identifiableTitle.setText(identifiable.getDublinCore().getTitle());
        if (identifiable instanceof Node) {
            Node node = (Node)identifiable;
            for (NodeLabel nodeLabel : node.getLabels()) {
                Decorator decorator;
                if (!(nodeLabel instanceof DynamicNodeLabel)) continue;
                DynamicNodeLabel dynamicNodeLabel = (DynamicNodeLabel)nodeLabel;
                RelativeValueHistoryProviderAdapter relativeValueHistoryProviderAdapter = (RelativeValueHistoryProviderAdapter)RelativeValueHistoryProviderAdapterFactory.INSTANCE.adapt((Notifier)nodeLabel, RelativeValueHistoryProvider.class);
                if (relativeValueHistoryProviderAdapter == null || (decorator = dynamicNodeLabel.getDecorator()) == null) continue;
                this.decoratorToLabelMap.put(decorator, dynamicNodeLabel);
                arrayList.add(decorator);
            }
            if (arrayList.size() > 0) {
                NodeLabel nodeLabel;
                nodeLabel = SimulationManager.getManager().mapGraphToSimulation(this.getGraph(node));
                if (this.simulation != null) {
                    this.simulation.removeSimulationListener((ISimulationListener)this);
                }
                this.simulation = nodeLabel;
                if (this.simulation != null) {
                    this.simulation.addSimulationListener((ISimulationListener)this);
                }
            }
        }
        this.propertySelector.setDecorators(arrayList);
    }

    public void relativeValueHistoryExtended(final RelativeValueHistoryProviderAdapter relativeValueHistoryProviderAdapter) {
        Display display = Display.getDefault();
        if (!display.isDisposed()) {
            try {
                display.asyncExec(new Runnable(){

                    public void run() {
                        if (!RelativeValueHistoryPlotter.this.timeSeriesCanvas.isDisposed()) {
                            RelativeValueHistoryPlotter.this.timeSeriesCanvas.setDataSourceAndRedraw(relativeValueHistoryProviderAdapter, RelativeValueHistoryPlotter.this.selectedProperties);
                        }
                    }
                });
            }
            catch (Exception exception) {}
        }
    }

    @Override
    protected void initializeFromSimulation(ISimulation iSimulation) {
        this.simulationNameLabel.setText(iSimulation.getName());
        this.propertySelector.setSimulation(iSimulation);
    }

    @Override
    public void refresh2() {
    }

    List<ItemPropertyDescriptor> getPropertiesToDisplay(Decorator decorator) {
        ArrayList<ItemPropertyDescriptor> arrayList = new ArrayList<ItemPropertyDescriptor>();
        if (decorator != null && !decorator.getLabelsToUpdate().isEmpty()) {
            arrayList.addAll(this.propertySieve.sieve((DynamicLabel)decorator.getLabelsToUpdate().get(0)));
        }
        return arrayList;
    }

    private Graph getGraph(Node node) {
        return (Graph)node.eContainer().eContainer();
    }

    public void simulationChanged(SimulationEvent simulationEvent) {
        if (simulationEvent.getSimulationState() == SimulationState.RESET) {
            this.timeSeriesCanvas.resetData();
        }
        if (simulationEvent.getSimulationState() == SimulationState.STOPPED) {
            this.simulation.removeSimulationListener((ISimulationListener)this);
            this.simulation = null;
            this.switchToRVHP(null);
            this.relativeValueHistoryExtended(null);
            this.identifiableTitle.setText("");
            this.propertySelector.setDecorators(Collections.EMPTY_LIST);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.rvhp != null) {
            this.rvhp.removeExtensionListener((RelativeValueHistoryExtendedListener)this);
        }
        if (this.simulation != null) {
            this.simulation.removeSimulationListener((ISimulationListener)this);
        }
    }

    @Override
    public Identifiable getIdentifiable() {
        return this.identifiable;
    }

    @Override
    public String getControlType() {
        return "IDENTIFIABLE_CONTROL_FACTORY";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PropertySieve {
        public List<ItemPropertyDescriptor> sieve(DynamicLabel var1);
    }
}

