/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.reports.views;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.definitions.adapters.relativevalue.history.RelativeValueHistoryExtendedListener;
import org.eclipse.stem.definitions.adapters.relativevalue.history.RelativeValueHistoryProviderAdapter;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.ISimulationListener;
import org.eclipse.stem.ui.reports.views.IRemoveListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class ReportControl
extends Composite
implements RelativeValueHistoryExtendedListener,
ISimulationListener,
ISelectionProvider {
    protected RelativeValueHistoryProviderAdapter rvhp;
    protected static final String REMOVE_TEXT = "remove";
    protected static final String ADD_REFERENCE_TEXT = "Add Reference";
    protected Label simulationNameLabel;
    protected ISimulation simulation = null;
    protected Identifiable identifiable;
    protected Decorator selectedDecorator;
    protected DynamicLabel selectedDynamicLabel;
    protected Map<Decorator, DynamicLabel> decoratorToLabelMap;
    protected Button removeButton = null;
    protected Button addReferenceButton = null;
    protected Label addReferenceLabel = null;
    protected final List<ISelectionChangedListener> listeners = new CopyOnWriteArrayList<ISelectionChangedListener>();
    protected final List<IRemoveListener> removeListeners = new CopyOnWriteArrayList<IRemoveListener>();
    ISelection selection = null;
    protected Label identifiableTitle;
    protected static final int MARGIN_WIDTH = 5;
    protected static final int MARGIN_HEIGHT = 5;

    public ReportControl(Composite composite, int n) {
        super(composite, n);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                ReportControl.this.dispose();
            }
        });
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = 5;
        formLayout.marginWidth = 5;
        this.setLayout((Layout)formLayout);
    }

    protected Composite createTopComposite(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        FillLayout fillLayout = new FillLayout(512);
        composite2.setLayout((Layout)fillLayout);
        this.simulationNameLabel = new Label(composite2, 0x1000000);
        this.simulationNameLabel.setText("");
        return composite2;
    }

    protected void switchToRVHP(RelativeValueHistoryProviderAdapter relativeValueHistoryProviderAdapter) {
        if (this.rvhp != null && this.rvhp != relativeValueHistoryProviderAdapter) {
            this.rvhp.removeExtensionListener((RelativeValueHistoryExtendedListener)this);
        }
        if (this.rvhp != relativeValueHistoryProviderAdapter && relativeValueHistoryProviderAdapter != null) {
            relativeValueHistoryProviderAdapter.addExtensionListener((RelativeValueHistoryExtendedListener)this);
        }
        this.rvhp = relativeValueHistoryProviderAdapter;
    }

    public abstract void remove();

    public void addIRemoveListener(IRemoveListener iRemoveListener) {
        this.removeListeners.add(iRemoveListener);
    }

    public void removeIRemoveListener(IRemoveListener iRemoveListener) {
        this.removeListeners.remove(iRemoveListener);
    }

    public void fireRemoveEvent(Identifiable identifiable) {
        for (IRemoveListener iRemoveListener : this.removeListeners) {
            iRemoveListener.identifiableRemoved(identifiable);
        }
    }

    public void setSimulation(ISimulation iSimulation) {
        if (this.simulation == iSimulation) {
            return;
        }
        if (this.simulation != null) {
            this.simulation.removeSimulationListener((ISimulationListener)this);
        }
        this.simulation = iSimulation;
        this.selection = null;
        if (this.simulation != null) {
            this.simulation.addSimulationListener((ISimulationListener)this);
            this.initializeFromSimulation(this.simulation);
        } else {
            this.initializeFromSimulation(null);
        }
        this.refresh2();
    }

    protected abstract void initializeFromSimulation(ISimulation var1);

    protected abstract void refresh2();

    public final ISelection getSelection() {
        return this.selection;
    }

    public void setSelection(ISelection iSelection) {
        this.selection = iSelection;
        this.fireSelection(iSelection);
    }

    public abstract void setIdentifiable(Identifiable var1);

    public abstract Identifiable getIdentifiable();

    public void fireSelection(ISelection iSelection) {
        SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent((ISelectionProvider)this, iSelection);
        for (ISelectionChangedListener iSelectionChangedListener : this.listeners) {
            iSelectionChangedListener.selectionChanged(selectionChangedEvent);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.listeners.add(iSelectionChangedListener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.listeners.remove(iSelectionChangedListener);
    }

    public abstract String getControlType();
}

