/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.reports.views;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.ISimulationManagerListener;
import org.eclipse.stem.jobs.simulation.SimulationManager;
import org.eclipse.stem.jobs.simulation.SimulationManagerEvent;
import org.eclipse.stem.ui.reports.Activator;
import org.eclipse.stem.ui.reports.views.IRemoveListener;
import org.eclipse.stem.ui.reports.views.ReportControl;
import org.eclipse.stem.ui.reports.views.ReportControlFactory;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportViewer
extends Viewer
implements ISelectionChangedListener,
ISimulationManagerListener {
    private final Set<Identifiable> identifiablesToDisplay = new LinkedHashSet<Identifiable>();
    private SimulationManager simulationManager;
    private ISelection selection = null;
    final Composite composite;
    private DialogSettings masterSettings = null;
    private final Set<String> monitorSet = new HashSet<String>();
    private static final String ROOT_KEY = "root";
    public static final String REPORTVIEWPREFERENCES_FILENAME = "Preferences.txt";
    public static final String LOCATION_PREFERENCE_KEY = "location.ids";
    private static final IPath PATH = Activator.getDefault().getStateLocation();
    private final ReportControlFactory rcf;

    public ReportViewer(Composite composite, ReportControlFactory reportControlFactory) {
        this.composite = new Composite(composite, 0);
        FillLayout fillLayout = new FillLayout(256);
        this.composite.setLayout((Layout)fillLayout);
        this.rcf = reportControlFactory;
        this.refresh();
        this.composite.pack();
    }

    public Control getControl() {
        return this.composite;
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void refresh() {
        if (this.simulationManager != null) {
            List list = null;
            List list2 = this.simulationManager.getActiveSimulations();
            if (list2 != null && list2.size() >= 1) {
                int n = 0;
                while (n < list2.size()) {
                    ISimulation iSimulation = (ISimulation)list2.get(n);
                    this.updatePreferenceState(iSimulation);
                    ++n;
                }
            }
            if (this.simulationManager != null) {
                list = this.simulationManager.getActiveSimulations();
                this.addToDisplayedIdentifiableSet(list);
            }
            this.identifiablesToDisplay.clear();
            this.identifiablesToDisplay.addAll(this.getIdentifiablesInSimulation(this.simulationManager.getActiveSimulations()));
        }
        if (this.rcf.getFactoryType().equals("IDENTIFIABLE_CONTROL_FACTORY")) {
            this.populateView();
        } else {
            this.populateView(null);
        }
    }

    public void addMonitor(Identifiable identifiable) {
        if (!(identifiable instanceof Node)) {
            return;
        }
        this.identifiablesToDisplay.add(identifiable);
        this.populateView();
        this.savePreferenceState();
    }

    public Object getInput() {
        return this.simulationManager;
    }

    public void setInput(Object object) {
        SimulationManager simulationManager = this.simulationManager;
        this.simulationManager = (SimulationManager)object;
        this.inputChanged(object, simulationManager);
    }

    protected void inputChanged(Object object, Object object2) {
        if (object2 != null) {
            ((SimulationManager)object2).removeListener((ISimulationManagerListener)this);
        }
        if (object != null) {
            ((SimulationManager)object).addSimulationManagerListener((ISimulationManagerListener)this);
        }
        this.refresh();
    }

    public void setSelection(ISelection iSelection, boolean bl) {
        this.selection = iSelection;
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        if (selectionChangedEvent.getSelectionProvider() instanceof ReportControl) {
            this.selection = selectionChangedEvent.getSelection();
            this.fireSelectionChanged(selectionChangedEvent);
        }
    }

    public void simulationsChanged(SimulationManagerEvent simulationManagerEvent) {
        this.removeFromDisplayedSimulationSet(Arrays.asList(simulationManagerEvent.getSimulationsRemoved()));
        List<ISimulation> list = Arrays.asList(simulationManagerEvent.getSimulationsAdded());
        if (list != null && list.size() >= 1) {
            int n = 0;
            while (n < list.size()) {
                ISimulation iSimulation = list.get(n);
                this.updatePreferenceState(iSimulation);
                this.addToDisplayedIdentifiableSet(iSimulation);
                this.populateView();
                this.populateView(iSimulation);
                ++n;
            }
        }
    }

    private void addToDisplayedIdentifiableSet(List<ISimulation> list) {
        if (!list.isEmpty()) {
            this.identifiablesToDisplay.addAll(this.getIdentifiablesInSimulation(list));
        }
    }

    private void addToDisplayedIdentifiableSet(ISimulation iSimulation) {
        this.identifiablesToDisplay.addAll(this.getIdentifiablesInSimulation(iSimulation));
    }

    private void removeFromDisplayedSimulationSet(List<ISimulation> list) {
        if (!list.isEmpty()) {
            Set<Identifiable> set = this.getIdentifiablesInSimulation(list);
            this.identifiablesToDisplay.removeAll(set);
            this.cleanup(set);
        }
    }

    private void cleanup(Set<Identifiable> set) {
        if (set != null) {
            Identifiable identifiable;
            Iterator<Identifiable> iterator = set.iterator();
            while (iterator != null && iterator.hasNext()) {
                identifiable = iterator.next();
                this.monitorSet.remove(identifiable.getURI().toString());
            }
            Identifiable identifiable2 = identifiable = this.composite.getChildren();
            int n = ((Identifiable)identifiable2).length;
            int n2 = 0;
            while (n2 < n) {
                Identifiable identifiable3 = identifiable2[n2];
                ReportControl reportControl = (ReportControl)identifiable3;
                try {
                    Identifiable identifiable4 = reportControl.getIdentifiable();
                    if (identifiable4 == null || !this.identifiablesToDisplay.contains(identifiable4)) {
                        reportControl.remove();
                    }
                }
                catch (SWTException sWTException) {}
                ++n2;
            }
        }
    }

    protected void removeIdentifiable(Identifiable identifiable) {
        if (identifiable != null) {
            this.identifiablesToDisplay.remove(identifiable);
            this.savePreferenceState();
        }
    }

    private void populateView(ISimulation iSimulation) {
        if (!this.rcf.getFactoryType().equals("SIMULATION_CONTROL_FACTORY")) {
            return;
        }
        boolean bl = false;
        if (this.composite.isDisposed()) {
            return;
        }
        this.selection = null;
        List list = SimulationManager.getManager().getActiveSimulations();
        HashSet hashSet = new HashSet();
        hashSet.addAll(list);
        if (iSimulation != null) {
            ReportControl reportControl;
            Object object;
            Control[] controlArray;
            Control[] controlArray2 = controlArray = this.composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = controlArray2[n2];
                reportControl = (ReportControl)((Object)object);
                if (reportControl.getControlType().equals("SIMULATION_CONTROL_FACTORY") && reportControl.simulation == null) {
                    reportControl.setSimulation(iSimulation);
                    reportControl.redraw();
                    bl = true;
                }
                ++n2;
            }
            controlArray2 = controlArray;
            n = controlArray.length;
            n2 = 0;
            while (n2 < n) {
                object = controlArray2[n2];
                reportControl = (ReportControl)((Object)object);
                if (reportControl.getControlType().equals("SIMULATION_CONTROL_FACTORY") && reportControl.simulation != null && !hashSet.contains(reportControl.simulation)) {
                    reportControl.removeSelectionChangedListener(this);
                    reportControl.dispose();
                }
                ++n2;
            }
            if (!bl) {
                object = this.rcf.create(this.composite);
                ((ReportControl)((Object)object)).addSelectionChangedListener(this);
                ((ReportControl)((Object)object)).setSimulation(iSimulation);
                ((ReportControl)((Object)object)).addIRemoveListener(new IRemoveListener(){

                    public void identifiableRemoved(Identifiable identifiable) {
                        ReportViewer.this.removeIdentifiable(identifiable);
                    }
                });
                object.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent disposeEvent) {
                        ReportViewer.this.composite.layout(true, true);
                        ReportViewer.this.composite.redraw();
                    }
                });
            }
        } else if (this.composite.getChildren().length == 0) {
            ReportControl reportControl = this.rcf.create(this.composite);
            reportControl.addSelectionChangedListener(this);
            reportControl.addIRemoveListener(new IRemoveListener(){

                public void identifiableRemoved(Identifiable identifiable) {
                    ReportViewer.this.removeIdentifiable(identifiable);
                }
            });
            reportControl.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    ReportViewer.this.composite.layout(true, true);
                    ReportViewer.this.composite.redraw();
                }
            });
        }
        this.composite.layout(true, true);
        this.composite.redraw();
    }

    private void populateView() {
        Identifiable identifiable;
        ReportControl reportControl;
        Identifiable identifiable22;
        if (this.rcf.getFactoryType().equals("SIMULATION_CONTROL_FACTORY")) {
            return;
        }
        if (this.composite.isDisposed()) {
            return;
        }
        this.selection = null;
        HashSet<Identifiable> hashSet = new HashSet<Identifiable>();
        for (Identifiable identifiable22 : this.identifiablesToDisplay) {
            if (this.isDisplayed(identifiable22)) continue;
            hashSet.add(identifiable22);
        }
        Identifiable identifiable3 = identifiable22 = this.composite.getChildren();
        int n = ((Identifiable)identifiable3).length;
        int n2 = 0;
        while (n2 < n) {
            Identifiable identifiable4 = identifiable3[n2];
            reportControl = (ReportControl)identifiable4;
            if (reportControl.getControlType().equals("IDENTIFIABLE_CONTROL_FACTORY") && !hashSet.isEmpty() && !this.identifiablesToDisplay.contains(reportControl.getIdentifiable())) {
                identifiable = (Identifiable)hashSet.toArray()[0];
                reportControl.setIdentifiable(identifiable);
                hashSet.remove(identifiable);
            }
            ++n2;
        }
        identifiable3 = identifiable22;
        n = ((Identifiable)identifiable3).length;
        n2 = 0;
        while (n2 < n) {
            Identifiable identifiable5 = identifiable3[n2];
            reportControl = (ReportControl)identifiable5;
            if (reportControl.getControlType().equals("IDENTIFIABLE_CONTROL_FACTORY") && (identifiable = reportControl.getIdentifiable()) != null && !this.identifiablesToDisplay.contains(identifiable)) {
                reportControl.removeSelectionChangedListener(this);
                reportControl.dispose();
            }
            ++n2;
        }
        for (Identifiable identifiable6 : hashSet) {
            if (identifiable6 == null) continue;
            ReportControl reportControl2 = this.rcf.create(this.composite);
            reportControl2.addSelectionChangedListener(this);
            reportControl2.setIdentifiable(identifiable6);
            reportControl2.addIRemoveListener(new IRemoveListener(){

                public void identifiableRemoved(Identifiable identifiable) {
                    ReportViewer.this.removeIdentifiable(identifiable);
                }
            });
            reportControl2.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    ReportViewer.this.composite.layout(true, true);
                    ReportViewer.this.composite.redraw();
                }
            });
        }
        if (this.composite.getChildren().length == 0) {
            ReportControl reportControl3 = this.rcf.create(this.composite);
            reportControl3.addSelectionChangedListener(this);
            reportControl3.addIRemoveListener(new IRemoveListener(){

                public void identifiableRemoved(Identifiable identifiable) {
                    ReportViewer.this.removeIdentifiable(identifiable);
                }
            });
            reportControl3.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    ReportViewer.this.composite.layout(true, true);
                    ReportViewer.this.composite.redraw();
                }
            });
        }
        this.composite.layout(true, true);
        this.composite.redraw();
    }

    private Set<Identifiable> getIdentifiablesInSimulation(List<ISimulation> list) {
        LinkedHashSet<Identifiable> linkedHashSet = new LinkedHashSet<Identifiable>();
        int n = 0;
        while (n < list.size()) {
            ISimulation iSimulation = list.get(n);
            Graph graph = iSimulation.getScenario().getCanonicalGraph();
            if (graph != null) {
                Iterator<String> iterator = this.monitorSet.iterator();
                while (iterator != null && iterator.hasNext()) {
                    String string = iterator.next();
                    Node node = null;
                    URI uRI = null;
                    try {
                        uRI = URI.createURI((String)string);
                        node = graph.getNode(uRI);
                        if (node == null) continue;
                        linkedHashSet.add((Identifiable)node);
                    }
                    catch (Exception exception) {
                        Activator.logError("ReportViewer.getIdentifiablesInSimulation() Error setting Identifiable to " + string + " ", exception);
                    }
                }
            }
            ++n;
        }
        return linkedHashSet;
    }

    private Set<Identifiable> getIdentifiablesInSimulation(ISimulation iSimulation) {
        LinkedHashSet<Identifiable> linkedHashSet = new LinkedHashSet<Identifiable>();
        Graph graph = iSimulation.getScenario().getCanonicalGraph();
        if (graph != null) {
            Iterator<String> iterator = this.monitorSet.iterator();
            while (iterator != null && iterator.hasNext()) {
                String string = iterator.next();
                Node node = null;
                URI uRI = null;
                try {
                    uRI = URI.createURI((String)string);
                    node = graph.getNode(uRI);
                    if (node == null) continue;
                    linkedHashSet.add((Identifiable)node);
                }
                catch (Exception exception) {
                    Activator.logError("ReportViewer.getIdentifiablesInSimulation() Error setting Identifiable to " + string + " ", exception);
                }
            }
        }
        return linkedHashSet;
    }

    private boolean isDisplayed(Identifiable identifiable) {
        Control[] controlArray;
        boolean bl = false;
        Control[] controlArray2 = controlArray = this.composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray2[n2];
            ReportControl reportControl = (ReportControl)control;
            Identifiable identifiable2 = reportControl.getIdentifiable();
            if (identifiable2 != null && identifiable2.equals(identifiable)) {
                bl = true;
                break;
            }
            ++n2;
        }
        return bl;
    }

    private void savePreferenceState() {
        List list = null;
        HashSet<String> hashSet = new HashSet<String>();
        if (this.simulationManager != null) {
            list = this.simulationManager.getActiveSimulations();
        }
        if (list != null && list.size() >= 1) {
            int n = 0;
            while (n < list.size()) {
                Node node;
                Identifiable identifiable;
                hashSet.clear();
                ISimulation iSimulation = (ISimulation)list.get(n);
                String string = iSimulation.getScenario().getURI().toString();
                DialogSettings dialogSettings = new DialogSettings(string);
                Graph graph = iSimulation.getScenario().getCanonicalGraph();
                Iterator<Identifiable> iterator = this.identifiablesToDisplay.iterator();
                while (iterator != null && iterator.hasNext()) {
                    String string2;
                    identifiable = iterator.next();
                    if (identifiable == null || (node = graph.getNode(identifiable.getURI())) == null || (string2 = identifiable.getURI().toString()) == null) continue;
                    hashSet.add(string2);
                }
                identifiable = new String[hashSet.size()];
                node = hashSet.iterator();
                int n2 = 0;
                while (node != null && node.hasNext()) {
                    identifiable[n2] = (String)node.next();
                    ++n2;
                }
                dialogSettings.put(LOCATION_PREFERENCE_KEY, (String[])identifiable);
                if (this.masterSettings == null) {
                    this.masterSettings = new DialogSettings(ROOT_KEY);
                }
                this.masterSettings.addSection((IDialogSettings)dialogSettings);
                try {
                    this.masterSettings.save(this.getPrefFileName());
                }
                catch (IOException iOException) {
                    Activator.logError("exception writing file [" + iOException.getMessage() + "]", iOException);
                }
                ++n;
            }
        }
    }

    private void updatePreferenceState(ISimulation iSimulation) {
        String[] stringArray;
        String string;
        IDialogSettings iDialogSettings;
        if (this.masterSettings == null) {
            this.readMasterSettingsFromFile();
        }
        if ((iDialogSettings = this.masterSettings.getSection(string = iSimulation.getScenario().getURI().toString())) == null) {
            iDialogSettings = new DialogSettings(string);
            this.masterSettings.addSection(iDialogSettings);
        }
        if ((stringArray = iDialogSettings.getArray(LOCATION_PREFERENCE_KEY)) != null) {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray2[n2];
                this.monitorSet.add(string2);
                ++n2;
            }
        }
    }

    public void readMasterSettingsFromFile() {
        this.masterSettings = new DialogSettings(ROOT_KEY);
        String string = this.getPrefFileName();
        File file = new File(string);
        if (file.exists()) {
            try {
                this.masterSettings.load(string);
            }
            catch (IOException iOException) {
                Activator.logError("exception loading file [" + iOException.getMessage() + "]", iOException);
            }
        } else {
            try {
                this.masterSettings.save(string);
            }
            catch (IOException iOException) {
                Activator.logError("exception creating file [" + iOException.getMessage() + "]", iOException);
            }
        }
    }

    public String getPrefFileName() {
        String string = this.rcf.getUniqueControlName();
        String string2 = PATH.append(String.valueOf(string) + "_" + REPORTVIEWPREFERENCES_FILENAME).toOSString();
        return string2;
    }
}

