/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.reports.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Anchor;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Marker;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.model.type.ScatterSeries;
import org.eclipse.birt.chart.model.type.impl.ScatterSeriesImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.definitions.adapters.relativevalue.history.RelativeValueHistoryProvider;
import org.eclipse.stem.definitions.adapters.relativevalue.history.RelativeValueHistoryProviderAdapter;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.ui.preferences.VisualizationPreferencePage;
import org.eclipse.stem.ui.reports.Activator;
import org.eclipse.stem.ui.reports.views.Messages;
import org.eclipse.stem.ui.reports.views.ReportControl;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeSeriesCanvas
extends Canvas {
    protected IDeviceRenderer idr = null;
    protected Chart cm = null;
    private RelativeValueHistoryProvider rvhp;
    private ReportControl control = null;
    protected static final ColorDefinition[] colorDefault = new ColorDefinition[]{ColorDefinitionImpl.BLUE(), ColorDefinitionImpl.BLACK(), ColorDefinitionImpl.GREY(), ColorDefinitionImpl.CYAN(), ColorDefinitionImpl.ORANGE()};
    protected int seriesCount = 0;
    private double minLogScaleValue = 1.0;
    private static final int DEFAULT_AUTOAXIS_THRESHOLD = 5;
    private int maxTimeAxisValue = 5;
    private static final int MIN_TICKS = 5;
    private static final int MAX_TICKS = 10;
    private static final int TICK_TRIGGER = 2;
    protected Map<ItemPropertyDescriptor, Boolean> propertiesToPlot = new HashMap<ItemPropertyDescriptor, Boolean>();
    private static final String[] HIDE_ON_STARTUP = new String[]{"IR", "IF", "Incidence", "Births", "Deaths"};
    private static final Set<String> defaultHideSet = new HashSet<String>();
    protected final Map<String, DataSeries> dataSeriesMap = new HashMap<String, DataSeries>();
    private final List<Integer> cycleNumbers = new ArrayList<Integer>();
    Generator gr;
    Axis yAxisPrimary;
    Axis xAxisPrimary;
    Menu popUpMenu = null;
    private LinearScaleAction linearTimeAction;
    private LogScaleAction logTimeAction;
    protected boolean useLinearTimeScale = true;
    private LegendViewAction viewLegend;
    private LegendHideAction hideLegend;
    protected boolean showLegend = true;
    protected Legend legend = null;
    private static final String defaultKey = "S";
    Image imgChart = null;

    public TimeSeriesCanvas(Composite composite) {
        super(composite, 0x20000800);
        int n = 0;
        while (n < HIDE_ON_STARTUP.length) {
            defaultHideSet.add(HIDE_ON_STARTUP[n]);
            ++n;
        }
        this.gr = Generator.instance();
        try {
            this.idr = PluginSettings.instance().getDevice("dv.SWT");
        }
        catch (ChartException chartException) {
            Activator.logError("Problem initializing chart", chartException);
            return;
        }
        this.control = (ReportControl)composite;
        this.rvhp = this.control.rvhp;
        this.cm = this.createSimpleLineChart(this.dataSeriesMap, this.cycleNumbers, Messages.getString("CC.title"));
        this.resetData();
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                Composite composite = (Composite)paintEvent.getSource();
                Rectangle rectangle = composite.getClientArea();
                if (TimeSeriesCanvas.this.imgChart != null) {
                    TimeSeriesCanvas.this.imgChart.dispose();
                }
                TimeSeriesCanvas.this.imgChart = new Image((Device)composite.getDisplay(), rectangle);
                TimeSeriesCanvas.this.idr.setProperty("device.output.context", (Object)new GC((Drawable)TimeSeriesCanvas.this.imgChart));
                Bounds bounds = BoundsImpl.create((double)rectangle.x, (double)rectangle.y, (double)rectangle.width, (double)rectangle.height);
                bounds.scale(72.0 / (double)TimeSeriesCanvas.this.idr.getDisplayServer().getDpiResolution());
                try {
                    TimeSeriesCanvas.this.gr.render(TimeSeriesCanvas.this.idr, TimeSeriesCanvas.this.gr.build(TimeSeriesCanvas.this.idr.getDisplayServer(), TimeSeriesCanvas.this.cm, bounds, null, null, null));
                    paintEvent.gc.drawImage(TimeSeriesCanvas.this.imgChart, rectangle.x, rectangle.y);
                }
                catch (ChartException chartException) {
                    Activator.logError("Problem rendering chart", chartException);
                }
            }
        });
        this.createContextMenu((Composite)this);
    }

    public void draw() {
        if (this.rvhp != null) {
            for (DataSeries object2 : this.dataSeriesMap.values()) {
                object2.hide();
            }
            Iterator<ItemPropertyDescriptor> iterator = this.propertiesToPlot.keySet().iterator();
            ArrayList arrayList = new ArrayList();
            while (iterator != null && iterator.hasNext()) {
                DataSeries dataSeries;
                ItemPropertyDescriptor itemPropertyDescriptor = iterator.next();
                boolean bl = this.propertiesToPlot.get(itemPropertyDescriptor);
                arrayList.add(itemPropertyDescriptor);
                if (bl) {
                    if (!this.dataSeriesMap.containsKey(itemPropertyDescriptor.getDisplayName((Object)itemPropertyDescriptor)) || (dataSeries = this.dataSeriesMap.get(itemPropertyDescriptor.getDisplayName((Object)itemPropertyDescriptor))).isVisible()) continue;
                    dataSeries.show();
                    continue;
                }
                if (!this.dataSeriesMap.containsKey(itemPropertyDescriptor.getDisplayName((Object)itemPropertyDescriptor)) || !(dataSeries = this.dataSeriesMap.get(itemPropertyDescriptor.getDisplayName((Object)itemPropertyDescriptor))).isVisible()) continue;
                dataSeries.hide();
            }
            double d = this.rvhp.getDenominator(null);
            if (d <= 0.0) {
                d = 1.0;
            }
            this.minLogScaleValue = 0.1 / d;
            this.resetData();
            boolean bl = false;
            int n = 0;
            STEMTime[] sTEMTimeArray = this.rvhp.getAllHistoricTimeValues();
            this.cycleNumbers.clear();
            this.cycleNumbers.add(new Integer(0));
            int n2 = 0;
            while (n2 < arrayList.size()) {
                ItemPropertyDescriptor itemPropertyDescriptor = (ItemPropertyDescriptor)arrayList.get(n2);
                String string = itemPropertyDescriptor.getDisplayName((Object)itemPropertyDescriptor);
                double[] dArray = this.rvhp.getHistoricInstances(itemPropertyDescriptor, sTEMTimeArray);
                if (dArray.length > 0) {
                    if (n < dArray.length) {
                        n = dArray.length;
                    }
                    if (!this.dataSeriesMap.containsKey(itemPropertyDescriptor.getDisplayName((Object)itemPropertyDescriptor))) {
                        DataSeries dataSeries = new DataSeries(string, this.seriesCount);
                        if (dArray.length < n) {
                            int n3 = dArray.length;
                            while (n3 < n - 1) {
                                dataSeries.addValue(new Double(0.0));
                                ++n3;
                            }
                        }
                        this.dataSeriesMap.put(string, dataSeries);
                    }
                    int n4 = this.rvhp.getEarliestCycleNumber();
                    DataSeries dataSeries = this.dataSeriesMap.get(itemPropertyDescriptor.getDisplayName((Object)itemPropertyDescriptor));
                    dataSeries.setColorDefs(itemPropertyDescriptor.getDisplayName((Object)itemPropertyDescriptor));
                    int n5 = 0;
                    while (n5 < dArray.length) {
                        double d2 = dArray[n5];
                        if (d2 <= this.minLogScaleValue) {
                            d2 = this.minLogScaleValue;
                        }
                        Double d3 = this.useLinearTimeScale ? new Double(d2) : new Double(Math.log(d2));
                        dataSeries.addValue(d3);
                        if (!bl) {
                            this.cycleNumbers.add(new Integer(n4 + n5 + 1));
                            if (this.cycleNumbers.size() > 2 * this.maxTimeAxisValue) {
                                this.maxTimeAxisValue = this.cycleNumbers.size() + 1;
                                int n6 = this.maxTimeAxisValue / 5;
                                this.xAxisPrimary.getScale().setStep((double)n6);
                            }
                        }
                        ++n5;
                    }
                    bl = true;
                } else {
                    this.resetData();
                }
                ++n2;
            }
        } else {
            this.resetData();
        }
        for (DataSeries dataSeries : this.dataSeriesMap.values()) {
            if (dataSeries.relativeValues.size() >= this.cycleNumbers.size()) continue;
            dataSeries.relativeValues.clear();
            int n = 0;
            while (n < this.cycleNumbers.size()) {
                dataSeries.addValue(new Double(0.0));
                ++n;
            }
        }
        if (!this.isDisposed()) {
            this.redraw();
        }
    }

    private void createContextMenu(Composite composite) {
        MenuManager menuManager = new MenuManager();
        this.linearTimeAction = new LinearScaleAction();
        this.logTimeAction = new LogScaleAction();
        menuManager.add((IAction)this.linearTimeAction);
        menuManager.add((IAction)this.logTimeAction);
        menuManager.add((IContributionItem)new Separator("additions"));
        this.viewLegend = new LegendViewAction();
        this.hideLegend = new LegendHideAction();
        menuManager.add((IAction)this.viewLegend);
        menuManager.add((IAction)this.hideLegend);
        menuManager.add((IContributionItem)new Separator("additions"));
        this.popUpMenu = menuManager.createContextMenu((Control)composite);
        composite.setMenu(this.popUpMenu);
    }

    private void updateContextMenu(Composite composite) {
        List list;
        this.popUpMenu.dispose();
        MenuManager menuManager = new MenuManager();
        this.linearTimeAction = new LinearScaleAction();
        this.logTimeAction = new LogScaleAction();
        menuManager.add((IAction)this.linearTimeAction);
        menuManager.add((IAction)this.logTimeAction);
        menuManager.add((IContributionItem)new Separator("additions"));
        this.viewLegend = new LegendViewAction();
        this.hideLegend = new LegendHideAction();
        menuManager.add((IAction)this.viewLegend);
        menuManager.add((IAction)this.hideLegend);
        menuManager.add((IContributionItem)new Separator("additions"));
        if (this.rvhp != null) {
            list = this.rvhp.getProperties();
            int n = 0;
            while (n < list.size()) {
                ItemPropertyDescriptor itemPropertyDescriptor = (ItemPropertyDescriptor)list.get(n);
                DisplayableProperty displayableProperty = new DisplayableProperty(itemPropertyDescriptor);
                menuManager.add((IAction)displayableProperty);
                ++n;
            }
        }
        menuManager.add((IContributionItem)new Separator("additions"));
        list = menuManager.createContextMenu((Control)composite);
        composite.setMenu((Menu)list);
    }

    public final Chart createSimpleLineChart(Map<String, DataSeries> map, List<Integer> list, String string) {
        ChartWithAxes chartWithAxes = ChartWithAxesImpl.create();
        ColorDefinition colorDefinition = ColorDefinitionImpl.WHITE();
        ColorDefinition colorDefinition2 = ColorDefinitionImpl.BLACK();
        ColorDefinition colorDefinition3 = ColorDefinitionImpl.create((int)50, (int)50, (int)50);
        chartWithAxes.getBlock().setBackground((Fill)colorDefinition3);
        Plot plot = chartWithAxes.getPlot();
        plot.getClientArea().setBackground((Fill)colorDefinition2);
        chartWithAxes.getTitle().setVisible(false);
        this.legend = chartWithAxes.getLegend();
        LineAttributes lineAttributes = this.legend.getOutline();
        this.legend.getText().getFont().setSize(8.0f);
        lineAttributes.setStyle(LineStyle.SOLID_LITERAL);
        this.legend.getInsets().set(10.0, 5.0, 0.0, 0.0);
        this.legend.getOutline().setVisible(false);
        this.legend.setAnchor(Anchor.NORTH_LITERAL);
        this.legend.setPosition(Position.BELOW_LITERAL);
        this.legend.getText().setColor(colorDefinition);
        this.legend.getOutline().setColor(colorDefinition);
        this.xAxisPrimary = chartWithAxes.getPrimaryBaseAxes()[0];
        this.xAxisPrimary.getMajorGrid().setTickStyle(TickStyle.BELOW_LITERAL);
        this.xAxisPrimary.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        this.xAxisPrimary.getTitle().setVisible(false);
        this.xAxisPrimary.getTitle().getCaption().getFont().setSize(9.0f);
        this.xAxisPrimary.getTitle().getCaption().setColor(colorDefinition);
        this.xAxisPrimary.getLabel().getCaption().setColor(colorDefinition);
        this.xAxisPrimary.setType(AxisType.LINEAR_LITERAL);
        Series series = SeriesImpl.create();
        series.getLabel().getCaption().setColor(colorDefinition);
        series.getLabel().getOutline().setColor(colorDefinition);
        NumberDataSet numberDataSet = NumberDataSetImpl.create(list);
        series.setDataSet((DataSet)numberDataSet);
        SeriesDefinition seriesDefinition = SeriesDefinitionImpl.create();
        this.xAxisPrimary.getSeriesDefinitions().add((Object)seriesDefinition);
        seriesDefinition.getSeries().add((Object)series);
        this.yAxisPrimary = chartWithAxes.getPrimaryOrthogonalAxis(this.xAxisPrimary);
        this.yAxisPrimary.getMajorGrid().setTickStyle(TickStyle.LEFT_LITERAL);
        this.xAxisPrimary.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
        this.xAxisPrimary.getScale().setStep(1.0);
        this.xAxisPrimary.getLabel().getCaption().getFont().setSize(9.0f);
        this.xAxisPrimary.getLabel().getCaption().setColor(colorDefinition);
        this.setTimeLabel();
        this.yAxisPrimary.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
        this.yAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)1.0));
        this.yAxisPrimary.getScale().setStep(0.25);
        this.yAxisPrimary.getLabel().getCaption().getFont().setSize(9.0f);
        this.yAxisPrimary.getLabel().getCaption().setColor(colorDefinition);
        if (!map.containsKey(defaultKey)) {
            DataSeries dataSeries = new DataSeries(defaultKey, this.seriesCount);
            map.put(defaultKey, dataSeries);
        }
        return chartWithAxes;
    }

    void setTimeLabel() {
        ISimulation iSimulation;
        String string = "";
        if (this.control != null && (iSimulation = this.control.simulation) != null) {
            long l = iSimulation.getScenario().getSequencer().getTimeDelta();
            if (l < STEMTime.Units.MINUTE.getMilliseconds()) {
                string = "secs";
                this.xAxisPrimary.getTitle().setVisible(true);
                this.xAxisPrimary.getTitle().getCaption().setValue(string);
                return;
            }
            if (l < STEMTime.Units.HOUR.getMilliseconds()) {
                string = "mins";
                this.xAxisPrimary.getTitle().setVisible(true);
                this.xAxisPrimary.getTitle().getCaption().setValue(string);
                return;
            }
            if (l < STEMTime.Units.DAY.getMilliseconds()) {
                string = "hrs";
                this.xAxisPrimary.getTitle().setVisible(true);
                this.xAxisPrimary.getTitle().getCaption().setValue(string);
                return;
            }
            if (l <= STEMTime.Units.WEEK.getMilliseconds()) {
                string = "days";
                this.xAxisPrimary.getTitle().setVisible(true);
                this.xAxisPrimary.getTitle().getCaption().setValue(string);
                return;
            }
            if (l < 4L * STEMTime.Units.WEEK.getMilliseconds()) {
                string = "weeks";
                this.xAxisPrimary.getTitle().setVisible(true);
                this.xAxisPrimary.getTitle().getCaption().setValue(string);
                return;
            }
            if (l < STEMTime.Units.YEAR.getMilliseconds()) {
                string = "months";
                this.xAxisPrimary.getTitle().setVisible(true);
                this.xAxisPrimary.getTitle().getCaption().setValue(string);
                return;
            }
            string = "years";
            this.xAxisPrimary.getTitle().setVisible(true);
            this.xAxisPrimary.getTitle().getCaption().setValue(string);
            return;
        }
    }

    public void setDataSourceAndRedraw(RelativeValueHistoryProviderAdapter relativeValueHistoryProviderAdapter, List<ItemPropertyDescriptor> list) {
        this.propertiesToPlot = this.addProperties(list);
        if (relativeValueHistoryProviderAdapter != this.rvhp) {
            this.propertiesToPlot.clear();
            this.propertiesToPlot = this.addProperties(list);
            this.rvhp = relativeValueHistoryProviderAdapter;
            this.updateContextMenu((Composite)this);
        }
        this.draw();
    }

    protected List<ItemPropertyDescriptor> filterPreferredProperties(List<ItemPropertyDescriptor> list) {
        ArrayList<ItemPropertyDescriptor> arrayList = new ArrayList<ItemPropertyDescriptor>();
        Set set = VisualizationPreferencePage.getPreferenceSet();
        int n = 0;
        while (n < list.size()) {
            ItemPropertyDescriptor itemPropertyDescriptor = list.get(n);
            if (set.contains(itemPropertyDescriptor.getDisplayName((Object)itemPropertyDescriptor))) {
                arrayList.add(itemPropertyDescriptor);
            }
            ++n;
        }
        if (arrayList.size() == 0) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    protected Map<ItemPropertyDescriptor, Boolean> addProperties(List<ItemPropertyDescriptor> list) {
        int n = 0;
        while (n < list.size()) {
            ItemPropertyDescriptor itemPropertyDescriptor = list.get(n);
            if (!this.propertiesToPlot.containsKey(itemPropertyDescriptor)) {
                boolean bl = true;
                if (defaultHideSet.contains(itemPropertyDescriptor.getDisplayName((Object)itemPropertyDescriptor))) {
                    bl = false;
                }
                Boolean bl2 = new Boolean(bl);
                this.propertiesToPlot.put(itemPropertyDescriptor, bl2);
            }
            ++n;
        }
        return this.propertiesToPlot;
    }

    public void setRelativeValueHistoryProvider(RelativeValueHistoryProvider relativeValueHistoryProvider) {
        this.rvhp = relativeValueHistoryProvider;
    }

    public void dispose() {
        super.dispose();
    }

    public void reset() {
        this.resetData();
        this.rvhp = null;
        this.redraw();
    }

    protected void resetData() {
        this.clearData();
        if (!this.dataSeriesMap.containsKey(defaultKey)) {
            DataSeries dataSeries = new DataSeries(defaultKey, this.seriesCount);
            this.dataSeriesMap.put(defaultKey, dataSeries);
        }
        this.cycleNumbers.add(new Integer(0));
    }

    private void clearData() {
        Iterator<String> iterator = this.dataSeriesMap.keySet().iterator();
        while (iterator != null && iterator.hasNext()) {
            String string = iterator.next();
            DataSeries dataSeries = this.dataSeriesMap.get(string);
            dataSeries.relativeValues.clear();
            dataSeries.addValue(new Double(0.0));
            this.xAxisPrimary.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
            this.maxTimeAxisValue = 5;
            this.xAxisPrimary.getScale().setStep(1.0);
        }
        this.cycleNumbers.clear();
    }

    void toggleAxisScale() {
        if (this.useLinearTimeScale) {
            this.logTimeAction.setChecked(true);
            this.linearTimeAction.setChecked(false);
            this.yAxisPrimary.getScale().setMin(null);
            this.yAxisPrimary.getScale().setMax(null);
            this.yAxisPrimary.getScale().unsetStep();
            this.yAxisPrimary.getScale().unsetStepNumber();
        } else {
            this.logTimeAction.setChecked(false);
            this.linearTimeAction.setChecked(true);
            this.yAxisPrimary.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
            this.yAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)1.0));
            this.yAxisPrimary.getScale().setStep(0.25);
        }
        this.useLinearTimeScale = !this.useLinearTimeScale;
    }

    void toggleLegend() {
        if (this.showLegend) {
            this.viewLegend.setChecked(false);
            this.hideLegend.setChecked(true);
            this.legend.setVisible(false);
        } else {
            this.viewLegend.setChecked(true);
            this.hideLegend.setChecked(false);
            this.legend.setVisible(true);
        }
        this.showLegend = !this.showLegend;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DataSeries {
        public String propertyName = "";
        public List<Double> relativeValues = new ArrayList<Double>();
        public LineSeries lineSeries = null;
        private boolean visible = true;
        private SeriesDefinition sdY = null;
        private int seriesIndex = 0;

        public boolean isVisible() {
            return this.visible;
        }

        public DataSeries(String string, int n) {
            this.propertyName = string;
            this.seriesIndex = n;
            ++TimeSeriesCanvas.this.seriesCount;
            this.relativeValues = new ArrayList<Double>();
            this.relativeValues.add(new Double(0.0));
            this.addLineSeries(string);
        }

        public void addValue(Double d) {
            if (this.relativeValues == null) {
                this.relativeValues = new ArrayList<Double>();
            }
            this.relativeValues.add(d);
        }

        public void addLineSeries(String string) {
            NumberDataSet numberDataSet = NumberDataSetImpl.create(this.relativeValues);
            if (this.lineSeries == null) {
                this.lineSeries = (ScatterSeries)ScatterSeriesImpl.create();
            }
            this.lineSeries.setDataSet((DataSet)numberDataSet);
            this.lineSeries.getLineAttributes().setVisible(true);
            this.setColorDefs(string);
            if (!this.lineSeries.getMarkers().isEmpty()) {
                Marker marker = (Marker)this.lineSeries.getMarkers().get(0);
                marker.setVisible(false);
            }
            this.sdY = SeriesDefinitionImpl.create();
            this.sdY.getSeries().add((Object)this.lineSeries);
            TimeSeriesCanvas.this.yAxisPrimary.getSeriesDefinitions().add((Object)this.sdY);
            TimeSeriesCanvas.this.setTimeLabel();
        }

        public void hide() {
            this.lineSeries.setVisible(false);
            this.visible = false;
        }

        public void show() {
            this.lineSeries.setVisible(true);
            this.visible = true;
        }

        public void setColorDefs(String string) {
            Map map = VisualizationPreferencePage.getColorMapping();
            int n = this.seriesIndex % colorDefault.length;
            ColorDefinition colorDefinition = colorDefault[n];
            if (map.containsKey(string)) {
                Color color = (Color)map.get(string);
                colorDefinition = ColorDefinitionImpl.create((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue());
            }
            this.lineSeries.setSeriesIdentifier((Object)string);
            this.lineSeries.getLineAttributes().setColor(colorDefinition);
        }

        public int getDataSize() {
            return this.relativeValues.size();
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public void setPropertyName(String string) {
            this.propertyName = string;
        }

        public List<Double> getRelativeValues() {
            return this.relativeValues;
        }

        public void setRelativeValues(List<Double> list) {
            this.relativeValues = list;
        }

        public LineSeries getLineSeries() {
            return this.lineSeries;
        }

        public void setLineSeries(LineSeries lineSeries) {
            this.lineSeries = lineSeries;
        }
    }

    protected class DisplayableProperty
    extends Action {
        ItemPropertyDescriptor property;

        public DisplayableProperty(ItemPropertyDescriptor itemPropertyDescriptor) {
            super(itemPropertyDescriptor.getDisplayName((Object)itemPropertyDescriptor), 2);
            this.property = null;
            this.property = itemPropertyDescriptor;
            this.setChecked(TimeSeriesCanvas.this.propertiesToPlot.get(itemPropertyDescriptor));
        }

        public String getText() {
            return this.property.getDisplayName((Object)this.property);
        }

        public void run() {
            boolean bl = TimeSeriesCanvas.this.propertiesToPlot.get(this.property) == false;
            TimeSeriesCanvas.this.propertiesToPlot.put(this.property, new Boolean(bl));
            this.setChecked(bl);
        }
    }

    class LegendHideAction
    extends Action {
        public LegendHideAction() {
            super(Messages.getString("ContextMenu.HideLegend"), 2);
            this.setChecked(!TimeSeriesCanvas.this.showLegend);
        }

        public String getText() {
            return Messages.getString("ContextMenu.HideLegend");
        }

        public void run() {
            if (!TimeSeriesCanvas.this.showLegend) {
                this.setChecked(true);
            } else {
                TimeSeriesCanvas.this.toggleLegend();
            }
        }
    }

    protected class LegendViewAction
    extends Action {
        public LegendViewAction() {
            super(Messages.getString("ContextMenu.ShowLegend"), 2);
            this.setChecked(TimeSeriesCanvas.this.showLegend);
        }

        public String getText() {
            return Messages.getString("ContextMenu.ShowLegend");
        }

        public void run() {
            if (TimeSeriesCanvas.this.showLegend) {
                this.setChecked(true);
            } else {
                TimeSeriesCanvas.this.toggleLegend();
            }
        }
    }

    protected class LinearScaleAction
    extends Action {
        public LinearScaleAction() {
            super(Messages.getString("ContextMenu.LinearTimeScale"), 2);
            this.setChecked(TimeSeriesCanvas.this.useLinearTimeScale);
        }

        public String getText() {
            return Messages.getString("ContextMenu.LinearTimeScale");
        }

        public void run() {
            if (TimeSeriesCanvas.this.useLinearTimeScale) {
                this.setChecked(true);
            } else {
                TimeSeriesCanvas.this.toggleAxisScale();
            }
        }
    }

    class LogScaleAction
    extends Action {
        public LogScaleAction() {
            super(Messages.getString("ContextMenu.LogTimeScale"), 2);
            this.setChecked(!TimeSeriesCanvas.this.useLinearTimeScale);
        }

        public String getText() {
            return Messages.getString("ContextMenu.LogTimeScale");
        }

        public void run() {
            if (!TimeSeriesCanvas.this.useLinearTimeScale) {
                this.setChecked(true);
            } else {
                TimeSeriesCanvas.this.toggleAxisScale();
            }
        }
    }
}

