/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.externaldatasource.impl;

import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.stem.analysis.ScenarioInitializationException;
import org.eclipse.stem.analysis.impl.ReferenceScenarioDataMapImpl;
import org.eclipse.stem.analysis.util.CSVscenarioLoader;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.definitions.labels.AreaLabel;
import org.eclipse.stem.definitions.labels.PopulationLabel;
import org.eclipse.stem.diseasemodels.Activator;
import org.eclipse.stem.diseasemodels.externaldatasource.ExternalDataSourceDiseaseModel;
import org.eclipse.stem.diseasemodels.externaldatasource.ExternalDataSourcePackage;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelState;
import org.eclipse.stem.diseasemodels.standard.Infector;
import org.eclipse.stem.diseasemodels.standard.SEIRLabelValue;
import org.eclipse.stem.diseasemodels.standard.SILabelValue;
import org.eclipse.stem.diseasemodels.standard.SIRLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelState;
import org.eclipse.stem.diseasemodels.standard.StandardFactory;
import org.eclipse.stem.diseasemodels.standard.impl.DiseaseModelImpl;
import org.eclipse.stem.diseasemodels.standard.impl.SEIRLabelValueImpl;
import org.eclipse.stem.diseasemodels.standard.impl.SILabelValueImpl;
import org.eclipse.stem.diseasemodels.standard.impl.SIRLabelValueImpl;
import org.eclipse.stem.diseasemodels.standard.provider.StandardItemProviderAdapterFactory;

public class ExternalDataSourceDiseaseModelImpl
extends DiseaseModelImpl
implements ExternalDataSourceDiseaseModel {
    protected static final String DATA_PATH_EDEFAULT = null;
    protected String dataPath = DATA_PATH_EDEFAULT;
    protected static final String DISEASE_TYPE_EDEFAULT = null;
    public static final String LOCATIONID_PREFIX = "/node/geo/region/";
    public String dirName = DEFAULT_DIR;
    private ReferenceScenarioDataMapImpl scenarioMap = null;
    private ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance dataInstance = null;
    private int fileLineCounter = 0;
    public static String labelS = null;
    public static String labelE = null;
    public static String labelI = null;
    public static String labelR = null;
    private double totalPopulationCount = 0.0;
    private double totalArea = 0.0;
    private String diseaseType;

    public void updateLabels(STEMTime sTEMTime, long l, int n) {
        for (StandardDiseaseModelLabel standardDiseaseModelLabel : this.getLabelsToUpdate()) {
            assert (standardDiseaseModelLabel.getPopulationLabel().getPopulationIdentifier().equals(this.getPopulationIdentifier()));
            StandardDiseaseModelLabelValue standardDiseaseModelLabelValue = (StandardDiseaseModelLabelValue)standardDiseaseModelLabel.getCurrentValue();
            this.importDiseaseData(standardDiseaseModelLabelValue, standardDiseaseModelLabel, sTEMTime, l);
            StandardDiseaseModelLabelValue standardDiseaseModelLabelValue2 = (StandardDiseaseModelLabelValue)standardDiseaseModelLabel.getNextValue();
            standardDiseaseModelLabelValue2.set((DiseaseModelLabelValue)standardDiseaseModelLabelValue);
            assert (standardDiseaseModelLabelValue2.sane()) : "disease state is insane after subtracting deaths: " + standardDiseaseModelLabelValue2.toString();
            standardDiseaseModelLabel.setNextValueValid(true);
        }
        ++this.fileLineCounter;
    }

    private static void setPropertyLabels() {
        SEIRLabelValue sEIRLabelValue = StandardFactory.eINSTANCE.createSEIRLabel().getCurrentSEIRValue();
        StandardItemProviderAdapterFactory standardItemProviderAdapterFactory = new StandardItemProviderAdapterFactory();
        IItemPropertySource iItemPropertySource = (IItemPropertySource)standardItemProviderAdapterFactory.adapt((Notifier)sEIRLabelValue, PropertySource.class);
        List list = iItemPropertySource.getPropertyDescriptors(null);
        IItemPropertyDescriptor iItemPropertyDescriptor = (IItemPropertyDescriptor)list.get(3);
        IItemPropertyDescriptor iItemPropertyDescriptor2 = (IItemPropertyDescriptor)list.get(6);
        IItemPropertyDescriptor iItemPropertyDescriptor3 = (IItemPropertyDescriptor)list.get(4);
        IItemPropertyDescriptor iItemPropertyDescriptor4 = (IItemPropertyDescriptor)list.get(5);
        labelS = iItemPropertyDescriptor.getDisplayName((Object)iItemPropertyDescriptor);
        labelE = iItemPropertyDescriptor2.getDisplayName((Object)iItemPropertyDescriptor2);
        labelI = iItemPropertyDescriptor3.getDisplayName((Object)iItemPropertyDescriptor3);
        labelR = iItemPropertyDescriptor4.getDisplayName((Object)iItemPropertyDescriptor4);
    }

    public StandardDiseaseModelLabelValue importDiseaseData(StandardDiseaseModelLabelValue standardDiseaseModelLabelValue, StandardDiseaseModelLabel standardDiseaseModelLabel, STEMTime sTEMTime, long l) {
        String string;
        if (labelS == null) {
            ExternalDataSourceDiseaseModelImpl.setPropertyLabels();
        }
        Identifiable identifiable = standardDiseaseModelLabel.getIdentifiable();
        String string2 = identifiable.getURI().toString();
        int n = string2.lastIndexOf(LOCATIONID_PREFIX);
        String string3 = string2.substring(n += LOCATIONID_PREFIX.length(), string2.length());
        if (this.scenarioMap == null) {
            try {
                CSVscenarioLoader cSVscenarioLoader = new CSVscenarioLoader(this.dataPath);
                cSVscenarioLoader.getMaxResolution();
                this.scenarioMap = cSVscenarioLoader.parseAllFiles();
                this.diseaseType = cSVscenarioLoader.getType().name();
            }
            catch (ScenarioInitializationException scenarioInitializationException) {
                Activator.logError((String)"Error reading scenario files", (Throwable)scenarioInitializationException);
                return null;
            }
        }
        this.dataInstance = this.scenarioMap.getLocation(string3);
        if (this.dataInstance == null || this.dataInstance.getSize() == 0) {
            if (this.diseaseType.equals("SI")) {
                return new SILabelValueImpl(0.0, 0.0, 0.0, 0.0);
            }
            if (this.diseaseType.equals("SIR")) {
                return new SIRLabelValueImpl(0.0, 0.0, 0.0, 0.0, 0.0);
            }
            if (this.diseaseType.equals("SEIR")) {
                return new SEIRLabelValueImpl(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            }
            throw new UnsupportedOperationException("ExternalDataSource Invalid Type " + this.diseaseType + " must be SI, SIR, or SEIR");
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        if (this.dataInstance.getData(labelS).size() > this.fileLineCounter) {
            string = (String)this.dataInstance.getData(labelS).get(this.fileLineCounter);
            d = new Double(string);
        }
        if (this.diseaseType.equals("SEIR") && this.dataInstance.getData(labelE).size() > this.fileLineCounter) {
            string = (String)this.dataInstance.getData(labelE).get(this.fileLineCounter);
            d2 = new Double(string);
        }
        if (this.dataInstance.getData(labelI).size() > this.fileLineCounter) {
            string = (String)this.dataInstance.getData(labelI).get(this.fileLineCounter);
            d3 = new Double(string);
        }
        if ((this.diseaseType.equals("SIR") || this.diseaseType.equals("SEIR")) && this.dataInstance.getData(labelR).size() > this.fileLineCounter) {
            string = (String)this.dataInstance.getData(labelR).get(this.fileLineCounter);
            d4 = new Double(string);
        }
        if (this.diseaseType.equals("SI")) {
            ((SILabelValue)standardDiseaseModelLabelValue).setS(d);
            ((SILabelValue)standardDiseaseModelLabelValue).setI(d3);
            return new SILabelValueImpl(0.0, 0.0, 0.0, 0.0);
        }
        if (this.diseaseType.equals("SIR")) {
            ((SIRLabelValue)standardDiseaseModelLabelValue).setS(d);
            ((SIRLabelValue)standardDiseaseModelLabelValue).setI(d3);
            ((SIRLabelValue)standardDiseaseModelLabelValue).setR(d4);
            return new SIRLabelValueImpl(0.0, 0.0, 0.0, 0.0, 0.0);
        }
        if (this.diseaseType.equals("SEIR")) {
            ((SEIRLabelValue)standardDiseaseModelLabelValue).setS(d);
            ((SEIRLabelValue)standardDiseaseModelLabelValue).setE(d2);
            ((SEIRLabelValue)standardDiseaseModelLabelValue).setI(d3);
            ((SEIRLabelValue)standardDiseaseModelLabelValue).setR(d4);
            return new SEIRLabelValueImpl(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        throw new UnsupportedOperationException("ExternalDataSource Invalid Type " + this.diseaseType + " must be SI, SIR, or SEIR");
    }

    public DiseaseModelState createDiseaseModelState() {
        return StandardFactory.eINSTANCE.createSIDiseaseModelState();
    }

    public DiseaseModelLabel createDiseaseModelLabel() {
        if (this.diseaseType == "SI") {
            return StandardFactory.eINSTANCE.createSILabel();
        }
        if (this.diseaseType == "SIR") {
            return StandardFactory.eINSTANCE.createSIRLabel();
        }
        return StandardFactory.eINSTANCE.createSEIRLabel();
    }

    public DiseaseModelLabelValue createDiseaseModelLabelValue() {
        return StandardFactory.eINSTANCE.createSEIRLabelValue();
    }

    public DiseaseModelState initializeDiseaseState(DiseaseModelState diseaseModelState, DiseaseModelLabel diseaseModelLabel) {
        PopulationLabel populationLabel = diseaseModelLabel.getPopulationLabel();
        double d = populationLabel.getCurrentPopulationValue().getCount();
        this.addToTotalPopulationCount(d);
        double d2 = this.getArea(populationLabel);
        if (d2 <= 0.0) {
            this.reportBadAreaValue(populationLabel, d2);
            d2 = 1.0;
        }
        this.addToTotalArea(d2);
        return diseaseModelState;
    }

    public void initializeDiseaseState(DiseaseModelLabel diseaseModelLabel) {
        StandardDiseaseModelState standardDiseaseModelState = (StandardDiseaseModelState)diseaseModelLabel.getDiseaseModelState();
        if (this.totalPopulationCount > 0.0) {
            double d = this.getArea(diseaseModelLabel.getPopulationLabel());
            if (d <= 0.0) {
                this.reportBadAreaValue(diseaseModelLabel.getPopulationLabel(), d);
                d = 1.0;
            }
            double d2 = this.totalArea / d;
            standardDiseaseModelState.setAreaRatio(d2);
        }
    }

    public Infector createInfector() {
        throw new UnsupportedOperationException();
    }

    public void addToTotalArea(double d) {
        this.totalArea += d;
    }

    public void addToTotalPopulationCount(double d) {
        this.totalPopulationCount += d;
    }

    private double getArea(PopulationLabel populationLabel) {
        double d = 0.0;
        d = populationLabel.getPopulatedArea();
        if (d == 0.0) {
            for (NodeLabel nodeLabel : populationLabel.getNode().getLabels()) {
                if (!(nodeLabel instanceof AreaLabel)) continue;
                AreaLabel areaLabel = (AreaLabel)nodeLabel;
                d = areaLabel.getCurrentAreaValue().getArea();
                break;
            }
        }
        return d;
    }

    private void reportBadAreaValue(PopulationLabel populationLabel, double d) {
        if (populationLabel.getPopulatedArea() == 0.0) {
            Activator.logError((String)("The area value of \"" + d + "\" specified for \"" + populationLabel.getNode().toString() + "\" is not greater than zero (0.0)"), null);
        } else {
            Activator.logError((String)("The area value of \"" + d + "\" specified for the population \"" + populationLabel.getName() + "\" for the region \"" + populationLabel.getNode().toString() + "\" is not greater than zero (0.0)"), null);
        }
    }

    protected EClass eStaticClass() {
        return ExternalDataSourcePackage.Literals.EXTERNAL_DATA_SOURCE_DISEASE_MODEL;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public void setDataPath(String string) {
        String string2 = this.dataPath;
        this.dataPath = string;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 16, (Object)string2, (Object)this.dataPath));
        }
    }

    public String getDiseaseType() {
        return this.diseaseType;
    }

    public void setDiseaseType(String string) {
        String string2 = this.diseaseType;
        this.diseaseType = string;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 17, (Object)string2, (Object)this.diseaseType));
        }
    }

    public Object eGet(int n, boolean bl, boolean bl2) {
        switch (n) {
            case 16: {
                return this.getDataPath();
            }
            case 17: {
                return this.getDiseaseType();
            }
        }
        return super.eGet(n, bl, bl2);
    }

    public void eSet(int n, Object object) {
        switch (n) {
            case 16: {
                this.setDataPath((String)object);
                return;
            }
            case 17: {
                this.setDiseaseType((String)object);
                return;
            }
        }
        super.eSet(n, object);
    }

    public void eUnset(int n) {
        switch (n) {
            case 16: {
                this.setDataPath(DATA_PATH_EDEFAULT);
                return;
            }
            case 17: {
                this.setDiseaseType(DISEASE_TYPE_EDEFAULT);
                return;
            }
        }
        super.eUnset(n);
    }

    public boolean eIsSet(int n) {
        switch (n) {
            case 16: {
                return DATA_PATH_EDEFAULT == null ? this.dataPath != null : !DATA_PATH_EDEFAULT.equals(this.dataPath);
            }
            case 17: {
                return DISEASE_TYPE_EDEFAULT == null ? this.diseaseType != null : !DISEASE_TYPE_EDEFAULT.equals(this.diseaseType);
            }
        }
        return super.eIsSet(n);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(" (dataPath: ");
        stringBuffer.append(this.dataPath);
        stringBuffer.append(", diseaseType: ");
        stringBuffer.append(this.diseaseType);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

