/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.solvers.rk.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.graph.IntegrationLabelValue;
import org.eclipse.stem.core.graph.LabelValue;
import org.eclipse.stem.core.graph.SimpleDataExchangeLabelValue;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.IntegrationDecorator;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.solver.impl.SolverImpl;
import org.eclipse.stem.core.trigger.Trigger;
import org.eclipse.stem.solvers.rk.RkPackage;
import org.eclipse.stem.solvers.rk.RungeKutta;
import org.eclipse.stem.solvers.rk.impl.RkJob;
import org.eclipse.stem.ui.Activator;

public class RungeKuttaImpl
extends SolverImpl
implements RungeKutta {
    private short num_threads = (short)2;
    private RkJob[] jobs;
    private CyclicBarrier stepSizeBarrier;
    private CyclicBarrier updateDoneBarrier;
    private double smallestH;
    private double maximumError;
    private double stepSize = 1.0;
    private double currentX;
    static double a2 = 0.2;
    static double a3 = 0.3;
    static double a4 = 0.6;
    static double a5 = 1.0;
    static double a6 = 0.875;
    static double b21 = 0.2;
    static double b31 = 0.075;
    static double b32 = 0.225;
    static double b41 = 0.3;
    static double b42 = -0.9;
    static double b43 = 1.2;
    static double b51 = -0.2037037037037037;
    static double b52 = 2.5;
    static double b53 = -2.5925925925925926;
    static double b54 = 1.2962962962962963;
    static double b61 = 0.029495804398148147;
    static double b62 = 0.341796875;
    static double b63 = 0.041594328703703706;
    static double b64 = 0.40034541377314814;
    static double b65 = 0.061767578125;
    static double c1 = 0.09788359788359788;
    static double c3 = 0.4025764895330113;
    static double c4 = 0.21043771043771045;
    static double c6 = 0.2891022021456804;
    static double dc5 = -0.019321986607142856;
    static double dc1 = c1 - 0.10217737268518519;
    static double dc3 = c3 - 0.38390790343915343;
    static double dc4 = c4 - 0.24459273726851852;
    static double dc6 = c6 - 0.25;
    static double SAFETY = 0.9;
    static double PGROW = -0.2;
    static double PSHRNK = -0.25;
    static double ERRCON = 1.89E-4;
    static double TINY = 1.0E-30;
    private static int MAX_PROGRESS_REPORTS = 5;
    protected static final double RELATIVE_TOLERANCE_EDEFAULT = 1.0E-9;
    protected double relativeTolerance = 1.0E-9;

    public void step(STEMTime sTEMTime, long l, int n) {
        Object object;
        RkJob[] rkJobArray;
        Activator activator;
        if (!this.isInitialized()) {
            this.initialize(sTEMTime);
        }
        if ((activator = Activator.getDefault()) != null) {
            Preferences preferences = activator.getPluginPreferences();
            this.num_threads = (short)preferences.getInt("simulationThreads");
        } else {
            this.num_threads = (short)2;
        }
        int n2 = n;
        this.stepSizeBarrier = new CyclicBarrier(this.num_threads, new Runnable(){

            public void run() {
                RungeKuttaImpl.this.smallestH = Double.MAX_VALUE;
                RungeKuttaImpl.this.maximumError = -1.7976931348623157E308;
                int n = 0;
                while (n < RungeKuttaImpl.this.num_threads) {
                    if (((RungeKuttaImpl)RungeKuttaImpl.this).jobs[n].h <= RungeKuttaImpl.this.smallestH) {
                        if (((RungeKuttaImpl)RungeKuttaImpl.this).jobs[n].h == RungeKuttaImpl.this.smallestH && RungeKuttaImpl.this.maximumError < ((RungeKuttaImpl)RungeKuttaImpl.this).jobs[n].maxerror) {
                            RungeKuttaImpl.this.maximumError = ((RungeKuttaImpl)RungeKuttaImpl.this).jobs[n].maxerror;
                        } else if (((RungeKuttaImpl)RungeKuttaImpl.this).jobs[n].h != RungeKuttaImpl.this.smallestH) {
                            RungeKuttaImpl.this.maximumError = ((RungeKuttaImpl)RungeKuttaImpl.this).jobs[n].maxerror;
                        }
                        RungeKuttaImpl.this.smallestH = ((RungeKuttaImpl)RungeKuttaImpl.this).jobs[n].h;
                    }
                    ++n;
                }
            }
        });
        this.updateDoneBarrier = new CyclicBarrier(this.num_threads);
        for (Decorator decorator : this.getDecorators()) {
            if (!(decorator instanceof Trigger)) continue;
            decorator.updateLabels(sTEMTime, l, n);
        }
        for (Decorator decorator : this.getDecorators()) {
            EList eList = decorator.getLabelsToUpdate();
            rkJobArray = eList.iterator();
            while (rkJobArray.hasNext()) {
                if (!(decorator instanceof IntegrationDecorator)) continue;
                object = (IntegrationLabel)rkJobArray.next();
                ((IntegrationLabelValue)object.getProbeValue()).set((IntegrationLabelValue)object.getCurrentValue());
                ((IntegrationLabelValue)object.getTempValue()).set((IntegrationLabelValue)object.getCurrentValue());
            }
        }
        if (this.jobs == null || this.jobs.length != this.num_threads) {
            this.jobs = new RkJob[this.num_threads];
            short s = 0;
            while (s < this.num_threads) {
                short s2 = s;
                this.jobs[s] = new RkJob("Worker " + s, s2, this);
                s = (short)(s + 1);
            }
        }
        rkJobArray = this.jobs;
        int n3 = this.jobs.length;
        int n4 = 0;
        while (n4 < n3) {
            RkJob rkJob = rkJobArray[n4];
            rkJob.cycle = n2;
            rkJob.time = sTEMTime;
            rkJob.timeDelta = l;
            ++n4;
        }
        rkJobArray = this.jobs;
        n3 = this.jobs.length;
        n4 = 0;
        while (n4 < n3) {
            RkJob rkJob = rkJobArray[n4];
            rkJob.schedule();
            ++n4;
        }
        rkJobArray = this.jobs;
        n3 = this.jobs.length;
        n4 = 0;
        while (n4 < n3) {
            RkJob rkJob = rkJobArray[n4];
            try {
                rkJob.join();
            }
            catch (InterruptedException interruptedException) {
                Activator.logError((String)interruptedException.getMessage(), (Throwable)interruptedException);
            }
            ++n4;
        }
        double d = Double.MAX_VALUE;
        double d2 = this.jobs[0].t;
        RkJob[] rkJobArray2 = this.jobs;
        int n5 = this.jobs.length;
        int n6 = 0;
        while (n6 < n5) {
            object = rkJobArray2[n6];
            if (object.h < d) {
                d = object.h;
            }
            if (object.t != d2) {
                Activator.logError((String)("Error, one thread was in misstep with other threads, its time was " + object.t + " versus " + d2), (Throwable)new Exception());
            }
            ++n6;
        }
    }

    /*
     * Could not resolve type clashes
     */
    protected void _step(STEMTime sTEMTime, long l, int n, short s) {
        Object object;
        Object object22;
        ArrayList<Decorator> arrayList = new ArrayList<Decorator>();
        for (Decorator decorator : this.getDecorators()) {
            if (!(decorator instanceof IntegrationDecorator)) continue;
            arrayList.add(decorator);
        }
        double d = this.getStepSize();
        double d2 = this.getCurrentX();
        if (d2 >= (double)n) {
            for (Decorator decorator : arrayList) {
                EList eList = decorator.getLabelsToUpdate((int)s, (int)this.num_threads);
                int n2 = eList.size();
                double d3 = 0.0;
                int n3 = this.num_threads * n2 / MAX_PROGRESS_REPORTS;
                if (n3 == 0) {
                    n3 = 1;
                }
                for (IntegrationLabel integrationLabel : eList) {
                    IntegrationLabelValue integrationLabelValue = (IntegrationLabelValue)EcoreUtil.copy((EObject)integrationLabel.getProbeValue());
                    IntegrationLabelValue integrationLabelValue2 = (IntegrationLabelValue)integrationLabel.getCurrentValue();
                    IntegrationLabelValue integrationLabelValue3 = (IntegrationLabelValue)integrationLabel.getNextValue();
                    this.adjustValuesToCycle(integrationLabelValue2, integrationLabelValue, d2, n);
                    integrationLabelValue3.set(integrationLabelValue);
                    integrationLabel.setNextValueValid(true);
                    double d4 = d3 / (double)n2;
                    this.jobs[s].setProgress(d4);
                    if (d3 % (double)n3 == 0.0) {
                        int n4 = 0;
                        while (n4 < this.num_threads) {
                            if (n4 != s && this.jobs[n4] != null) {
                                d4 += this.jobs[n4].getProgress();
                            }
                            ++n4;
                        }
                        decorator.setProgress(d4 /= (double)this.num_threads);
                    }
                    d3 += 1.0;
                }
            }
            this.jobs[s].h = d;
            this.jobs[s].t = d2;
            return;
        }
        boolean bl = false;
        for (Object object22 : arrayList) {
            if (object22.getLabelsToUpdate((int)s, (int)this.num_threads).size() <= 0) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.jobs[s].h = d;
            this.jobs[s].t = d2;
            while (d2 < (double)n) {
                try {
                    do {
                        this.jobs[s].h = Double.MAX_VALUE;
                        this.stepSizeBarrier.await();
                    } while (this.maximumError > 1.0);
                    this.updateDoneBarrier.await();
                }
                catch (InterruptedException interruptedException) {
                    Activator.logError((String)interruptedException.getMessage(), (Throwable)interruptedException);
                }
                catch (BrokenBarrierException brokenBarrierException) {
                    Activator.logError((String)brokenBarrierException.getMessage(), (Throwable)brokenBarrierException);
                }
                d = this.smallestH;
                this.jobs[s].h = d;
                this.jobs[s].t = d2 += d;
            }
            return;
        }
        object22 = new HashMap();
        HashMap hashMap = new HashMap();
        HashMap<IntegrationLabel, IntegrationLabelValue> hashMap2 = new HashMap<IntegrationLabel, IntegrationLabelValue>();
        HashMap<IntegrationLabel, IntegrationLabelValue> hashMap3 = new HashMap<IntegrationLabel, IntegrationLabelValue>();
        HashMap<IntegrationLabel, IntegrationLabelValue> hashMap4 = new HashMap<IntegrationLabel, IntegrationLabelValue>();
        HashMap<IntegrationLabel, IntegrationLabelValue> hashMap5 = new HashMap<IntegrationLabel, IntegrationLabelValue>();
        int n5 = arrayList.size();
        IntegrationLabelValue[] integrationLabelValueArray = new IntegrationLabelValue[n5];
        IntegrationLabelValue[] integrationLabelValueArray2 = new IntegrationLabelValue[n5];
        IntegrationLabelValue[] integrationLabelValueArray3 = new IntegrationLabelValue[n5];
        IntegrationLabelValue[] integrationLabelValueArray4 = new IntegrationLabelValue[n5];
        IntegrationLabelValue[] integrationLabelValueArray5 = new IntegrationLabelValue[n5];
        IntegrationLabelValue[] integrationLabelValueArray6 = new IntegrationLabelValue[n5];
        HashMap<Object, IntegrationLabelValue> hashMap6 = new HashMap<Object, IntegrationLabelValue>();
        double d5 = 0.0;
        int n6 = 0;
        for (Decorator decorator : arrayList) {
            Iterator iterator = decorator.getLabelsToUpdate((int)s, (int)this.num_threads).iterator();
            IntegrationLabel integrationLabel = (IntegrationLabel)iterator.next();
            integrationLabelValueArray[n6] = (IntegrationLabelValue)EcoreUtil.copy((EObject)integrationLabel.getCurrentValue());
            integrationLabelValueArray2[n6] = (IntegrationLabelValue)EcoreUtil.copy((EObject)integrationLabel.getCurrentValue());
            integrationLabelValueArray3[n6] = (IntegrationLabelValue)EcoreUtil.copy((EObject)integrationLabel.getCurrentValue());
            integrationLabelValueArray4[n6] = (IntegrationLabelValue)EcoreUtil.copy((EObject)integrationLabel.getCurrentValue());
            integrationLabelValueArray5[n6] = (IntegrationLabelValue)EcoreUtil.copy((EObject)integrationLabel.getCurrentValue());
            integrationLabelValueArray6[n6++] = (IntegrationLabelValue)EcoreUtil.copy((EObject)integrationLabel.getCurrentValue());
        }
        double d6 = Math.floor(this.getCurrentX()) + 1.0;
        double d7 = (double)this.num_threads * (d6 - d2) / (double)MAX_PROGRESS_REPORTS;
        double d8 = d2 + d7;
        while (d2 < d6) {
            Object object3;
            object22.clear();
            hashMap.clear();
            hashMap2.clear();
            hashMap3.clear();
            hashMap4.clear();
            hashMap5.clear();
            hashMap6.clear();
            for (Decorator decorator : arrayList) {
                ((IntegrationDecorator)decorator).calculateDelta(sTEMTime, l, decorator.getLabelsToUpdate((int)s, (int)this.num_threads));
            }
            for (Decorator decorator : arrayList) {
                ((IntegrationDecorator)decorator).applyExternalDeltas(sTEMTime, l, decorator.getLabelsToUpdate((int)s, (int)this.num_threads));
            }
            for (Decorator decorator : arrayList) {
                for (IntegrationLabel integrationLabel : decorator.getLabelsToUpdate((int)s, (int)this.num_threads)) {
                    object = (IntegrationLabelValue)integrationLabel.getErrorScale();
                    object.set((IntegrationLabelValue)integrationLabel.getTempValue());
                    object3 = (IntegrationLabelValue)EcoreUtil.copy((EObject)integrationLabel.getDeltaValue());
                    object3.scale(d);
                    object3.abs();
                    object3.add(TINY);
                    object.abs();
                    object.add((IntegrationLabelValue)object3);
                }
            }
            for (Decorator decorator : arrayList) {
                for (IntegrationLabel integrationLabel : decorator.getLabelsToUpdate((int)s, (int)this.num_threads)) {
                    object = (IntegrationLabelValue)integrationLabel.getDeltaValue();
                    object22.put(integrationLabel, (IntegrationLabelValue)EcoreUtil.copy((EObject)object));
                    object.scale(d);
                    object.scale(b21);
                    ((IntegrationLabelValue)integrationLabel.getProbeValue()).set(object.add((IntegrationLabelValue)integrationLabel.getTempValue()));
                }
            }
            for (Decorator decorator : arrayList) {
                ((IntegrationDecorator)decorator).calculateDelta(sTEMTime, l, decorator.getLabelsToUpdate((int)s, (int)this.num_threads));
            }
            for (Decorator decorator : arrayList) {
                ((IntegrationDecorator)decorator).applyExternalDeltas(sTEMTime, l, decorator.getLabelsToUpdate((int)s, (int)this.num_threads));
            }
            n6 = 0;
            for (Decorator decorator : arrayList) {
                for (IntegrationLabel integrationLabel : decorator.getLabelsToUpdate((int)s, (int)this.num_threads)) {
                    object = (IntegrationLabelValue)integrationLabel.getDeltaValue();
                    hashMap.put(integrationLabel, (IntegrationLabelValue)EcoreUtil.copy((EObject)object));
                    integrationLabelValueArray[n6].set((IntegrationLabelValue)object22.get(integrationLabel));
                    integrationLabelValueArray2[n6].set((IntegrationLabelValue)object);
                    object3 = integrationLabelValueArray[n6].scale(b31);
                    integrationLabelValueArray2[n6].scale(b32);
                    object3.add(integrationLabelValueArray2[n6]);
                    object3.scale(d);
                    ((IntegrationLabelValue)integrationLabel.getProbeValue()).set(object3.add((IntegrationLabelValue)integrationLabel.getTempValue()));
                }
                ++n6;
            }
            for (Decorator decorator : arrayList) {
                ((IntegrationDecorator)decorator).calculateDelta(sTEMTime, l, decorator.getLabelsToUpdate((int)s, (int)this.num_threads));
            }
            for (Decorator decorator : arrayList) {
                ((IntegrationDecorator)decorator).applyExternalDeltas(sTEMTime, l, decorator.getLabelsToUpdate((int)s, (int)this.num_threads));
            }
            n6 = 0;
            for (Decorator decorator : arrayList) {
                for (IntegrationLabel integrationLabel : decorator.getLabelsToUpdate((int)s, (int)this.num_threads)) {
                    object = (IntegrationLabelValue)integrationLabel.getDeltaValue();
                    hashMap2.put(integrationLabel, (IntegrationLabelValue)EcoreUtil.copy((EObject)object));
                    integrationLabelValueArray[n6].set((IntegrationLabelValue)object22.get(integrationLabel));
                    integrationLabelValueArray2[n6].set((IntegrationLabelValue)hashMap.get(integrationLabel));
                    integrationLabelValueArray3[n6].set((IntegrationLabelValue)object);
                    integrationLabelValueArray[n6].scale(b41);
                    integrationLabelValueArray2[n6].scale(b42);
                    integrationLabelValueArray3[n6].scale(b43);
                    object3 = integrationLabelValueArray[n6];
                    object3.add(integrationLabelValueArray2[n6]);
                    object3.add(integrationLabelValueArray3[n6]);
                    object3.scale(d);
                    ((IntegrationLabelValue)integrationLabel.getProbeValue()).set(object3.add((IntegrationLabelValue)integrationLabel.getTempValue()));
                }
                ++n6;
            }
            for (Decorator decorator : arrayList) {
                ((IntegrationDecorator)decorator).calculateDelta(sTEMTime, l, decorator.getLabelsToUpdate((int)s, (int)this.num_threads));
            }
            for (Decorator decorator : arrayList) {
                ((IntegrationDecorator)decorator).applyExternalDeltas(sTEMTime, l, decorator.getLabelsToUpdate((int)s, (int)this.num_threads));
            }
            n6 = 0;
            for (Decorator decorator : arrayList) {
                for (IntegrationLabel integrationLabel : decorator.getLabelsToUpdate((int)s, (int)this.num_threads)) {
                    object = (IntegrationLabelValue)integrationLabel.getDeltaValue();
                    hashMap3.put(integrationLabel, (IntegrationLabelValue)EcoreUtil.copy((EObject)object));
                    integrationLabelValueArray[n6].set((IntegrationLabelValue)object22.get(integrationLabel));
                    integrationLabelValueArray2[n6].set((IntegrationLabelValue)hashMap.get(integrationLabel));
                    integrationLabelValueArray3[n6].set((IntegrationLabelValue)hashMap2.get(integrationLabel));
                    integrationLabelValueArray4[n6].set((IntegrationLabelValue)object);
                    integrationLabelValueArray[n6].scale(b51);
                    integrationLabelValueArray2[n6].scale(b52);
                    integrationLabelValueArray3[n6].scale(b53);
                    integrationLabelValueArray4[n6].scale(b54);
                    object3 = integrationLabelValueArray[n6];
                    object3.add(integrationLabelValueArray2[n6]);
                    object3.add(integrationLabelValueArray3[n6]);
                    object3.add(integrationLabelValueArray4[n6]);
                    object3.scale(d);
                    ((IntegrationLabelValue)integrationLabel.getProbeValue()).set(object3.add((IntegrationLabelValue)integrationLabel.getTempValue()));
                }
                ++n6;
            }
            for (Decorator decorator : arrayList) {
                ((IntegrationDecorator)decorator).calculateDelta(sTEMTime, l, decorator.getLabelsToUpdate((int)s, (int)this.num_threads));
            }
            for (Decorator decorator : arrayList) {
                ((IntegrationDecorator)decorator).applyExternalDeltas(sTEMTime, l, decorator.getLabelsToUpdate((int)s, (int)this.num_threads));
            }
            n6 = 0;
            for (Decorator decorator : arrayList) {
                for (IntegrationLabel integrationLabel : decorator.getLabelsToUpdate((int)s, (int)this.num_threads)) {
                    object = (IntegrationLabelValue)integrationLabel.getDeltaValue();
                    hashMap4.put(integrationLabel, (IntegrationLabelValue)EcoreUtil.copy((EObject)object));
                    integrationLabelValueArray[n6].set((IntegrationLabelValue)object22.get(integrationLabel));
                    integrationLabelValueArray2[n6].set((IntegrationLabelValue)hashMap.get(integrationLabel));
                    integrationLabelValueArray3[n6].set((IntegrationLabelValue)hashMap2.get(integrationLabel));
                    integrationLabelValueArray4[n6].set((IntegrationLabelValue)hashMap3.get(integrationLabel));
                    integrationLabelValueArray5[n6].set((IntegrationLabelValue)object);
                    integrationLabelValueArray[n6].scale(b61);
                    integrationLabelValueArray2[n6].scale(b62);
                    integrationLabelValueArray3[n6].scale(b63);
                    integrationLabelValueArray4[n6].scale(b64);
                    integrationLabelValueArray5[n6].scale(b65);
                    object3 = integrationLabelValueArray[n6];
                    object3.add(integrationLabelValueArray2[n6]);
                    object3.add(integrationLabelValueArray3[n6]);
                    object3.add(integrationLabelValueArray4[n6]);
                    object3.add(integrationLabelValueArray5[n6]);
                    object3.scale(d);
                    ((IntegrationLabelValue)integrationLabel.getProbeValue()).set(object3.add((IntegrationLabelValue)integrationLabel.getTempValue()));
                }
                ++n6;
            }
            for (Decorator decorator : arrayList) {
                ((IntegrationDecorator)decorator).calculateDelta(sTEMTime, l, decorator.getLabelsToUpdate((int)s, (int)this.num_threads));
            }
            for (Decorator decorator : arrayList) {
                ((IntegrationDecorator)decorator).applyExternalDeltas(sTEMTime, l, decorator.getLabelsToUpdate((int)s, (int)this.num_threads));
            }
            n6 = 0;
            for (Decorator decorator : arrayList) {
                for (IntegrationLabel integrationLabel : decorator.getLabelsToUpdate((int)s, (int)this.num_threads)) {
                    object = (IntegrationLabelValue)integrationLabel.getDeltaValue();
                    hashMap5.put(integrationLabel, (IntegrationLabelValue)EcoreUtil.copy((EObject)object));
                }
                ++n6;
            }
            boolean bl2 = true;
            double d9 = 0.0;
            n6 = 0;
            for (IntegrationLabel integrationLabel : arrayList) {
                for (Object object42 : integrationLabel.getLabelsToUpdate((int)s, (int)this.num_threads)) {
                    IntegrationLabelValue integrationLabelValue = (IntegrationLabelValue)object42.getTempValue();
                    integrationLabelValueArray[n6].set((IntegrationLabelValue)object22.get(object42));
                    integrationLabelValueArray3[n6].set((IntegrationLabelValue)hashMap2.get(object42));
                    integrationLabelValueArray4[n6].set((IntegrationLabelValue)hashMap3.get(object42));
                    integrationLabelValueArray5[n6].set((IntegrationLabelValue)hashMap4.get(object42));
                    integrationLabelValueArray6[n6].set((IntegrationLabelValue)hashMap5.get(object42));
                    integrationLabelValueArray[n6].scale(c1);
                    integrationLabelValueArray3[n6].scale(c3);
                    integrationLabelValueArray4[n6].scale(c4);
                    integrationLabelValueArray6[n6].scale(c6);
                    IntegrationLabelValue integrationLabelValue4 = (IntegrationLabelValue)EcoreUtil.copy((EObject)integrationLabelValueArray[n6].add(integrationLabelValueArray3[n6]).add(integrationLabelValueArray4[n6]).add(integrationLabelValueArray6[n6]));
                    integrationLabelValue4.scale(d);
                    integrationLabelValue4.add(integrationLabelValue);
                    integrationLabelValueArray[n6].set((IntegrationLabelValue)object22.get(object42));
                    integrationLabelValueArray3[n6].set((IntegrationLabelValue)hashMap2.get(object42));
                    integrationLabelValueArray4[n6].set((IntegrationLabelValue)hashMap3.get(object42));
                    integrationLabelValueArray5[n6].set((IntegrationLabelValue)hashMap4.get(object42));
                    integrationLabelValueArray6[n6].set((IntegrationLabelValue)hashMap5.get(object42));
                    integrationLabelValueArray[n6].scale(dc1);
                    integrationLabelValueArray3[n6].scale(dc3);
                    integrationLabelValueArray4[n6].scale(dc4);
                    integrationLabelValueArray5[n6].scale(dc5);
                    integrationLabelValueArray6[n6].scale(dc6);
                    IntegrationLabelValue integrationLabelValue5 = (IntegrationLabelValue)EcoreUtil.copy((EObject)integrationLabelValueArray[n6].add(integrationLabelValueArray3[n6]).add(integrationLabelValueArray4[n6]).add(integrationLabelValueArray5[n6]).add(integrationLabelValueArray6[n6]));
                    integrationLabelValue5.scale(d);
                    integrationLabelValue5.divide((IntegrationLabelValue)object42.getErrorScale());
                    double d10 = integrationLabelValue5.max();
                    d10 /= this.relativeTolerance;
                    if (d10 > d9) {
                        d9 = d10;
                    }
                    if (!(d10 <= 1.0)) continue;
                    hashMap6.put(object42, (IntegrationLabelValue)EcoreUtil.copy((EObject)integrationLabelValue4));
                }
                ++n6;
            }
            this.jobs[s].h = d;
            this.jobs[s].maxerror = d9;
            try {
                this.stepSizeBarrier.await();
            }
            catch (InterruptedException interruptedException) {
                Activator.logError((String)interruptedException.getMessage(), (Throwable)interruptedException);
            }
            catch (BrokenBarrierException brokenBarrierException) {
                Activator.logError((String)brokenBarrierException.getMessage(), (Throwable)brokenBarrierException);
            }
            if (this.maximumError > 1.0) {
                bl2 = false;
            }
            if (bl2) {
                Object object42;
                if (this.smallestH > d) {
                    Activator.logError((String)("Error, h was less than the smallest, perhaps barrier process failed to execute? h:" + d + " vs " + this.smallestH), (Throwable)new Exception());
                }
                d2 += d;
                d = this.maximumError > ERRCON ? SAFETY * d * Math.pow(this.maximumError, PGROW) : (d *= 5.0);
                if (d > 1.0) {
                    d = 1.0;
                }
                if (d2 < d6 && d2 + d > d6) {
                    d = d6 - d2;
                }
                for (IntegrationLabel integrationLabel : arrayList) {
                    for (Object object42 : integrationLabel.getLabelsToUpdate((int)s, (int)this.num_threads)) {
                        ((IntegrationLabelValue)object42.getTempValue()).set((IntegrationLabelValue)hashMap6.get(object42));
                        ((IntegrationLabelValue)object42.getProbeValue()).set((IntegrationLabelValue)hashMap6.get(object42));
                    }
                }
                try {
                    this.updateDoneBarrier.await();
                }
                catch (InterruptedException interruptedException) {
                    Activator.logError((String)interruptedException.getMessage(), (Throwable)interruptedException);
                }
                catch (BrokenBarrierException brokenBarrierException) {
                    Activator.logError((String)brokenBarrierException.getMessage(), (Throwable)brokenBarrierException);
                }
                double d11 = d6 - d2 < 0.0 ? 1.0 : 1.0 - (d6 - d2);
                this.jobs[s].setProgress(d11);
                if (!(d2 > d8)) continue;
                int n7 = 0;
                while (n7 < this.num_threads) {
                    if (n7 != s && this.jobs[n7] != null) {
                        d11 += this.jobs[n7].getProgress();
                    }
                    ++n7;
                }
                d11 /= (double)this.num_threads;
                object42 = arrayList.iterator();
                while (object42.hasNext()) {
                    Decorator decorator = (Decorator)object42.next();
                    decorator.setProgress(d11);
                }
                d8 += d7;
                continue;
            }
            d5 = SAFETY * d * Math.pow(this.maximumError, PSHRNK);
            d = d > 0.0 ? (d5 > 0.1 * d ? d5 : 0.1 * d) : (d5 > 0.1 * d ? 0.1 * d : d5);
            for (IntegrationLabel integrationLabel : arrayList) {
                for (Object object42 : integrationLabel.getLabelsToUpdate((int)s, (int)this.num_threads)) {
                    ((IntegrationLabelValue)object42.getProbeValue()).set((IntegrationLabelValue)object42.getTempValue());
                }
            }
        }
        this.jobs[s].t = d2;
        this.jobs[s].h = d;
        this.setStepSize(d);
        this.setCurrentX(d2);
        for (Decorator decorator : arrayList) {
            for (IntegrationLabel integrationLabel : decorator.getLabelsToUpdate((int)s, (int)this.num_threads)) {
                object = (IntegrationLabelValue)integrationLabel.getNextValue();
                IntegrationLabelValue cfr_ignored_0 = (IntegrationLabelValue)integrationLabel.getCurrentValue();
                IntegrationLabelValue integrationLabelValue = (IntegrationLabelValue)hashMap6.get(integrationLabel);
                object.set(integrationLabelValue);
                ((IntegrationDecorator)decorator).doModelSpecificAdjustments((LabelValue)object);
                integrationLabel.setNextValueValid(true);
            }
        }
    }

    void adjustValuesToCycle(IntegrationLabelValue integrationLabelValue, IntegrationLabelValue integrationLabelValue2, double d, int n) {
        IntegrationLabelValue integrationLabelValue3 = (IntegrationLabelValue)EcoreUtil.copy((EObject)integrationLabelValue);
        integrationLabelValue2.sub(integrationLabelValue);
        integrationLabelValue2.scale(1.0 / (d - (double)n + 1.0));
        integrationLabelValue2.set(integrationLabelValue3.add(integrationLabelValue2));
    }

    private void initialize(STEMTime sTEMTime) {
        IntegrationLabel integrationLabel;
        EList eList;
        BasicEList basicEList = new BasicEList();
        boolean bl = false;
        for (Decorator decorator : this.getDecorators()) {
            if (decorator instanceof IntegrationDecorator) {
                eList = decorator.getLabelsToUpdate();
                for (DynamicLabel dynamicLabel : eList) {
                    if (!(dynamicLabel instanceof IntegrationLabel)) continue;
                    integrationLabel = (IntegrationLabel)dynamicLabel;
                    integrationLabel.reset(sTEMTime);
                    if (!(((SimpleDataExchangeLabelValue)integrationLabel.getDeltaValue()).getAdditions() > 0.0) && !(((SimpleDataExchangeLabelValue)integrationLabel.getDeltaValue()).getSubstractions() > 0.0)) continue;
                    bl = true;
                }
            }
            if (bl) continue;
            basicEList.add((Object)decorator);
        }
        if (bl) {
            for (Decorator decorator : basicEList) {
                if (!(decorator instanceof IntegrationDecorator)) continue;
                eList = decorator.getLabelsToUpdate();
                for (DynamicLabel dynamicLabel : eList) {
                    if (!(dynamicLabel instanceof IntegrationLabel)) continue;
                    integrationLabel = (IntegrationLabel)dynamicLabel;
                    integrationLabel.reset(sTEMTime);
                }
            }
        }
        this.setInitialized(true);
    }

    public void reset() {
        this.setStepSize(1.0);
        this.setCurrentX(0.0);
        this.setInitialized(false);
    }

    protected double getStepSize() {
        return this.stepSize;
    }

    protected double getCurrentX() {
        return this.currentX;
    }

    protected void setStepSize(double d) {
        this.stepSize = d;
    }

    protected void setCurrentX(double d) {
        this.currentX = d;
    }

    protected EClass eStaticClass() {
        return RkPackage.Literals.RUNGE_KUTTA;
    }

    public double getRelativeTolerance() {
        return this.relativeTolerance;
    }

    public void setRelativeTolerance(double d) {
        double d2 = this.relativeTolerance;
        this.relativeTolerance = d;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, d2, this.relativeTolerance));
        }
    }

    public Object eGet(int n, boolean bl, boolean bl2) {
        switch (n) {
            case 5: {
                return new Double(this.getRelativeTolerance());
            }
        }
        return super.eGet(n, bl, bl2);
    }

    public void eSet(int n, Object object) {
        switch (n) {
            case 5: {
                this.setRelativeTolerance((Double)object);
                return;
            }
        }
        super.eSet(n, object);
    }

    public void eUnset(int n) {
        switch (n) {
            case 5: {
                this.setRelativeTolerance(1.0E-9);
                return;
            }
        }
        super.eUnset(n);
    }

    public boolean eIsSet(int n) {
        switch (n) {
            case 5: {
                return this.relativeTolerance != 1.0E-9;
            }
        }
        return super.eIsSet(n);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(" (relativeTolerance: ");
        stringBuffer.append(this.relativeTolerance);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

