/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.stem.analysis.impl.ReferenceScenarioDataMapImpl;
import org.eclipse.stem.diseasemodels.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregateDataWriter {
    private final String aggregateFileName;
    private final String incidenceFileName;
    private static final String keyS = "S";
    private static final String keyE = "E";
    private static final String keyI = "I";
    private static final String keyR = "R";
    private static final String keyBirths = "Births";
    private static final String keyDeaths = "Deaths";
    private static final String keyDeltaBirths = "deltaBirths";
    private static final String keyDeltaDeaths = "deltaDeaths";
    private static final String keyIncidence = "Incidence";
    private static List<String> birthsList = null;
    private static List<String> deathsList = null;
    private static List<String> deltaBirthsList = new ArrayList<String>();
    private static List<String> deltaDeathsList = new ArrayList<String>();
    private boolean haveBirths = false;
    private boolean haveDeaths = false;
    private static double pastBirths = 0.0;
    private static double pastDeaths = 0.0;
    String[] preferredKeyOrder = new String[]{"iteration", "time", "S", "E", "I", "R", "Births", "Deaths"};
    private static final IPath PATH = ResourcesPlugin.getWorkspace().getRoot().getLocation();
    private static final String sep = File.separator;
    public static final String ANALYSISFOLDER = PATH.toOSString();
    public static final String AGGREGATE_FOLDERNAME = "aggregate";
    private static final String aggregatePathSuffix = "aggregate" + sep;
    private String aggregateDirectoryName = PATH.append(String.valueOf(sep) + aggregatePathSuffix).toOSString();
    public static final String INCIDENCE_FOLDERNAME = "incidence";
    private static final String incidencePathSuffix = "incidence" + sep;
    private String incidenceDirectoryName = PATH.append(String.valueOf(sep) + incidencePathSuffix).toOSString();
    private FileWriter fw1;
    private FileWriter fw2;

    public AggregateDataWriter(String string, String string2) {
        boolean bl;
        boolean bl2;
        Path path = new Path(string);
        path = path.removeLastSegments(1);
        path = path.append(AGGREGATE_FOLDERNAME);
        this.aggregateDirectoryName = path.toOSString();
        File file = new File(this.aggregateDirectoryName);
        if (!(file.exists() && file.isDirectory() || (bl2 = file.mkdirs()))) {
            Activator.logError((String)("Failed to Create Directory" + this.aggregateDirectoryName), (Throwable)new IOException("Failed to Create Driectory" + this.aggregateDirectoryName));
        }
        path = new Path(string);
        path = path.removeLastSegments(1);
        path = path.append(INCIDENCE_FOLDERNAME);
        this.incidenceDirectoryName = path.toOSString();
        File file2 = new File(this.incidenceDirectoryName);
        if (!(file2.exists() && file2.isDirectory() || (bl = file2.mkdirs()))) {
            Activator.logError((String)("Failed to Create Indicence Directory" + this.incidenceDirectoryName), (Throwable)new IOException("Failed to Create Directory" + this.incidenceDirectoryName));
        }
        this.aggregateFileName = String.valueOf(this.aggregateDirectoryName) + sep + string2;
        try {
            this.fw1 = new FileWriter(this.aggregateFileName);
        }
        catch (IOException iOException) {
            Activator.logError((String)("Error opening data file" + this.aggregateDirectoryName + " " + this.aggregateFileName), (Throwable)iOException);
        }
        this.incidenceFileName = String.valueOf(this.incidenceDirectoryName) + sep + string2;
        try {
            this.fw2 = new FileWriter(this.incidenceFileName);
        }
        catch (IOException iOException) {
            Activator.logError((String)("Error opening data file" + this.incidenceDirectoryName + " " + this.incidenceFileName), (Throwable)iOException);
        }
    }

    public String[] logDataInstance(ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance referenceScenarioDataInstance, double d) {
        String[] stringArray = new String[2];
        Map map = referenceScenarioDataInstance.getInstance();
        Set<String> set = map.keySet();
        String[] stringArray2 = this.sortKeys(set);
        List list = (List)map.get(stringArray2[0]);
        String string = String.valueOf(stringArray2[0]);
        int n = 1;
        while (n < stringArray2.length) {
            string = String.valueOf(string) + "," + stringArray2[n].toString().trim();
            ++n;
        }
        string = String.valueOf(string) + "\n";
        try {
            this.fw1.append(string);
        }
        catch (IOException iOException) {
            Activator.logError((String)("Error writing aggregate data file" + this.aggregateDirectoryName + " " + this.aggregateFileName), (Throwable)iOException);
        }
        birthsList = (List)referenceScenarioDataInstance.getInstance().get(keyBirths);
        referenceScenarioDataInstance.getInstance().put(keyBirths, birthsList);
        deathsList = (List)referenceScenarioDataInstance.getInstance().get(keyDeaths);
        referenceScenarioDataInstance.getInstance().put(keyDeaths, deathsList);
        int n2 = list.size();
        int n3 = 0;
        while (n3 < n2) {
            String string2 = stringArray2[0].toString();
            List list2 = (List)referenceScenarioDataInstance.getInstance().get(string2);
            string = String.valueOf((String)list2.get(n3)) + " ";
            int n4 = 1;
            while (n4 < stringArray2.length) {
                string2 = stringArray2[n4].toString();
                list2 = (List)referenceScenarioDataInstance.getInstance().get(string2);
                string = String.valueOf(string) + ", " + (String)list2.get(n3);
                ++n4;
            }
            string = String.valueOf(string) + "\n";
            try {
                this.fw1.append(string);
            }
            catch (IOException iOException) {
                Activator.logError((String)("Error writing aggregate data file" + this.aggregateDirectoryName + this.aggregateFileName), (Throwable)iOException);
            }
            ++n3;
        }
        string = "";
        try {
            if (this.fw1 != null) {
                this.fw1.flush();
                this.fw1.close();
            }
        }
        catch (IOException iOException) {}
        this.haveBirths = false;
        if (birthsList != null) {
            this.haveBirths = true;
            n3 = 0;
            while (n3 < birthsList.size()) {
                deltaBirthsList.add(n3, birthsList.get(n3));
                ++n3;
            }
            if (deltaBirthsList != null) {
                pastBirths = 0.0;
                n3 = 0;
                while (n3 < deltaBirthsList.size()) {
                    double d2 = new Double(deltaBirthsList.get(n3));
                    deltaBirthsList.set(n3, "" + (d2 - pastBirths));
                    pastBirths = d2;
                    ++n3;
                }
            }
        }
        this.haveDeaths = false;
        if (deathsList != null) {
            this.haveDeaths = true;
            n3 = 0;
            while (n3 < deathsList.size()) {
                deltaDeathsList.add(n3, deathsList.get(n3));
                ++n3;
            }
            if (deltaDeathsList != null) {
                pastDeaths = 0.0;
                n3 = 0;
                while (n3 < deltaDeathsList.size()) {
                    double d3 = new Double(deltaDeathsList.get(n3));
                    deltaDeathsList.set(n3, "" + (d3 - pastDeaths));
                    pastDeaths = d3;
                    ++n3;
                }
            }
        }
        referenceScenarioDataInstance.getInstance().put(keyDeltaBirths, deltaBirthsList);
        referenceScenarioDataInstance.getInstance().put(keyDeltaDeaths, deltaDeathsList);
        stringArray[0] = this.aggregateFileName;
        stringArray[1] = this.logIncidence(referenceScenarioDataInstance, d);
        return stringArray;
    }

    public String logIncidence(ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance referenceScenarioDataInstance, double d) {
        Object object;
        Map map = referenceScenarioDataInstance.getInstance();
        Set<String> set = map.keySet();
        String[] stringArray = this.sortKeys(set);
        List list = (List)map.get(stringArray[0]);
        int n = list.size();
        ArrayList<Double> arrayList = new ArrayList<Double>();
        int n2 = 0;
        while (n2 < n) {
            double d2 = 0.0;
            if (set.contains(keyS)) {
                list = (List)map.get(keyS);
                object = new Double((String)list.get(n2));
                d2 += ((Double)object).doubleValue();
            }
            if (set.contains(keyE)) {
                list = (List)map.get(keyE);
                object = new Double((String)list.get(n2));
                d2 += ((Double)object).doubleValue();
            }
            if (set.contains(keyI)) {
                list = (List)map.get(keyI);
                object = new Double((String)list.get(n2));
                d2 += ((Double)object).doubleValue();
            }
            if (set.contains(keyR)) {
                list = (List)map.get(keyR);
                object = new Double((String)list.get(n2));
                d2 += ((Double)object).doubleValue();
            }
            arrayList.add(new Double(d2));
            ++n2;
        }
        List<Object> list2 = new ArrayList();
        List list3 = (List)map.get(keyS);
        List list4 = (List)map.get(keyI);
        object = (List)map.get(keyR);
        List list5 = (List)map.get(keyIncidence);
        if (list5 != null) {
            int n3 = 0;
            while (n3 < list5.size()) {
                list2.add(n3, new Double((String)list5.get(n3)));
                ++n3;
            }
        } else {
            list2 = this.computeIncidence(list4, (List<String>)object, d, n);
        }
        String string = String.valueOf(stringArray[0]) + "," + stringArray[1] + "," + "Incidence,S,P";
        if (this.haveBirths) {
            string = String.valueOf(string) + ",deltaBirths";
        }
        if (this.haveDeaths) {
            string = String.valueOf(string) + ",deltaDeaths";
        }
        string = String.valueOf(string) + "\n";
        try {
            this.fw2.append(string);
        }
        catch (IOException iOException) {
            Activator.logError((String)("Error writing aggregate data file" + this.aggregateDirectoryName + " " + this.aggregateFileName), (Throwable)iOException);
        }
        string = "";
        int n4 = 0;
        while (n4 < n) {
            string = "";
            String string2 = stringArray[0].toString();
            List list6 = (List)referenceScenarioDataInstance.getInstance().get(string2);
            string = String.valueOf((String)list6.get(n4)) + " ";
            string2 = stringArray[1].toString();
            list6 = (List)referenceScenarioDataInstance.getInstance().get(string2);
            string = String.valueOf(string) + ", " + (String)list6.get(n4);
            string = String.valueOf(string) + ", " + (Double)list2.get(n4);
            string = String.valueOf(string) + ", " + (String)list3.get(n4);
            string = String.valueOf(string) + ", " + (Double)arrayList.get(n4);
            if (this.haveBirths) {
                string2 = keyDeltaBirths;
                list6 = (List)referenceScenarioDataInstance.getInstance().get(string2);
                string = list6 != null && list6.size() > 0 ? String.valueOf(string) + ", " + (String)list6.get(n4) : String.valueOf(string) + ", 0";
            }
            if (this.haveDeaths) {
                string2 = keyDeltaDeaths;
                list6 = (List)referenceScenarioDataInstance.getInstance().get(string2);
                string = list6 != null && list6.size() > 0 ? String.valueOf(string) + ", " + (String)list6.get(n4) : String.valueOf(string) + ", 0";
            }
            string = String.valueOf(string) + " \n";
            try {
                this.fw2.append(string);
            }
            catch (IOException iOException) {
                Activator.logError((String)("Error writing aggregate data file" + this.incidenceDirectoryName + this.incidenceFileName), (Throwable)iOException);
            }
            ++n4;
        }
        string = "";
        try {
            if (this.fw2 != null) {
                this.fw2.flush();
                this.fw2.close();
            }
        }
        catch (IOException iOException) {}
        return this.incidenceFileName;
    }

    private List<Double> computeIncidence(List<String> list, List<String> list2, double d, int n) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        double d2 = new Double(list.get(0));
        double d3 = new Double(list2.get(0));
        double d4 = 0.0;
        double d5 = 0.0;
        if (birthsList != null && birthsList.size() >= 1) {
            d4 = new Double(birthsList.get(0));
        }
        if (deathsList != null && deathsList.size() >= 1) {
            d5 = new Double(deathsList.get(0));
        }
        Double d6 = new Double(d2 + d3 + (d5 - d4));
        arrayList.add(d6);
        int n2 = 1;
        while (n2 < n) {
            d2 = new Double(list.get(n2));
            d2 -= new Double(list.get(n2 - 1)).doubleValue();
            if (list2 != null) {
                d3 = new Double(list2.get(n2));
                d3 -= new Double(list2.get(n2 - 1)).doubleValue();
            }
            d4 = 0.0;
            d5 = 0.0;
            if (birthsList != null && birthsList.size() >= n2) {
                d4 = new Double(birthsList.get(n2));
            }
            if (deathsList != null && deathsList.size() >= n2) {
                d5 = new Double(deathsList.get(n2));
            }
            double d7 = new Double(list2.get(n2 - 1));
            double d8 = d2 + d3 + (d5 - d4) + d * d7;
            d6 = new Double(d8);
            arrayList.add(d6);
            ++n2;
        }
        return arrayList;
    }

    private String[] sortKeys(Set<String> set) {
        String[] stringArray = new String[set.size()];
        int n = 0;
        HashSet<String> hashSet = new HashSet<String>();
        int n2 = 0;
        while (n2 < this.preferredKeyOrder.length) {
            if (set.contains(this.preferredKeyOrder[n2])) {
                stringArray[n] = this.preferredKeyOrder[n2].trim();
                ++n;
                hashSet.add(this.preferredKeyOrder[n2]);
            }
            ++n2;
        }
        Iterator<String> iterator = set.iterator();
        while (iterator != null && iterator.hasNext()) {
            String string = iterator.next();
            if (hashSet.contains(string)) continue;
            stringArray[n] = string;
            ++n;
        }
        return stringArray;
    }

    public static String getKeyS() {
        return keyS;
    }

    public static String getKeyE() {
        return keyE;
    }

    public static String getKeyI() {
        return keyI;
    }

    public static String getKeyR() {
        return keyR;
    }

    public static String getKeyIncidence() {
        return keyIncidence;
    }
}

