/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.stem.analysis.ErrorResult;
import org.eclipse.stem.util.analysis.Activator;
import org.eclipse.stem.util.analysis.PhaseSpaceCoordinate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVAnalysisWriter {
    private String outputFileName = "";
    protected String paramFileName;
    private static final IPath PATH = Activator.getDefault().getStateLocation();
    private static final String sep = File.separator;
    protected static final String CSV = "csv";
    private static final String PATH_SUFFIX = "csv" + sep;
    private static String adir = PATH.append(String.valueOf(sep) + PATH_SUFFIX).toOSString();
    private FileWriter fw;

    public CSVAnalysisWriter(String string) {
        boolean bl;
        this.outputFileName = String.valueOf(adir) + string + "." + CSV;
        File file = new File(adir);
        if (!(file.exists() && file.isDirectory() || (bl = file.mkdirs()))) {
            Activator.logError("Failed to Create Driectory" + this.outputFileName, new IOException("Failed to Create Driectory" + this.outputFileName));
        }
        try {
            this.fw = new FileWriter(this.outputFileName);
        }
        catch (IOException iOException) {
            Activator.logError("Error closing CSV analysis file" + this.outputFileName + this.outputFileName, iOException);
        }
    }

    public CSVAnalysisWriter(String string, String string2) {
        boolean bl;
        adir = string;
        this.outputFileName = String.valueOf(adir) + string2 + "." + CSV;
        File file = new File(adir);
        if (!(file.exists() && file.isDirectory() || (bl = file.mkdirs()))) {
            Activator.logError("Failed to Create Driectory" + this.outputFileName, new IOException("Failed to Create Driectory" + this.outputFileName));
        }
        try {
            this.fw = new FileWriter(this.outputFileName);
        }
        catch (IOException iOException) {
            Activator.logError("Error closing CSV analysis file" + this.outputFileName + this.outputFileName, iOException);
        }
    }

    public void logData(List<EList<Double>> list) {
        Object object;
        int n = 0;
        int n2 = list.size();
        int n3 = 0;
        while (n3 < n2) {
            object = list.get(n3);
            if (object.size() >= n) {
                n = object.size();
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n) {
            object = "";
            int n4 = 0;
            while (n4 < n2) {
                EList<Double> eList = list.get(n4);
                if (eList.size() >= n) {
                    object = String.valueOf(object) + eList.get(n3);
                    if (n4 < n2 - 1) {
                        object = String.valueOf(object) + ", ";
                    }
                }
                ++n4;
            }
            object = String.valueOf(object) + "\n";
            try {
                this.fw.write((String)object);
            }
            catch (IOException iOException) {
                Activator.logError("Error writing data to CSV Analysis file" + this.outputFileName + this.outputFileName, iOException);
            }
            ++n3;
        }
        try {
            this.fw.flush();
            this.fw.close();
        }
        catch (IOException iOException) {
            Activator.logError("Error closing CSV analysis file" + this.outputFileName + this.outputFileName, iOException);
        }
    }

    public void logData(List<String> list, List<double[]> list2) {
        Object object;
        String string = "iteration";
        int n = 0;
        while (n < list.size()) {
            string = String.valueOf(string) + ", " + list.get(n);
            ++n;
        }
        string = String.valueOf(string) + "\n";
        try {
            this.fw.write(string);
        }
        catch (IOException iOException) {
            Activator.logError("Error writing HEADER to CSV Analysis file" + this.outputFileName + this.outputFileName, iOException);
        }
        int n2 = 0;
        int n3 = list2.size();
        int n4 = 0;
        while (n4 < n3) {
            object = list2.get(n4);
            if (((double[])object).length >= n2) {
                n2 = ((double[])object).length;
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < n2) {
            object = String.valueOf(n4) + " ";
            int n5 = 0;
            while (n5 < n3) {
                double[] dArray = list2.get(n5);
                if (dArray.length >= n2) {
                    object = String.valueOf(object) + ", " + dArray[n4];
                }
                ++n5;
            }
            object = String.valueOf(object) + "\n";
            try {
                this.fw.write((String)object);
            }
            catch (IOException iOException) {
                Activator.logError("Error writing data to CSV Analysis file" + this.outputFileName + this.outputFileName, iOException);
            }
            ++n4;
        }
        try {
            this.fw.flush();
            this.fw.close();
        }
        catch (IOException iOException) {
            Activator.logError("Error closing CSV analysis file" + this.outputFileName + this.outputFileName, iOException);
        }
    }

    public void logData(int n, List<PhaseSpaceCoordinate[]> list) {
        Object object;
        int n2 = 0;
        int n3 = list.size();
        int n4 = 0;
        while (n4 < n3) {
            object = list.get(n4);
            if (((PhaseSpaceCoordinate[])object).length >= n2) {
                n2 = ((PhaseSpaceCoordinate[])object).length;
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < n2) {
            object = "";
            int n5 = 0;
            while (n5 < n3) {
                PhaseSpaceCoordinate[] phaseSpaceCoordinateArray = list.get(n5);
                if (phaseSpaceCoordinateArray.length >= n2) {
                    object = String.valueOf(object) + phaseSpaceCoordinateArray[n4].xValue + ", " + phaseSpaceCoordinateArray[n4].yValue + "  ";
                    if (n5 < n3 - 1) {
                        object = String.valueOf(object) + ", ";
                    }
                }
                ++n5;
            }
            object = String.valueOf(object) + "\n";
            try {
                this.fw.write((String)object);
            }
            catch (IOException iOException) {
                Activator.logError("Error writing data to CSV Analysis file" + this.outputFileName + this.outputFileName, iOException);
            }
            ++n4;
        }
        try {
            this.fw.flush();
            this.fw.close();
        }
        catch (IOException iOException) {
            Activator.logError("Error closing CSV analysis file" + this.outputFileName + this.outputFileName, iOException);
        }
    }

    public void logData(Map<Map<String, String>, ErrorResult> map) {
        try {
            Map<String, String> map2 = map.keySet().iterator().next();
            Set<String> set = map2.keySet();
            for (String object : set) {
                this.fw.write(object);
                this.fw.write(",");
            }
            this.fw.write("RMS");
            this.fw.write("\n");
            for (Map map3 : map.keySet()) {
                ErrorResult errorResult = map.get(map3);
                Collection collection = map3.values();
                for (String string : collection) {
                    this.fw.write(string);
                    this.fw.write(",");
                }
                double d = 0.0;
                if (errorResult != null) {
                    d = errorResult.getError();
                }
                this.fw.write(String.valueOf(d));
                this.fw.write("\n");
            }
        }
        catch (IOException iOException) {
            Activator.logError("Error closing CSV analysis file" + this.outputFileName + this.outputFileName, iOException);
        }
    }

    public void flushLoggerData() {
        try {
            if (this.fw != null) {
                this.fw.flush();
            }
        }
        catch (IOException iOException) {}
    }

    public void closeLoggerData() {
        this.flushLoggerData();
        if (this.fw == null) {
            return;
        }
        try {
            this.fw.close();
        }
        catch (IOException iOException) {
            Activator.logError("Error CLOSING CSV Logger file" + this.outputFileName + this.outputFileName, iOException);
        }
    }
}

