/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.stem.analysis.impl.ReferenceScenarioDataMapImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CycleCompressor {
    ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance data;
    static final int WINDOW = 365;
    static final int INITIAL_PHASE_SHIFT = 30;
    public static List<Integer> peakPositions = new ArrayList<Integer>();
    static List<Double> compressedCycles = new ArrayList<Double>();
    protected static final int[] DAY_OF_CHANNUKA = new int[]{347, 702, 1086, 1430, 1794, 2179, 2533, 2916, 3271, 3625, 4008};

    public CycleCompressor(ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance referenceScenarioDataInstance) {
        this.data = referenceScenarioDataInstance;
        String string = "Incidence";
        peakPositions = this.getDelayAfterChannuka(this.data, string);
        int n = 0;
        while (n < peakPositions.size()) {
            int n2 = peakPositions.get(n);
            System.out.print(n2 + ",");
            ++n;
        }
        System.out.println("-1");
        compressedCycles = this.compressData(this.data, peakPositions, string);
    }

    public List<Integer> getPeakPositions(ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance referenceScenarioDataInstance, String string) {
        int n;
        int n2;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        List list = (List)referenceScenarioDataInstance.getData().get(string);
        List<Double> list2 = CycleCompressor.smooth3(list);
        List<Double> list3 = CycleCompressor.smooth3(list2);
        int n3 = CycleCompressor.findPeak(list3, n2 = 0, n = 30);
        if (n3 != n2) {
            arrayList.add(new Integer(n3));
        }
        int n4 = list3.size() - 182;
        while (n3 < n4) {
            n2 = n3 + 182;
            n = n2 + 365;
            n3 = CycleCompressor.findPeak(list3, n2, n);
            arrayList.add(new Integer(n3));
        }
        return arrayList;
    }

    public List<Integer> getDelayAfterChannuka(ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance referenceScenarioDataInstance, String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        List list = (List)referenceScenarioDataInstance.getData().get(string);
        List<Double> list2 = CycleCompressor.smooth3(list);
        List<Double> list3 = CycleCompressor.smooth3(list2);
        int n = 0;
        while (n < DAY_OF_CHANNUKA.length) {
            int n2 = DAY_OF_CHANNUKA[n] - 30;
            int n3 = n2 + 90;
            int n4 = CycleCompressor.findPeak(list3, n2, n3);
            arrayList.add(new Integer(n4));
            ++n;
        }
        return arrayList;
    }

    public List<Double> compressData(ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance referenceScenarioDataInstance, List<Integer> list, String string) {
        int n;
        List list2 = (List)referenceScenarioDataInstance.getData().get(string);
        double[] dArray = new double[365];
        double[] dArray2 = new double[365];
        int n2 = 0;
        while (n2 < 365) {
            dArray[n2] = 0.0;
            dArray2[n2] = 0.0;
            ++n2;
        }
        n2 = 0;
        while (n2 < list.size()) {
            int n3;
            n = list.get(n2);
            int n4 = n3 = n - 182;
            int n5 = 0;
            while (n5 < 365) {
                if (n4 >= 0 && n4 < list2.size()) {
                    double d = (Double)list2.get(n4);
                    int n6 = n5;
                    dArray[n6] = dArray[n6] + d;
                    int n7 = n5;
                    dArray2[n7] = dArray2[n7] + 1.0;
                }
                ++n4;
                ++n5;
            }
            ++n2;
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        n = 0;
        while (n < 365) {
            if (dArray2[n] <= 0.0) {
                dArray2[n] = 1.0;
            }
            double d = dArray[n] / dArray2[n];
            arrayList.add(n, new Double(d));
            ++n;
        }
        return arrayList;
    }

    public static int findPeak(List<Double> list, int n, int n2) {
        int n3 = n;
        double d = 0.0;
        int n4 = n;
        while (n4 < n2) {
            double d2;
            if (n4 < list.size() && (d2 = list.get(n4).doubleValue()) > d) {
                d = d2;
                n3 = n4;
            }
            ++n4;
        }
        return n3;
    }

    public static int findFirstPeak(List<Double> list, int n, int n2) {
        int n3 = n;
        double d = 0.0;
        int n4 = n;
        while (n4 < n2) {
            if (n4 < list.size()) {
                double d2 = list.get(n4);
                if (d2 >= d) {
                    d = d2;
                    n3 = n4;
                } else {
                    return n3;
                }
            }
            ++n4;
        }
        return n3;
    }

    public static List<Double> smooth3(List<Double> list) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        double d = list.get(0);
        double d2 = list.get(1);
        arrayList.add(new Double((d + d2) / 2.0));
        int n = 1;
        while (n < list.size() - 1) {
            double d3 = list.get(n - 1);
            double d4 = list.get(n);
            double d5 = list.get(n + 1);
            arrayList.add(n, new Double((d3 + d4 + d5) / 3.0));
            ++n;
        }
        n = list.size() - 1;
        d = list.get(n);
        d2 = list.get(n - 1);
        arrayList.add(new Double((d + d2) / 2.0));
        return arrayList;
    }

    public double[] getCompressedData() {
        double[] dArray = new double[compressedCycles.size()];
        int n = 0;
        while (n < compressedCycles.size()) {
            dArray[n] = compressedCycles.get(n);
            ++n;
        }
        return dArray;
    }
}

