/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.stem.analysis.ScenarioInitializationException;
import org.eclipse.stem.definitions.Activator;
import org.eclipse.stem.util.analysis.LinearLeastSquaresFit;

public class DataProcessor {
    private static final String INCIDENCE_FILE_NAME = "Incidence_2.csv";
    private static final String SUSCEPTIBLE_FILE_NAME = "S_2.csv";
    private static final String INFECTIOUS_FILE_NAME = "I_2.csv";
    private static final String RECOVERED_FILE_NAME = "R_2.csv";
    private static final String POPULATION_FILE_NAME = "P_2.csv";
    private static final String REPORTING_FRACTION_FILE_NAME = "reportingFraction.csv";
    private Map<String, List<Data>> incidenceMap = new HashMap<String, List<Data>>();
    private Map<String, Double> populationMap = new HashMap<String, Double>();
    private int maxIteration = 0;
    private long referencePopulationDay;
    private double fractChangePopulationPerDay;

    public void process(String string, String string2, Date date, Date date2, String string3, long l, long l2, double d, double d2, double d3) throws ScenarioInitializationException {
        this.readPopulationData(string3, date, date2, l, l2);
        this.readSourceData(string);
        this.modelDiseaseState(d, d2, d3);
        this.writeResults(string2);
    }

    private void readPopulationData(String string, Date date, Date date2, long l, long l2) throws ScenarioInitializationException {
        File file = new File(string);
        BufferedReader bufferedReader = DataProcessor.openReader(file);
        if (bufferedReader == null) {
            throw new ScenarioInitializationException("Failed to open population data file " + string);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int n = calendar.get(1);
        try {
            String string2 = null;
            while (!DataProcessor.EOF(string2 = bufferedReader.readLine())) {
                int n2 = string2.indexOf("=");
                if (n2 < 0) continue;
                String string3 = string2.substring(0, n2).trim();
                String string4 = string2.substring(n2 + 1, string2.length()).trim();
                if (string3.equals("YEAR")) {
                    try {
                        n = Integer.parseInt(string4);
                    }
                    catch (NumberFormatException numberFormatException) {
                        Activator.logInformation((String)"Failed to read population year", (Throwable)numberFormatException);
                    }
                    continue;
                }
                if (string3.indexOf("-") < 0) continue;
                try {
                    this.populationMap.put(string3, new Double(string4));
                }
                catch (NumberFormatException numberFormatException) {
                    Activator.logInformation((String)("Failed to read population for " + string3), (Throwable)numberFormatException);
                }
            }
            if (this.populationMap.isEmpty()) {
                throw new ScenarioInitializationException("Failed to read population data from " + file.getName());
            }
            calendar = Calendar.getInstance();
            calendar.set(6, 1);
            calendar.set(1, n);
            long l3 = calendar.getTimeInMillis() - date.getTime();
            this.referencePopulationDay = l3 / 86400000L;
            l3 = date2.getTime() - date.getTime();
            long l4 = l3 / 86400000L;
            double d = ((double)l2 - (double)l) / (double)(l4 + 1L);
            this.fractChangePopulationPerDay = d / (double)l;
        }
        catch (IOException iOException) {
            throw new ScenarioInitializationException((Throwable)iOException);
        }
    }

    private void readSourceData(String string) throws ScenarioInitializationException {
        File file = new File(string);
        int n = 0;
        File[] fileArray = file.listFiles();
        int n2 = 0;
        while (n2 < fileArray.length) {
            try {
                this.readDataFromSourceFile(fileArray[n2]);
                ++n;
            }
            catch (ScenarioInitializationException scenarioInitializationException) {
                Activator.logInformation((String)("Failed to read data from " + fileArray[n2].getName()), (Throwable)scenarioInitializationException);
            }
            ++n2;
        }
        if (n == 0) {
            throw new ScenarioInitializationException("Failed to read source data from " + string);
        }
    }

    private void readDataFromSourceFile(File file) throws ScenarioInitializationException {
        List<Object> list;
        String string = file.getName();
        if (string.indexOf(".txt") < 0) {
            return;
        }
        BufferedReader bufferedReader = DataProcessor.openReader(file);
        if (bufferedReader == null) {
            throw new ScenarioInitializationException("Failed to open file " + string);
        }
        int n = string.indexOf(".txt");
        String string2 = string.substring(0, n);
        String string3 = this.convertID(string2);
        if (string3 == null) {
            throw new ScenarioInitializationException("Failed to convert " + string2 + " to STEM ID");
        }
        Double d = this.populationMap.get(string3);
        if (d == null) {
            throw new ScenarioInitializationException("No population found for " + string3 + " from " + string2);
        }
        if (!this.incidenceMap.containsKey(string3)) {
            list = new ArrayList();
            this.incidenceMap.put(string3, list);
        }
        list = this.incidenceMap.get(string3);
        try {
            String string4 = null;
            bufferedReader.readLine();
            while (!DataProcessor.EOF(string4 = bufferedReader.readLine())) {
                StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
                String string5 = stringTokenizer.nextToken(",");
                String string6 = stringTokenizer.nextToken(",");
                String string7 = stringTokenizer.nextToken(",");
                Integer n2 = new Integer(string5.trim());
                double d2 = new Double(string7);
                double d3 = this.getPopulation(n2, d);
                Data data = new Data(n2, string6, d2, d3);
                list.add(data);
                if (list.size() <= this.maxIteration) continue;
                this.maxIteration = list.size();
            }
        }
        catch (IOException iOException) {
            throw new ScenarioInitializationException((Throwable)iOException);
        }
    }

    private void modelDiseaseState(double d, double d2, double d3) {
        double d4;
        double d5;
        double d6;
        List<Data> list;
        for (String string : this.populationMap.keySet()) {
            if (!this.incidenceMap.containsKey(string)) continue;
            list = this.incidenceMap.get(string);
            d6 = 10.0;
            d5 = 1.0;
            double d7 = Double.MAX_VALUE;
            boolean bl = true;
            boolean bl2 = true;
            int n = 1000;
            double d8 = 100000.0;
            int n2 = (int)d8;
            while (n2 > 1 && bl) {
                double d9;
                bl2 = true;
                if (n2 <= n && n >= 10) {
                    n /= 10;
                }
                d4 = (double)n2 / d8;
                double d10 = 0.0;
                double d11 = 0.0;
                double[] dArray = new double[this.maxIteration];
                double[] dArray2 = new double[this.maxIteration];
                double[] dArray3 = new double[this.maxIteration];
                int n3 = 0;
                while (n3 < this.maxIteration) {
                    dArray[n3] = 0.0;
                    dArray2[n3] = 0.0;
                    dArray3[n3] = 0.0;
                    ++n3;
                }
                n3 = 0;
                while (n3 < list.size() && bl) {
                    Data data = list.get(n3);
                    double d12 = data.reports / d4;
                    double d13 = data.population;
                    double d14 = (d10 += d12) * d;
                    d11 += d14;
                    if (n3 == 0) {
                        d11 += (1.0 - d2) * d13;
                    }
                    double d15 = d10 -= d14;
                    double d16 = d11 *= 1.0 - d3;
                    double d17 = d13 - (d15 + d16);
                    dArray[n3] = d17 / d13;
                    dArray2[n3] = d16 / d13;
                    dArray3[n3] = n3;
                    if (!(d17 >= 0.0 && d16 >= 0.0 && d15 >= 0.0)) {
                        bl2 = false;
                        if (n > 1) {
                            n2 += n;
                            n /= 10;
                            break;
                        }
                        bl = false;
                        n = 1000;
                        break;
                    }
                    data.reportingFraction = d6 = d4;
                    if (!bl || !bl2) break;
                    ++n3;
                }
                if (bl && bl2 && Math.abs(d9 = this.getSlopeLinear(dArray3, dArray)) <= d7) {
                    d7 = Math.abs(d9);
                    d5 = d4;
                }
                n2 -= n;
            }
            n2 = 0;
            while (n2 < list.size() && bl) {
                Data data = list.get(n2);
                if (d5 < 0.9 && d5 >= data.reportingFraction) {
                    data.reportingFraction = d5;
                }
                ++n2;
            }
        }
        for (String string : this.populationMap.keySet()) {
            if (!this.incidenceMap.containsKey(string)) continue;
            list = this.incidenceMap.get(string);
            d6 = 0.0;
            d5 = 0.0;
            int n = 0;
            while (n < list.size()) {
                Data data = list.get(n);
                double d18 = data.reportingFraction;
                double d19 = data.reports / d18;
                double d20 = data.population;
                d4 = (d6 += d19) * d;
                d5 += d4;
                if (n == 0) {
                    d5 += (1.0 - d2) * d20;
                }
                data.infectious = d6 -= d4;
                data.recovered = d5 *= 1.0 - d3;
                data.susceptible = d20 - (data.infectious + data.recovered);
                ++n;
            }
        }
    }

    private void writeResults(String string) throws ScenarioInitializationException {
        try {
            if (!string.endsWith(File.separator)) {
                string = String.valueOf(string) + File.separator;
            }
            FileWriter fileWriter = new FileWriter(String.valueOf(string) + INCIDENCE_FILE_NAME);
            FileWriter fileWriter2 = new FileWriter(String.valueOf(string) + SUSCEPTIBLE_FILE_NAME);
            FileWriter fileWriter3 = new FileWriter(String.valueOf(string) + INFECTIOUS_FILE_NAME);
            FileWriter fileWriter4 = new FileWriter(String.valueOf(string) + RECOVERED_FILE_NAME);
            FileWriter fileWriter5 = new FileWriter(String.valueOf(string) + POPULATION_FILE_NAME);
            FileWriter fileWriter6 = new FileWriter(String.valueOf(string) + REPORTING_FRACTION_FILE_NAME);
            Object[] objectArray = new String[this.populationMap.keySet().size()];
            Iterator<String> iterator = this.populationMap.keySet().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                objectArray[n++] = iterator.next();
            }
            Arrays.sort(objectArray);
            String string2 = "iteration,time";
            int n2 = 0;
            while (n2 < objectArray.length) {
                if (this.incidenceMap.containsKey(objectArray[n2])) {
                    string2 = String.valueOf(string2) + "," + (String)objectArray[n2];
                }
                ++n2;
            }
            string2 = String.valueOf(string2) + "\n";
            fileWriter.write(string2);
            fileWriter2.write(string2);
            fileWriter3.write(string2);
            fileWriter4.write(string2);
            fileWriter5.write(string2);
            fileWriter6.write(string2);
            n2 = 0;
            while (n2 < this.maxIteration) {
                String string3 = "";
                String string4 = "";
                String string5 = "";
                String string6 = "";
                String string7 = "";
                String string8 = "0,0";
                int n3 = 0;
                while (n3 < objectArray.length) {
                    Object object = objectArray[n3];
                    if (this.incidenceMap.containsKey(object)) {
                        List<Data> list = this.incidenceMap.get(object);
                        if (n2 >= list.size()) break;
                        Data data = list.get(n2);
                        if (n2 == 0) {
                            string8 = String.valueOf(string8) + "," + data.reportingFraction;
                        }
                        if (n3 == 0) {
                            string3 = String.valueOf(string3) + data.iteration + "," + data.time;
                            string4 = String.valueOf(string4) + data.iteration + "," + data.time;
                            string5 = String.valueOf(string5) + data.iteration + "," + data.time;
                            string6 = String.valueOf(string6) + data.iteration + "," + data.time;
                            string7 = String.valueOf(string7) + data.iteration + "," + data.time;
                        }
                        string3 = String.valueOf(string3) + "," + data.reports;
                        string4 = String.valueOf(string4) + "," + data.susceptible;
                        string5 = String.valueOf(string5) + "," + data.infectious;
                        string6 = String.valueOf(string6) + "," + data.recovered;
                        string7 = String.valueOf(string7) + "," + data.population;
                    }
                    ++n3;
                }
                string3 = String.valueOf(string3) + "\n";
                string4 = String.valueOf(string4) + "\n";
                string5 = String.valueOf(string5) + "\n";
                string6 = String.valueOf(string6) + "\n";
                string7 = String.valueOf(string7) + "\n";
                if (n2 == 0) {
                    string8 = String.valueOf(string8) + "\n";
                }
                fileWriter.write(string3);
                fileWriter2.write(string4);
                fileWriter3.write(string5);
                fileWriter4.write(string6);
                fileWriter5.write(string7);
                if (n2 == 0) {
                    fileWriter6.write(string8);
                }
                ++n2;
            }
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
            ((Writer)fileWriter2).flush();
            ((Writer)fileWriter2).close();
            ((Writer)fileWriter3).flush();
            ((Writer)fileWriter3).close();
            ((Writer)fileWriter4).flush();
            ((Writer)fileWriter4).close();
            ((Writer)fileWriter5).flush();
            ((Writer)fileWriter5).close();
            ((Writer)fileWriter6).flush();
            ((Writer)fileWriter6).close();
        }
        catch (IOException iOException) {
            throw new ScenarioInitializationException((Throwable)iOException);
        }
    }

    public String convertID(String string) {
        String string2 = DataProcessor.getAdmin2Code(string);
        for (String string3 : this.populationMap.keySet()) {
            if (!DataProcessor.getAdmin2Code(string3).equalsIgnoreCase(string2)) continue;
            return string3;
        }
        return null;
    }

    public static String getAdmin2Code(String string) {
        int n = string.lastIndexOf("-");
        return string.substring(n + 1, string.length());
    }

    private double getSlopeLinear(double[] dArray, double[] dArray2) {
        LinearLeastSquaresFit linearLeastSquaresFit = new LinearLeastSquaresFit(dArray, dArray2);
        return linearLeastSquaresFit.getSlope();
    }

    private double getPopulation(int n, double d) {
        double d2 = (double)((long)n - this.referencePopulationDay) * this.fractChangePopulationPerDay;
        return d * (1.0 + d2);
    }

    public static BufferedReader openReader(File file) {
        block3: {
            try {
                if (file.exists()) break block3;
                return null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
        return new BufferedReader(new FileReader(file));
    }

    public static boolean EOF(String string) {
        return string == null || string.length() == 0;
    }

    public class Data {
        public double reports;
        public double reportingFraction = -1.0;
        public double susceptible = 0.0;
        public double infectious = 0.0;
        public double recovered = 0.0;
        public double population = 0.0;
        public Integer iteration;
        public String time;

        public Data(Integer n, String string, double d, double d2) {
            this.iteration = n;
            this.time = string;
            this.reports = d;
            this.population = d2;
        }

        public double getReferencePopulation() {
            return this.population;
        }

        public void setLocalPopulation(double d) {
            this.population = d;
            this.susceptible = d;
        }
    }
}

