/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis;

import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinearLeastSquaresFit {
    private double slope = 0.0;
    private double intercept = 0.0;
    private double slopeVariance = 0.0;
    private double interceptVariance = 0.0;
    private double slopeStdDev = 0.0;
    private double interceptStdDev = 0.0;

    public LinearLeastSquaresFit(List<Double> list, List<Double> list2) {
        int n = list.size();
        assert (n == list2.size());
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = list.get(n2);
            dArray2[n2] = list2.get(n2);
            ++n2;
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        int n3 = 0;
        while (n3 < n) {
            d += dArray[n3];
            d2 += dArray2[n3];
            d3 += dArray[n3] * dArray2[n3];
            d4 += dArray[n3] * dArray[n3];
            d5 += dArray2[n3] * dArray2[n3];
            d6 += 1.0;
            ++n3;
        }
        double d7 = -(d6 * d4 - d * d);
        this.intercept = (d * d3 - d2 * d4) / d7;
        this.slope = (d * d2 - d6 * d3) / d7;
        double d8 = (d5 + this.intercept * this.intercept * d6 + this.slope * this.slope * d4 - 2.0 * (-this.intercept * d2 + this.slope * d3 + this.intercept * this.slope * d)) / (double)(n - 2);
        this.interceptVariance = Math.abs(d8 / d7 * d4);
        this.slopeVariance = Math.abs(d8 / d7 * d6);
        this.interceptStdDev = Math.sqrt(this.interceptVariance);
        this.slopeStdDev = Math.sqrt(this.slopeVariance);
    }

    public LinearLeastSquaresFit(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        assert (n == dArray2.length);
        double[] dArray3 = dArray;
        double[] dArray4 = dArray2;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        int n2 = 0;
        while (n2 < n) {
            d += dArray3[n2];
            d2 += dArray4[n2];
            d3 += dArray3[n2] * dArray4[n2];
            d4 += dArray3[n2] * dArray3[n2];
            d5 += dArray4[n2] * dArray4[n2];
            d6 += 1.0;
            ++n2;
        }
        double d7 = -(d6 * d4 - d * d);
        this.intercept = (d * d3 - d2 * d4) / d7;
        this.slope = (d * d2 - d6 * d3) / d7;
        double d8 = (d5 + this.intercept * this.intercept * d6 + this.slope * this.slope * d4 - 2.0 * (-this.intercept * d2 + this.slope * d3 + this.intercept * this.slope * d)) / (double)(n - 2);
        this.interceptVariance = Math.abs(d8 / d7 * d4);
        this.slopeVariance = Math.abs(d8 / d7 * d6);
        this.interceptStdDev = Math.sqrt(this.interceptVariance);
        this.slopeStdDev = Math.sqrt(this.slopeVariance);
    }

    public double getSlope() {
        return this.slope;
    }

    public double getIntercept() {
        return this.intercept;
    }

    public double getSlopeVariance() {
        return this.slopeVariance;
    }

    public double getInterceptVariance() {
        return this.interceptVariance;
    }

    public double getSlopeStdDev() {
        return this.slopeStdDev;
    }

    public double getInterceptStdDev() {
        return this.interceptStdDev;
    }
}

