/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.stem.analysis.States;
import org.eclipse.stem.analysis.impl.ReferenceScenarioDataMapImpl;
import org.eclipse.stem.util.analysis.PhaseSpaceCoordinate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LyapunovAnalysis {
    Map<String, List<PhaseSpaceCoordinate>> commonPhaseSpaceA = new HashMap<String, List<PhaseSpaceCoordinate>>();
    Map<String, List<PhaseSpaceCoordinate>> commonPhaseSpaceB = new HashMap<String, List<PhaseSpaceCoordinate>>();
    Map<String, List<Double>> totalPopulation = new HashMap<String, List<Double>>();
    public double[] locationCount;
    public PhaseSpaceCoordinate[] trajectoryA;
    public PhaseSpaceCoordinate[] trajectoryB;
    public double[] time;

    public LyapunovAnalysis(ReferenceScenarioDataMapImpl referenceScenarioDataMapImpl, ReferenceScenarioDataMapImpl referenceScenarioDataMapImpl2, IRunnableContext iRunnableContext) {
        final ReferenceScenarioDataMapImpl referenceScenarioDataMapImpl3 = referenceScenarioDataMapImpl;
        final ReferenceScenarioDataMapImpl referenceScenarioDataMapImpl4 = referenceScenarioDataMapImpl2;
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) {
                iProgressMonitor.beginTask("Calculating common locations...", referenceScenarioDataMapImpl3.getNumLocations());
                Iterator iterator = referenceScenarioDataMapImpl3.getLocations().iterator();
                int n = -1;
                while (iterator.hasNext()) {
                    iProgressMonitor.worked(1);
                    if (iProgressMonitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    String string = (String)iterator.next();
                    if (!referenceScenarioDataMapImpl4.containsLocation(string)) continue;
                    ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance referenceScenarioDataInstance = referenceScenarioDataMapImpl3.getLocation(string);
                    List<PhaseSpaceCoordinate> list = LyapunovAnalysis.this.getNormalizedTrajectory(referenceScenarioDataInstance);
                    LyapunovAnalysis.this.commonPhaseSpaceA.put(string, list);
                    LyapunovAnalysis.this.totalPopulation.put(string, LyapunovAnalysis.this.getTotalPopulation(referenceScenarioDataInstance));
                    ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance referenceScenarioDataInstance2 = referenceScenarioDataMapImpl4.getLocation(string);
                    List<PhaseSpaceCoordinate> list2 = LyapunovAnalysis.this.getNormalizedTrajectory(referenceScenarioDataInstance2);
                    LyapunovAnalysis.this.commonPhaseSpaceB.put(string, list2);
                    if (n == -1) {
                        n = list.size();
                    }
                    if (list.size() < n) {
                        n = list.size();
                    }
                    if (list2.size() >= n) continue;
                    n = list2.size();
                }
                iProgressMonitor.done();
                if (LyapunovAnalysis.this.time == null) {
                    LyapunovAnalysis.this.time = new double[n];
                    LyapunovAnalysis.this.trajectoryA = new PhaseSpaceCoordinate[n];
                    LyapunovAnalysis.this.trajectoryB = new PhaseSpaceCoordinate[n];
                    LyapunovAnalysis.this.locationCount = new double[n];
                    int n2 = 0;
                    while (n2 < n) {
                        LyapunovAnalysis.this.time[n2] = n2;
                        LyapunovAnalysis.this.trajectoryA[n2] = new PhaseSpaceCoordinate(0.0, 0.0);
                        LyapunovAnalysis.this.trajectoryB[n2] = new PhaseSpaceCoordinate(0.0, 0.0);
                        LyapunovAnalysis.this.locationCount[n2] = 0.0;
                        ++n2;
                    }
                }
            }
        };
        try {
            iRunnableContext.run(true, false, iRunnableWithProgress);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
    }

    public List<PhaseSpaceCoordinate> getNormalizedTrajectory(ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance referenceScenarioDataInstance) {
        String string = States.statesToFit[0];
        String string2 = States.statesToFit[1];
        String string3 = States.statesToFit[2];
        String string4 = States.statesToFit[3];
        List list = null;
        List list2 = null;
        List list3 = referenceScenarioDataInstance.getData(string3);
        List list4 = referenceScenarioDataInstance.getData(string);
        assert (list3 != null);
        assert (list4 != null);
        if (referenceScenarioDataInstance.containsParameter(string2)) {
            list = referenceScenarioDataInstance.getData(string2);
        }
        if (referenceScenarioDataInstance.containsParameter(string4)) {
            list2 = referenceScenarioDataInstance.getData(string4);
        }
        ArrayList<PhaseSpaceCoordinate> arrayList = new ArrayList<PhaseSpaceCoordinate>();
        double[] dArray = new double[list3.size()];
        int n = 0;
        while (n < list3.size()) {
            double d = new Double((String)list3.get(n));
            double d2 = new Double((String)list4.get(n));
            double d3 = 0.0;
            double d4 = 0.0;
            if (list != null) {
                d3 = new Double((String)list.get(n));
            }
            if (list2 != null) {
                d4 = new Double((String)list2.get(n));
            }
            dArray[n] = d + d2 + d3 + d4;
            PhaseSpaceCoordinate phaseSpaceCoordinate = new PhaseSpaceCoordinate(d2 /= dArray[n], d /= dArray[n]);
            arrayList.add(phaseSpaceCoordinate);
            ++n;
        }
        return arrayList;
    }

    public List<Double> getTotalPopulation(ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance referenceScenarioDataInstance) {
        String string = States.statesToFit[0];
        String string2 = States.statesToFit[1];
        String string3 = States.statesToFit[2];
        String string4 = States.statesToFit[3];
        List list = null;
        List list2 = null;
        List list3 = referenceScenarioDataInstance.getData(string3);
        List list4 = referenceScenarioDataInstance.getData(string);
        assert (list3 != null);
        assert (list4 != null);
        if (referenceScenarioDataInstance.containsParameter(string2)) {
            list = referenceScenarioDataInstance.getData(string2);
        }
        if (referenceScenarioDataInstance.containsParameter(string4)) {
            list2 = referenceScenarioDataInstance.getData(string4);
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        int n = 0;
        while (n < list3.size()) {
            double d = 0.0;
            double d2 = new Double((String)list3.get(n));
            double d3 = new Double((String)list4.get(n));
            double d4 = 0.0;
            double d5 = 0.0;
            if (list != null) {
                d4 = new Double((String)list.get(n));
            }
            if (list2 != null) {
                d5 = new Double((String)list2.get(n));
            }
            d = d2 + d3 + d4 + d5;
            arrayList.add(new Double(d));
            ++n;
        }
        return arrayList;
    }

    public List<PhaseSpaceCoordinate[]> getLyapunovTrajectory(IRunnableContext iRunnableContext) {
        final ArrayList<PhaseSpaceCoordinate[]> arrayList = new ArrayList<PhaseSpaceCoordinate[]>();
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) {
                iProgressMonitor.beginTask("Getting Lyapunov trajectory", LyapunovAnalysis.this.time.length);
                double[] dArray = new double[LyapunovAnalysis.this.time.length];
                int n = 0;
                while (n < LyapunovAnalysis.this.time.length) {
                    iProgressMonitor.worked(1);
                    if (iProgressMonitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    dArray[n] = 0.0;
                    for (String string : LyapunovAnalysis.this.commonPhaseSpaceA.keySet()) {
                        List<PhaseSpaceCoordinate> list = LyapunovAnalysis.this.commonPhaseSpaceA.get(string);
                        List<PhaseSpaceCoordinate> list2 = LyapunovAnalysis.this.commonPhaseSpaceB.get(string);
                        List<Double> list3 = LyapunovAnalysis.this.totalPopulation.get(string);
                        double d = list.get(n).getYValue();
                        double d2 = list2.get(n).getYValue();
                        double d3 = list.get(n).getXValue();
                        double d4 = list2.get(n).getXValue();
                        double d5 = list3.get(n);
                        if (!(d > 0.0) && !(d2 > 0.0)) continue;
                        int n2 = n;
                        LyapunovAnalysis.this.locationCount[n2] = LyapunovAnalysis.this.locationCount[n2] + 1.0;
                        int n3 = n;
                        dArray[n3] = dArray[n3] + d5;
                        LyapunovAnalysis.this.trajectoryA[n].integratePath(d3 * d5, d * d5);
                        LyapunovAnalysis.this.trajectoryB[n].integratePath(d4 * d5, d2 * d5);
                    }
                    if (LyapunovAnalysis.this.locationCount[n] >= 1.0) {
                        LyapunovAnalysis.this.trajectoryA[n].normalize(dArray[n]);
                        LyapunovAnalysis.this.trajectoryB[n].normalize(dArray[n]);
                    }
                    ++n;
                }
                arrayList.add(LyapunovAnalysis.this.trajectoryA);
                arrayList.add(LyapunovAnalysis.this.trajectoryB);
                iProgressMonitor.done();
            }
        };
        try {
            iRunnableContext.run(true, true, iRunnableWithProgress);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
        return arrayList;
    }

    public static List<EList<Double>> getCumulativePhaseSpaceDeviation(List<PhaseSpaceCoordinate[]> list) {
        ArrayList<EList<Double>> arrayList = new ArrayList<EList<Double>>();
        PhaseSpaceCoordinate[] phaseSpaceCoordinateArray = list.get(0);
        if (list.size() >= 2) {
            int n = 1;
            while (n < list.size()) {
                PhaseSpaceCoordinate[] phaseSpaceCoordinateArray2 = list.get(n);
                BasicEList basicEList = new BasicEList(phaseSpaceCoordinateArray.length);
                int n2 = 0;
                while (n2 < basicEList.size()) {
                    basicEList.set(n2, (Object)0.0);
                    if (phaseSpaceCoordinateArray2.length >= n2) {
                        PhaseSpaceCoordinate phaseSpaceCoordinate = phaseSpaceCoordinateArray[n2];
                        PhaseSpaceCoordinate phaseSpaceCoordinate2 = phaseSpaceCoordinateArray2[n2];
                        basicEList.set(n2, (Object)((Double)basicEList.get(n2) + phaseSpaceCoordinate.getDistance(phaseSpaceCoordinate2)));
                        if (n2 >= 1) {
                            basicEList.set(n2, (Object)((Double)basicEList.get(n2 - 1) + (Double)basicEList.get(n2)));
                        }
                    }
                    ++n2;
                }
                n2 = 0;
                while (n2 < basicEList.size()) {
                    if ((Double)basicEList.get(n2) > 0.0) {
                        basicEList.set(n2, (Object)Math.log((Double)basicEList.get(n2)));
                    }
                    ++n2;
                }
                arrayList.add((EList<Double>)basicEList);
                ++n;
            }
        }
        return arrayList;
    }
}

