/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.stem.analysis.States;
import org.eclipse.stem.analysis.impl.ReferenceScenarioDataMapImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeanSquareDifference {
    Map<String, List<Double>> commonInfectiousLocationsA = new HashMap<String, List<Double>>();
    Map<String, List<Double>> commonInfectiousLocationsB = new HashMap<String, List<Double>>();
    Map<String, List<Double>> commonSusceptibleLocationsA = new HashMap<String, List<Double>>();
    Map<String, List<Double>> commonSusceptibleLocationsB = new HashMap<String, List<Double>>();
    Map<String, List<Double>> totalPopulation = new HashMap<String, List<Double>>();
    public double[] locationCount;
    public double[] meanSqDiff;
    public double[] time;

    public MeanSquareDifference(ReferenceScenarioDataMapImpl referenceScenarioDataMapImpl, ReferenceScenarioDataMapImpl referenceScenarioDataMapImpl2, IRunnableContext iRunnableContext) {
        final ReferenceScenarioDataMapImpl referenceScenarioDataMapImpl3 = referenceScenarioDataMapImpl;
        final ReferenceScenarioDataMapImpl referenceScenarioDataMapImpl4 = referenceScenarioDataMapImpl2;
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) {
                iProgressMonitor.beginTask("Calculating common locations...", referenceScenarioDataMapImpl3.getNumLocations());
                Iterator iterator = referenceScenarioDataMapImpl3.getLocations().iterator();
                int n = -1;
                while (iterator.hasNext()) {
                    iProgressMonitor.worked(1);
                    if (iProgressMonitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    String string = (String)iterator.next();
                    if (!referenceScenarioDataMapImpl4.containsLocation(string)) continue;
                    ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance referenceScenarioDataInstance = referenceScenarioDataMapImpl3.getLocation(string);
                    List<Double> list = MeanSquareDifference.this.getNormalizedInfectious(referenceScenarioDataInstance);
                    MeanSquareDifference.this.commonInfectiousLocationsA.put(string, list);
                    List<Double> list2 = MeanSquareDifference.this.getNormalizedSusceptible(referenceScenarioDataInstance);
                    MeanSquareDifference.this.commonSusceptibleLocationsA.put(string, list2);
                    MeanSquareDifference.this.totalPopulation.put(string, MeanSquareDifference.this.getTotalPopulation(referenceScenarioDataInstance));
                    ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance referenceScenarioDataInstance2 = referenceScenarioDataMapImpl4.getLocation(string);
                    List<Double> list3 = MeanSquareDifference.this.getNormalizedInfectious(referenceScenarioDataInstance2);
                    MeanSquareDifference.this.commonInfectiousLocationsB.put(string, list3);
                    List<Double> list4 = MeanSquareDifference.this.getNormalizedSusceptible(referenceScenarioDataInstance2);
                    MeanSquareDifference.this.commonSusceptibleLocationsB.put(string, list4);
                    if (n == -1) {
                        n = list.size();
                    }
                    if (n >= list3.size()) {
                        n = list3.size();
                    }
                    if (n < list.size()) continue;
                    n = list.size();
                }
                iProgressMonitor.done();
                if (n <= 0) {
                    n = 0;
                }
                if (MeanSquareDifference.this.time == null) {
                    MeanSquareDifference.this.time = new double[n];
                    MeanSquareDifference.this.meanSqDiff = new double[n];
                    MeanSquareDifference.this.locationCount = new double[n];
                    int n2 = 0;
                    while (n2 < n) {
                        MeanSquareDifference.this.time[n2] = n2;
                        MeanSquareDifference.this.meanSqDiff[n2] = 0.0;
                        MeanSquareDifference.this.locationCount[n2] = 0.0;
                        ++n2;
                    }
                }
            }
        };
        try {
            iRunnableContext.run(true, false, iRunnableWithProgress);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
    }

    public List<Double> getNormalizedInfectious(ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance referenceScenarioDataInstance) {
        String string = States.statesToFit[0];
        String string2 = States.statesToFit[1];
        String string3 = States.statesToFit[2];
        String string4 = States.statesToFit[3];
        List list = null;
        List list2 = null;
        List list3 = referenceScenarioDataInstance.getData(string3);
        List list4 = referenceScenarioDataInstance.getData(string);
        assert (list3 != null);
        assert (list4 != null);
        if (referenceScenarioDataInstance.containsParameter(string2)) {
            list = referenceScenarioDataInstance.getData(string2);
        }
        if (referenceScenarioDataInstance.containsParameter(string4)) {
            list2 = referenceScenarioDataInstance.getData(string4);
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        double[] dArray = new double[list3.size()];
        int n = 0;
        while (n < list3.size()) {
            double d = new Double((String)list3.get(n));
            double d2 = new Double((String)list4.get(n));
            double d3 = 0.0;
            double d4 = 0.0;
            if (list != null) {
                d3 = new Double((String)list.get(n));
            }
            if (list2 != null) {
                d4 = new Double((String)list2.get(n));
            }
            dArray[n] = d + d2 + d3 + d4;
            arrayList.add(new Double(d /= dArray[n]));
            ++n;
        }
        return arrayList;
    }

    public List<Double> getNormalizedSusceptible(ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance referenceScenarioDataInstance) {
        String string = States.statesToFit[0];
        String string2 = States.statesToFit[1];
        String string3 = States.statesToFit[2];
        String string4 = States.statesToFit[3];
        List list = null;
        List list2 = null;
        List list3 = referenceScenarioDataInstance.getData(string3);
        List list4 = referenceScenarioDataInstance.getData(string);
        assert (list3 != null);
        assert (list4 != null);
        if (referenceScenarioDataInstance.containsParameter(string2)) {
            list = referenceScenarioDataInstance.getData(string2);
        }
        if (referenceScenarioDataInstance.containsParameter(string4)) {
            list2 = referenceScenarioDataInstance.getData(string4);
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        double[] dArray = new double[list4.size()];
        int n = 0;
        while (n < list4.size()) {
            double d = new Double((String)list3.get(n));
            double d2 = new Double((String)list4.get(n));
            double d3 = 0.0;
            double d4 = 0.0;
            if (list != null) {
                d3 = new Double((String)list.get(n));
            }
            if (list2 != null) {
                d4 = new Double((String)list2.get(n));
            }
            dArray[n] = d + d2 + d3 + d4;
            d2 = dArray[n] != 0.0 ? (d2 /= dArray[n]) : 0.0;
            arrayList.add(new Double(d2));
            ++n;
        }
        return arrayList;
    }

    public List<Double> getTotalPopulation(ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance referenceScenarioDataInstance) {
        String string = States.statesToFit[0];
        String string2 = States.statesToFit[1];
        String string3 = States.statesToFit[2];
        String string4 = States.statesToFit[3];
        List list = null;
        List list2 = null;
        List list3 = referenceScenarioDataInstance.getData(string3);
        List list4 = referenceScenarioDataInstance.getData(string);
        assert (list3 != null);
        assert (list4 != null);
        if (referenceScenarioDataInstance.containsParameter(string2)) {
            list = referenceScenarioDataInstance.getData(string2);
        }
        if (referenceScenarioDataInstance.containsParameter(string4)) {
            list2 = referenceScenarioDataInstance.getData(string4);
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        int n = 0;
        while (n < list3.size()) {
            double d = 0.0;
            double d2 = new Double((String)list3.get(n));
            double d3 = new Double((String)list4.get(n));
            double d4 = 0.0;
            double d5 = 0.0;
            if (list != null) {
                d4 = new Double((String)list.get(n));
            }
            if (list2 != null) {
                d5 = new Double((String)list2.get(n));
            }
            d = d2 + d3 + d4 + d5;
            arrayList.add(new Double(d));
            ++n;
        }
        return arrayList;
    }

    public double[] solve(IRunnableContext iRunnableContext) {
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) {
                iProgressMonitor.beginTask("Solving...", MeanSquareDifference.this.time.length);
                double[] dArray = new double[MeanSquareDifference.this.time.length];
                int n = 0;
                while (n < MeanSquareDifference.this.time.length) {
                    iProgressMonitor.worked(1);
                    if (iProgressMonitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    dArray[n] = 0.0;
                    for (String string : MeanSquareDifference.this.commonInfectiousLocationsA.keySet()) {
                        List<Double> list = MeanSquareDifference.this.commonInfectiousLocationsA.get(string);
                        List<Double> list2 = MeanSquareDifference.this.commonInfectiousLocationsB.get(string);
                        List<Double> list3 = MeanSquareDifference.this.totalPopulation.get(string);
                        double d = list.get(n);
                        double d2 = list2.get(n);
                        double d3 = list3.get(n);
                        if (!(d > 0.0) && !(d2 > 0.0)) continue;
                        int n2 = n;
                        MeanSquareDifference.this.locationCount[n2] = MeanSquareDifference.this.locationCount[n2] + 1.0;
                        int n3 = n;
                        dArray[n3] = dArray[n3] + d3;
                        double d4 = (d - d2) * (d - d2);
                        double d5 = d3 * Math.sqrt(d4);
                        int n4 = n;
                        MeanSquareDifference.this.meanSqDiff[n4] = MeanSquareDifference.this.meanSqDiff[n4] + d5;
                    }
                    if (MeanSquareDifference.this.locationCount[n] >= 1.0) {
                        int n5 = n;
                        MeanSquareDifference.this.meanSqDiff[n5] = MeanSquareDifference.this.meanSqDiff[n5] / dArray[n];
                    }
                    ++n;
                }
                iProgressMonitor.done();
            }
        };
        try {
            iRunnableContext.run(true, true, iRunnableWithProgress);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
        return this.meanSqDiff;
    }
}

