/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.stem.util.analysis.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelParameters {
    private final HashMap<String, Parameter> parameters = new HashMap();
    private final HashMap<String, List<double[][]>> selectedData = new HashMap();
    private final HashMap<String, List<double[][]>> regressionData = new HashMap();
    private final HashMap<String, List<double[][]>> fittedData = new HashMap();
    public static final double REFERENCE_POPULATION_DENSITY = 100.0;
    HashMap<String, Double> numerators = new HashMap();
    HashMap<String, Double> denominators = new HashMap();

    public ModelParameters average(Map<String, ModelParameters> map) {
        Iterator<String> iterator = map.keySet().iterator();
        while (iterator != null && iterator.hasNext()) {
            Object object;
            Object object2;
            Object object3;
            String string = iterator.next();
            ModelParameters modelParameters = map.get(string);
            this.accumulateNumerator(modelParameters);
            this.accumulateDenominator(modelParameters);
            Iterator<String> iterator2 = modelParameters.selectedData.keySet().iterator();
            while (iterator2 != null && iterator2.hasNext()) {
                object3 = iterator2.next();
                object2 = modelParameters.selectedData.get(object3);
                this.selectedData.put((String)object3, (List<double[][]>)object2);
            }
            object3 = modelParameters.regressionData.keySet().iterator();
            while (object3 != null && object3.hasNext()) {
                object2 = (String)object3.next();
                object = modelParameters.regressionData.get(object2);
                this.regressionData.put((String)object2, (List<double[][]>)object);
            }
            object2 = modelParameters.fittedData.keySet().iterator();
            while (object2 != null && object2.hasNext()) {
                object = (String)object2.next();
                List<double[][]> list = modelParameters.fittedData.get(object);
                this.fittedData.put((String)object, list);
            }
        }
        this.average();
        this.calculateStdAvg();
        return this;
    }

    private void accumulateNumerator(ModelParameters modelParameters) {
        for (Parameter parameter : modelParameters.getParameters().values()) {
            if (this.numerators.containsKey(parameter.name)) {
                this.numerators.put(parameter.name, this.numerators.get(parameter.name) + parameter.value / parameter.variance);
                continue;
            }
            this.numerators.put(parameter.name, parameter.value / parameter.variance);
        }
    }

    private void accumulateDenominator(ModelParameters modelParameters) {
        for (Parameter parameter : modelParameters.getParameters().values()) {
            if (this.denominators.containsKey(parameter.name)) {
                this.denominators.put(parameter.name, this.denominators.get(parameter.name) + 1.0 / parameter.variance);
                continue;
            }
            this.denominators.put(parameter.name, 1.0 / parameter.variance);
        }
    }

    private void average() {
        for (String string : this.numerators.keySet()) {
            double d = this.numerators.get(string);
            double d2 = this.denominators.get(string);
            this.addParameter(string, new Parameter(string, d / d2));
        }
    }

    private void calculateStdAvg() {
        for (String string : this.numerators.keySet()) {
            Parameter parameter = this.getParameter(string);
            parameter.stddev = Math.sqrt(1.0 / this.denominators.get(string));
        }
    }

    public void addParameter(String string, Parameter parameter) {
        this.parameters.put(string, parameter);
    }

    public void addSelectedData(String string, List<double[][]> list) {
        this.selectedData.put(string, list);
    }

    public void addRegressionData(String string, List<double[][]> list) {
        this.regressionData.put(string, list);
    }

    public void addFittedData(String string, List<double[][]> list) {
        this.fittedData.put(string, list);
    }

    public double[] getDataValues(String string, int n, int n2) {
        List<double[][]> list = this.selectedData.get(string);
        double[][] dArray = list.get(n);
        return dArray[n2];
    }

    public double[] getRegressionValues(String string, int n, int n2) {
        List<double[][]> list = this.regressionData.get(string);
        double[][] dArray = list.get(n);
        return dArray[n2];
    }

    public double[] getFittedValues(String string, int n, int n2) {
        List<double[][]> list = this.fittedData.get(string);
        double[][] dArray = list.get(n);
        return dArray[n2];
    }

    public boolean validDataID(String string) {
        boolean bl = false;
        if (string != null && this.selectedData.containsKey(string)) {
            bl = true;
        }
        return bl;
    }

    public String[] getDataLocations() {
        Set<String> set = this.selectedData.keySet();
        Object[] objectArray = new String[set.size()];
        Iterator<String> iterator = set.iterator();
        int n = 0;
        while (iterator != null && iterator.hasNext()) {
            objectArray[n] = iterator.next();
            ++n;
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    public Map<String, Parameter> getParameters() {
        return this.parameters;
    }

    public Parameter getParameter(String string) {
        return this.parameters.get(string);
    }

    public boolean containsParameter(String string) {
        return this.parameters.containsKey(string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Parameter parameter : this.parameters.values()) {
            stringBuffer.append(parameter.name).append("=").append(parameter.value).append("\n");
            stringBuffer.append("deviation(").append(parameter.name).append(")").append("=").append(parameter.stddev).append("\n");
            stringBuffer.append("variance(").append(parameter.name).append(")").append("=").append(parameter.variance).append("\n");
        }
        return stringBuffer.toString();
    }
}

