/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.stem.util.analysis.Activator;

public class MonitorPreferences {
    Plugin plugin = Activator.getDefault();
    Preferences prefs = this.plugin.getPluginPreferences();
    private static final String DEFAULT_PREFERENCE = "PREVIOUS_FOLDER";
    private static final String ESTIMATOR_PREFERENCE = "ESTIMATOR_METHOD";
    private static final String DEFAULT_PREF_VALUE = "";
    String recentFolder = null;
    String recentEstimationMethod = null;

    public MonitorPreferences() {
        if (this.prefs.contains(DEFAULT_PREFERENCE)) {
            this.recentFolder = this.prefs.getString(DEFAULT_PREFERENCE);
        } else {
            this.recentFolder = DEFAULT_PREF_VALUE;
            this.setPreferences();
        }
        if (this.prefs.contains(ESTIMATOR_PREFERENCE)) {
            this.recentEstimationMethod = this.prefs.getString(ESTIMATOR_PREFERENCE);
        } else {
            this.recentEstimationMethod = null;
            this.setPreferences();
        }
    }

    public void setPreferences() {
        this.prefs.setValue(DEFAULT_PREFERENCE, this.recentFolder);
        if (this.recentEstimationMethod != null) {
            this.prefs.setValue(ESTIMATOR_PREFERENCE, this.recentEstimationMethod);
        }
        this.plugin.savePluginPreferences();
    }

    public void setRecentFolder(String string, String string2) {
        this.recentFolder = string2;
        this.prefs.setValue(String.valueOf(string) + "_" + DEFAULT_PREFERENCE, this.recentFolder);
        this.plugin.savePluginPreferences();
    }

    public void setEstimatorMethod(String string) {
        this.recentEstimationMethod = string;
        this.prefs.setValue(ESTIMATOR_PREFERENCE, this.recentEstimationMethod);
        this.plugin.savePluginPreferences();
    }

    public String getRecentFolder(String string) {
        this.recentFolder = this.prefs.getString(String.valueOf(string) + "_" + DEFAULT_PREFERENCE);
        if (this.recentFolder == null || this.recentFolder.length() == 0) {
            this.recentFolder = DEFAULT_PREF_VALUE;
            this.setRecentFolder(string, this.recentFolder);
        }
        return this.recentFolder;
    }

    public String getRecentEstimatorMethod() {
        return this.recentEstimationMethod;
    }
}

