/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.stem.analysis.States;
import org.eclipse.stem.analysis.impl.ReferenceScenarioDataMapImpl;
import org.eclipse.stem.util.analysis.ModelParameters;
import org.eclipse.stem.util.analysis.Parameter;
import org.eclipse.stem.util.analysis.SEIRparameterEstimator;

public class NonLinearSEIRParameterEstimator
extends SEIRparameterEstimator {
    double[] e;
    double[] r;

    public NonLinearSEIRParameterEstimator(ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance referenceScenarioDataInstance) {
        super(referenceScenarioDataInstance);
        ArrayList<Double> arrayList = new ArrayList<Double>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        ArrayList<Double> arrayList3 = new ArrayList<Double>();
        ArrayList<Double> arrayList4 = new ArrayList<Double>();
        List list = (List)referenceScenarioDataInstance.getData().get(States.statesToFit[2]);
        List list2 = (List)referenceScenarioDataInstance.getData().get(States.statesToFit[0]);
        List list3 = (List)referenceScenarioDataInstance.getData().get(States.statesToFit[3]);
        List list4 = (List)referenceScenarioDataInstance.getData().get(States.statesToFit[1]);
        int n = 1;
        while (n < list.size()) {
            arrayList3.add((Double)list.get(n));
            arrayList2.add((Double)list4.get(n));
            arrayList.add((Double)list2.get(n));
            arrayList4.add((Double)list3.get(n));
            ++n;
        }
        this.numDataPoints = arrayList3.size();
        if (this.numDataPoints < 7) {
            return;
        }
        this.dataValid = true;
        this.s = new double[this.numDataPoints];
        this.e = new double[this.numDataPoints];
        this.i = new double[this.numDataPoints];
        this.r = new double[this.numDataPoints];
        this.t = new double[this.numDataPoints];
        n = this.numDataPoints;
        double[][] dArray = new double[2][n - 1];
        double[][] dArray2 = new double[2][n - 1];
        double[][] dArray3 = new double[2][n - 1];
        double[][] dArray4 = new double[2][n - 1];
        int n2 = 0;
        while (n2 < this.numDataPoints) {
            this.s[n2] = (Double)arrayList.get(n2);
            this.e[n2] = (Double)arrayList2.get(n2);
            this.i[n2] = (Double)arrayList3.get(n2);
            this.r[n2] = (Double)arrayList4.get(n2);
            this.t[n2] = n2;
            if (n2 < this.numDataPoints - 1) {
                dArray[0][n2] = (this.s[n2] + this.s[n2 + 1]) / 2.0;
                dArray2[0][n2] = (this.e[n2] + this.e[n2 + 1]) / 2.0;
                dArray3[0][n2] = (this.i[n2] + this.i[n2 + 1]) / 2.0;
                dArray4[0][n2] = (this.r[n2] + this.r[n2 + 1]) / 2.0;
                dArray[1][n2] = (this.s[n2] + this.s[n2 + 1]) / 2.0;
                dArray2[1][n2] = (this.e[n2] + this.e[n2 + 1]) / 2.0;
                dArray3[1][n2] = (this.i[n2] + this.i[n2 + 1]) / 2.0;
                dArray4[1][n2] = (this.r[n2] + this.r[n2 + 1]) / 2.0;
                int n3 = 0;
                while (n3 < 4) {
                    dArray[1][n2] = 0.0;
                    dArray2[1][n2] = 0.0;
                    dArray3[1][n2] = 0.0;
                    dArray4[1][n2] = 0.0;
                    ++n3;
                }
            }
            ++n2;
        }
    }

    public ModelParameters estimate(double d, double d2, String string) {
        ModelParameters modelParameters = null;
        int n = this.s.length;
        assert (n == this.e.length);
        assert (n == this.i.length);
        assert (n == this.r.length);
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray2[n2] = Math.log(this.e[n2]);
            ++n2;
        }
        dArray[0] = this.s[1] - this.s[0];
        dArray[n - 1] = this.s[n - 1] - this.s[n - 2];
        dArray3[0] = dArray2[1] - dArray2[0];
        dArray3[n - 1] = dArray2[n - 1] - dArray2[n - 2];
        n2 = 1;
        while (n2 < n - 1) {
            dArray[n2] = (this.s[n2 + 1] - this.s[n2 - 1]) / 2.0;
            dArray3[n2] = (dArray2[n2 + 1] - dArray2[n2 - 1]) / 2.0;
            ++n2;
        }
        double[] dArray4 = new double[n];
        double[] dArray5 = new double[n];
        int n3 = 0;
        while (n3 < n) {
            dArray4[n3] = this.r[n3] / this.e[n3];
            dArray5[n3] = 1.0 / this.e[n3] * dArray[n3] + dArray3[n3];
            ++n3;
        }
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        int n4 = 0;
        while (n4 < n) {
            d3 += dArray4[n4];
            d4 += dArray5[n4];
            d5 += dArray4[n4] * dArray5[n4];
            d6 += dArray4[n4] * dArray4[n4];
            d7 += dArray5[n4] * dArray5[n4];
            d8 += 1.0;
            ++n4;
        }
        double d9 = -(d8 * d6 - d3 * d3);
        double d10 = -(d8 * d5 - d3 * d4) / d9;
        double d11 = (d6 * d4 - d3 * d5) / d9;
        double d12 = (d7 + d8 * d11 * d11 + d10 * d10 * d6 - 2.0 * (d10 * d5 - d11 * d4 + d11 * d10 * d3)) / (double)(n - 2);
        double d13 = -(d12 / d9) * d8;
        double d14 = -(d12 / d9) * d6;
        double d15 = Math.sqrt(d13);
        double d16 = Math.sqrt(d14);
        int n5 = 0;
        while (n5 < n) {
            dArray4[n5] = Math.log((this.s[n5] + this.e[n5] + this.i[n5] - 0.3) / 0.7);
            dArray5[n5] = Math.log((d10 * this.r[n5] - dArray[n5]) / (this.s[n5] * this.i[n5]));
            ++n5;
        }
        d3 = 0.0;
        d4 = 0.0;
        d5 = 0.0;
        d6 = 0.0;
        d7 = 0.0;
        d8 = 0.0;
        n5 = 0;
        while (n5 < n) {
            d3 += dArray4[n5];
            d4 += dArray5[n5];
            d5 += dArray4[n5] * dArray5[n5];
            d6 += dArray4[n5] * dArray4[n5];
            d7 += dArray5[n5] * dArray5[n5];
            d8 += 1.0;
            ++n5;
        }
        d9 = d8 * d6 - d3 * d3;
        double d17 = (d4 * d6 - d3 * d5) / d9;
        double d18 = (d8 * d5 - d3 * d4) / d9;
        double d19 = Math.exp(d17);
        d12 = (d7 + d17 * d17 * d8 + d18 * d18 * d6 - 2.0 * (d17 * d4 + d18 * d5 + d17 * d18 * d3)) / (double)(n - 2);
        double d20 = d12 / d9 * d6;
        double d21 = d12 / d9 * d8;
        double d22 = Math.sqrt(d20);
        double d23 = Math.sqrt(d21);
        modelParameters = new ModelParameters();
        double d24 = d19;
        if (!useFreqDependantBeta) {
            d24 *= 100.0 / d;
        }
        modelParameters.addParameter(Parameter.BETA, new Parameter(Parameter.BETA, d24));
        modelParameters.addParameter(Parameter.LNBETA, new Parameter(Parameter.LNBETA, d17, d22, d20));
        modelParameters.addParameter(Parameter.ALPHA, new Parameter(Parameter.ALPHA, d10, d15, d13));
        modelParameters.addParameter(Parameter.EPSILON, new Parameter(Parameter.EPSILON, d11, d16, d14));
        modelParameters.addParameter(Parameter.LAMBDA, new Parameter(Parameter.LAMBDA, d18, d23, d21));
        return modelParameters;
    }
}

