/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.stem.analysis.impl.ReferenceScenarioDataMapImpl;
import org.eclipse.stem.util.analysis.ModelParameters;
import org.eclipse.stem.util.analysis.PhaseSpaceCoordinate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ParameterEstimator {
    protected static final String keyS = "S";
    protected static final String keyE = "E";
    protected static final String keyI = "I";
    protected static final String keyR = "R";
    protected static final String keySelectedS = "S*";
    protected static final String keySelectedE = "E*";
    protected static final String keySelectedI = "I*";
    protected static final String keySelectedR = "R*";
    protected static final String keyXY1 = "X1vsY1";
    protected static final String keyXY2 = "X2vsY2";
    protected static final String keyXY3 = "X3vsY3";
    protected static final String keyXY4 = "X4vsY4";
    protected static final String keyFit1 = "Fit XY1";
    protected static final String keyFit2 = "Fit XY2";
    protected static final String keyFit3 = "Fit XY3";
    protected static final String keyFit4 = "Fit XY4";
    protected static double minSthreshold = 0.01;
    protected static double minEthreshold = 0.01;
    protected static double minIthreshold = 0.01;
    protected static double minRthreshold = 0.01;
    protected static double maxSthreshold = 0.99;
    protected static double maxEthreshold = 0.99;
    protected static double maxIthreshold = 0.99;
    protected static double maxRthreshold = 0.99;
    protected static boolean useFreqDependantBeta = true;
    protected double rejectCount = 0.0;
    List<double[][]> dataToPlot = new ArrayList<double[][]>();
    List<double[][]> regressionValues = new ArrayList<double[][]>();
    List<double[][]> fittedValues = new ArrayList<double[][]>();
    protected ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance data;
    protected static final int MINSIZE = 7;
    public static final int LINEAR_DERIVATIVE = 1;
    public static final int POLYNOMIAL_DERIVATIVE = 2;
    double[] p;
    double[] s;
    double[] i;
    double[] t;
    public boolean dataValid = false;
    int numDataPoints;

    public ParameterEstimator(ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance referenceScenarioDataInstance) {
        this.data = referenceScenarioDataInstance;
        this.data.findMaxValues();
    }

    public abstract int getNumProperties();

    public String getProperty(int n, int n2) {
        switch (n) {
            case 0: {
                if (n2 == 0) {
                    return keyS;
                }
                if (n2 == 1) {
                    return keySelectedS;
                }
                if (n2 == 2 || n2 == 3) {
                    return keyXY1;
                }
                return keyFit1;
            }
            case 1: {
                if (n2 == 0) {
                    return keyI;
                }
                if (n2 == 1) {
                    return keySelectedI;
                }
                if (n2 == 2 || n2 == 3) {
                    return keyXY2;
                }
                return keyFit2;
            }
            case 2: {
                if (n2 == 0) {
                    return keyR;
                }
                if (n2 == 1) {
                    return keySelectedR;
                }
                if (n2 == 2 || n2 == 3) {
                    return keyXY3;
                }
                return keyFit3;
            }
            case 3: {
                if (n2 == 0) {
                    return keyE;
                }
                if (n2 == 1) {
                    return keySelectedE;
                }
                if (n2 == 2 || n2 == 3) {
                    return keyXY4;
                }
                return keyFit4;
            }
        }
        return null;
    }

    public void setAllParameters(Map<String, Object> map) {
        if (map != null) {
            maxSthreshold = (Double)map.get("MAXS");
            minSthreshold = (Double)map.get("MINS");
            maxEthreshold = (Double)map.get("MAXE");
            minEthreshold = (Double)map.get("MINE");
            maxIthreshold = (Double)map.get("MAXI");
            minIthreshold = (Double)map.get("MINI");
            maxRthreshold = (Double)map.get("MAXR");
            minRthreshold = (Double)map.get("MINR");
            useFreqDependantBeta = (Boolean)map.get("FREQ_MODE");
        }
    }

    public abstract ModelParameters estimate(double var1, double var3, String var5);

    public double[] getValues(int n, int n2) {
        if (n2 <= 1) {
            double[][] dArray = this.dataToPlot.get(n);
            return dArray[n2];
        }
        double[][] dArray = this.regressionValues.get(n);
        return dArray[n2 - 2];
    }

    public double[][] getSortedRegression(List<Double> list, List<Double> list2) {
        double[][] dArray = new double[2][list.size()];
        if (list2.size() != list.size()) {
            return dArray;
        }
        ArrayList<PhaseSpaceCoordinate> arrayList = new ArrayList<PhaseSpaceCoordinate>();
        int n = 0;
        while (n < list.size()) {
            double d = list.get(n);
            double d2 = list2.get(n);
            PhaseSpaceCoordinate phaseSpaceCoordinate = new PhaseSpaceCoordinate(d, d2);
            arrayList.add(phaseSpaceCoordinate);
            ++n;
        }
        Object[] objectArray = arrayList.toArray();
        Arrays.sort(objectArray);
        int n2 = 0;
        while (n2 < list.size()) {
            PhaseSpaceCoordinate phaseSpaceCoordinate = (PhaseSpaceCoordinate)objectArray[n2];
            dArray[0][n2] = phaseSpaceCoordinate.xValue;
            dArray[1][n2] = phaseSpaceCoordinate.yValue;
            ++n2;
        }
        return dArray;
    }
}

