/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis;

import org.eclipse.stem.analysis.impl.ReferenceScenarioDataMapImpl;
import org.eclipse.stem.util.analysis.Activator;
import org.eclipse.stem.util.analysis.NonLinearSEIRParameterEstimator;
import org.eclipse.stem.util.analysis.ParameterEstimator;
import org.eclipse.stem.util.analysis.ParameterEstimatorMethod;
import org.eclipse.stem.util.analysis.SEIRparameterEstimator;
import org.eclipse.stem.util.analysis.SIRparameterEstimator;
import org.eclipse.stem.util.analysis.SIparameterEstimator;

public class ParameterEstimatorFactory {
    public static ParameterEstimator createEstimator(ParameterEstimatorMethod parameterEstimatorMethod, ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance referenceScenarioDataInstance) {
        ParameterEstimator parameterEstimator = null;
        switch (parameterEstimatorMethod) {
            case SEIR: {
                parameterEstimator = new SEIRparameterEstimator(referenceScenarioDataInstance);
                break;
            }
            case SIR: {
                parameterEstimator = new SIRparameterEstimator(referenceScenarioDataInstance);
                break;
            }
            case SI: {
                parameterEstimator = new SIparameterEstimator(referenceScenarioDataInstance);
                break;
            }
            case NONLINEARSEIR: {
                parameterEstimator = new NonLinearSEIRParameterEstimator(referenceScenarioDataInstance);
                break;
            }
            default: {
                Activator.logError("Unknown method: " + (Object)((Object)parameterEstimatorMethod), null);
            }
        }
        return parameterEstimator;
    }
}

