/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.stem.analysis.States;
import org.eclipse.stem.analysis.impl.ReferenceScenarioDataMapImpl;
import org.eclipse.stem.util.analysis.LinearLeastSquaresFit;
import org.eclipse.stem.util.analysis.ModelParameters;
import org.eclipse.stem.util.analysis.Parameter;
import org.eclipse.stem.util.analysis.ParameterEstimator;

public class SEIRparameterEstimator
extends ParameterEstimator {
    double[] e;
    double[] r;

    public SEIRparameterEstimator(ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance referenceScenarioDataInstance) {
        super(referenceScenarioDataInstance);
        ArrayList<Double> arrayList = new ArrayList<Double>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        ArrayList<Double> arrayList3 = new ArrayList<Double>();
        ArrayList<Double> arrayList4 = new ArrayList<Double>();
        List list = (List)referenceScenarioDataInstance.getData().get(States.statesToFit[2]);
        List list2 = (List)referenceScenarioDataInstance.getData().get(States.statesToFit[0]);
        List list3 = (List)referenceScenarioDataInstance.getData().get(States.statesToFit[3]);
        List list4 = (List)referenceScenarioDataInstance.getData().get(States.statesToFit[1]);
        int n = 1;
        while (n < list.size()) {
            arrayList3.add((Double)list.get(n));
            arrayList2.add((Double)list4.get(n));
            arrayList.add((Double)list2.get(n));
            arrayList4.add((Double)list3.get(n));
            ++n;
        }
        this.numDataPoints = arrayList3.size();
        if (this.numDataPoints < 7) {
            return;
        }
        this.dataValid = true;
        this.p = new double[this.numDataPoints];
        this.s = new double[this.numDataPoints];
        this.e = new double[this.numDataPoints];
        this.i = new double[this.numDataPoints];
        this.r = new double[this.numDataPoints];
        this.t = new double[this.numDataPoints];
        n = 0;
        while (n < this.numDataPoints) {
            this.s[n] = (Double)arrayList.get(n);
            this.e[n] = (Double)arrayList2.get(n);
            this.i[n] = (Double)arrayList3.get(n);
            this.r[n] = (Double)arrayList4.get(n);
            this.p[n] = this.s[n] + this.e[n] + this.i[n] + this.r[n];
            this.t[n] = n;
            ++n;
        }
    }

    public ModelParameters estimate(double d, double d2, String string) {
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        ModelParameters modelParameters = new ModelParameters();
        int n = this.s.length;
        assert (n == this.e.length);
        assert (n == this.i.length);
        assert (n == this.r.length);
        double[] dArray = new double[n];
        double[] dArray2 = new double[n - 1];
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n - 1];
        double[] dArray5 = new double[n];
        double[] dArray6 = new double[n - 1];
        double[] dArray7 = new double[n];
        double[] dArray8 = new double[n - 1];
        double[] dArray9 = new double[n - 1];
        double[] dArray10 = new double[n - 1];
        double[] dArray11 = new double[n - 1];
        double[] dArray12 = new double[n - 1];
        double[] dArray13 = new double[n - 1];
        double[][] dArray14 = new double[2][n - 1];
        double[][] dArray15 = new double[2][n - 1];
        double[][] dArray16 = new double[2][n - 1];
        double[][] dArray17 = new double[2][n - 1];
        double d11 = 5.0E-10;
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = this.s[n2] >= d11 ? Math.log(this.s[n2]) : Math.log(d11);
            dArray3[n2] = this.e[n2] >= d11 ? Math.log(this.e[n2]) : Math.log(d11);
            dArray5[n2] = this.i[n2] >= d11 ? Math.log(this.i[n2]) : Math.log(d11);
            dArray7[n2] = this.r[n2] >= d11 ? Math.log(this.r[n2]) : Math.log(d11);
            ++n2;
        }
        double d12 = 0.0;
        double d13 = 0.0;
        double d14 = 0.0;
        double d15 = 0.0;
        int n3 = 1;
        while (n3 < n - 1) {
            dArray2[n3 - 1] = dArray[n3] - dArray[n3 - 1];
            dArray4[n3 - 1] = dArray3[n3] - dArray3[n3 - 1];
            dArray6[n3 - 1] = dArray5[n3] - dArray5[n3 - 1];
            dArray8[n3 - 1] = dArray7[n3] - dArray7[n3 - 1];
            dArray9[n3 - 1] = (this.s[n3] + this.s[n3 - 1]) / 2.0;
            dArray10[n3 - 1] = (this.e[n3] + this.e[n3 - 1]) / 2.0;
            dArray11[n3 - 1] = (this.i[n3] + this.i[n3 - 1]) / 2.0;
            dArray12[n3 - 1] = (this.r[n3] + this.r[n3 - 1]) / 2.0;
            if (dArray9[n3 - 1] >= d12) {
                d12 = dArray9[n3 - 1];
            }
            if (dArray10[n3 - 1] >= d13) {
                d13 = dArray10[n3 - 1];
            }
            if (dArray11[n3 - 1] >= d14) {
                d14 = dArray11[n3 - 1];
            }
            if (dArray12[n3 - 1] >= d15) {
                d15 = dArray12[n3 - 1];
            }
            dArray13[n3 - 1] = (this.p[n3] + this.p[n3 - 1]) / 2.0;
            ++n3;
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        ArrayList<Double> arrayList3 = new ArrayList<Double>();
        int n4 = 0;
        while (n4 < n - 1) {
            d10 = dArray9[n4] / d12;
            d9 = dArray11[n4] / d14;
            d8 = dArray12[n4] / d15;
            d7 = dArray10[n4] / d13;
            dArray14[0][n4] = d10;
            dArray16[0][n4] = d9;
            dArray17[0][n4] = d8;
            dArray15[0][n4] = d7;
            dArray14[1][n4] = d10;
            dArray16[1][n4] = d9;
            dArray17[1][n4] = d8;
            dArray15[1][n4] = d7;
            if (d10 <= maxSthreshold && d10 >= minSthreshold && d9 >= minIthreshold && d8 <= maxRthreshold) {
                d6 = dArray13[n4] * dArray12[n4] / dArray9[n4];
                d5 = d6 / dArray11[n4];
                d4 = dArray13[n4] * dArray2[n4] / dArray11[n4];
                arrayList.add(new Double(d5));
                arrayList2.add(new Double(d4));
            } else {
                dArray14[1][n4] = 0.0;
                dArray16[1][n4] = 0.0;
                dArray17[1][n4] = 0.0;
            }
            ++n4;
        }
        LinearLeastSquaresFit linearLeastSquaresFit = null;
        if (arrayList.size() > 2) {
            linearLeastSquaresFit = new LinearLeastSquaresFit(arrayList, arrayList2);
            d10 = -1.0 * linearLeastSquaresFit.getIntercept();
            d9 = linearLeastSquaresFit.getInterceptVariance();
            d8 = linearLeastSquaresFit.getInterceptStdDev();
            d7 = linearLeastSquaresFit.getSlope();
            d6 = linearLeastSquaresFit.getSlopeVariance();
            d5 = linearLeastSquaresFit.getSlopeStdDev();
            d4 = d10;
            if (!useFreqDependantBeta) {
                d4 *= 100.0 / d;
            }
            modelParameters.addParameter(Parameter.BETA, new Parameter(Parameter.BETA, d4, d8, d9));
            modelParameters.addParameter(Parameter.ALPHA, new Parameter(Parameter.ALPHA, d7, d5, d6));
            int n5 = 0;
            while (n5 < arrayList.size()) {
                double d16 = linearLeastSquaresFit.getSlope() * (Double)arrayList.get(n5) + linearLeastSquaresFit.getIntercept();
                arrayList3.add(new Double(d16));
                ++n5;
            }
        } else {
            this.rejectCount += 1.0;
        }
        ArrayList<Double> arrayList4 = new ArrayList<Double>();
        ArrayList<Double> arrayList5 = new ArrayList<Double>();
        ArrayList<Double> arrayList6 = new ArrayList<Double>();
        int n6 = 0;
        while (n6 < n - 1) {
            d8 = dArray9[n6] / d12;
            d7 = dArray10[n6] / d13;
            if (d8 <= maxSthreshold && d8 >= minSthreshold && d7 >= minEthreshold) {
                d6 = dArray9[n6] * dArray11[n6] / (dArray13[n6] * dArray10[n6]);
                d5 = dArray4[n6];
                arrayList4.add(new Double(d6));
                arrayList5.add(new Double(d5));
            } else {
                dArray15[1][n6] = 0.0;
            }
            ++n6;
        }
        LinearLeastSquaresFit linearLeastSquaresFit2 = null;
        if (arrayList4.size() > 2) {
            linearLeastSquaresFit2 = new LinearLeastSquaresFit(arrayList4, arrayList5);
            d8 = -1.0 * linearLeastSquaresFit2.getIntercept();
            d7 = linearLeastSquaresFit2.getInterceptVariance();
            d6 = linearLeastSquaresFit2.getInterceptStdDev();
            d5 = linearLeastSquaresFit2.getSlope();
            d4 = linearLeastSquaresFit2.getSlopeVariance();
            double d17 = linearLeastSquaresFit2.getSlopeStdDev();
            d3 = d5;
            if (!useFreqDependantBeta) {
                d3 *= 100.0 / d;
            }
            modelParameters.addParameter(Parameter.BETA2, new Parameter(Parameter.BETA2, d3, d17, d4));
            modelParameters.addParameter(Parameter.EPSILON, new Parameter(Parameter.EPSILON, d8, d6, d7));
            int n7 = 0;
            while (n7 < arrayList4.size()) {
                double d18 = linearLeastSquaresFit2.getSlope() * (Double)arrayList4.get(n7) + linearLeastSquaresFit2.getIntercept();
                arrayList6.add(new Double(d18));
                ++n7;
            }
        } else {
            this.rejectCount += 1.0;
        }
        ArrayList<Double> arrayList7 = new ArrayList<Double>();
        ArrayList<Double> arrayList8 = new ArrayList<Double>();
        ArrayList<Double> arrayList9 = new ArrayList<Double>();
        int n8 = 0;
        while (n8 < n - 1) {
            d6 = dArray11[n8] / d14;
            d5 = dArray10[n8] / d13;
            if (d6 >= minIthreshold && d5 >= minEthreshold) {
                arrayList7.add(new Double(dArray10[n8] / dArray11[n8]));
                arrayList8.add(new Double(dArray6[n8]));
            }
            ++n8;
        }
        LinearLeastSquaresFit linearLeastSquaresFit3 = null;
        if (arrayList7.size() > 2) {
            linearLeastSquaresFit3 = new LinearLeastSquaresFit(arrayList7, arrayList8);
            d6 = -1.0 * linearLeastSquaresFit3.getIntercept();
            d5 = linearLeastSquaresFit3.getInterceptVariance();
            d4 = linearLeastSquaresFit3.getInterceptStdDev();
            double d19 = linearLeastSquaresFit3.getSlope();
            d3 = linearLeastSquaresFit3.getSlopeVariance();
            double d20 = linearLeastSquaresFit3.getSlopeStdDev();
            modelParameters.addParameter(Parameter.GAMMA, new Parameter(Parameter.GAMMA, d6, d4, d5));
            modelParameters.addParameter(Parameter.EPSILON2, new Parameter(Parameter.EPSILON2, d19, d20, d3));
            int n9 = 0;
            while (n9 < arrayList7.size()) {
                double d21 = linearLeastSquaresFit3.getSlope() * (Double)arrayList7.get(n9) + linearLeastSquaresFit3.getIntercept();
                arrayList9.add(new Double(d21));
                ++n9;
            }
        } else {
            this.rejectCount += 1.0;
        }
        ArrayList<Double> arrayList10 = new ArrayList<Double>();
        ArrayList<Double> arrayList11 = new ArrayList<Double>();
        ArrayList<Double> arrayList12 = new ArrayList<Double>();
        int n10 = 0;
        while (n10 < n - 1) {
            d4 = dArray11[n10] / d14;
            double d22 = dArray12[n10] / d15;
            if (d4 >= minIthreshold && d22 >= minRthreshold && d22 <= maxRthreshold) {
                arrayList10.add(new Double(dArray11[n10] / dArray12[n10]));
                arrayList11.add(new Double(dArray8[n10]));
            }
            ++n10;
        }
        LinearLeastSquaresFit linearLeastSquaresFit4 = null;
        if (arrayList10.size() > 2) {
            linearLeastSquaresFit4 = new LinearLeastSquaresFit(arrayList10, arrayList11);
            d4 = Math.abs(-1.0 * linearLeastSquaresFit4.getIntercept());
            double d23 = linearLeastSquaresFit4.getInterceptVariance();
            d3 = linearLeastSquaresFit4.getInterceptStdDev();
            double d24 = linearLeastSquaresFit4.getSlope();
            double d25 = linearLeastSquaresFit4.getSlopeVariance();
            double d26 = linearLeastSquaresFit4.getSlopeStdDev();
            modelParameters.addParameter(Parameter.ALPHA2, new Parameter(Parameter.ALPHA2, d4, d3, d23));
            modelParameters.addParameter(Parameter.GAMMA2, new Parameter(Parameter.GAMMA2, d24, d26, d25));
            int n11 = 0;
            while (n11 < arrayList10.size()) {
                double d27 = linearLeastSquaresFit4.getSlope() * (Double)arrayList10.get(n11) + linearLeastSquaresFit4.getIntercept();
                arrayList12.add(new Double(d27));
                ++n11;
            }
        } else {
            this.rejectCount += 1.0;
        }
        modelParameters.addParameter(Parameter.REJECT, new Parameter(Parameter.REJECT, this.rejectCount));
        this.dataToPlot.add(dArray14);
        this.dataToPlot.add(dArray16);
        this.dataToPlot.add(dArray17);
        this.dataToPlot.add(dArray15);
        modelParameters.addSelectedData(string, this.dataToPlot);
        double[][] dArray18 = this.getSortedRegression(arrayList, arrayList2);
        double[][] dArray19 = this.getSortedRegression(arrayList4, arrayList5);
        double[][] dArray20 = this.getSortedRegression(arrayList7, arrayList8);
        double[][] dArray21 = this.getSortedRegression(arrayList10, arrayList11);
        double[][] dArray22 = this.getSortedRegression(arrayList, arrayList3);
        double[][] dArray23 = this.getSortedRegression(arrayList4, arrayList6);
        double[][] dArray24 = this.getSortedRegression(arrayList7, arrayList9);
        double[][] dArray25 = this.getSortedRegression(arrayList10, arrayList12);
        this.regressionValues.add(dArray18);
        this.regressionValues.add(dArray19);
        this.regressionValues.add(dArray20);
        this.regressionValues.add(dArray21);
        this.fittedValues.add(dArray22);
        this.fittedValues.add(dArray23);
        this.fittedValues.add(dArray24);
        this.fittedValues.add(dArray25);
        modelParameters.addRegressionData(string, this.regressionValues);
        modelParameters.addFittedData(string, this.fittedValues);
        return modelParameters;
    }

    public int getNumProperties() {
        return 4;
    }
}

