/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.stem.analysis.States;
import org.eclipse.stem.analysis.impl.ReferenceScenarioDataMapImpl;
import org.eclipse.stem.util.analysis.LinearLeastSquaresFit;
import org.eclipse.stem.util.analysis.ModelParameters;
import org.eclipse.stem.util.analysis.Parameter;
import org.eclipse.stem.util.analysis.ParameterEstimator;

public class SIRparameterEstimator
extends ParameterEstimator {
    double[] r;
    static final double MINCUTOFF = 0.005;

    public SIRparameterEstimator(ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance referenceScenarioDataInstance) {
        super(referenceScenarioDataInstance);
        ArrayList<Double> arrayList = new ArrayList<Double>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        ArrayList<Double> arrayList3 = new ArrayList<Double>();
        List list = (List)referenceScenarioDataInstance.getData().get(States.statesToFit[2]);
        List list2 = (List)referenceScenarioDataInstance.getData().get(States.statesToFit[0]);
        List list3 = (List)referenceScenarioDataInstance.getData().get(States.statesToFit[3]);
        int n = 1;
        while (n < list.size()) {
            arrayList2.add((Double)list.get(n));
            arrayList.add((Double)list2.get(n));
            arrayList3.add((Double)list3.get(n));
            ++n;
        }
        this.numDataPoints = arrayList2.size();
        if (this.numDataPoints < 7) {
            return;
        }
        this.dataValid = true;
        this.p = new double[this.numDataPoints];
        this.s = new double[this.numDataPoints];
        this.i = new double[this.numDataPoints];
        this.r = new double[this.numDataPoints];
        this.t = new double[this.numDataPoints];
        n = 0;
        while (n < this.numDataPoints) {
            this.s[n] = (Double)arrayList.get(n);
            this.i[n] = (Double)arrayList2.get(n);
            this.r[n] = (Double)arrayList3.get(n);
            this.p[n] = this.s[n] + this.i[n] + this.r[n];
            this.t[n] = n;
            ++n;
        }
    }

    public ModelParameters estimate(double d, double d2, String string) {
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        ModelParameters modelParameters = new ModelParameters();
        int n = this.s.length;
        assert (n == this.i.length);
        assert (n == this.r.length);
        double[] dArray = new double[n];
        double[] dArray2 = new double[n - 1];
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n - 1];
        double[] dArray5 = new double[n];
        double[] dArray6 = new double[n - 1];
        double[] dArray7 = new double[n - 1];
        double[] dArray8 = new double[n - 1];
        double[] dArray9 = new double[n - 1];
        double[] dArray10 = new double[n - 1];
        double[][] dArray11 = new double[2][n - 1];
        double[][] dArray12 = new double[2][n - 1];
        double[][] dArray13 = new double[2][n - 1];
        double d11 = 5.0E-10;
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = this.s[n2] >= d11 ? Math.log(this.s[n2]) : Math.log(d11);
            dArray3[n2] = this.i[n2] >= d11 ? Math.log(this.i[n2]) : Math.log(d11);
            dArray5[n2] = this.r[n2] >= d11 ? Math.log(this.r[n2]) : Math.log(d11);
            ++n2;
        }
        double d12 = 0.0;
        double d13 = 0.0;
        double d14 = 0.0;
        int n3 = 1;
        while (n3 < n - 1) {
            dArray2[n3 - 1] = dArray[n3] - dArray[n3 - 1];
            dArray4[n3 - 1] = dArray3[n3] - dArray3[n3 - 1];
            dArray6[n3 - 1] = dArray5[n3] - dArray5[n3 - 1];
            dArray7[n3 - 1] = (this.s[n3] + this.s[n3 - 1]) / 2.0;
            dArray8[n3 - 1] = (this.i[n3] + this.i[n3 - 1]) / 2.0;
            dArray9[n3 - 1] = (this.r[n3] + this.r[n3 - 1]) / 2.0;
            if (dArray7[n3 - 1] >= d12) {
                d12 = dArray7[n3 - 1];
            }
            if (dArray8[n3 - 1] >= d13) {
                d13 = dArray8[n3 - 1];
            }
            if (dArray9[n3 - 1] >= d14) {
                d14 = dArray9[n3 - 1];
            }
            dArray10[n3 - 1] = (this.p[n3] + this.p[n3 - 1]) / 2.0;
            ++n3;
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        ArrayList<Double> arrayList3 = new ArrayList<Double>();
        int n4 = 0;
        while (n4 < n - 1) {
            d10 = dArray7[n4] / d12;
            d9 = dArray8[n4] / d13;
            d8 = dArray9[n4] / d14;
            dArray11[0][n4] = d10;
            dArray12[0][n4] = d9;
            dArray13[0][n4] = d8;
            dArray11[1][n4] = d10;
            dArray12[1][n4] = d9;
            dArray13[1][n4] = d8;
            if (d10 <= maxSthreshold && d10 >= minSthreshold && d9 >= minIthreshold && d8 <= maxRthreshold) {
                d7 = dArray10[n4] * dArray9[n4] / dArray7[n4];
                arrayList.add(new Double(d7 / dArray8[n4]));
                arrayList2.add(new Double(dArray2[n4] * (dArray10[n4] / dArray8[n4])));
            } else {
                dArray11[1][n4] = 0.0;
                dArray12[1][n4] = 0.0;
                dArray13[1][n4] = 0.0;
            }
            ++n4;
        }
        LinearLeastSquaresFit linearLeastSquaresFit = null;
        if (arrayList.size() > 2) {
            linearLeastSquaresFit = new LinearLeastSquaresFit(arrayList, arrayList2);
            d10 = -1.0 * linearLeastSquaresFit.getIntercept();
            d9 = linearLeastSquaresFit.getInterceptVariance();
            d8 = linearLeastSquaresFit.getInterceptStdDev();
            d7 = linearLeastSquaresFit.getSlope();
            d6 = linearLeastSquaresFit.getSlopeVariance();
            d5 = linearLeastSquaresFit.getSlopeStdDev();
            d4 = d10;
            if (!useFreqDependantBeta) {
                d4 *= 100.0 / d;
            }
            modelParameters.addParameter(Parameter.BETA, new Parameter(Parameter.BETA, d4, d8, d9));
            modelParameters.addParameter(Parameter.ALPHA, new Parameter(Parameter.ALPHA, d7, d5, d6));
            int n5 = 0;
            while (n5 < arrayList.size()) {
                double d15 = -linearLeastSquaresFit.getSlope() * (Double)arrayList.get(n5) + linearLeastSquaresFit.getIntercept();
                arrayList3.add(new Double(d15));
                ++n5;
            }
        } else {
            this.rejectCount += 1.0;
        }
        ArrayList<Double> arrayList4 = new ArrayList<Double>();
        ArrayList<Double> arrayList5 = new ArrayList<Double>();
        ArrayList<Double> arrayList6 = new ArrayList<Double>();
        int n6 = 0;
        while (n6 < n - 1) {
            d8 = dArray7[n6] / d12;
            d7 = dArray8[n6] / d13;
            if (d8 <= maxSthreshold && d8 >= minSthreshold && d7 >= minIthreshold) {
                d6 = dArray10[n6] / dArray7[n6];
                arrayList4.add(new Double(d6));
                arrayList5.add(new Double(d6 * dArray4[n6]));
            }
            ++n6;
        }
        LinearLeastSquaresFit linearLeastSquaresFit2 = null;
        if (arrayList4.size() > 2) {
            linearLeastSquaresFit2 = new LinearLeastSquaresFit(arrayList4, arrayList5);
            d8 = -1.0 * linearLeastSquaresFit2.getSlope();
            d7 = linearLeastSquaresFit2.getSlopeVariance();
            d6 = linearLeastSquaresFit2.getSlopeStdDev();
            d5 = linearLeastSquaresFit2.getIntercept();
            d4 = linearLeastSquaresFit2.getInterceptVariance();
            double d16 = linearLeastSquaresFit2.getInterceptStdDev();
            d3 = d5;
            if (!useFreqDependantBeta) {
                d3 *= 100.0 / d;
            }
            modelParameters.addParameter(Parameter.BETA2, new Parameter(Parameter.BETA2, d3, d16, d4));
            modelParameters.addParameter(Parameter.GAMMA, new Parameter(Parameter.GAMMA, d8, d6, d7));
            int n7 = 0;
            while (n7 < arrayList4.size()) {
                double d17 = linearLeastSquaresFit2.getSlope() * (Double)arrayList4.get(n7) + linearLeastSquaresFit2.getIntercept();
                arrayList6.add(new Double(d17));
                ++n7;
            }
        } else {
            this.rejectCount += 1.0;
        }
        ArrayList<Double> arrayList7 = new ArrayList<Double>();
        ArrayList<Double> arrayList8 = new ArrayList<Double>();
        ArrayList<Double> arrayList9 = new ArrayList<Double>();
        int n8 = 0;
        while (n8 < n - 1) {
            d6 = dArray8[n8] / d13;
            d5 = dArray9[n8] / d14;
            if (d6 >= minIthreshold && d5 >= minRthreshold && d5 <= maxRthreshold) {
                arrayList7.add(new Double(dArray8[n8] / dArray9[n8]));
                arrayList8.add(new Double(dArray6[n8]));
            }
            ++n8;
        }
        LinearLeastSquaresFit linearLeastSquaresFit3 = null;
        if (arrayList7.size() > 2) {
            linearLeastSquaresFit3 = new LinearLeastSquaresFit(arrayList7, arrayList8);
            d6 = Math.abs(-1.0 * linearLeastSquaresFit3.getIntercept());
            d5 = linearLeastSquaresFit3.getInterceptVariance();
            d4 = linearLeastSquaresFit3.getInterceptStdDev();
            double d18 = linearLeastSquaresFit3.getSlope();
            d3 = linearLeastSquaresFit3.getSlopeVariance();
            double d19 = linearLeastSquaresFit3.getSlopeStdDev();
            modelParameters.addParameter(Parameter.ALPHA2, new Parameter(Parameter.ALPHA2, d6, d4, d5));
            modelParameters.addParameter(Parameter.GAMMA2, new Parameter(Parameter.GAMMA2, d18, d19, d3));
            int n9 = 0;
            while (n9 < arrayList7.size()) {
                double d20 = linearLeastSquaresFit3.getSlope() * (Double)arrayList7.get(n9) + linearLeastSquaresFit3.getIntercept();
                arrayList9.add(new Double(d20));
                ++n9;
            }
        } else {
            this.rejectCount += 1.0;
        }
        modelParameters.addParameter(Parameter.REJECT, new Parameter(Parameter.REJECT, this.rejectCount));
        this.dataToPlot.add(dArray11);
        this.dataToPlot.add(dArray12);
        this.dataToPlot.add(dArray13);
        modelParameters.addSelectedData(string, this.dataToPlot);
        double[][] dArray14 = this.getSortedRegression(arrayList, arrayList2);
        double[][] dArray15 = this.getSortedRegression(arrayList4, arrayList5);
        double[][] dArray16 = this.getSortedRegression(arrayList7, arrayList8);
        double[][] dArray17 = this.getSortedRegression(arrayList, arrayList3);
        double[][] dArray18 = this.getSortedRegression(arrayList4, arrayList6);
        double[][] dArray19 = this.getSortedRegression(arrayList7, arrayList9);
        this.regressionValues.add(dArray14);
        this.regressionValues.add(dArray15);
        this.regressionValues.add(dArray16);
        this.fittedValues.add(dArray17);
        this.fittedValues.add(dArray18);
        this.fittedValues.add(dArray19);
        modelParameters.addRegressionData(string, this.regressionValues);
        modelParameters.addFittedData(string, this.fittedValues);
        return modelParameters;
    }

    public int getNumProperties() {
        return 3;
    }
}

