/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.stem.analysis.ErrorResult;
import org.eclipse.stem.analysis.ScenarioInitializationException;
import org.eclipse.stem.analysis.impl.ReferenceScenarioDataMapImpl;
import org.eclipse.stem.analysis.util.CSVscenarioLoader;
import org.eclipse.stem.util.analysis.AggregateDataWriter;
import org.eclipse.stem.util.analysis.CSVAnalysisWriter;
import org.eclipse.stem.util.analysis.LyapunovAnalysis;
import org.eclipse.stem.util.analysis.ModelParameters;
import org.eclipse.stem.util.analysis.ParameterEstimator;
import org.eclipse.stem.util.analysis.ParameterEstimatorMethod;
import org.eclipse.stem.util.analysis.PhaseSpaceCoordinate;
import org.eclipse.stem.util.analysis.ScenarioParameterEstimator;
import org.eclipse.stem.util.analysis.ThresholdMeanSquareDifference;
import org.eclipse.stem.util.analysis.views.AnalysisControl;
import org.eclipse.stem.util.analysis.views.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScenarioAnalysisSuite {
    public static final String REFERENCE_ROOT_DIRECTORY;
    public static String REFERENCE_TESTING_DIRECTORY;
    public static String REFERENCE_TESTING_AGGREGATE_FILE;
    public static String REFERENCE_TESTING_INCIDENCE_FILE;
    private static String DEFAULT_AGGREGATE_FILENAME;
    private static String COMPARISON_FILE_NAME;
    public static final String NOT_FOUND_MSG;
    public static final String INVALID_DATA_MSG;
    public static final String DONE_MSG;
    public static final String READY_MSG;
    public static final String WORKING_MSG;
    ReferenceScenarioDataMapImpl referenceScenarioDataMap = null;
    ReferenceScenarioDataMapImpl comparisonScenarioDataMap = null;
    ScenarioParameterEstimator estimator = null;
    AnalysisControl control = null;

    static {
        REFERENCE_TESTING_DIRECTORY = REFERENCE_ROOT_DIRECTORY = AggregateDataWriter.ANALYSISFOLDER;
        REFERENCE_TESTING_AGGREGATE_FILE = String.valueOf(REFERENCE_ROOT_DIRECTORY) + File.separator + "aggregate" + File.separator + "aggregate.csv";
        REFERENCE_TESTING_INCIDENCE_FILE = String.valueOf(REFERENCE_ROOT_DIRECTORY) + File.separator + "incidence" + File.separator + "incidence.csv";
        DEFAULT_AGGREGATE_FILENAME = "aggregate";
        COMPARISON_FILE_NAME = "RMSComparisonResults";
        NOT_FOUND_MSG = Messages.getString("COMMON.NOTFOUND");
        INVALID_DATA_MSG = Messages.getString("COMMON.NOTDATA");
        DONE_MSG = Messages.getString("COMMON.DONE");
        READY_MSG = Messages.getString("COMMON.READY");
        WORKING_MSG = Messages.getString("COMMON.WORKING");
    }

    public ScenarioAnalysisSuite(AnalysisControl analysisControl) {
        this.control = analysisControl;
    }

    public String[] aggregateData(String string, IRunnableContext iRunnableContext, double d) throws ScenarioInitializationException {
        String[] stringArray = new String[2];
        CSVscenarioLoader cSVscenarioLoader = new CSVscenarioLoader(string);
        int n = cSVscenarioLoader.getMaxResolution();
        ReferenceScenarioDataMapImpl referenceScenarioDataMapImpl = cSVscenarioLoader.parseAllFiles(n);
        String string2 = ScenarioAnalysisSuite.getAggregateFileName(string);
        ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance referenceScenarioDataInstance = referenceScenarioDataMapImpl.aggregateScenarioData(iRunnableContext);
        AggregateDataWriter aggregateDataWriter = new AggregateDataWriter(string, string2);
        stringArray = aggregateDataWriter.logDataInstance(referenceScenarioDataInstance, d);
        return stringArray;
    }

    public String[] aggregateByFilter(String string, String string2, IRunnableContext iRunnableContext, double d) throws ScenarioInitializationException {
        String[] stringArray = new String[2];
        CSVscenarioLoader cSVscenarioLoader = new CSVscenarioLoader(string);
        int n = cSVscenarioLoader.getMaxResolution();
        Set set = cSVscenarioLoader.getLocations(n);
        CSVscenarioLoader cSVscenarioLoader2 = new CSVscenarioLoader(string2);
        int n2 = cSVscenarioLoader2.getMaxResolution();
        ReferenceScenarioDataMapImpl referenceScenarioDataMapImpl = cSVscenarioLoader2.parseAllFiles(set, n2);
        String string3 = ScenarioAnalysisSuite.getAggregateFileName(string2);
        ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance referenceScenarioDataInstance = referenceScenarioDataMapImpl.aggregateScenarioData(iRunnableContext);
        AggregateDataWriter aggregateDataWriter = new AggregateDataWriter(string2, string3);
        stringArray = aggregateDataWriter.logDataInstance(referenceScenarioDataInstance, d);
        return stringArray;
    }

    public ModelParameters estimateParameters(ReferenceScenarioDataMapImpl referenceScenarioDataMapImpl, ParameterEstimatorMethod parameterEstimatorMethod, IRunnableContext iRunnableContext) {
        this.referenceScenarioDataMap = referenceScenarioDataMapImpl;
        this.estimator = new ScenarioParameterEstimator(this.referenceScenarioDataMap, parameterEstimatorMethod);
        ModelParameters modelParameters = new ModelParameters();
        boolean bl = false;
        Map<String, Object> map = this.control.getControlParametersMap();
        if (map != null) {
            bl = (Boolean)map.get("SUM_LOCATIONS");
        }
        if (bl) {
            modelParameters = this.estimator.averageThenEstimateParameters(map, iRunnableContext);
        } else {
            Map<String, ModelParameters> map2 = this.estimator.estimateParameters(map, iRunnableContext);
            modelParameters.average(map2);
        }
        return modelParameters;
    }

    private static String getAggregateFileName(String string) {
        int n = string.lastIndexOf(File.separatorChar);
        String string2 = DEFAULT_AGGREGATE_FILENAME;
        if (n >= 0) {
            string2 = string.substring(n + 1, string.length());
        }
        string2 = String.valueOf(string2) + ".csv";
        return string2;
    }

    public ErrorResult compare(String string, String string2, IRunnableContext iRunnableContext) throws ScenarioInitializationException {
        CSVscenarioLoader cSVscenarioLoader = new CSVscenarioLoader(string);
        String string3 = COMPARISON_FILE_NAME;
        CSVAnalysisWriter cSVAnalysisWriter = new CSVAnalysisWriter(string3);
        HashMap<Map<String, String>, ErrorResult> hashMap = new HashMap<Map<String, String>, ErrorResult>();
        this.compareRecursive(cSVscenarioLoader, string2, hashMap, iRunnableContext);
        cSVAnalysisWriter.logData(hashMap);
        cSVAnalysisWriter.flushLoggerData();
        cSVAnalysisWriter.closeLoggerData();
        double d = Double.MAX_VALUE;
        ErrorResult errorResult = null;
        for (Map map : hashMap.keySet()) {
            ErrorResult errorResult2 = (ErrorResult)hashMap.get(map);
            double d2 = 0.0;
            if (errorResult2 != null) {
                d2 = errorResult2.getError();
            }
            if (!(d2 < d)) continue;
            d = d2;
            errorResult = errorResult2;
        }
        return errorResult;
    }

    /*
     * Unable to fully structure code
     */
    public void compareRecursive(CSVscenarioLoader var1_1, String var2_2, Map<Map<String, String>, ErrorResult> var3_3, IRunnableContext var4_4) throws ScenarioInitializationException {
        block3: {
            try {
                var5_5 = new CSVscenarioLoader(var2_2);
                var6_7 = this._compare(var1_1, var5_5, var4_4);
                var7_9 = var5_5.getRunParameters();
                var3_3.put(var7_9, var6_7);
                break block3;
            }
            catch (ScenarioInitializationException v0) {
                var5_6 = new File(var2_2);
                var6_8 = var5_6.list();
                if (var6_8 == null) break block3;
                var10_11 = var6_8;
                var9_12 = var6_8.length;
                var8_13 = 0;
                ** while (var8_13 < var9_12)
            }
lbl-1000:
            // 1 sources

            {
                var7_10 = var10_11[var8_13];
                this.compareRecursive(var1_1, String.valueOf(var2_2) + File.separator + var7_10, var3_3, var4_4);
                ++var8_13;
                continue;
            }
        }
    }

    private ErrorResult _compare(CSVscenarioLoader cSVscenarioLoader, CSVscenarioLoader cSVscenarioLoader2, IRunnableContext iRunnableContext) throws ScenarioInitializationException {
        int n;
        int n2 = cSVscenarioLoader.getMaxResolution();
        int n3 = n2 > (n = cSVscenarioLoader2.getMaxResolution()) ? n : n2;
        this.referenceScenarioDataMap = cSVscenarioLoader.parseAllFiles(n3);
        this.comparisonScenarioDataMap = cSVscenarioLoader2.parseAllFiles(n3);
        ThresholdMeanSquareDifference thresholdMeanSquareDifference = new ThresholdMeanSquareDifference(this.referenceScenarioDataMap, this.comparisonScenarioDataMap);
        ErrorResult errorResult = thresholdMeanSquareDifference.solve(iRunnableContext);
        return errorResult;
    }

    public boolean validate(String string) {
        return CSVscenarioLoader.validate((String)string);
    }

    public List<PhaseSpaceCoordinate[]> getLyapunovTrajectory(String string, String string2, IRunnableContext iRunnableContext) throws ScenarioInitializationException {
        CSVscenarioLoader cSVscenarioLoader;
        int n;
        CSVscenarioLoader cSVscenarioLoader2 = new CSVscenarioLoader(string);
        int n2 = cSVscenarioLoader2.getMaxResolution();
        int n3 = n2 > (n = (cSVscenarioLoader = new CSVscenarioLoader(string2)).getMaxResolution()) ? n : n2;
        this.referenceScenarioDataMap = cSVscenarioLoader2.parseAllFiles(n3);
        this.comparisonScenarioDataMap = cSVscenarioLoader.parseAllFiles(n3);
        LyapunovAnalysis lyapunovAnalysis = new LyapunovAnalysis(this.referenceScenarioDataMap, this.comparisonScenarioDataMap, iRunnableContext);
        List<PhaseSpaceCoordinate[]> list = lyapunovAnalysis.getLyapunovTrajectory(iRunnableContext);
        return list;
    }

    public static List<EList<Double>> getCumulativePhaseSpaceDeviation(List<PhaseSpaceCoordinate[]> list) {
        List<EList<Double>> list2 = LyapunovAnalysis.getCumulativePhaseSpaceDeviation(list);
        return list2;
    }

    public ParameterEstimator getEstimator() {
        return this.estimator.getEstimator();
    }
}

