/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.stem.analysis.States;
import org.eclipse.stem.analysis.impl.ReferenceScenarioDataMapImpl;
import org.eclipse.stem.data.geography.GeographicMapper;
import org.eclipse.stem.definitions.labels.AreaLabel;
import org.eclipse.stem.definitions.labels.PopulationLabel;
import org.eclipse.stem.ui.Utility;
import org.eclipse.stem.util.analysis.Activator;
import org.eclipse.stem.util.analysis.ModelParameters;
import org.eclipse.stem.util.analysis.ParameterEstimator;
import org.eclipse.stem.util.analysis.ParameterEstimatorFactory;
import org.eclipse.stem.util.analysis.ParameterEstimatorMethod;
import org.eclipse.stem.util.analysis.views.EstimatorControl;
import org.eclipse.stem.util.analysis.views.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScenarioParameterEstimator {
    ReferenceScenarioDataMapImpl referenceScenarioDataMap = null;
    ParameterEstimatorMethod parameterEstimatorMethod = null;
    Set<String> referenceLocations;
    Map<String, Double> referenceAreaDataMap;
    Map<String, Double> referencePopulationDataMap;
    Map<String, Double> maxInfectiousMap = new HashMap<String, Double>();
    ParameterEstimator estimator;
    private static final String AREA_URI_PREFIX = "label/area";
    private static final String POPULATION_URI_PREFIX = "label/population";
    private static final String SPECIES = "human";
    private static final String YEAR = "2006";
    public static final int ALL_MODE = 0;
    public static final int NON_ZERO_DATA_MODE = 1;
    public static final String LEVEL_STRING = "level";
    private static final double FITTING_FRACTION = 0.05;
    protected EstimatorControl control = null;

    public ScenarioParameterEstimator(ReferenceScenarioDataMapImpl referenceScenarioDataMapImpl, ParameterEstimatorMethod parameterEstimatorMethod) {
        this.referenceScenarioDataMap = referenceScenarioDataMapImpl;
        this.parameterEstimatorMethod = parameterEstimatorMethod;
        this.referenceLocations = this.getReferenceLocations();
        this.getAreaDataMap();
        this.getPopulationDataMap();
    }

    public Map<String, ModelParameters> estimateParameters(Map<String, Object> map, IRunnableContext iRunnableContext) {
        final Map<String, Object> map2 = map;
        final ParameterEstimatorMethod parameterEstimatorMethod = this.parameterEstimatorMethod;
        IScenarioParameterEstimatorRunnableWithProgress iScenarioParameterEstimatorRunnableWithProgress = new IScenarioParameterEstimatorRunnableWithProgress(){
            public Map<String, ModelParameters> fittedParameters = new HashMap<String, ModelParameters>();

            public void run(IProgressMonitor iProgressMonitor) {
                Iterator<String> iterator = ScenarioParameterEstimator.this.referenceLocations.iterator();
                int n = 0;
                iProgressMonitor.beginTask("Estimating parameters", ScenarioParameterEstimator.this.referenceLocations.size());
                while (iterator.hasNext()) {
                    ++n;
                    String string = iterator.next();
                    ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance referenceScenarioDataInstance = ScenarioParameterEstimator.this.referenceScenarioDataMap.getLocation(string);
                    ScenarioParameterEstimator.this.estimator = ParameterEstimatorFactory.createEstimator(parameterEstimatorMethod, referenceScenarioDataInstance);
                    ScenarioParameterEstimator.this.estimator.setAllParameters(map2);
                    double d = ScenarioParameterEstimator.this.getArea(string);
                    if (!$assertionsDisabled && !(d > 0.0)) {
                        throw new AssertionError();
                    }
                    if (d == 0.0) {
                        d = 1.0;
                    }
                    double d2 = ScenarioParameterEstimator.this.getPopulation(string);
                    double d3 = d2 / d;
                    ModelParameters modelParameters = ScenarioParameterEstimator.this.estimator.estimate(d3, d2, string);
                    this.fittedParameters.put(string, modelParameters);
                    if (iProgressMonitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    iProgressMonitor.worked(1);
                }
                iProgressMonitor.done();
            }

            @Override
            public Map<String, ModelParameters> getFittedParameters() {
                return this.fittedParameters;
            }
        };
        try {
            iRunnableContext.run(true, true, (IRunnableWithProgress)iScenarioParameterEstimatorRunnableWithProgress);
        }
        catch (InterruptedException interruptedException) {
            Activator.logError("", interruptedException);
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            Activator.logError("", invocationTargetException);
            return null;
        }
        return iScenarioParameterEstimatorRunnableWithProgress.getFittedParameters();
    }

    public ModelParameters averageThenEstimateParameters(Map<String, Object> map, IRunnableContext iRunnableContext) {
        final Map<String, Object> map2 = map;
        final ParameterEstimatorMethod parameterEstimatorMethod = this.parameterEstimatorMethod;
        IAveragedParameterEstimatorRunnableWithProgress iAveragedParameterEstimatorRunnableWithProgress = new IAveragedParameterEstimatorRunnableWithProgress(){
            ModelParameters modelParameters = null;

            public void run(IProgressMonitor iProgressMonitor) {
                Iterator<String> iterator = ScenarioParameterEstimator.this.referenceLocations.iterator();
                iProgressMonitor.beginTask("Averaging data", ScenarioParameterEstimator.this.referenceLocations.size());
                ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance referenceScenarioDataInstance = null;
                double d = 0.0;
                double d2 = 0.0;
                ScenarioParameterEstimator.this.referenceScenarioDataMap.findMaxIncidence();
                String string = ScenarioParameterEstimator.this.referenceScenarioDataMap.getMaxIncidenceLocation();
                d += ScenarioParameterEstimator.this.getArea(string).doubleValue();
                d2 += ScenarioParameterEstimator.this.getPopulation(string).doubleValue();
                ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance referenceScenarioDataInstance2 = ScenarioParameterEstimator.this.referenceScenarioDataMap.getLocation(string);
                referenceScenarioDataInstance = referenceScenarioDataInstance2.clone();
                while (iterator.hasNext()) {
                    String string2 = iterator.next();
                    if (string2.equalsIgnoreCase(string)) continue;
                    d += ScenarioParameterEstimator.this.getArea(string2).doubleValue();
                    d2 += ScenarioParameterEstimator.this.getPopulation(string2).doubleValue();
                    ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance referenceScenarioDataInstance3 = ScenarioParameterEstimator.this.referenceScenarioDataMap.getLocation(string2);
                    referenceScenarioDataInstance.integrateData(referenceScenarioDataInstance3.instance);
                }
                ScenarioParameterEstimator.this.estimator = ParameterEstimatorFactory.createEstimator(parameterEstimatorMethod, referenceScenarioDataInstance);
                ScenarioParameterEstimator.this.estimator.setAllParameters(map2);
                if (!$assertionsDisabled && !(d > 0.0)) {
                    throw new AssertionError();
                }
                if (d == 0.0) {
                    d = 1.0;
                }
                double d3 = d2 / d;
                this.modelParameters = ScenarioParameterEstimator.this.estimator.estimate(d3, d2, Messages.getString("EST.AVERAGE"));
                if (iProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                iProgressMonitor.worked(1);
                iProgressMonitor.done();
            }

            public ModelParameters getModelParameters() {
                return this.modelParameters;
            }
        };
        try {
            iRunnableContext.run(true, true, (IRunnableWithProgress)iAveragedParameterEstimatorRunnableWithProgress);
        }
        catch (InterruptedException interruptedException) {
            Activator.logError("", interruptedException);
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            Activator.logError("", invocationTargetException);
            return null;
        }
        return iAveragedParameterEstimatorRunnableWithProgress.getModelParameters();
    }

    private Set<String> getReferenceLocations() {
        Object object;
        Object object2;
        HashSet<String> hashSet = new HashSet<String>();
        Set set = this.referenceScenarioDataMap.getLocations();
        double d = 0.0;
        Iterator iterator = set.iterator();
        while (iterator != null && iterator.hasNext()) {
            object2 = (String)iterator.next();
            object = this.referenceScenarioDataMap.getLocation((String)object2);
            if (!object.containsParameter(States.statesToFit[2])) continue;
            List list = object.getData(States.statesToFit[2]);
            double d2 = 0.0;
            int n = 0;
            while (n < list.size()) {
                double d3 = new Double((String)list.get(n));
                if (d2 < d3) {
                    d2 = d3;
                }
                if (d < d2) {
                    d = d2;
                }
                ++n;
            }
            this.maxInfectiousMap.put((String)object2, new Double(d2));
        }
        object2 = this.maxInfectiousMap.keySet().iterator();
        while (object2 != null && object2.hasNext()) {
            object = (String)object2.next();
            double d4 = this.maxInfectiousMap.get(object);
            if (!(d4 >= 0.05 * d)) continue;
            hashSet.add((String)object);
        }
        return hashSet;
    }

    Double getArea(String string) {
        double d = 0.0;
        URI uRI = this.getAreaURI(string);
        AreaLabel areaLabel = (AreaLabel)Utility.getLabel((URI)uRI);
        if (areaLabel == null) {
            Activator.logError("area label is null", new NumberFormatException("null area"));
        }
        d = areaLabel.getCurrentAreaValue().getArea();
        return new Double(d);
    }

    Double getPopulation(String string) {
        double d = 0.0;
        URI uRI = this.getPopulationURI(string);
        PopulationLabel populationLabel = (PopulationLabel)Utility.getLabel((URI)uRI);
        if (populationLabel == null) {
            Activator.logError("Population label is null", new NumberFormatException("null population"));
        }
        d = populationLabel.getCurrentPopulationValue().getCount();
        return new Double(d);
    }

    Map<String, Double> getAreaDataMap() {
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        for (String string : this.referenceLocations) {
            Double d = this.getArea(string);
            hashMap.put(string, d);
        }
        return hashMap;
    }

    Map<String, Double> getPopulationDataMap() {
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        for (String string : this.referenceLocations) {
            Double d = this.getPopulation(string);
            hashMap.put(string, d);
        }
        return hashMap;
    }

    public static double[] getDoubleValues(List<String> list) {
        double[] dArray = new double[list.size()];
        try {
            int n = 0;
            while (n < list.size()) {
                Double d = new Double(list.get(n));
                dArray[n] = d;
                ++n;
            }
        }
        catch (Exception exception) {
            Activator.logError("String Data not valid. Expecting Double values", exception);
        }
        return dArray;
    }

    public ParameterEstimator getEstimator() {
        return this.estimator;
    }

    URI getAreaURI(String string) {
        String string2;
        String string3;
        int n = this.getLevel(string);
        if (n == 0) {
            string3 = string;
        } else {
            string2 = string.substring(0, 2);
            string3 = GeographicMapper.getAlpha3((String)string2);
        }
        string2 = "stem://org.eclipse.stem/label/area/" + string3 + "/" + this.getLevel(string) + "/" + string;
        URI uRI = URI.createURI((String)string2);
        return uRI;
    }

    URI getPopulationURI(String string) {
        String string2;
        String string3;
        int n = this.getLevel(string);
        if (n == 0) {
            string3 = string;
        } else {
            string2 = string.substring(0, 2);
            string3 = GeographicMapper.getAlpha3((String)string2);
        }
        string2 = "stem://org.eclipse.stem/label/population/" + string3 + "/" + this.getLevel(string) + "/" + SPECIES + "/" + YEAR + "/" + string;
        URI uRI = URI.createURI((String)string2);
        return uRI;
    }

    private int getLevel(String string) {
        if (string.indexOf("-") == -1) {
            return 0;
        }
        int n = string.indexOf("-");
        String string2 = string.substring(n + 1, string.length());
        if (string2.indexOf("-") == -1) {
            return 1;
        }
        int n2 = string2.indexOf("-");
        String string3 = string2.substring(n2 + 1, string2.length());
        if (string3.indexOf("-") == -1) {
            return 2;
        }
        int n3 = string3.indexOf("-");
        String string4 = string3.substring(n3 + 1, string3.length());
        if (string4.indexOf("-") == -1) {
            return 3;
        }
        return 4;
    }

    public static String[] getStatesToFit() {
        return States.statesToFit;
    }

    public double[] getValues(int n, int n2) {
        return this.estimator.getValues(n, n2);
    }

    private static interface IAveragedParameterEstimatorRunnableWithProgress
    extends IRunnableWithProgress {
        public ModelParameters getModelParameters();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface IScenarioParameterEstimatorRunnableWithProgress
    extends IRunnableWithProgress {
        public Map<String, ModelParameters> getFittedParameters();
    }
}

