/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis.views;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.util.analysis.MonitorPreferences;
import org.eclipse.stem.util.analysis.views.IRemoveListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnalysisControl
extends Composite {
    MonitorPreferences prefs = new MonitorPreferences();
    protected static final String CLEAR_TEXT = "clear monitors";
    protected Label simulationNameLabel;
    public static final String STATUS_TEXT = "status";
    protected static Map<String, Object> controlParametersMap = new HashMap<String, Object>();
    protected String userMessage = "";
    protected Label userMessageLabel = null;
    protected Button analyzeButton = null;
    protected Button selectEstimatorButton = null;
    protected final List<ISelectionChangedListener> listeners = new CopyOnWriteArrayList<ISelectionChangedListener>();
    protected final List<IRemoveListener> removeListeners = new CopyOnWriteArrayList<IRemoveListener>();
    protected Label identifiableTitle;
    protected static final int MARGIN_WIDTH = 5;
    protected static final int MARGIN_HEIGHT = 5;

    public AnalysisControl(Composite composite, int n) {
        super(composite, n);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                AnalysisControl.this.dispose();
            }
        });
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = 5;
        formLayout.marginWidth = 5;
        this.setLayout((Layout)formLayout);
    }

    protected Composite createTopComposite(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        FillLayout fillLayout = new FillLayout(512);
        composite2.setLayout((Layout)fillLayout);
        this.simulationNameLabel = new Label(composite2, 0x1000000);
        this.simulationNameLabel.setText("");
        return composite2;
    }

    Composite getAnalyzeButtonComposite(AnalysisControl analysisControl, String string) {
        Composite composite = new Composite((Composite)analysisControl, 2048);
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 256;
        composite.setLayout((Layout)fillLayout);
        Label label = new Label(composite, 0);
        label.setText(" ");
        this.analyzeButton = new Button(composite, 0);
        this.analyzeButton.setText(string);
        Label label2 = new Label(composite, 0);
        label2.setText(" ");
        return composite;
    }

    protected abstract void initializeHeader(String var1);

    public abstract void remove();

    public void addIRemoveListener(IRemoveListener iRemoveListener) {
        this.removeListeners.add(iRemoveListener);
    }

    public void removeIRemoveListener(IRemoveListener iRemoveListener) {
        this.removeListeners.remove(iRemoveListener);
    }

    public void fireRemoveEvent(Set<Identifiable> set) {
        for (IRemoveListener iRemoveListener : this.removeListeners) {
            Iterator<Identifiable> iterator = set.iterator();
            while (iterator != null && iterator.hasNext()) {
                Identifiable identifiable = iterator.next();
                iRemoveListener.identifiableRemoved(identifiable);
            }
        }
    }

    public abstract double[] getValues(int var1, int var2);

    public void updateMessage() {
        if (this.userMessageLabel != null) {
            this.userMessageLabel.setText(this.userMessage);
        }
    }

    public void updateMessage(String string) {
        this.userMessage = string;
        if (this.userMessageLabel != null) {
            this.userMessageLabel.setText(this.userMessage);
        }
    }

    public abstract String getProperty(int var1, int var2);

    public abstract int getNumProperties(int var1);

    public abstract Map<String, Object> getControlParametersMap();
}

