/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis.views;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stem.util.analysis.views.AnalysisControl;
import org.eclipse.stem.util.analysis.views.AnalysisControlFactory;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class AnalysisViewer
extends Viewer {
    private static final String URI_PREFIX = "/resources/data/scenario/disease/";
    final Composite composite;
    private final AnalysisControlFactory acf;

    public AnalysisViewer(Composite composite, AnalysisControlFactory analysisControlFactory) {
        this.composite = new Composite(composite, 0);
        FillLayout fillLayout = new FillLayout(256);
        this.composite.setLayout((Layout)fillLayout);
        this.acf = analysisControlFactory;
        this.refresh();
        this.composite.pack();
    }

    public Control getControl() {
        return this.composite;
    }

    public void refresh() {
        this.populateView();
    }

    private void populateView() {
        if (this.composite.isDisposed()) {
            return;
        }
        String string = "data directory here";
        AnalysisControl analysisControl = this.acf.create(this.composite, string);
        analysisControl.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                AnalysisViewer.this.composite.layout(true, true);
                AnalysisViewer.this.composite.redraw();
            }
        });
        this.composite.layout(true, true);
        this.composite.redraw();
    }

    public static String nameFilter(String string) {
        String string2 = string.trim();
        string2 = string2.replace('\"', ' ');
        string2 = string2.replaceAll(" ", "");
        string2 = string2.replace(',', '_');
        string2 = string2.replace('.', '_');
        string = string2 = string2.replaceAll("_", "");
        return string;
    }

    public static String filterFilename(String string) {
        int n = string.indexOf(URI_PREFIX);
        if (n >= 0) {
            return string.substring(n += URI_PREFIX.length(), string.length());
        }
        return string;
    }

    public Object getInput() {
        return null;
    }

    public void setInput(Object object) {
    }

    public void setSelection(ISelection iSelection, boolean bl) {
    }

    public ISelection getSelection() {
        return null;
    }
}

