/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.stem.analysis.ScenarioInitializationException;
import org.eclipse.stem.analysis.impl.ReferenceScenarioDataMapImpl;
import org.eclipse.stem.analysis.util.CSVscenarioLoader;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.diseasemodels.Activator;
import org.eclipse.stem.util.analysis.AggregateDataWriter;
import org.eclipse.stem.util.analysis.ScenarioAnalysisSuite;
import org.eclipse.stem.util.analysis.views.AnalysisControl;
import org.eclipse.stem.util.analysis.views.Messages;
import org.eclipse.stem.util.analysis.views.TimeSeriesCanvas;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EpidemicControl
extends AnalysisControl {
    private static final String CONSUMER = "EPIDEMIC_CONTROL";
    private static final String AGGREGATE_FOLDER_KEY = "EPIDEMIC_CONTROL_AGGREGATE";
    private static final String REFERENCE_FOLDER_KEY = "EPIDEMIC_CONTROL_REFERENCE";
    private static final String INCIDENCE_FOLDER_KEY = "EPIDEMIC_CONTROL_INCIDENCE";
    static Label statusLabel;
    static Label scenarioFolderLabel;
    static Label aggregateFileLabel;
    static Label incidenceFileLabel;
    public static Text aggregateDirtext;
    public static Text referenceDirtext;
    public static Text filetextAggregate;
    public static Text filetextIncidence;
    protected static double alpha;
    TimeSeriesCanvas aggregateDataCanvas;
    TimeSeriesCanvas newIncidenceCanvas;
    protected static final String[] incidenceStates;
    private static final String[] OMIT_LIST;
    static final ColorDefinition foreGround;
    static final ColorDefinition backgroundGround;
    static final ColorDefinition frameColor;
    final Color white = this.getDisplay().getSystemColor(1);
    final Color grey = this.getDisplay().getSystemColor(15);
    ScenarioAnalysisSuite analyzer = new ScenarioAnalysisSuite(this);
    private static String TITLE_TEXT;
    public List<List<Double>> aggregateData = new ArrayList<List<Double>>();
    public List<List<Double>> incidenceData = new ArrayList<List<Double>>();
    public List<String> primaryPropertiesToPlot = new ArrayList<String>();
    public List<String> secondaryPropertiesToPlot = new ArrayList<String>();
    private Button aggregateButton;
    protected Button useReferenceCheckbox;
    protected Button pickRefButton;
    private Button plotButton;

    static {
        alpha = 0.003;
        incidenceStates = new String[]{"Incidence", "deltaBirths", "deltaDeaths"};
        OMIT_LIST = new String[]{"time", "#iteration", "Incidence"};
        foreGround = ColorDefinitionImpl.create((int)180, (int)0, (int)0);
        backgroundGround = ColorDefinitionImpl.create((int)255, (int)255, (int)225);
        frameColor = ColorDefinitionImpl.WHITE();
        TITLE_TEXT = "Aggregate data view";
    }

    public EpidemicControl(Composite composite) {
        super(composite, 0);
        this.createContents();
    }

    void createContents() {
        this.setLayout((Layout)new FormLayout());
        Display display = this.getDisplay();
        this.identifiableTitle = new Label((Composite)this, 0);
        this.identifiableTitle.setText(TITLE_TEXT);
        int n = 5;
        FormData formData = new FormData();
        this.identifiableTitle.setLayoutData((Object)formData);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(n, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        Color color = new Color((Device)display, new RGB(180, 180, 200));
        n += 5;
        scenarioFolderLabel = new Label((Composite)this, 2048);
        scenarioFolderLabel.setBackground(color);
        scenarioFolderLabel.setText(Messages.getString("EPIVIEW.SCENARIOFOLDERLABEL"));
        FormData formData2 = new FormData();
        scenarioFolderLabel.setLayoutData((Object)formData2);
        formData2.top = new FormAttachment((Control)this.identifiableTitle, 0);
        formData2.bottom = new FormAttachment(n, 0);
        formData2.left = new FormAttachment(0, 0);
        formData2.right = new FormAttachment(15, 0);
        aggregateDirtext = new Text((Composite)this, 2048);
        aggregateDirtext.setBounds(10, 10, 100, 20);
        String string = this.prefs.getRecentFolder(CONSUMER);
        if (string == null) {
            string = ScenarioAnalysisSuite.REFERENCE_TESTING_DIRECTORY;
        }
        aggregateDirtext.setText(string);
        FormData formData3 = new FormData();
        aggregateDirtext.setLayoutData((Object)formData3);
        formData3.top = new FormAttachment((Control)this.identifiableTitle, 0);
        formData3.bottom = new FormAttachment(n, 0);
        formData3.left = new FormAttachment((Control)scenarioFolderLabel, 0);
        formData3.right = new FormAttachment(80, 0);
        Button button = new Button((Composite)this, 0);
        button.setText(Messages.getString("EPIVIEW.SELECTDIR"));
        FormData formData4 = new FormData();
        formData4.top = new FormAttachment((Control)this.identifiableTitle, 0);
        formData4.bottom = new FormAttachment(n, 0);
        formData4.left = new FormAttachment((Control)aggregateDirtext, 0);
        formData4.right = new FormAttachment(100, 0);
        button.setLayoutData((Object)formData4);
        button.setEnabled(true);
        final Shell shell = this.getShell();
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DirectoryDialog directoryDialog = new DirectoryDialog(shell, 4096);
                directoryDialog.setText(Messages.getString("EPIVIEW.SELECTSCENARIOFOLDER"));
                directoryDialog.setFilterPath(aggregateDirtext.getText());
                String string = directoryDialog.open();
                aggregateDirtext.setText(string);
            }
        });
        n += 5;
        this.useReferenceCheckbox = new Button((Composite)this, 32);
        this.useReferenceCheckbox.setText(Messages.getString("EPIVIEW.REFERENCEFOLDERLABEL"));
        this.useReferenceCheckbox.setBackground(color);
        this.useReferenceCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (EpidemicControl.this.useReferenceCheckbox.getSelection()) {
                    referenceDirtext.setBackground(EpidemicControl.this.white);
                    String string = EpidemicControl.this.prefs.getRecentFolder(EpidemicControl.REFERENCE_FOLDER_KEY);
                    if (string == null) {
                        string = aggregateDirtext.getText();
                    }
                    referenceDirtext.setText(string);
                    EpidemicControl.this.pickRefButton.setEnabled(true);
                } else {
                    referenceDirtext.setBackground(EpidemicControl.this.grey);
                    EpidemicControl.this.pickRefButton.setEnabled(false);
                }
            }
        });
        FormData formData5 = new FormData();
        this.useReferenceCheckbox.setLayoutData((Object)formData5);
        formData5.top = new FormAttachment((Control)scenarioFolderLabel, 0);
        formData5.bottom = new FormAttachment(n, 0);
        formData5.left = new FormAttachment(0, 0);
        formData5.right = new FormAttachment(15, 0);
        referenceDirtext = new Text((Composite)this, 2048);
        referenceDirtext.setBounds(10, 10, 100, 20);
        String string2 = this.prefs.getRecentFolder(REFERENCE_FOLDER_KEY);
        if (string2 == null) {
            string2 = string;
        }
        referenceDirtext.setText(string2);
        FormData formData6 = new FormData();
        referenceDirtext.setLayoutData((Object)formData6);
        formData6.top = new FormAttachment((Control)scenarioFolderLabel, 0);
        formData6.bottom = new FormAttachment(n, 0);
        formData6.left = new FormAttachment((Control)this.useReferenceCheckbox, 0);
        formData6.right = new FormAttachment(80, 0);
        this.pickRefButton = new Button((Composite)this, 0);
        this.pickRefButton.setText(Messages.getString("EPIVIEW.SELECTDIR"));
        FormData formData7 = new FormData();
        formData7.top = new FormAttachment((Control)scenarioFolderLabel, 0);
        formData7.bottom = new FormAttachment(n, 0);
        formData7.left = new FormAttachment((Control)referenceDirtext, 0);
        formData7.right = new FormAttachment(100, 0);
        this.pickRefButton.setLayoutData((Object)formData7);
        this.pickRefButton.setEnabled(true);
        this.pickRefButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DirectoryDialog directoryDialog = new DirectoryDialog(shell, 4096);
                directoryDialog.setText(Messages.getString("EPIVIEW.SELECTREFERENCEFOLDER"));
                directoryDialog.setFilterPath(referenceDirtext.getText());
                String string = directoryDialog.open();
                referenceDirtext.setText(string);
            }
        });
        this.useReferenceCheckbox.setSelection(false);
        referenceDirtext.setBackground(this.grey);
        this.pickRefButton.setEnabled(false);
        Composite composite = this.getAggregateButtonComposite(this, Messages.getString("EPIVIEW.AGGREGATEDATA"));
        FormData formData8 = new FormData();
        formData8.top = new FormAttachment((Control)this.useReferenceCheckbox, 0);
        formData8.bottom = new FormAttachment(n += 5, 0);
        formData8.left = new FormAttachment(0, 0);
        formData8.right = new FormAttachment(100, 0);
        composite.setLayoutData((Object)formData8);
        final ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.getShell());
        this.aggregateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = aggregateDirtext.getText();
                if (!EpidemicControl.this.analyzer.validate(string)) {
                    EpidemicControl.this.identifiableTitle.setText(ScenarioAnalysisSuite.NOT_FOUND_MSG);
                    EpidemicControl.this.updateMessage(ScenarioAnalysisSuite.NOT_FOUND_MSG);
                    return;
                }
                EpidemicControl.this.updateMessage(ScenarioAnalysisSuite.WORKING_MSG);
                String string2 = null;
                String string3 = null;
                try {
                    String[] stringArray = EpidemicControl.this.useReferenceCheckbox.getSelection() ? EpidemicControl.this.analyzer.aggregateByFilter(referenceDirtext.getText(), aggregateDirtext.getText(), (IRunnableContext)progressMonitorDialog, alpha) : EpidemicControl.this.analyzer.aggregateData(aggregateDirtext.getText(), (IRunnableContext)progressMonitorDialog, alpha);
                    string2 = stringArray[0];
                    string3 = stringArray[1];
                    EpidemicControl.this.prefs.setRecentFolder(EpidemicControl.CONSUMER, aggregateDirtext.getText());
                    EpidemicControl.this.prefs.setRecentFolder(EpidemicControl.REFERENCE_FOLDER_KEY, referenceDirtext.getText());
                    EpidemicControl.this.prefs.setRecentFolder(EpidemicControl.AGGREGATE_FOLDER_KEY, string2);
                    EpidemicControl.this.prefs.setRecentFolder(EpidemicControl.INCIDENCE_FOLDER_KEY, string3);
                }
                catch (ScenarioInitializationException scenarioInitializationException) {
                    EpidemicControl.this.updateMessage(ScenarioAnalysisSuite.INVALID_DATA_MSG);
                    Activator.logError((String)scenarioInitializationException.getMessage(), (Throwable)scenarioInitializationException);
                }
                filetextAggregate.setText(string2);
                filetextIncidence.setText(string3);
                EpidemicControl.this.updateMessage(ScenarioAnalysisSuite.READY_MSG);
            }
        });
        n += 5;
        aggregateFileLabel = new Label((Composite)this, 2048);
        aggregateFileLabel.setBackground(color);
        aggregateFileLabel.setText(Messages.getString("EPIVIEW.AGGFILELABEL"));
        FormData formData9 = new FormData();
        aggregateFileLabel.setLayoutData((Object)formData9);
        formData9.top = new FormAttachment((Control)composite, 0);
        formData9.bottom = new FormAttachment(n, 0);
        formData9.left = new FormAttachment(0, 0);
        formData9.right = new FormAttachment(15, 0);
        filetextAggregate = new Text((Composite)this, 2048);
        filetextAggregate.setBounds(10, 10, 100, 20);
        String string3 = this.prefs.getRecentFolder(AGGREGATE_FOLDER_KEY);
        filetextAggregate.setText(string3);
        FormData formData10 = new FormData();
        filetextAggregate.setLayoutData((Object)formData10);
        formData10.top = new FormAttachment((Control)composite, 0);
        formData10.bottom = new FormAttachment(n, 0);
        formData10.left = new FormAttachment((Control)aggregateFileLabel, 0);
        formData10.right = new FormAttachment(80, 0);
        incidenceFileLabel = new Label((Composite)this, 2048);
        incidenceFileLabel.setBackground(color);
        incidenceFileLabel.setText(Messages.getString("EPIVIEW.INCFILELABEL"));
        FormData formData11 = new FormData();
        incidenceFileLabel.setLayoutData((Object)formData11);
        formData11.top = new FormAttachment((Control)aggregateFileLabel, 0);
        formData11.bottom = new FormAttachment(n + 5, 0);
        formData11.left = new FormAttachment(0, 0);
        formData11.right = new FormAttachment(15, 0);
        filetextIncidence = new Text((Composite)this, 2048);
        filetextIncidence.setBounds(10, 10, 100, 20);
        String string4 = this.prefs.getRecentFolder(INCIDENCE_FOLDER_KEY);
        filetextIncidence.setText(string4);
        FormData formData12 = new FormData();
        filetextIncidence.setLayoutData((Object)formData12);
        formData12.top = new FormAttachment((Control)filetextAggregate, 0);
        formData12.bottom = new FormAttachment(n + 5, 0);
        formData12.left = new FormAttachment((Control)incidenceFileLabel, 0);
        formData12.right = new FormAttachment(80, 0);
        Button button2 = new Button((Composite)this, 0);
        button2.setText(Messages.getString("EPIVIEW.SELECTAGGFILE"));
        FormData formData13 = new FormData();
        formData13.top = new FormAttachment((Control)composite, 0);
        formData13.bottom = new FormAttachment(n, 0);
        formData13.left = new FormAttachment((Control)filetextAggregate, 0);
        formData13.right = new FormAttachment(100, 0);
        button2.setLayoutData((Object)formData13);
        button2.setEnabled(true);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(shell, 4096);
                fileDialog.setText(Messages.getString("EPIVIEW.SELECTAGGFILE"));
                fileDialog.setFilterPath(filetextAggregate.getText());
                String string = fileDialog.open();
                filetextAggregate.setText(string);
            }
        });
        Button button3 = new Button((Composite)this, 0);
        button3.setText(Messages.getString("EPIVIEW.SELECTINCFILE"));
        FormData formData14 = new FormData();
        formData14.top = new FormAttachment((Control)button2, 0);
        formData14.bottom = new FormAttachment(n += 5, 0);
        formData14.left = new FormAttachment((Control)filetextIncidence, 0);
        formData14.right = new FormAttachment(100, 0);
        button3.setLayoutData((Object)formData14);
        button3.setEnabled(true);
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(shell, 4096);
                fileDialog.setText(Messages.getString("EPIVIEW.SELECTINCFILE"));
                fileDialog.setFilterPath(filetextIncidence.getText());
                String string = fileDialog.open();
                filetextIncidence.setText(string);
            }
        });
        Composite composite2 = this.getPlotButtonComposite(this, Messages.getString("EPIVIEW.PLOTTEXT"));
        FormData formData15 = new FormData();
        formData15.top = new FormAttachment((Control)incidenceFileLabel, 0);
        formData15.bottom = new FormAttachment(n += 5, 0);
        formData15.left = new FormAttachment(0, 0);
        formData15.right = new FormAttachment(100, 0);
        composite2.setLayoutData((Object)formData15);
        final EpidemicControl epidemicControl = this;
        this.plotButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Object object;
                Object object2;
                Object object32;
                EpidemicControl.this.aggregateData.clear();
                EpidemicControl.this.incidenceData.clear();
                EpidemicControl.this.primaryPropertiesToPlot.clear();
                EpidemicControl.this.secondaryPropertiesToPlot.clear();
                EpidemicControl.this.aggregateDataCanvas.reset();
                EpidemicControl.this.newIncidenceCanvas.reset();
                CSVscenarioLoader cSVscenarioLoader = new CSVscenarioLoader();
                ReferenceScenarioDataMapImpl referenceScenarioDataMapImpl = null;
                try {
                    referenceScenarioDataMapImpl = cSVscenarioLoader.parseAggregateFile(filetextAggregate.getText());
                }
                catch (ScenarioInitializationException scenarioInitializationException) {
                    Activator.logError((String)scenarioInitializationException.getMessage(), (Throwable)scenarioInitializationException);
                }
                for (Object object32 : referenceScenarioDataMapImpl.getLocations()) {
                    object2 = referenceScenarioDataMapImpl.getLocation((String)object32);
                    object = object2.getData();
                    Object[] objectArray = EpidemicControl.this.filterDisplayableStates(object.keySet());
                    Arrays.sort(objectArray);
                    int n = 0;
                    while (n < objectArray.length) {
                        if (object.get(objectArray[n]) != null) {
                            EpidemicControl.this.aggregateData.add((List)object.get(objectArray[n]));
                            EpidemicControl.this.primaryPropertiesToPlot.add((String)objectArray[n]);
                        }
                        ++n;
                    }
                    epidemicControl.aggregateDataCanvas.draw();
                }
                object32 = null;
                try {
                    object32 = cSVscenarioLoader.processIncidenceFile(filetextIncidence.getText());
                }
                catch (ScenarioInitializationException scenarioInitializationException) {
                    Activator.logError((String)scenarioInitializationException.getMessage(), (Throwable)scenarioInitializationException);
                }
                EpidemicControl.this.incidenceData = new ArrayList<List<Double>>();
                int n = 0;
                while (n < incidenceStates.length) {
                    if (object32.get(incidenceStates[n]) != null) {
                        object2 = new ArrayList();
                        object = (List)object32.get(incidenceStates[n]);
                        int n2 = 0;
                        while (n2 < object.size()) {
                            try {
                                Double d = new Double((String)object.get(n2));
                                if (d != null) {
                                    object2.add(d);
                                }
                            }
                            catch (Exception exception) {}
                            ++n2;
                        }
                        if (object2.size() >= 1) {
                            EpidemicControl.this.incidenceData.add((List<Double>)object2);
                        }
                        EpidemicControl.this.secondaryPropertiesToPlot.add(incidenceStates[n]);
                    }
                    ++n;
                }
                epidemicControl.newIncidenceCanvas.draw();
            }
        });
        statusLabel = new Label((Composite)this, 2048);
        statusLabel.setBackground(color);
        statusLabel.setText("");
        this.aggregateDataCanvas = new TimeSeriesCanvas(this, Messages.getString("EPIVIEW.AGGREGATELEGEND"), Messages.getString("EPIVIEW.YAXIS"), AggregateDataWriter.getKeyS(), foreGround, backgroundGround, frameColor, 0);
        FormData formData16 = new FormData();
        this.aggregateDataCanvas.setLayoutData(formData16);
        formData16.top = new FormAttachment(n += 5, 0);
        formData16.bottom = new FormAttachment(100, 0);
        formData16.left = new FormAttachment(0, 0);
        formData16.right = new FormAttachment(50, 0);
        this.newIncidenceCanvas = new TimeSeriesCanvas(this, Messages.getString("INCVIEW.INCIDENCELEGEND"), Messages.getString("INCVIEW.YAXIS"), incidenceStates[0], foreGround, backgroundGround, frameColor, 1);
        FormData formData17 = new FormData();
        this.newIncidenceCanvas.setLayoutData(formData17);
        formData17.top = new FormAttachment(n, 0);
        formData17.bottom = new FormAttachment(100, 0);
        formData17.left = new FormAttachment(50, 0);
        formData17.right = new FormAttachment(100, 0);
    }

    Composite getAggregateButtonComposite(AnalysisControl analysisControl, String string) {
        Composite composite = new Composite((Composite)analysisControl, 2048);
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 256;
        composite.setLayout((Layout)fillLayout);
        Label label = new Label(composite, 0);
        label.setText(" ");
        this.aggregateButton = new Button(composite, 0);
        this.aggregateButton.setText(string);
        Label label2 = new Label(composite, 0);
        label2.setText(" ");
        this.aggregateButton.setEnabled(true);
        return composite;
    }

    Composite getPlotButtonComposite(AnalysisControl analysisControl, String string) {
        Composite composite = new Composite((Composite)analysisControl, 2048);
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 256;
        composite.setLayout((Layout)fillLayout);
        this.userMessageLabel = new Label(composite, 0);
        this.userMessageLabel.setText(this.userMessage);
        this.plotButton = new Button(composite, 0);
        this.plotButton.setText(string);
        Label label = new Label(composite, 0);
        label.setText(" ");
        this.plotButton.setEnabled(true);
        return composite;
    }

    public void enableAnalysis(boolean bl) {
        if (bl) {
            this.analyzeButton.setEnabled(true);
        } else {
            this.analyzeButton.setEnabled(false);
        }
    }

    @Override
    public void remove() {
        this.updateStatusLabel();
    }

    protected void updateStatusLabel() {
        statusLabel.setText("status");
    }

    @Override
    protected void initializeHeader(String string) {
        this.simulationNameLabel.setText("analyzing " + string);
    }

    public void dispose() {
        super.dispose();
    }

    public Identifiable getIdentifiable() {
        return null;
    }

    @Override
    public double[] getValues(int n, int n2) {
        List<List<Double>> list = this.aggregateData;
        if (n >= 1) {
            list = this.incidenceData;
        }
        double[] dArray = new double[list.get(n2).size()];
        int n3 = 0;
        for (double d : list.get(n2)) {
            dArray[n3++] = d;
        }
        return dArray;
    }

    @Override
    public String getProperty(int n, int n2) {
        if (n == 0) {
            return this.primaryPropertiesToPlot.get(n2);
        }
        return this.secondaryPropertiesToPlot.get(n2);
    }

    @Override
    public int getNumProperties(int n) {
        if (n == 0) {
            return this.primaryPropertiesToPlot.size();
        }
        return this.secondaryPropertiesToPlot.size();
    }

    protected String[] filterDisplayableStates(Set<String> set) {
        int n = 0;
        while (n < OMIT_LIST.length) {
            set.remove(OMIT_LIST[n]);
            ++n;
        }
        Object[] objectArray = new String[set.size()];
        int n2 = 0;
        Iterator<String> iterator = set.iterator();
        while (iterator != null && iterator.hasNext()) {
            String string = iterator.next();
            objectArray[n2] = string;
            ++n2;
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    @Override
    public Map<String, Object> getControlParametersMap() {
        return controlParametersMap;
    }
}

