/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Anchor;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.TextDataSet;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.BarSeries;
import org.eclipse.birt.chart.model.type.impl.BarSeriesImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.stem.util.analysis.Activator;
import org.eclipse.stem.util.analysis.Parameter;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EstimatorCanvas
extends Canvas {
    protected IDeviceRenderer idr = null;
    protected Chart cm = null;
    static ColorDefinition[] barColors = new ColorDefinition[]{ColorDefinitionImpl.RED(), ColorDefinitionImpl.BLUE(), ColorDefinitionImpl.ORANGE(), ColorDefinitionImpl.YELLOW(), ColorDefinitionImpl.GREEN(), ColorDefinitionImpl.PINK(), ColorDefinitionImpl.BLACK()};
    private static final String TITLE = "Estimated Parameters";
    private static final String VALUES = "Parameter Values";
    private static final String VALUES_LOWER = "Value - Std.Dev.";
    private static final String VALUES_HIGHER = "Value + Std.Dev.";
    private static final boolean SHOW_STD_DEV = false;
    private static Vector<String> xAxisParameterNames = new Vector();
    private static ArrayList<Double> barValues = new ArrayList();
    private static NumberDataSet barOrthoValues;
    private static ArrayList<Double> barStdDevLower;
    private static ArrayList<Double> barStdDevHigher;
    private static NumberDataSet barOrthoStdDevLower;
    private static NumberDataSet barOrthoStdDevHigher;
    Generator gr = Generator.instance();
    Image imgChart = null;

    static {
        barStdDevLower = new ArrayList();
        barStdDevHigher = new ArrayList();
    }

    public EstimatorCanvas(Composite composite) {
        super(composite, 0x20000800);
        try {
            this.idr = PluginSettings.instance().getDevice("dv.SWT");
        }
        catch (ChartException chartException) {
            Activator.logError("Problem initializing chart", chartException);
            return;
        }
        Vector<String> vector = new Vector<String>();
        vector.add("beta");
        vector.add("alpha");
        vector.add("epsilon");
        vector.add("gamma");
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                if (EstimatorCanvas.this.cm == null) {
                    return;
                }
                Composite composite = (Composite)paintEvent.getSource();
                Rectangle rectangle = composite.getClientArea();
                if (EstimatorCanvas.this.imgChart != null) {
                    EstimatorCanvas.this.imgChart.dispose();
                }
                EstimatorCanvas.this.imgChart = new Image((Device)composite.getDisplay(), rectangle);
                EstimatorCanvas.this.idr.setProperty("device.output.context", (Object)new GC((Drawable)EstimatorCanvas.this.imgChart));
                Bounds bounds = BoundsImpl.create((double)rectangle.x, (double)rectangle.y, (double)rectangle.width, (double)rectangle.height);
                bounds.scale(72.0 / (double)EstimatorCanvas.this.idr.getDisplayServer().getDpiResolution());
                try {
                    EstimatorCanvas.this.gr.render(EstimatorCanvas.this.idr, EstimatorCanvas.this.gr.build(EstimatorCanvas.this.idr.getDisplayServer(), EstimatorCanvas.this.cm, bounds, null, null, null));
                    paintEvent.gc.drawImage(EstimatorCanvas.this.imgChart, rectangle.x, rectangle.y);
                }
                catch (ChartException chartException) {
                    Activator.logError("Problem rendering chart", chartException);
                }
            }
        });
    }

    public static Chart createBarChart(Map<String, Parameter> map) {
        Double d;
        Object object;
        xAxisParameterNames.clear();
        barValues.clear();
        barStdDevLower.clear();
        barStdDevHigher.clear();
        ChartWithAxes chartWithAxes = ChartWithAxesImpl.create();
        chartWithAxes.getBlock().setBackground((Fill)ColorDefinitionImpl.WHITE());
        chartWithAxes.getBlock().getOutline().setVisible(true);
        chartWithAxes.setDimension(ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL);
        Plot plot = chartWithAxes.getPlot();
        plot.getClientArea().setBackground((Fill)ColorDefinitionImpl.create((int)255, (int)255, (int)225));
        plot.getOutline().setVisible(false);
        chartWithAxes.getTitle().getLabel().getCaption().setValue(TITLE);
        Legend legend = chartWithAxes.getLegend();
        legend.getText().getFont().setSize(16.0f);
        legend.getInsets().set(10.0, 5.0, 0.0, 0.0);
        legend.setAnchor(Anchor.NORTH_LITERAL);
        Axis axis = chartWithAxes.getPrimaryBaseAxes()[0];
        axis.setType(AxisType.TEXT_LITERAL);
        axis.getMajorGrid().setTickStyle(TickStyle.BELOW_LITERAL);
        axis.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        axis.getTitle().setVisible(false);
        Axis axis2 = chartWithAxes.getPrimaryOrthogonalAxis(axis);
        axis2.getMajorGrid().setTickStyle(TickStyle.LEFT_LITERAL);
        axis2.setType(AxisType.LINEAR_LITERAL);
        axis2.getLabel().getCaption().getFont().setRotation(90.0);
        Set<String> set = map.keySet();
        Object[] objectArray = new String[set.size()];
        Iterator<String> iterator = set.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            objectArray[n] = iterator.next();
            ++n;
        }
        Arrays.sort(objectArray);
        int n2 = 0;
        while (n2 < objectArray.length) {
            object = objectArray[n2];
            xAxisParameterNames.add((String)object);
            d = new Double(map.get((Object)object).value);
            barStdDevLower.add(d);
            barValues.add(d);
            barStdDevHigher.add(d);
            ++n2;
        }
        TextDataSet textDataSet = TextDataSetImpl.create(xAxisParameterNames);
        barOrthoValues = NumberDataSetImpl.create(barValues);
        barOrthoStdDevLower = NumberDataSetImpl.create(barStdDevLower);
        barOrthoStdDevHigher = NumberDataSetImpl.create(barStdDevHigher);
        object = SeriesImpl.create();
        object.setDataSet((DataSet)textDataSet);
        d = (BarSeries)BarSeriesImpl.create();
        d.setSeriesIdentifier(VALUES_LOWER);
        d.setDataSet((DataSet)barOrthoStdDevLower);
        d.setRiserOutline(null);
        d.getLabel().setVisible(true);
        d.setLabelPosition(Position.INSIDE_LITERAL);
        BarSeries barSeries = (BarSeries)BarSeriesImpl.create();
        barSeries.setSeriesIdentifier((Object)VALUES);
        barSeries.setDataSet((DataSet)barOrthoValues);
        barSeries.setRiserOutline(null);
        barSeries.getLabel().setVisible(true);
        barSeries.setLabelPosition(Position.INSIDE_LITERAL);
        BarSeries barSeries2 = (BarSeries)BarSeriesImpl.create();
        barSeries2.setSeriesIdentifier((Object)VALUES_HIGHER);
        barSeries2.setDataSet((DataSet)barOrthoStdDevHigher);
        barSeries2.setRiserOutline(null);
        barSeries2.getLabel().setVisible(true);
        barSeries2.setLabelPosition(Position.INSIDE_LITERAL);
        SeriesDefinition seriesDefinition = SeriesDefinitionImpl.create();
        seriesDefinition.getSeriesPalette().update(0);
        axis.getSeriesDefinitions().add((Object)seriesDefinition);
        seriesDefinition.getSeries().add(object);
        SeriesDefinition seriesDefinition2 = SeriesDefinitionImpl.create();
        seriesDefinition2.getSeriesPalette().update(1);
        axis2.getSeriesDefinitions().add((Object)seriesDefinition2);
        seriesDefinition2.getSeries().add((Object)barSeries);
        return chartWithAxes;
    }

    public static void refresh(Map<String, Parameter> map) {
        for (String string : map.keySet()) {
            int n = xAxisParameterNames.indexOf(string);
            if (n < 0) continue;
            double d = map.get((Object)string).value;
            double d2 = map.get((Object)string).stddev;
            Double d3 = new Double(d - d2);
            Double d4 = new Double(d + d2);
            barValues.set(n, new Double(d));
            barStdDevLower.set(n, d3);
            barStdDevHigher.set(n, d4);
        }
    }

    public void draw(Map<String, Parameter> map) {
        this.cm = EstimatorCanvas.createBarChart(map);
        if (!this.isDisposed()) {
            this.redraw();
        }
    }

    public void dispose() {
        super.dispose();
    }
}

