/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis.views;

import java.util.List;
import java.util.Map;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.stem.analysis.impl.ReferenceScenarioDataMapImpl;
import org.eclipse.stem.analysis.util.CSVscenarioLoader;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.definitions.Activator;
import org.eclipse.stem.util.analysis.AggregateDataWriter;
import org.eclipse.stem.util.analysis.ModelParameters;
import org.eclipse.stem.util.analysis.ParameterEstimatorMethod;
import org.eclipse.stem.util.analysis.ScenarioAnalysisSuite;
import org.eclipse.stem.util.analysis.views.AnalysisControl;
import org.eclipse.stem.util.analysis.views.EstimatorCanvas;
import org.eclipse.stem.util.analysis.views.Messages;
import org.eclipse.stem.util.analysis.views.ParameterEstimatorWizard;
import org.eclipse.stem.util.analysis.views.TimeSeriesCanvas;
import org.eclipse.stem.util.analysis.views.XYSeriesCanvas;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EstimatorControl
extends AnalysisControl {
    String recentFolder;
    private static final String CONSUMER = "ESTIMATOR_CONTROL";
    static Label scenarioFolderLabel;
    static Label estimatorFolderLabel;
    public static Text text1;
    public static Text estimatorText;
    static Label statusLabel;
    public static Button[] dataAverageRadioButtons;
    public static Button[] betaModeRadioButtons;
    private static final int SPINNER_RESOLUTION = 1000;
    private static final int SPINNER_INCREMENT = 1;
    protected static Spinner minThresholdSpinnerS;
    protected static Spinner maxThresholdSpinnerS;
    static Label minSpinnerLabelS;
    static Label maxSpinnerLabelS;
    public static final String MIN_S_KEY = "MINS";
    public static final String MIN_E_KEY = "MINE";
    public static final String MIN_I_KEY = "MINI";
    public static final String MIN_R_KEY = "MINR";
    public static final String MAX_S_KEY = "MAXS";
    public static final String MAX_E_KEY = "MAXE";
    public static final String MAX_I_KEY = "MAXI";
    public static final String MAX_R_KEY = "MAXR";
    public static final String SUM_LOCATIONS_KEY = "SUM_LOCATIONS";
    public static final String FREQ_MODE_KEY = "FREQ_MODE";
    protected static Combo displayRegionCombo;
    protected static String regionToDisplay;
    protected static Spinner minThresholdSpinnerE;
    protected static Spinner maxThresholdSpinnerE;
    static Label minSpinnerLabelE;
    static Label maxSpinnerLabelE;
    protected static Spinner minThresholdSpinnerI;
    protected static Spinner maxThresholdSpinnerI;
    static Label minSpinnerLabelI;
    static Label maxSpinnerLabelI;
    protected static Spinner minThresholdSpinnerR;
    protected static Spinner maxThresholdSpinnerR;
    static Label minSpinnerLabelR;
    static Label maxSpinnerLabelR;
    static ModelParameters averageParms;
    static TabFolder tabFolder;
    static EstimatorCanvas estimatorCanvas;
    static final ColorDefinition foreGround;
    static final ColorDefinition backgroundGround;
    static final ColorDefinition frameColor;
    protected static TimeSeriesCanvas[] equationSeries;
    protected static XYSeriesCanvas[] regressionSeries;
    static ParameterEstimatorWizard parameterEstimatorWizard;
    static WizardDialog wizardDialog;
    protected static ScenarioAnalysisSuite analyzer;
    List<ItemPropertyDescriptor> selectedProperties;

    static {
        dataAverageRadioButtons = new Button[2];
        betaModeRadioButtons = new Button[2];
        regionToDisplay = "";
        foreGround = ColorDefinitionImpl.create((int)180, (int)0, (int)0);
        backgroundGround = ColorDefinitionImpl.create((int)255, (int)255, (int)225);
        frameColor = ColorDefinitionImpl.WHITE();
        equationSeries = new TimeSeriesCanvas[4];
        regressionSeries = new XYSeriesCanvas[4];
    }

    public EstimatorControl(Composite composite) {
        super(composite, 0);
        this.createContents();
    }

    void createContents() {
        analyzer = new ScenarioAnalysisSuite(this);
        this.setLayout((Layout)new FormLayout());
        this.identifiableTitle = new Label((Composite)this, 0);
        this.identifiableTitle.setText(Messages.getString("EST.TITLE"));
        Display display = this.getDisplay();
        Color color = new Color((Device)display, new RGB(180, 180, 200));
        statusLabel = new Label((Composite)this, 2048);
        statusLabel.setBackground(color);
        statusLabel.setText("");
        scenarioFolderLabel = new Label((Composite)this, 2048);
        scenarioFolderLabel.setBackground(color);
        scenarioFolderLabel.setText(Messages.getString("EST.SCFOLDER"));
        estimatorFolderLabel = new Label((Composite)this, 2048);
        estimatorFolderLabel.setBackground(color);
        estimatorFolderLabel.setText(Messages.getString("EST.PARAMESTIMATOR"));
        text1 = new Text((Composite)this, 2048);
        text1.setBounds(10, 10, 100, 20);
        this.recentFolder = this.prefs.getRecentFolder(CONSUMER);
        if (this.recentFolder == null) {
            this.recentFolder = ScenarioAnalysisSuite.REFERENCE_TESTING_DIRECTORY;
        }
        text1.setText(this.recentFolder);
        String string = this.prefs.getRecentEstimatorMethod();
        estimatorText = new Text((Composite)this, 2048);
        estimatorText.setBounds(10, 10, 100, 20);
        if (string != null) {
            estimatorText.setText(string);
        } else {
            estimatorText.setText("");
        }
        this.selectEstimatorButton = new Button((Composite)this, 0);
        this.selectEstimatorButton.setText(Messages.getString("EST.SELECTESTIMATOR"));
        Composite composite = this.getRegionSelectorComboComposite(this);
        Composite composite2 = this.getDataAvgRadioButtonsComposite(this);
        Composite composite3 = this.getSpinnerComposite(this);
        Composite composite4 = this.getbetaModeRadioButtonsComposite(this);
        Composite composite5 = this.getAnalyzeButtonComposite(this, Messages.getString("EST.ESTIMATE"));
        tabFolder = new TabFolder((Composite)this, 0);
        TabItem tabItem = new TabItem(tabFolder, 2048);
        tabItem.setText(Messages.getString("EST.RESULTS"));
        estimatorCanvas = new EstimatorCanvas((Composite)tabFolder);
        tabItem.setControl((Control)estimatorCanvas);
        TabItem tabItem2 = new TabItem(tabFolder, 0);
        tabItem2.setText(Messages.getString("EST.INPUTDATA"));
        Composite composite6 = new Composite((Composite)tabFolder, 2048);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite6.setLayout((Layout)new FormLayout());
        tabItem2.setControl((Control)composite6);
        this.getEquationSeriesCharts(composite6);
        TabItem tabItem3 = new TabItem(tabFolder, 0);
        tabItem3.setText(Messages.getString("EST.REGRESSION"));
        Composite composite7 = new Composite((Composite)tabFolder, 2048);
        composite7.setLayout((Layout)new FormLayout());
        tabItem3.setControl((Control)composite7);
        this.getRegressionSeriesCharts(composite7);
        int n = 5;
        FormData formData = new FormData();
        this.identifiableTitle.setLayoutData((Object)formData);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(n, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        FormData formData2 = new FormData();
        formData2.top = new FormAttachment((Control)this.identifiableTitle, 0);
        formData2.bottom = new FormAttachment(n += 5, 0);
        formData2.left = new FormAttachment(0, 0);
        formData2.right = new FormAttachment(15, 0);
        scenarioFolderLabel.setLayoutData((Object)formData2);
        FormData formData3 = new FormData();
        formData3.top = new FormAttachment((Control)this.identifiableTitle, 0);
        formData3.bottom = new FormAttachment(n, 0);
        formData3.left = new FormAttachment((Control)scenarioFolderLabel, 0);
        formData3.right = new FormAttachment(80, 0);
        text1.setLayoutData((Object)formData3);
        text1.setEditable(false);
        FormData formData4 = new FormData();
        formData4.top = new FormAttachment((Control)this.identifiableTitle, 0);
        formData4.bottom = new FormAttachment(n, 0);
        formData4.left = new FormAttachment((Control)text1, 0);
        formData4.right = new FormAttachment(100, 0);
        this.selectEstimatorButton.setLayoutData((Object)formData4);
        FormData formData5 = new FormData();
        formData5.top = new FormAttachment((Control)scenarioFolderLabel, 0);
        formData5.bottom = new FormAttachment(n += 5, 0);
        formData5.left = new FormAttachment(0, 0);
        formData5.right = new FormAttachment(15, 0);
        estimatorFolderLabel.setLayoutData((Object)formData5);
        FormData formData6 = new FormData();
        formData6.top = new FormAttachment((Control)scenarioFolderLabel, 0);
        formData6.bottom = new FormAttachment(n, 0);
        formData6.left = new FormAttachment((Control)scenarioFolderLabel, 0);
        formData6.right = new FormAttachment(100, 0);
        estimatorText.setLayoutData((Object)formData6);
        estimatorText.setEditable(false);
        int n2 = n;
        FormData formData7 = new FormData();
        formData7.top = new FormAttachment((Control)estimatorText, 0);
        formData7.bottom = new FormAttachment(n += 10, 0);
        formData7.left = new FormAttachment(5, 0);
        formData7.right = new FormAttachment(24, 0);
        composite.setLayoutData((Object)formData7);
        FormData formData8 = new FormData();
        formData8.top = new FormAttachment((Control)estimatorText, 0);
        formData8.bottom = new FormAttachment(n, 0);
        formData8.left = new FormAttachment(25, 0);
        formData8.right = new FormAttachment(39, 0);
        composite4.setLayoutData((Object)formData8);
        FormData formData9 = new FormData();
        formData9.top = new FormAttachment((Control)estimatorText, 0);
        formData9.bottom = new FormAttachment(n, 0);
        formData9.left = new FormAttachment(40, 0);
        formData9.right = new FormAttachment(61, 0);
        composite2.setLayoutData((Object)formData9);
        FormData formData10 = new FormData();
        formData10.top = new FormAttachment(n2, 0);
        formData10.bottom = new FormAttachment(n, 0);
        formData10.left = new FormAttachment(62, 0);
        formData10.right = new FormAttachment(100, 0);
        composite3.setLayoutData((Object)formData10);
        n2 = n;
        FormData formData11 = new FormData();
        formData11.top = new FormAttachment((Control)composite2, 0);
        formData11.bottom = new FormAttachment(n += 5, 0);
        formData11.left = new FormAttachment(0, 0);
        formData11.right = new FormAttachment(100, 0);
        composite5.setLayoutData((Object)formData11);
        if (this.recentFolder != null && string != null) {
            this.analyzeButton.setEnabled(true);
        } else {
            this.analyzeButton.setEnabled(false);
        }
        n += 40;
        FormData formData12 = new FormData();
        tabFolder.setLayoutData((Object)formData12);
        formData12.top = new FormAttachment((Control)composite5, 0);
        formData12.bottom = new FormAttachment(100, 0);
        formData12.left = new FormAttachment(0, 0);
        formData12.right = new FormAttachment(100, 0);
        final Shell shell = this.getShell();
        final EstimatorControl estimatorControl = this;
        this.selectEstimatorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = null;
                string = parameterEstimatorWizard != null ? EstimatorControl.parameterEstimatorWizard.selectFolderPage.getDirName() : EstimatorControl.this.recentFolder;
                parameterEstimatorWizard = new ParameterEstimatorWizard(estimatorControl, string);
                wizardDialog = new WizardDialog(shell, (IWizard)parameterEstimatorWizard);
                wizardDialog.create();
                estimatorControl.analyzeButton.setEnabled(false);
                estimatorText.setText("");
                wizardDialog.open();
            }
        });
        final ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.getShell());
        this.analyzeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String[] stringArray;
                ParameterEstimatorMethod parameterEstimatorMethod;
                ReferenceScenarioDataMapImpl referenceScenarioDataMapImpl;
                EstimatorControl.this.recentFolder = text1.getText();
                String string = estimatorText.getText();
                EstimatorControl.this.identifiableTitle.setText(Messages.getString("EST.TITLE"));
                if (!analyzer.validate(EstimatorControl.this.recentFolder)) {
                    EstimatorControl.this.identifiableTitle.setText(ScenarioAnalysisSuite.NOT_FOUND_MSG);
                    text1.setText("");
                    return;
                }
                EstimatorControl.this.prefs.setRecentFolder(EstimatorControl.CONSUMER, EstimatorControl.this.recentFolder);
                EstimatorControl.this.prefs.setEstimatorMethod(string);
                if (parameterEstimatorWizard != null) {
                    referenceScenarioDataMapImpl = parameterEstimatorWizard.getReferenceScenarioDataMap();
                    parameterEstimatorMethod = parameterEstimatorWizard.getParameterEstimatorMethod();
                } else {
                    try {
                        stringArray = new CSVscenarioLoader(EstimatorControl.this.recentFolder);
                        int n = stringArray.getMaxResolution();
                        referenceScenarioDataMapImpl = stringArray.parseAllFiles(n);
                        parameterEstimatorMethod = ParameterEstimatorMethod.valueOf(string);
                    }
                    catch (Exception exception) {
                        Activator.logError((String)exception.getMessage(), (Throwable)exception);
                        return;
                    }
                }
                averageParms = analyzer.estimateParameters(referenceScenarioDataMapImpl, parameterEstimatorMethod, (IRunnableContext)progressMonitorDialog);
                stringArray = averageParms.getDataLocations();
                displayRegionCombo.setItems(stringArray);
                displayRegionCombo.select(0);
                regionToDisplay = stringArray[0];
                EstimatorControl.updateCharts();
            }
        });
        maxThresholdSpinnerS.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = maxThresholdSpinnerS.getSelection();
                int n2 = minThresholdSpinnerS.getSelection();
                int n3 = n - 1;
                int n4 = n2 + 1;
                maxThresholdSpinnerS.setMinimum(n4);
                minThresholdSpinnerS.setMaximum(n3);
            }
        });
        minThresholdSpinnerS.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = maxThresholdSpinnerS.getSelection();
                int n2 = minThresholdSpinnerS.getSelection();
                int n3 = n - 1;
                int n4 = n2 + 1;
                maxThresholdSpinnerS.setMinimum(n4);
                minThresholdSpinnerS.setMaximum(n3);
            }
        });
    }

    Composite getDataAvgRadioButtonsComposite(EstimatorControl estimatorControl) {
        Composite composite = new Composite((Composite)estimatorControl, 2048);
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 512;
        composite.setLayout((Layout)fillLayout);
        EstimatorControl.dataAverageRadioButtons[0] = new Button(composite, 16);
        dataAverageRadioButtons[0].setSelection(true);
        dataAverageRadioButtons[0].setText(Messages.getString("EST.CHOICE1"));
        dataAverageRadioButtons[0].setBounds(10, 5, 75, 30);
        EstimatorControl.dataAverageRadioButtons[1] = new Button(composite, 16);
        dataAverageRadioButtons[1].setText(Messages.getString("EST.CHOICE2"));
        dataAverageRadioButtons[1].setBounds(10, 30, 75, 30);
        return composite;
    }

    Composite getbetaModeRadioButtonsComposite(EstimatorControl estimatorControl) {
        Composite composite = new Composite((Composite)estimatorControl, 2048);
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 512;
        composite.setLayout((Layout)fillLayout);
        EstimatorControl.betaModeRadioButtons[0] = new Button(composite, 16);
        betaModeRadioButtons[0].setSelection(true);
        betaModeRadioButtons[0].setText(Messages.getString("EST.FREQBETA"));
        betaModeRadioButtons[0].setBounds(10, 5, 75, 30);
        EstimatorControl.betaModeRadioButtons[1] = new Button(composite, 16);
        betaModeRadioButtons[1].setText(Messages.getString("EST.DENSITYBETA"));
        betaModeRadioButtons[1].setBounds(10, 30, 75, 30);
        return composite;
    }

    Composite getRegionSelectorComboComposite(EstimatorControl estimatorControl) {
        Composite composite = new Composite((Composite)estimatorControl, 2048);
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 512;
        composite.setLayout((Layout)fillLayout);
        displayRegionCombo = new Combo(composite, 8);
        displayRegionCombo.setItems(new String[]{Messages.getString("EST.AVERAGE")});
        displayRegionCombo.setSize(200, 200);
        displayRegionCombo.pack();
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("EST.DISPLAY"));
        displayRegionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                regionToDisplay = displayRegionCombo.getText();
                EstimatorControl.updateCharts();
            }
        });
        return composite;
    }

    protected static void updateCharts() {
        statusLabel.setText(Messages.getString("EST.COMPLETE"));
        estimatorCanvas.draw(averageParms.getParameters());
        int n = analyzer.getEstimator().getNumProperties();
        int n2 = 0;
        while (n2 < n) {
            equationSeries[n2].draw();
            regressionSeries[n2].draw();
            ++n2;
        }
    }

    Composite getSpinnerComposite(EstimatorControl estimatorControl) {
        Composite composite = new Composite((Composite)estimatorControl, 2048);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 8;
        composite.setLayout((Layout)gridLayout);
        maxThresholdSpinnerS = new Spinner(composite, 0);
        maxThresholdSpinnerS.setDigits(3);
        maxThresholdSpinnerS.setMinimum(1);
        maxThresholdSpinnerS.setMaximum(1000);
        maxThresholdSpinnerS.setIncrement(1);
        maxThresholdSpinnerS.setSelection(990);
        maxSpinnerLabelS = new Label(composite, 0);
        maxSpinnerLabelS.setText(Messages.getString("EST.MAXTHRESHOLDS"));
        maxThresholdSpinnerE = new Spinner(composite, 0);
        maxThresholdSpinnerE.setDigits(3);
        maxThresholdSpinnerE.setMinimum(1);
        maxThresholdSpinnerE.setMaximum(1000);
        maxThresholdSpinnerE.setIncrement(1);
        maxThresholdSpinnerE.setSelection(1000);
        maxSpinnerLabelE = new Label(composite, 0);
        maxSpinnerLabelE.setText(Messages.getString("EST.MAXTHRESHOLDE"));
        maxThresholdSpinnerI = new Spinner(composite, 0);
        maxThresholdSpinnerI.setDigits(3);
        maxThresholdSpinnerI.setMinimum(1);
        maxThresholdSpinnerI.setMaximum(1000);
        maxThresholdSpinnerI.setIncrement(1);
        maxThresholdSpinnerI.setSelection(1000);
        maxSpinnerLabelI = new Label(composite, 0);
        maxSpinnerLabelI.setText(Messages.getString("EST.MAXTHRESHOLDI"));
        maxThresholdSpinnerR = new Spinner(composite, 0);
        maxThresholdSpinnerR.setDigits(3);
        maxThresholdSpinnerR.setMinimum(1);
        maxThresholdSpinnerR.setMaximum(1000);
        maxThresholdSpinnerR.setIncrement(1);
        maxThresholdSpinnerR.setSelection(990);
        maxSpinnerLabelR = new Label(composite, 0);
        maxSpinnerLabelR.setText(Messages.getString("EST.MAXTHRESHOLDR"));
        minThresholdSpinnerS = new Spinner(composite, 0);
        minThresholdSpinnerS.setDigits(3);
        minThresholdSpinnerS.setMinimum(1);
        minThresholdSpinnerS.setMaximum(1000);
        minThresholdSpinnerS.setIncrement(1);
        minThresholdSpinnerS.setSelection(10);
        minSpinnerLabelS = new Label(composite, 0);
        minSpinnerLabelS.setText(Messages.getString("EST.MINTHRESHOLDS"));
        minThresholdSpinnerE = new Spinner(composite, 0);
        minThresholdSpinnerE.setDigits(3);
        minThresholdSpinnerE.setMinimum(1);
        minThresholdSpinnerE.setMaximum(1000);
        minThresholdSpinnerE.setIncrement(1);
        minThresholdSpinnerE.setSelection(100);
        minSpinnerLabelE = new Label(composite, 0);
        minSpinnerLabelE.setText(Messages.getString("EST.MINTHRESHOLDE"));
        minThresholdSpinnerI = new Spinner(composite, 0);
        minThresholdSpinnerI.setDigits(3);
        minThresholdSpinnerI.setMinimum(1);
        minThresholdSpinnerI.setMaximum(1000);
        minThresholdSpinnerI.setIncrement(1);
        minThresholdSpinnerI.setSelection(100);
        minSpinnerLabelI = new Label(composite, 0);
        minSpinnerLabelI.setText(Messages.getString("EST.MINTHRESHOLDI"));
        minThresholdSpinnerR = new Spinner(composite, 0);
        minThresholdSpinnerR.setDigits(3);
        minThresholdSpinnerR.setMinimum(1);
        minThresholdSpinnerR.setMaximum(1000);
        minThresholdSpinnerR.setIncrement(1);
        minThresholdSpinnerR.setSelection(1);
        minSpinnerLabelR = new Label(composite, 0);
        minSpinnerLabelR.setText(Messages.getString("EST.MINTHRESHOLDR"));
        composite.pack();
        return composite;
    }

    private void getEquationSeriesCharts(Composite composite) {
        EstimatorControl.equationSeries[0] = new TimeSeriesCanvas(this, composite, Messages.getString("EST.EQUATION1"), Messages.getString("EST.AXISLABEL1"), AggregateDataWriter.getKeyS(), foreGround, backgroundGround, frameColor, 0, true);
        FormData formData = new FormData();
        equationSeries[0].setLayoutData(formData);
        formData.top = new FormAttachment((Control)composite, 0);
        formData.bottom = new FormAttachment(50, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(50, 0);
        EstimatorControl.equationSeries[1] = new TimeSeriesCanvas(this, composite, Messages.getString("EST.EQUATION3"), Messages.getString("EST.AXISLABEL3"), AggregateDataWriter.getKeyI(), foreGround, backgroundGround, frameColor, 1, true);
        FormData formData2 = new FormData();
        equationSeries[1].setLayoutData(formData2);
        formData2.top = new FormAttachment(51, 0);
        formData2.bottom = new FormAttachment(100, 0);
        formData2.left = new FormAttachment(0, 0);
        formData2.right = new FormAttachment(50, 0);
        EstimatorControl.equationSeries[2] = new TimeSeriesCanvas(this, composite, Messages.getString("EST.EQUATION4"), Messages.getString("EST.AXISLABEL4"), AggregateDataWriter.getKeyR(), foreGround, backgroundGround, frameColor, 2, true);
        FormData formData3 = new FormData();
        equationSeries[2].setLayoutData(formData3);
        formData3.top = new FormAttachment(51, 0);
        formData3.bottom = new FormAttachment(100, 0);
        formData3.left = new FormAttachment(51, 0);
        formData3.right = new FormAttachment(100, 0);
        EstimatorControl.equationSeries[3] = new TimeSeriesCanvas(this, composite, Messages.getString("EST.EQUATION2"), Messages.getString("EST.AXISLABEL2"), AggregateDataWriter.getKeyE(), foreGround, backgroundGround, frameColor, 3, true);
        FormData formData4 = new FormData();
        equationSeries[3].setLayoutData(formData4);
        formData4.top = new FormAttachment((Control)composite, 0);
        formData4.bottom = new FormAttachment(50, 0);
        formData4.left = new FormAttachment(51, 0);
        formData4.right = new FormAttachment(100, 0);
    }

    private void getRegressionSeriesCharts(Composite composite) {
        EstimatorControl.regressionSeries[0] = new XYSeriesCanvas(this, composite, Messages.getString("EST.EQUATION1"), Messages.getString("EST.RAXISLABEL1"), foreGround, backgroundGround, frameColor, 0);
        FormData formData = new FormData();
        regressionSeries[0].setLayoutData(formData);
        formData.top = new FormAttachment((Control)composite, 0);
        formData.bottom = new FormAttachment(50, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(50, 0);
        EstimatorControl.regressionSeries[1] = new XYSeriesCanvas(this, composite, Messages.getString("EST.EQUATION3"), Messages.getString("EST.RAXISLABEL3"), foreGround, backgroundGround, frameColor, 1);
        FormData formData2 = new FormData();
        regressionSeries[1].setLayoutData(formData2);
        formData2.top = new FormAttachment(51, 0);
        formData2.bottom = new FormAttachment(100, 0);
        formData2.left = new FormAttachment(0, 0);
        formData2.right = new FormAttachment(50, 0);
        EstimatorControl.regressionSeries[2] = new XYSeriesCanvas(this, composite, Messages.getString("EST.EQUATION4"), Messages.getString("EST.RAXISLABEL4"), foreGround, backgroundGround, frameColor, 2);
        FormData formData3 = new FormData();
        regressionSeries[2].setLayoutData(formData3);
        formData3.top = new FormAttachment(51, 0);
        formData3.bottom = new FormAttachment(100, 0);
        formData3.left = new FormAttachment(51, 0);
        formData3.right = new FormAttachment(100, 0);
        EstimatorControl.regressionSeries[3] = new XYSeriesCanvas(this, composite, Messages.getString("EST.EQUATION2"), Messages.getString("EST.RAXISLABEL2"), foreGround, backgroundGround, frameColor, 3);
        FormData formData4 = new FormData();
        regressionSeries[3].setLayoutData(formData4);
        formData4.top = new FormAttachment((Control)composite, 0);
        formData4.bottom = new FormAttachment(50, 0);
        formData4.left = new FormAttachment(51, 0);
        formData4.right = new FormAttachment(100, 0);
    }

    public void enableAnalysis(boolean bl) {
        if (bl) {
            this.analyzeButton.setEnabled(true);
        } else {
            this.analyzeButton.setEnabled(false);
        }
    }

    @Override
    public void remove() {
        this.updateStatusLabel();
    }

    protected void updateStatusLabel() {
        statusLabel.setText("status");
    }

    @Override
    protected void initializeHeader(String string) {
        this.simulationNameLabel.setText("analyzing " + string);
    }

    public void dispose() {
        super.dispose();
    }

    public Identifiable getIdentifiable() {
        return null;
    }

    @Override
    public double[] getValues(int n, int n2) {
        if (n2 <= 1) {
            return averageParms.getDataValues(regionToDisplay, n, n2);
        }
        if (n2 <= 3) {
            return averageParms.getRegressionValues(regionToDisplay, n, n2 - 2);
        }
        return averageParms.getFittedValues(regionToDisplay, n, n2 - 4);
    }

    @Override
    public String getProperty(int n, int n2) {
        return analyzer.getEstimator().getProperty(n, n2);
    }

    public double getMaxThresholdS() {
        double d = maxThresholdSpinnerS.getSelection();
        double d2 = 1000.0;
        return d / d2;
    }

    public double getMinThresholdS() {
        double d = minThresholdSpinnerS.getSelection();
        double d2 = 1000.0;
        return d / d2;
    }

    public double getMaxThresholdE() {
        double d = maxThresholdSpinnerE.getSelection();
        double d2 = 1000.0;
        return d / d2;
    }

    public double getMinThresholdE() {
        double d = minThresholdSpinnerE.getSelection();
        double d2 = 1000.0;
        return d / d2;
    }

    public double getMaxThresholdI() {
        double d = maxThresholdSpinnerI.getSelection();
        double d2 = 1000.0;
        return d / d2;
    }

    public double getMinThresholdI() {
        double d = minThresholdSpinnerI.getSelection();
        double d2 = 1000.0;
        return d / d2;
    }

    public double getMaxThresholdR() {
        double d = maxThresholdSpinnerR.getSelection();
        double d2 = 1000.0;
        return d / d2;
    }

    public double getMinThresholdR() {
        double d = minThresholdSpinnerR.getSelection();
        double d2 = 1000.0;
        return d / d2;
    }

    @Override
    public int getNumProperties(int n) {
        if (analyzer != null) {
            return 2;
        }
        return 0;
    }

    @Override
    public Map<String, Object> getControlParametersMap() {
        controlParametersMap.put(MIN_S_KEY, new Double(this.getMinThresholdS()));
        controlParametersMap.put(MIN_E_KEY, new Double(this.getMinThresholdE()));
        controlParametersMap.put(MIN_I_KEY, new Double(this.getMinThresholdI()));
        controlParametersMap.put(MIN_R_KEY, new Double(this.getMinThresholdR()));
        controlParametersMap.put(MAX_S_KEY, new Double(this.getMaxThresholdS()));
        controlParametersMap.put(MAX_E_KEY, new Double(this.getMaxThresholdE()));
        controlParametersMap.put(MAX_I_KEY, new Double(this.getMaxThresholdI()));
        controlParametersMap.put(MAX_R_KEY, new Double(this.getMaxThresholdR()));
        boolean bl = dataAverageRadioButtons[1].getSelection();
        boolean bl2 = betaModeRadioButtons[0].getSelection();
        controlParametersMap.put(SUM_LOCATIONS_KEY, new Boolean(bl));
        controlParametersMap.put(FREQ_MODE_KEY, new Boolean(bl2));
        return controlParametersMap;
    }
}

