/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis.views;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.stem.analysis.ScenarioInitializationException;
import org.eclipse.stem.diseasemodels.Activator;
import org.eclipse.stem.util.analysis.CSVAnalysisWriter;
import org.eclipse.stem.util.analysis.PhaseSpaceCoordinate;
import org.eclipse.stem.util.analysis.ScenarioAnalysisSuite;
import org.eclipse.stem.util.analysis.views.AnalysisControl;
import org.eclipse.stem.util.analysis.views.LyapunovTrajectoryCanvas;
import org.eclipse.stem.util.analysis.views.Messages;
import org.eclipse.stem.util.analysis.views.TimeSeriesCanvas;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LyapunovControl
extends AnalysisControl {
    private static final String CONSUMER = "LYAPUNOV_CONTROL";
    private static final String PRIMARY_FOLDER_KEY = "LYAPUNOV_CONTROL_PRIMARY";
    private static final String SECONDARY_FOLDER_KEY = "LYAPUNOV_CONTROL_SECONDARY";
    Label firstScenarioFolderLabel;
    Label secondScenarioFolderLabel;
    Text text1;
    Text text2;
    Label statusLabel;
    Label resultsLabel;
    LyapunovTrajectoryCanvas lyapunovTrajectoryCanvas;
    TimeSeriesCanvas timeSeriesCanvas;
    static final ColorDefinition foreGround = ColorDefinitionImpl.create((int)180, (int)0, (int)0);
    static final ColorDefinition backgroundGround = ColorDefinitionImpl.create((int)255, (int)255, (int)225);
    static final ColorDefinition frameColor = ColorDefinitionImpl.WHITE();
    List<PhaseSpaceCoordinate[]> comparisonValues = new ArrayList<PhaseSpaceCoordinate[]>();
    List<EList<Double>> cumulativeDeviation = new ArrayList<EList<Double>>();
    private static final String LYAPUNOV_FILE_PREFIX = "LyapunovAnalysis";
    private static final String LYAPUNOV_DEVIATION_FILE_PREFIX = "LyapunovDeviation";
    private static final String SELECT_FOLDER_DIALOG_TEXT = "Pick a scenario folder";
    ScenarioAnalysisSuite analyzer = new ScenarioAnalysisSuite(this);

    public LyapunovControl(Composite composite) {
        super(composite, 0);
        this.createContents();
    }

    private void createContents() {
        int n;
        this.setLayout((Layout)new FormLayout());
        this.identifiableTitle = new Label((Composite)this, 0);
        this.identifiableTitle.setText(Messages.getString("LYA.TITLE"));
        Display display = this.getDisplay();
        Color color = new Color((Device)display, new RGB(180, 180, 200));
        this.statusLabel = new Label((Composite)this, 2048);
        this.statusLabel.setBackground(color);
        this.statusLabel.setText("");
        this.firstScenarioFolderLabel = new Label((Composite)this, 2048);
        this.firstScenarioFolderLabel.setBackground(color);
        this.firstScenarioFolderLabel.setText(Messages.getString("LYA.FOLDER1LABEL"));
        this.text1 = new Text((Composite)this, 2048);
        this.text1.setBounds(10, 10, 100, 20);
        String string = this.prefs.getRecentFolder(PRIMARY_FOLDER_KEY);
        this.text1.setText(string);
        this.secondScenarioFolderLabel = new Label((Composite)this, 2048);
        this.secondScenarioFolderLabel.setBackground(color);
        this.secondScenarioFolderLabel.setText(Messages.getString("LYA.FOLDER2LABEL"));
        this.text2 = new Text((Composite)this, 2048);
        this.text2.setBounds(10, 10, 100, 20);
        String string2 = this.prefs.getRecentFolder(SECONDARY_FOLDER_KEY);
        this.text2.setText(string2);
        Composite composite = this.getAnalyzeButtonComposite(this, Messages.getString("LYA.COMPARISON"));
        this.resultsLabel = new Label((Composite)this, 8);
        this.resultsLabel.setBackground(display.getSystemColor(1));
        this.resultsLabel.setText(Messages.getString("LYA.RESULTS"));
        int n2 = n = 5;
        FormData formData = new FormData();
        this.identifiableTitle.setLayoutData((Object)formData);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(n2, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        FormData formData2 = new FormData();
        formData2.top = new FormAttachment((Control)this.identifiableTitle, 0);
        formData2.bottom = new FormAttachment(n2 += n, 0);
        formData2.left = new FormAttachment(0, 0);
        formData2.right = new FormAttachment(15, 0);
        this.firstScenarioFolderLabel.setLayoutData((Object)formData2);
        FormData formData3 = new FormData();
        formData3.top = new FormAttachment((Control)this.identifiableTitle, 0);
        formData3.bottom = new FormAttachment(n2, 0);
        formData3.left = new FormAttachment((Control)this.firstScenarioFolderLabel, 0);
        formData3.right = new FormAttachment(75, 0);
        this.text1.setLayoutData((Object)formData3);
        Button button = new Button((Composite)this, 0);
        button.setText(Messages.getString("LYA.SELECTFOLDER"));
        FormData formData4 = new FormData();
        formData4.top = new FormAttachment((Control)this.identifiableTitle, 0);
        formData4.bottom = new FormAttachment(n2, 0);
        formData4.left = new FormAttachment((Control)this.text1, 0);
        formData4.right = new FormAttachment(100, 0);
        button.setLayoutData((Object)formData4);
        final Shell shell = this.getShell();
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DirectoryDialog directoryDialog = new DirectoryDialog(shell, 4096);
                directoryDialog.setText(Messages.getString("LYA.SELECTFOLDERDIALOG"));
                directoryDialog.setFilterPath(LyapunovControl.this.text1.getText());
                String string = directoryDialog.open();
                LyapunovControl.this.text1.setText(string);
            }
        });
        FormData formData5 = new FormData();
        formData5.top = new FormAttachment((Control)this.firstScenarioFolderLabel, 0);
        formData5.bottom = new FormAttachment(n2 += n, 0);
        formData5.left = new FormAttachment(0, 0);
        formData5.right = new FormAttachment(15, 0);
        this.secondScenarioFolderLabel.setLayoutData((Object)formData5);
        FormData formData6 = new FormData();
        formData6.top = new FormAttachment((Control)this.text1, 0);
        formData6.bottom = new FormAttachment(n2, 0);
        formData6.left = new FormAttachment((Control)this.secondScenarioFolderLabel, 0);
        formData6.right = new FormAttachment(75, 0);
        this.text2.setLayoutData((Object)formData6);
        Button button2 = new Button((Composite)this, 0);
        button2.setText(Messages.getString("LYA.SELECTFOLDER"));
        FormData formData7 = new FormData();
        formData7.top = new FormAttachment((Control)this.text1, 0);
        formData7.bottom = new FormAttachment(n2, 0);
        formData7.left = new FormAttachment((Control)this.text2, 0);
        formData7.right = new FormAttachment(100, 0);
        button2.setLayoutData((Object)formData7);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DirectoryDialog directoryDialog = new DirectoryDialog(shell, 4096);
                directoryDialog.setText(LyapunovControl.SELECT_FOLDER_DIALOG_TEXT);
                directoryDialog.setFilterPath(LyapunovControl.this.text2.getText());
                String string = directoryDialog.open();
                LyapunovControl.this.text2.setText(string);
            }
        });
        FormData formData8 = new FormData();
        formData8.top = new FormAttachment((Control)this.text2, 0);
        formData8.bottom = new FormAttachment(n2 += n, 0);
        formData8.left = new FormAttachment(0, 0);
        formData8.right = new FormAttachment(100, 0);
        composite.setLayoutData((Object)formData8);
        this.lyapunovTrajectoryCanvas = new LyapunovTrajectoryCanvas(this);
        FormData formData9 = new FormData();
        this.lyapunovTrajectoryCanvas.setLayoutData(formData9);
        formData9.top = new FormAttachment(n2, 0);
        formData9.bottom = new FormAttachment(100, 0);
        formData9.left = new FormAttachment(0, 0);
        formData9.right = new FormAttachment(50, 0);
        this.timeSeriesCanvas = new TimeSeriesCanvas(this, Messages.getString("LYA.DIVERGENCELEGEND"), Messages.getString("LYA.DIVERGENCEYAXIS"), Messages.getString("LYA.DIVERGENCEYAXIS"), foreGround, backgroundGround, frameColor, 0);
        FormData formData10 = new FormData();
        this.timeSeriesCanvas.setLayoutData(formData10);
        formData10.top = new FormAttachment(n2, 0);
        formData10.bottom = new FormAttachment(100, 0);
        formData10.left = new FormAttachment(50, 0);
        formData10.right = new FormAttachment(100, 0);
        final ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.getShell());
        this.analyzeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = LyapunovControl.this.text1.getText();
                String string2 = LyapunovControl.this.text2.getText();
                LyapunovControl.this.identifiableTitle.setText(Messages.getString("LYA.TITLE"));
                LyapunovControl.this.comparisonValues.clear();
                LyapunovControl.this.cumulativeDeviation.clear();
                LyapunovControl.this.lyapunovTrajectoryCanvas.reset();
                if (!LyapunovControl.this.analyzer.validate(string)) {
                    LyapunovControl.this.identifiableTitle.setText(ScenarioAnalysisSuite.NOT_FOUND_MSG);
                    LyapunovControl.this.text1.setText("");
                }
                if (!LyapunovControl.this.analyzer.validate(string2)) {
                    LyapunovControl.this.identifiableTitle.setText(ScenarioAnalysisSuite.NOT_FOUND_MSG);
                    LyapunovControl.this.text2.setText("");
                }
                if (!LyapunovControl.this.analyzer.validate(string) || !LyapunovControl.this.analyzer.validate(string2)) {
                    return;
                }
                try {
                    LyapunovControl.this.comparisonValues.addAll(LyapunovControl.this.analyzer.getLyapunovTrajectory(string, string2, (IRunnableContext)progressMonitorDialog));
                    LyapunovControl.this.prefs.setRecentFolder(LyapunovControl.PRIMARY_FOLDER_KEY, string);
                    LyapunovControl.this.prefs.setRecentFolder(LyapunovControl.SECONDARY_FOLDER_KEY, string2);
                }
                catch (ScenarioInitializationException scenarioInitializationException) {
                    Activator.logError((String)"", (Throwable)scenarioInitializationException);
                }
                LyapunovControl.this.cumulativeDeviation.addAll(ScenarioAnalysisSuite.getCumulativePhaseSpaceDeviation(LyapunovControl.this.comparisonValues));
                LyapunovControl.this.statusLabel.setText(Messages.getString("LYA.COMPLETE"));
                LyapunovControl.this.lyapunovTrajectoryCanvas.draw();
                String string3 = "LyapunovAnalysis_" + LyapunovControl.getScenarioNameFromDirectoryName(string) + "_" + LyapunovControl.getScenarioNameFromDirectoryName(string2);
                CSVAnalysisWriter cSVAnalysisWriter = new CSVAnalysisWriter(string3);
                cSVAnalysisWriter.logData(2, LyapunovControl.this.comparisonValues);
                string3 = "LyapunovDeviation_" + LyapunovControl.getScenarioNameFromDirectoryName(string) + "_" + LyapunovControl.getScenarioNameFromDirectoryName(string2);
                CSVAnalysisWriter cSVAnalysisWriter2 = new CSVAnalysisWriter(string3);
                cSVAnalysisWriter2.logData(LyapunovControl.this.cumulativeDeviation);
                LyapunovControl.this.timeSeriesCanvas.draw();
            }
        });
    }

    public static String getScenarioNameFromDirectoryName(String string) {
        int n = string.lastIndexOf("/");
        int n2 = string.lastIndexOf("\\");
        if (n2 > n) {
            n = n2;
        }
        if (n <= 0) {
            n = 0;
        }
        String string2 = string.substring(n + 1, string.length());
        return string2;
    }

    public PhaseSpaceCoordinate[] getPointValues(int n) {
        return this.comparisonValues.get(n);
    }

    @Override
    public double[] getValues(int n, int n2) {
        EList<Double> eList = this.cumulativeDeviation.get(n2);
        double[] dArray = new double[eList.size()];
        int n3 = 0;
        while (n3 < dArray.length) {
            dArray[n3] = (Double)eList.get(n3);
            ++n3;
        }
        return dArray;
    }

    @Override
    public String getProperty(int n, int n2) {
        return Messages.getString("LYA.DIVERGENCEYAXIS");
    }

    @Override
    public int getNumProperties(int n) {
        return 1;
    }

    @Override
    public void remove() {
        this.updateStatusLabel();
    }

    protected void updateStatusLabel() {
        this.statusLabel.setText("status");
    }

    @Override
    protected void initializeHeader(String string) {
        this.simulationNameLabel.setText("analyzing " + string);
    }

    public void dispose() {
        super.dispose();
    }

    @Override
    public Map<String, Object> getControlParametersMap() {
        return controlParametersMap;
    }
}

