/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.model.type.ScatterSeries;
import org.eclipse.birt.chart.model.type.impl.ScatterSeriesImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.stem.util.analysis.Activator;
import org.eclipse.stem.util.analysis.PhaseSpaceCoordinate;
import org.eclipse.stem.util.analysis.views.LyapunovControl;
import org.eclipse.stem.util.analysis.views.Messages;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LyapunovTrajectoryCanvas
extends Canvas {
    protected IDeviceRenderer idr = null;
    protected Chart cm = null;
    private LyapunovControl control = null;
    private final List<List<Double>> relativeValuesX = new ArrayList<List<Double>>();
    private final List<List<Double>> relativeValuesY = new ArrayList<List<Double>>();
    Generator gr;
    private final List<LineSeries> lineSeriesList = new ArrayList<LineSeries>();
    Axis yAxisPrimary;
    Axis xAxisPrimary;
    double maxX = -1.0;
    double maxY = -1.0;
    ColorDefinition[] lineColors = new ColorDefinition[]{ColorDefinitionImpl.RED(), ColorDefinitionImpl.BLUE(), ColorDefinitionImpl.ORANGE(), ColorDefinitionImpl.YELLOW(), ColorDefinitionImpl.GREEN(), ColorDefinitionImpl.PINK(), ColorDefinitionImpl.BLACK()};
    private static final int NUM_TRAJECTORIES = 2;
    public static final String TIME_LABEL = "time";
    public static final String RMS_LABEL = "I[A] vs I[B]";
    Image imgChart = null;

    public LyapunovTrajectoryCanvas(Composite composite) {
        super(composite, 0x20000800);
        while (this.relativeValuesX.size() < 2) {
            this.relativeValuesX.add(new ArrayList());
        }
        while (this.relativeValuesY.size() < 2) {
            this.relativeValuesY.add(new ArrayList());
        }
        this.resetData();
        this.gr = Generator.instance();
        try {
            this.idr = PluginSettings.instance().getDevice("dv.SWT");
        }
        catch (ChartException chartException) {
            Activator.logError("Problem initializing chart", chartException);
            return;
        }
        this.control = (LyapunovControl)composite;
        this.cm = this.createLyapunovTrajectoryChart(this.relativeValuesX, this.relativeValuesY, Messages.getString("PH.title"));
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                Composite composite = (Composite)paintEvent.getSource();
                Rectangle rectangle = composite.getClientArea();
                if (LyapunovTrajectoryCanvas.this.imgChart != null) {
                    LyapunovTrajectoryCanvas.this.imgChart.dispose();
                }
                LyapunovTrajectoryCanvas.this.imgChart = new Image((Device)composite.getDisplay(), rectangle);
                LyapunovTrajectoryCanvas.this.idr.setProperty("device.output.context", (Object)new GC((Drawable)LyapunovTrajectoryCanvas.this.imgChart));
                Bounds bounds = BoundsImpl.create((double)rectangle.x, (double)rectangle.y, (double)rectangle.width, (double)rectangle.height);
                bounds.scale(72.0 / (double)LyapunovTrajectoryCanvas.this.idr.getDisplayServer().getDpiResolution());
                try {
                    LyapunovTrajectoryCanvas.this.gr.render(LyapunovTrajectoryCanvas.this.idr, LyapunovTrajectoryCanvas.this.gr.build(LyapunovTrajectoryCanvas.this.idr.getDisplayServer(), LyapunovTrajectoryCanvas.this.cm, bounds, null, null, null));
                    paintEvent.gc.drawImage(LyapunovTrajectoryCanvas.this.imgChart, rectangle.x, rectangle.y);
                }
                catch (ChartException chartException) {
                    Activator.logError("Problem rendering chart", chartException);
                }
            }
        });
    }

    public void draw() {
        this.clearData();
        LyapunovTrajectoryCanvas.setColorDefs(this.lineSeriesList);
        this.maxX = -1.0;
        this.maxY = -1.0;
        int n = 0;
        while (n < 2) {
            PhaseSpaceCoordinate[] phaseSpaceCoordinateArray = this.control.getPointValues(n);
            if (phaseSpaceCoordinateArray.length > 0) {
                int n2 = 0;
                while (n2 < phaseSpaceCoordinateArray.length) {
                    if (phaseSpaceCoordinateArray[n2].getXValue() >= this.maxX) {
                        this.maxX = phaseSpaceCoordinateArray[n2].getXValue();
                        this.xAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)this.maxX));
                    }
                    if (phaseSpaceCoordinateArray[n2].getYValue() >= this.maxY) {
                        this.maxY = phaseSpaceCoordinateArray[n2].getYValue();
                        this.yAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)this.maxY));
                    }
                    ++n2;
                }
                n2 = 0;
                while (n2 < phaseSpaceCoordinateArray.length) {
                    this.relativeValuesX.get(n).add(new Double(phaseSpaceCoordinateArray[n2].getXValue()));
                    this.relativeValuesY.get(n).add(new Double(phaseSpaceCoordinateArray[n2].getYValue()));
                    ++n2;
                }
            } else {
                this.resetData();
            }
            ++n;
        }
        if (!this.isDisposed()) {
            this.redraw();
        }
    }

    public final Chart createLyapunovTrajectoryChart(List<List<Double>> list, List<List<Double>> list2, String string) {
        ChartWithAxes chartWithAxes = ChartWithAxesImpl.create();
        String string2 = "S";
        String string3 = "I";
        chartWithAxes.getBlock().setBackground((Fill)ColorDefinitionImpl.WHITE());
        Plot plot = chartWithAxes.getPlot();
        plot.getClientArea().setBackground((Fill)ColorDefinitionImpl.create((int)255, (int)255, (int)225));
        chartWithAxes.getTitle().setVisible(false);
        Legend legend = chartWithAxes.getLegend();
        legend.setVisible(false);
        this.xAxisPrimary = chartWithAxes.getPrimaryBaseAxes()[0];
        this.xAxisPrimary.setType(AxisType.LINEAR_LITERAL);
        this.yAxisPrimary = chartWithAxes.getPrimaryOrthogonalAxis(this.xAxisPrimary);
        this.xAxisPrimary.getMajorGrid().setTickStyle(TickStyle.BELOW_LITERAL);
        this.yAxisPrimary.getMajorGrid().setTickStyle(TickStyle.LEFT_LITERAL);
        this.xAxisPrimary.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        this.xAxisPrimary.getTitle().getCaption().getFont().setSize(8.0f);
        String string4 = string2;
        this.xAxisPrimary.getTitle().getCaption().setValue(string4);
        this.xAxisPrimary.getTitle().setVisible(true);
        this.yAxisPrimary.getTitle().getCaption().getFont().setSize(8.0f);
        String string5 = string3;
        this.yAxisPrimary.getTitle().getCaption().setValue(string5);
        this.yAxisPrimary.getTitle().setVisible(true);
        int n = this.lineColors.length;
        int n2 = 0;
        while (n2 < list.size()) {
            NumberDataSet numberDataSet = NumberDataSetImpl.create(list.get(n2));
            NumberDataSet numberDataSet2 = NumberDataSetImpl.create(list2.get(n2));
            Series series = SeriesImpl.create();
            series.setDataSet((DataSet)numberDataSet);
            ScatterSeries scatterSeries = (ScatterSeries)ScatterSeriesImpl.create();
            scatterSeries.setDataSet((DataSet)numberDataSet2);
            scatterSeries.getLineAttributes().setVisible(true);
            int n3 = n2 % n;
            scatterSeries.getLineAttributes().setColor(this.lineColors[n3]);
            scatterSeries.setSeriesIdentifier((Object)string);
            scatterSeries.getMarker().setVisible(false);
            SeriesDefinition seriesDefinition = SeriesDefinitionImpl.create();
            SeriesDefinition seriesDefinition2 = SeriesDefinitionImpl.create();
            seriesDefinition2.getSeriesPalette().update(-2);
            this.xAxisPrimary.getSeriesDefinitions().add((Object)seriesDefinition);
            this.yAxisPrimary.getSeriesDefinitions().add((Object)seriesDefinition2);
            seriesDefinition.getSeries().add((Object)series);
            seriesDefinition2.getSeries().add((Object)scatterSeries);
            ++n2;
        }
        this.xAxisPrimary.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
        this.xAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)1.0));
        this.xAxisPrimary.getScale().setStep(0.25);
        this.xAxisPrimary.getLabel().getCaption().getFont().setSize(9.0f);
        this.yAxisPrimary.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
        this.yAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)1.0));
        this.yAxisPrimary.getScale().setStep(0.25);
        this.yAxisPrimary.getLabel().getCaption().getFont().setSize(9.0f);
        return chartWithAxes;
    }

    public static void setColorDefs(List<LineSeries> list) {
        int n = 0;
        while (n < list.size()) {
            ColorDefinition colorDefinition = ColorDefinitionImpl.BLUE();
            list.get(n).getLineAttributes().setColor(colorDefinition);
            ++n;
        }
    }

    public void dispose() {
        super.dispose();
    }

    public void reset() {
        this.resetData();
        this.redraw();
    }

    protected void resetData() {
        this.clearData();
        int n = 0;
        while (n < this.relativeValuesX.size()) {
            this.relativeValuesX.get(n).add(new Double(1.0));
            this.relativeValuesY.get(n).add(new Double(0.0));
            ++n;
        }
    }

    private void clearData() {
        int n = 0;
        while (n < this.relativeValuesX.size()) {
            this.relativeValuesX.get(n).clear();
            this.relativeValuesY.get(n).clear();
            ++n;
        }
    }
}

