/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis.views;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stem.analysis.DiseaseType;
import org.eclipse.stem.analysis.impl.ReferenceScenarioDataMapImpl;
import org.eclipse.stem.analysis.util.CSVscenarioLoader;
import org.eclipse.stem.util.analysis.ParameterEstimatorMethod;
import org.eclipse.stem.util.analysis.views.EstimatorControl;
import org.eclipse.stem.util.analysis.views.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;

public class ParameterEstimatorWizard
extends Wizard {
    protected ParameterEstimatorWizardSelectFolderPage selectFolderPage;
    protected ParameterEstimatorWizardSelectEstimatorPage selectEstimatorPage;
    protected IWorkbench workbench;
    IStructuredSelection selection;
    EstimatorControl estimatorControl;
    ReferenceScenarioDataMapImpl referenceScenarioDataMap;
    public ParameterEstimatorMethod parameterEstimatorMethod;
    private String initDir = null;

    public ParameterEstimatorWizard(EstimatorControl estimatorControl, String string) {
        this.estimatorControl = estimatorControl;
        this.initDir = string;
        this.setForcePreviousAndNextButtons(true);
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.workbench = iWorkbench;
        this.selection = iStructuredSelection;
        this.setWindowTitle("Create Parameter Estimator");
    }

    public boolean performFinish() {
        EstimatorControl.text1.setText(this.selectFolderPage.getDirName());
        EstimatorControl.estimatorText.setText(this.parameterEstimatorMethod.getName());
        this.estimatorControl.enableAnalysis(true);
        return true;
    }

    public ReferenceScenarioDataMapImpl getReferenceScenarioDataMap() {
        return this.referenceScenarioDataMap;
    }

    public ParameterEstimatorMethod getParameterEstimatorMethod() {
        return this.parameterEstimatorMethod;
    }

    public void createPageControls(Composite composite) {
    }

    public void addPages() {
        this.selectFolderPage = new ParameterEstimatorWizardSelectFolderPage("Folder");
        this.selectFolderPage.setTitle(Messages.getString("EST.WIZARDPAGE1TITLE"));
        this.selectFolderPage.setDescription("");
        this.selectFolderPage.setDirName(this.initDir);
        this.addPage((IWizardPage)this.selectFolderPage);
    }

    public class ParameterEstimatorWizardSelectEstimatorPage
    extends WizardPage {
        public ParameterEstimatorWizardSelectEstimatorPage(String string) {
            super(string);
        }

        protected boolean validatePage() {
            return ((ParameterEstimatorWizard)this.getWizard()).parameterEstimatorMethod != null;
        }

        public void createControl(Composite composite) {
            Composite composite2 = new Composite(composite, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 1;
            gridLayout.verticalSpacing = 12;
            composite2.setLayout((Layout)gridLayout);
            GridData gridData = new GridData();
            gridData.verticalAlignment = 4;
            gridData.grabExcessVerticalSpace = true;
            gridData.horizontalAlignment = 4;
            composite2.setLayoutData((Object)gridData);
            gridLayout = new Label(composite2, 16384);
            gridLayout.setText(Messages.getString("EST.PARAMESTLABEL"));
            gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridLayout.setLayoutData((Object)gridData);
            gridData = new Label(composite2, 16384);
            gridData.setText("");
            GridData gridData2 = new GridData();
            gridData2.horizontalAlignment = 4;
            gridData.setLayoutData((Object)gridData2);
            boolean bl = true;
            ParameterEstimatorMethod[] parameterEstimatorMethodArray = ParameterEstimatorMethod.values();
            int n = parameterEstimatorMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                ParameterEstimatorMethod parameterEstimatorMethod = parameterEstimatorMethodArray[n2];
                DiseaseType diseaseType = ((ParameterEstimatorWizard)this.getWizard()).referenceScenarioDataMap.getType();
                if (parameterEstimatorMethod.getType() == diseaseType) {
                    Button button = new Button(composite2, 16);
                    button.setText(parameterEstimatorMethod.getName());
                    if (bl) {
                        button.setSelection(true);
                        ((ParameterEstimatorWizard)this.getWizard()).parameterEstimatorMethod = parameterEstimatorMethod;
                        gridData.setText(parameterEstimatorMethod.getDescription());
                        bl = false;
                    }
                    final ParameterEstimatorWizard parameterEstimatorWizard = (ParameterEstimatorWizard)this.getWizard();
                    final ParameterEstimatorMethod parameterEstimatorMethod2 = parameterEstimatorMethod;
                    GridData gridData3 = gridData;
                    button.addSelectionListener((SelectionListener)new SelectionAdapter((Label)gridData3){
                        private final /* synthetic */ Label val$descLabel;
                        {
                            this.val$descLabel = label;
                        }

                        public void widgetSelected(SelectionEvent selectionEvent) {
                            parameterEstimatorWizard.parameterEstimatorMethod = parameterEstimatorMethod2;
                            this.val$descLabel.setText(parameterEstimatorMethod2.getDescription());
                            parameterEstimatorWizard.getContainer().updateButtons();
                        }
                    });
                }
                ++n2;
            }
            this.setPageComplete(this.validatePage());
            this.setControl((Control)composite2);
        }

        public boolean canFlipToNextPage() {
            return false;
        }

        public boolean isPageComplete() {
            return this.validatePage();
        }
    }

    public class ParameterEstimatorWizardSelectFolderPage
    extends WizardPage {
        Text folderText;
        private String directory;

        public ParameterEstimatorWizardSelectFolderPage(String string) {
            super(string);
            this.folderText = null;
        }

        protected boolean validatePage() {
            return true;
        }

        public void createControl(Composite composite) {
            Composite composite2 = new Composite(composite, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            gridLayout.verticalSpacing = 12;
            composite2.setLayout((Layout)gridLayout);
            GridData gridData = new GridData();
            gridData.verticalAlignment = 4;
            gridData.grabExcessVerticalSpace = true;
            gridData.horizontalAlignment = 4;
            composite2.setLayoutData((Object)gridData);
            gridLayout = new Label(composite2, 16384);
            gridLayout.setText(Messages.getString("EST.SCFOLDER"));
            gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridLayout.setLayoutData((Object)gridData);
            this.folderText = new Text(composite2, 16384);
            this.folderText.setText(this.getDirName());
            gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            gridData.minimumWidth = 100;
            this.folderText.setLayoutData((Object)gridData);
            gridData = new Button(composite2, 16384);
            gridData.setText(Messages.getString("EST.SELECTFOLDEBUTTON"));
            GridData gridData2 = new GridData();
            gridData2.horizontalAlignment = 4;
            gridData.setLayoutData((Object)gridData2);
            gridData2 = this.getShell();
            gridData.addSelectionListener((SelectionListener)new SelectionAdapter((Shell)gridData2){
                private final /* synthetic */ Shell val$shell;
                {
                    this.val$shell = shell;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    DirectoryDialog directoryDialog = new DirectoryDialog(this.val$shell, 4096);
                    directoryDialog.setText(Messages.getString("EST.SELECTFOLDEDIALOGTITLE"));
                    directoryDialog.setFilterPath(ParameterEstimatorWizardSelectFolderPage.this.folderText.getText());
                    String string = directoryDialog.open();
                    ParameterEstimatorWizardSelectFolderPage.this.folderText.setText(string);
                }
            });
            this.setPageComplete(this.validatePage());
            this.setControl((Control)composite2);
        }

        public void setDirName(String string) {
            this.directory = string;
        }

        public String getDirName() {
            return this.directory;
        }

        public boolean canFlipToNextPage() {
            return this.validatePage();
        }

        public boolean isPageComplete() {
            return this.validatePage();
        }

        public IWizardPage getNextPage() {
            try {
                ReferenceScenarioDataMapImpl referenceScenarioDataMapImpl;
                ParameterEstimatorWizard.this.selectEstimatorPage = new ParameterEstimatorWizardSelectEstimatorPage("Estimator");
                ParameterEstimatorWizard.this.selectEstimatorPage.setTitle(Messages.getString("EST.PARAMESTTITLE"));
                ParameterEstimatorWizard.this.selectEstimatorPage.setDescription("");
                ParameterEstimatorWizard.this.selectEstimatorPage.setWizard(this.getWizard());
                CSVscenarioLoader cSVscenarioLoader = new CSVscenarioLoader(this.folderText.getText());
                int n = cSVscenarioLoader.getMaxResolution();
                ((ParameterEstimatorWizard)this.getWizard()).referenceScenarioDataMap = referenceScenarioDataMapImpl = cSVscenarioLoader.parseAllFiles(n);
                this.setDirName(this.folderText.getText());
            }
            catch (Exception exception) {
                this.setErrorMessage(exception.getMessage());
                return this;
            }
            return ParameterEstimatorWizard.this.selectEstimatorPage;
        }
    }
}

