/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis.views;

import java.io.BufferedReader;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.stem.analysis.ScenarioInitializationException;
import org.eclipse.stem.util.analysis.DataProcessor;
import org.eclipse.stem.util.analysis.views.AnalysisControl;
import org.eclipse.stem.util.analysis.views.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessorControl
extends AnalysisControl {
    private static final String TIME_FORMAT = "yyyy-MM-dd";
    protected static Text sourceFolder;
    protected static Text targetFolder;
    protected static Text populationDataFile;
    protected static Spinner recoveryRate;
    protected static Spinner susceptibleRate;
    protected static Spinner immunityLossRate;
    protected static Spinner populationSizeStartYear;
    protected static Spinner populationSizeEndYear;
    protected Button processButton;
    protected static Label statusLabel;
    protected static Date startDate;
    protected static Date endDate;

    public ProcessorControl(Composite composite) {
        super(composite, 0);
        this.createContents();
    }

    void createContents() {
        final Shell shell = this.getShell();
        this.setLayout((Layout)new FormLayout());
        this.identifiableTitle = new Label((Composite)this, 0);
        this.identifiableTitle.setText(Messages.getString("PROCESSOR.TITLE"));
        Display display = this.getDisplay();
        Color color = new Color((Device)display, new RGB(180, 180, 200));
        statusLabel = new Label((Composite)this, 2048);
        statusLabel.setText("");
        Label label = new Label((Composite)this, 2048);
        label.setBackground(color);
        label.setText(Messages.getString("PROCESSOR.SOURCEFOLDER"));
        sourceFolder = new Text((Composite)this, 2048);
        sourceFolder.setBounds(10, 10, 100, 20);
        sourceFolder.setText("");
        sourceFolder.setEditable(false);
        Button button = new Button((Composite)this, 0);
        button.setText(Messages.getString("PROCESSOR.SELECTSOURCEFOLDER"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DirectoryDialog directoryDialog = new DirectoryDialog(shell, 4096);
                directoryDialog.setText(Messages.getString("PROCESSOR.SELECTSOURCEFOLDEDIALOGTITLE"));
                directoryDialog.setFilterPath(sourceFolder.getText());
                String string = directoryDialog.open();
                sourceFolder.setText(string);
                if (string != null && string.length() != 0) {
                    statusLabel.setText(Messages.getString("PROCESSOR.READINGDATA"));
                    populationSizeStartYear.setEnabled(false);
                    populationSizeEndYear.setEnabled(false);
                    ProcessorControl.this.initializeDates();
                    if (startDate != null && endDate != null) {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(ProcessorControl.TIME_FORMAT);
                        statusLabel.setText("Processing data from " + simpleDateFormat.format(startDate) + " to " + simpleDateFormat.format(endDate));
                        if (targetFolder.getText() == null || targetFolder.getText().length() == 0) {
                            targetFolder.setText(string);
                        }
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(startDate);
                        Calendar calendar2 = Calendar.getInstance();
                        calendar2.setTime(endDate);
                        populationSizeStartYear.setEnabled(true);
                        if (calendar.get(1) < calendar2.get(1)) {
                            populationSizeEndYear.setEnabled(true);
                        }
                    } else {
                        statusLabel.setText(Messages.getString("PROCESSOR.FAILEDREADDATA"));
                        sourceFolder.setText("");
                    }
                }
                ProcessorControl.this.enableProcessButton();
            }
        });
        Label label2 = new Label((Composite)this, 2048);
        label2.setBackground(color);
        label2.setText(Messages.getString("PROCESSOR.TARGETFOLDER"));
        targetFolder = new Text((Composite)this, 2048);
        targetFolder.setBounds(10, 10, 100, 20);
        targetFolder.setText("");
        targetFolder.setEditable(false);
        Button button2 = new Button((Composite)this, 0);
        button2.setText(Messages.getString("PROCESSOR.SELECTTARGETFOLDER"));
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DirectoryDialog directoryDialog = new DirectoryDialog(shell, 4096);
                directoryDialog.setText(Messages.getString("PROCESSOR.SELECTTARGETFOLDEDIALOGTITLE"));
                directoryDialog.setFilterPath(targetFolder.getText());
                String string = directoryDialog.open();
                targetFolder.setText(string);
                ProcessorControl.this.enableProcessButton();
            }
        });
        Label label3 = new Label((Composite)this, 2048);
        label3.setBackground(color);
        label3.setText(Messages.getString("PROCESSOR.POPULATIONDATAFILE"));
        populationDataFile = new Text((Composite)this, 2048);
        populationDataFile.setBounds(10, 10, 100, 20);
        populationDataFile.setText("");
        populationDataFile.setEditable(false);
        Button button3 = new Button((Composite)this, 0);
        button3.setText(Messages.getString("PROCESSOR.SELECTPOPULATIONDATAFILE"));
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(shell, 4096);
                fileDialog.setText(Messages.getString("PROCESSOR.SELECTPOPULATIONDATAFILEDIALOGTITLE"));
                fileDialog.setFilterPath(populationDataFile.getText());
                String string = fileDialog.open();
                populationDataFile.setText(string);
                ProcessorControl.this.enableProcessButton();
            }
        });
        Label label4 = new Label((Composite)this, 2048);
        label4.setBackground(color);
        label4.setText(Messages.getString("PROCESSOR.PARAMETERS"));
        Composite composite = new Composite((Composite)this, 2048);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 6;
        composite.setLayout((Layout)gridLayout);
        Label label5 = new Label(composite, 0);
        label5.setText(Messages.getString("PROCESSOR.RECOVERYRATE"));
        recoveryRate = new Spinner(composite, 0);
        recoveryRate.setDigits(2);
        recoveryRate.setMinimum(0);
        recoveryRate.setMaximum(100);
        recoveryRate.setIncrement(1);
        recoveryRate.setSelection(20);
        recoveryRate.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ProcessorControl.this.enableProcessButton();
            }
        });
        Label label6 = new Label(composite, 0);
        label6.setText(Messages.getString("PROCESSOR.SUSCEPTIBLERATE"));
        susceptibleRate = new Spinner(composite, 0);
        susceptibleRate.setDigits(3);
        susceptibleRate.setMinimum(0);
        susceptibleRate.setMaximum(1000);
        susceptibleRate.setIncrement(1);
        susceptibleRate.setSelection(333);
        susceptibleRate.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ProcessorControl.this.enableProcessButton();
            }
        });
        Label label7 = new Label(composite, 0);
        label7.setText(Messages.getString("PROCESSOR.IMMUNITYLOSSRATE"));
        immunityLossRate = new Spinner(composite, 0);
        immunityLossRate.setDigits(4);
        immunityLossRate.setMinimum(0);
        immunityLossRate.setMaximum(10000);
        immunityLossRate.setIncrement(1);
        immunityLossRate.setSelection(9);
        immunityLossRate.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ProcessorControl.this.enableProcessButton();
            }
        });
        composite.pack();
        Label label8 = new Label((Composite)this, 2048);
        label8.setBackground(color);
        label8.setText(Messages.getString("PROCESSOR.POPULATIONSIZE"));
        Composite composite2 = new Composite((Composite)this, 2048);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        composite2.setLayout((Layout)gridLayout);
        Label label9 = new Label(composite2, 0);
        label9.setText(Messages.getString("PROCESSOR.STARTYEAR"));
        populationSizeStartYear = new Spinner(composite2, 0);
        populationSizeStartYear.setDigits(0);
        populationSizeStartYear.setMinimum(0);
        populationSizeStartYear.setMaximum(100000000);
        populationSizeStartYear.setIncrement(1000);
        populationSizeStartYear.setSelection(10000000);
        populationSizeStartYear.setEnabled(false);
        populationSizeStartYear.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ProcessorControl.this.enableProcessButton();
            }
        });
        Label label10 = new Label(composite2, 0);
        label10.setText(Messages.getString("PROCESSOR.ENDYEAR"));
        populationSizeEndYear = new Spinner(composite2, 0);
        populationSizeEndYear.setDigits(0);
        populationSizeEndYear.setMinimum(0);
        populationSizeEndYear.setMaximum(100000000);
        populationSizeEndYear.setIncrement(1000);
        populationSizeEndYear.setSelection(10000000);
        populationSizeEndYear.setEnabled(false);
        populationSizeEndYear.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ProcessorControl.this.enableProcessButton();
            }
        });
        composite2.pack();
        this.processButton = new Button((Composite)this, 0);
        this.processButton.setText(Messages.getString("PROCESSOR.PROCESS"));
        this.processButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                try {
                    DataProcessor dataProcessor = new DataProcessor();
                    dataProcessor.process(sourceFolder.getText(), targetFolder.getText(), startDate, endDate, populationDataFile.getText(), Long.parseLong(populationSizeStartYear.getText()), Long.parseLong(populationSizeEndYear.getText()), Double.parseDouble(recoveryRate.getText()), Double.parseDouble(susceptibleRate.getText()), Double.parseDouble(immunityLossRate.getText()));
                    statusLabel.setText(Messages.getString("COMMON.DONE"));
                }
                catch (ScenarioInitializationException scenarioInitializationException) {
                    statusLabel.setText(scenarioInitializationException.getMessage());
                }
            }
        });
        this.enableProcessButton();
        this.createFormData(null, this.identifiableTitle, null, null, 5);
        this.createFormData((Control)this.identifiableTitle, label, (Control)sourceFolder, button, 10);
        this.createFormData((Control)label, label2, (Control)targetFolder, button2, 15);
        this.createFormData((Control)label2, label3, (Control)populationDataFile, button3, 20);
        this.createFormData((Control)label3, label4, (Control)composite, null, 25);
        this.createFormData((Control)label4, label8, (Control)composite2, null, 30);
        this.createFormData((Control)label8, null, null, this.processButton, 35);
        this.createFormData((Control)this.processButton, statusLabel, null, null, 100);
    }

    void enableProcessButton() {
        boolean bl = true;
        if (bl && (sourceFolder.getText() == null || sourceFolder.getText().length() == 0)) {
            bl = false;
        }
        if (bl && (targetFolder.getText() == null || targetFolder.getText().length() == 0)) {
            bl = false;
        }
        if (bl && (populationDataFile.getText() == null || populationDataFile.getText().length() == 0)) {
            bl = false;
        }
        if (bl && (recoveryRate.getText() == null || recoveryRate.getText().length() == 0)) {
            bl = false;
        }
        if (bl && (susceptibleRate.getText() == null || susceptibleRate.getText().length() == 0)) {
            bl = false;
        }
        if (bl && (immunityLossRate.getText() == null || immunityLossRate.getText().length() == 0)) {
            bl = false;
        }
        if (bl && (populationSizeStartYear.getText() == null || populationSizeStartYear.getText().length() == 0)) {
            bl = false;
        }
        if (bl && (populationSizeEndYear.getText() == null || populationSizeEndYear.getText().length() == 0)) {
            bl = false;
        }
        this.processButton.setEnabled(bl);
    }

    protected void initializeDates() {
        startDate = null;
        endDate = null;
        File file = new File(sourceFolder.getText());
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            BufferedReader bufferedReader;
            String string = fileArray[n].getName();
            if (string.indexOf(".txt") >= 0 && (bufferedReader = DataProcessor.openReader(fileArray[n])) != null) {
                try {
                    String string2 = null;
                    bufferedReader.readLine();
                    while (!DataProcessor.EOF(string2 = bufferedReader.readLine())) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                        if (stringTokenizer.countTokens() != 3) continue;
                        stringTokenizer.nextToken(",");
                        String string3 = stringTokenizer.nextToken(",");
                        stringTokenizer.nextToken(",");
                        if (string3 == null) continue;
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(TIME_FORMAT);
                        Date date = simpleDateFormat.parse(string3);
                        if (startDate == null || date.before(startDate)) {
                            startDate = date;
                        }
                        if (endDate != null && !date.after(endDate)) continue;
                        endDate = date;
                    }
                }
                catch (Exception exception) {}
            }
            ++n;
        }
    }

    private void createFormData(Control control, Label label, Control control2, Button button, int n) {
        int n2;
        FormData formData;
        if (label != null) {
            formData = new FormData();
            formData.top = control != null ? new FormAttachment(control, 0) : new FormAttachment(0, 0);
            formData.bottom = new FormAttachment(n, 0);
            formData.left = new FormAttachment(0, 0);
            n2 = 15;
            if (control2 == null && button == null) {
                n2 = 100;
            }
            formData.right = new FormAttachment(n2, 0);
            label.setLayoutData((Object)formData);
        }
        if (control2 != null) {
            formData = new FormData();
            formData.top = control != null ? new FormAttachment(control, 0) : new FormAttachment(0, 0);
            formData.bottom = new FormAttachment(n, 0);
            formData.left = label != null ? new FormAttachment((Control)label, 0) : new FormAttachment(0, 0);
            n2 = 80;
            if (button == null) {
                n2 = 100;
            }
            formData.right = new FormAttachment(n2, 0);
            control2.setLayoutData((Object)formData);
        }
        if (button != null) {
            formData = new FormData();
            formData.top = control != null ? new FormAttachment(control, 0) : new FormAttachment(0, 0);
            formData.bottom = new FormAttachment(n, 0);
            formData.left = control2 != null ? new FormAttachment(control2, 0) : (label != null ? new FormAttachment((Control)label, 0) : new FormAttachment(0, 0));
            formData.right = new FormAttachment(100, 0);
            button.setLayoutData((Object)formData);
        }
    }

    public void dispose() {
        super.dispose();
    }

    @Override
    public void remove() {
    }

    @Override
    protected void initializeHeader(String string) {
    }

    @Override
    public double[] getValues(int n, int n2) {
        return null;
    }

    @Override
    public String getProperty(int n, int n2) {
        return null;
    }

    @Override
    public int getNumProperties(int n) {
        return 0;
    }

    @Override
    public Map<String, Object> getControlParametersMap() {
        return controlParametersMap;
    }
}

