/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Anchor;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.model.type.impl.ScatterSeriesImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.stem.ui.preferences.VisualizationPreferencePage;
import org.eclipse.stem.util.analysis.Activator;
import org.eclipse.stem.util.analysis.AggregateDataWriter;
import org.eclipse.stem.util.analysis.ScenarioAnalysisSuite;
import org.eclipse.stem.util.analysis.views.AnalysisControl;
import org.eclipse.stem.util.analysis.views.Messages;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeSeriesCanvas
extends Canvas {
    protected IDeviceRenderer idr = null;
    protected Chart cm = null;
    private AnalysisControl control = null;
    private int chartIndex = 0;
    private static String defaultKey = AggregateDataWriter.getKeyS();
    protected static final ColorDefinition[] colorDefault = new ColorDefinition[]{ColorDefinitionImpl.BLUE(), ColorDefinitionImpl.BLACK(), ColorDefinitionImpl.GREY(), ColorDefinitionImpl.CYAN(), ColorDefinitionImpl.ORANGE()};
    private boolean overlayMode = false;
    private int seriesCount = 0;
    Menu popUpMenu = null;
    private LinearScaleAction linearTimeAction;
    private LogScaleAction logTimeAction;
    protected boolean useLinearTimeScale = true;
    private LegendViewAction viewLegend;
    private LegendHideAction hideLegend;
    protected boolean showLegend = true;
    protected Legend legend = null;
    protected final Map<String, DataSeries> dataSeriesMap = new HashMap<String, DataSeries>();
    private final List<Integer> cycleNumbers = new ArrayList<Integer>();
    Generator gr;
    Axis yAxisPrimary;
    Axis xAxisPrimary;
    double maxY = -1.0;
    private double minYscale = 1.0;
    public String Ordinate_LEGEND = "Y";
    public String Ordinate_AXIS = "Y";
    private ColorDefinition foreGround = ColorDefinitionImpl.WHITE();
    private ColorDefinition backgroundGround = ColorDefinitionImpl.BLACK();
    private ColorDefinition frameColor = ColorDefinitionImpl.create((int)180, (int)180, (int)200);
    Image imgChart = null;

    public TimeSeriesCanvas(AnalysisControl analysisControl, Composite composite, String string, String string2, String string3, ColorDefinition colorDefinition, ColorDefinition colorDefinition2, ColorDefinition colorDefinition3, int n, boolean bl) {
        super(composite, 0x20000800);
        this.Ordinate_LEGEND = string;
        this.Ordinate_AXIS = string2;
        defaultKey = string3;
        this.foreGround = colorDefinition;
        this.backgroundGround = colorDefinition2;
        this.frameColor = colorDefinition3;
        this.chartIndex = n;
        this.overlayMode = bl;
        this.gr = Generator.instance();
        try {
            this.idr = PluginSettings.instance().getDevice("dv.SWT");
        }
        catch (ChartException chartException) {
            Activator.logError("Problem initializing chart", chartException);
            return;
        }
        this.control = analysisControl;
        this.cm = this.createSimpleLineChart(this.dataSeriesMap, this.cycleNumbers, Messages.getString("CC.title"));
        this.resetData();
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                Composite composite = (Composite)paintEvent.getSource();
                Rectangle rectangle = composite.getClientArea();
                if (TimeSeriesCanvas.this.imgChart != null) {
                    TimeSeriesCanvas.this.imgChart.dispose();
                }
                TimeSeriesCanvas.this.imgChart = new Image((Device)composite.getDisplay(), rectangle);
                TimeSeriesCanvas.this.idr.setProperty("device.output.context", (Object)new GC((Drawable)TimeSeriesCanvas.this.imgChart));
                Bounds bounds = BoundsImpl.create((double)rectangle.x, (double)rectangle.y, (double)rectangle.width, (double)rectangle.height);
                bounds.scale(72.0 / (double)TimeSeriesCanvas.this.idr.getDisplayServer().getDpiResolution());
                try {
                    TimeSeriesCanvas.this.gr.render(TimeSeriesCanvas.this.idr, TimeSeriesCanvas.this.gr.build(TimeSeriesCanvas.this.idr.getDisplayServer(), TimeSeriesCanvas.this.cm, bounds, null, null, null));
                    paintEvent.gc.drawImage(TimeSeriesCanvas.this.imgChart, rectangle.x, rectangle.y);
                }
                catch (ChartException chartException) {
                    Activator.logError("Problem rendering chart", chartException);
                }
            }
        });
        this.createContextMenu((Composite)this);
    }

    public TimeSeriesCanvas(Composite composite, String string, String string2, String string3, ColorDefinition colorDefinition, ColorDefinition colorDefinition2, ColorDefinition colorDefinition3, int n) {
        super(composite, 0x20000800);
        this.Ordinate_LEGEND = string;
        this.Ordinate_AXIS = string2;
        defaultKey = string3;
        this.foreGround = colorDefinition;
        this.backgroundGround = colorDefinition2;
        this.frameColor = colorDefinition3;
        this.chartIndex = n;
        this.gr = Generator.instance();
        try {
            this.idr = PluginSettings.instance().getDevice("dv.SWT");
        }
        catch (ChartException chartException) {
            Activator.logError("Problem initializing chart", chartException);
            return;
        }
        this.control = (AnalysisControl)composite;
        this.cm = this.createSimpleLineChart(this.dataSeriesMap, this.cycleNumbers, Messages.getString("CC.title"));
        this.resetData();
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                Composite composite = (Composite)paintEvent.getSource();
                Rectangle rectangle = composite.getClientArea();
                if (TimeSeriesCanvas.this.imgChart != null) {
                    TimeSeriesCanvas.this.imgChart.dispose();
                }
                TimeSeriesCanvas.this.imgChart = new Image((Device)composite.getDisplay(), rectangle);
                TimeSeriesCanvas.this.idr.setProperty("device.output.context", (Object)new GC((Drawable)TimeSeriesCanvas.this.imgChart));
                Bounds bounds = BoundsImpl.create((double)rectangle.x, (double)rectangle.y, (double)rectangle.width, (double)rectangle.height);
                bounds.scale(72.0 / (double)TimeSeriesCanvas.this.idr.getDisplayServer().getDpiResolution());
                try {
                    TimeSeriesCanvas.this.gr.render(TimeSeriesCanvas.this.idr, TimeSeriesCanvas.this.gr.build(TimeSeriesCanvas.this.idr.getDisplayServer(), TimeSeriesCanvas.this.cm, bounds, null, null, null));
                    paintEvent.gc.drawImage(TimeSeriesCanvas.this.imgChart, rectangle.x, rectangle.y);
                }
                catch (ChartException chartException) {
                    Activator.logError("Problem rendering chart", chartException);
                }
            }
        });
        this.createContextMenu((Composite)this);
    }

    public double[] draw() {
        this.resetData();
        int n = this.control.getNumProperties(this.chartIndex);
        int n2 = 0;
        while (n2 < n) {
            DataSeries dataSeries;
            String string = this.control.getProperty(this.chartIndex, n2);
            if (!this.dataSeriesMap.containsKey(string)) {
                dataSeries = new DataSeries(string, this.seriesCount, this.overlayMode);
                ++this.seriesCount;
                this.dataSeriesMap.put(string, dataSeries);
            }
            if ((dataSeries = this.dataSeriesMap.get(string)).isVisible()) {
                dataSeries.show();
            } else {
                dataSeries.hide();
            }
            ++n2;
        }
        this.updateContextMenu((Composite)this);
        this.resetData();
        double[] dArray = new double[n];
        int n3 = 0;
        while (n3 < n) {
            dArray[n3] = 0.0;
            ++n3;
        }
        this.maxY = -1.0;
        n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            String string = this.control.getProperty(this.chartIndex, n5);
            double[] dArray2 = this.control.getValues(this.chartIndex, n5);
            DataSeries dataSeries = this.dataSeriesMap.get(string);
            int n6 = 0;
            while (n6 < dArray2.length) {
                int n7 = n5;
                dArray[n7] = dArray[n7] + dArray2[n6];
                if (dArray2[n6] <= this.minYscale && dArray2[n6] > 0.0) {
                    this.minYscale = dArray2[n6];
                }
                if (dArray2[n6] >= this.maxY) {
                    double d;
                    this.maxY = dArray2[n6];
                    double d2 = Math.floor(Math.log10(this.maxY));
                    double d3 = Math.ceil(this.maxY / Math.pow(10.0, d2)) * Math.pow(10.0, d2);
                    if (d3 <= 1.0) {
                        d3 = 1.0;
                    }
                    d3 = this.maxY * 100.0;
                    int n8 = (int)(d3 += 1.0);
                    d3 = (double)n8 / 100.0;
                    if (this.useLinearTimeScale) {
                        this.yAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)d3));
                        d = d3 / 10.0;
                        this.yAxisPrimary.getScale().setStep(d);
                    } else {
                        d = Math.log(d3);
                        if (d3 > 1.0) {
                            long l = Math.round(d += 0.499);
                            d = l;
                        }
                        this.yAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)d));
                        double d4 = d / 10.0;
                        this.yAxisPrimary.getScale().setStep(d4);
                    }
                }
                ++n6;
            }
            int n9 = n5;
            dArray[n9] = dArray[n9] / (double)dArray2.length;
            if (dArray2.length > 0) {
                if (n4 < dArray2.length) {
                    n4 = dArray2.length;
                }
                n6 = 0;
                while (n6 < dArray2.length) {
                    double d = dArray2[n6];
                    if (d <= this.minYscale) {
                        d = this.minYscale;
                    }
                    Double d5 = this.useLinearTimeScale ? new Double(d) : new Double(Math.log(d));
                    dataSeries.addValue(d5);
                    if (n3 == 0) {
                        this.cycleNumbers.add(new Integer(n6));
                    }
                    ++n6;
                }
                n3 = 1;
            }
            ++n5;
        }
        if (!this.isDisposed()) {
            this.redraw();
        }
        if (this.chartIndex == 1) {
            this.control.updateMessage(ScenarioAnalysisSuite.READY_MSG);
        } else {
            this.control.updateMessage(ScenarioAnalysisSuite.WORKING_MSG);
        }
        return dArray;
    }

    public final Chart createSimpleLineChart(Map<String, DataSeries> map, List<Integer> list, String string) {
        ChartWithAxes chartWithAxes = ChartWithAxesImpl.create();
        chartWithAxes.getBlock().setBackground((Fill)this.frameColor);
        Plot plot = chartWithAxes.getPlot();
        plot.getClientArea().setBackground((Fill)this.backgroundGround);
        chartWithAxes.getTitle().setVisible(false);
        this.legend = chartWithAxes.getLegend();
        LineAttributes lineAttributes = this.legend.getOutline();
        this.legend.getText().getFont().setSize(8.0f);
        lineAttributes.setStyle(LineStyle.SOLID_LITERAL);
        this.legend.getInsets().set(10.0, 5.0, 0.0, 0.0);
        this.legend.getOutline().setVisible(false);
        this.legend.setAnchor(Anchor.NORTH_LITERAL);
        this.legend.setPosition(Position.BELOW_LITERAL);
        this.legend.getText().setColor(this.foreGround);
        this.legend.getOutline().setColor(this.foreGround);
        this.xAxisPrimary = chartWithAxes.getPrimaryBaseAxes()[0];
        this.xAxisPrimary.setType(AxisType.TEXT_LITERAL);
        this.xAxisPrimary.getMajorGrid().setTickStyle(TickStyle.BELOW_LITERAL);
        this.xAxisPrimary.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        this.xAxisPrimary.getTitle().setVisible(false);
        this.xAxisPrimary.getTitle().getCaption().getFont().setSize(9.0f);
        this.xAxisPrimary.getTitle().getCaption().setColor(this.foreGround);
        this.xAxisPrimary.getLabel().getCaption().setColor(this.foreGround);
        Series series = SeriesImpl.create();
        series.getLabel().getCaption().setColor(this.foreGround);
        series.getLabel().getOutline().setColor(this.foreGround);
        NumberDataSet numberDataSet = NumberDataSetImpl.create(list);
        series.setDataSet((DataSet)numberDataSet);
        SeriesDefinition seriesDefinition = SeriesDefinitionImpl.create();
        this.xAxisPrimary.getSeriesDefinitions().add((Object)seriesDefinition);
        seriesDefinition.getSeries().add((Object)series);
        this.yAxisPrimary = chartWithAxes.getPrimaryOrthogonalAxis(this.xAxisPrimary);
        this.yAxisPrimary.getMajorGrid().setTickStyle(TickStyle.LEFT_LITERAL);
        this.xAxisPrimary.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
        this.xAxisPrimary.getLabel().getCaption().getFont().setSize(9.0f);
        this.xAxisPrimary.getLabel().getCaption().setColor(this.foreGround);
        this.xAxisPrimary.getTitle().setVisible(true);
        this.xAxisPrimary.getTitle().getCaption().setValue(Messages.getString("TS.TIMELABEL"));
        this.yAxisPrimary.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
        this.yAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)1.0));
        this.yAxisPrimary.getScale().setStep(0.25);
        this.yAxisPrimary.getLabel().getCaption().getFont().setSize(9.0f);
        this.yAxisPrimary.getLabel().getCaption().setColor(this.foreGround);
        this.yAxisPrimary.getTitle().getCaption().setValue(this.Ordinate_AXIS);
        this.yAxisPrimary.getTitle().setVisible(true);
        if (!map.containsKey(defaultKey)) {
            DataSeries dataSeries = new DataSeries(defaultKey, this.seriesCount, this.overlayMode);
            ++this.seriesCount;
            map.put(defaultKey, dataSeries);
        }
        return chartWithAxes;
    }

    protected void createContextMenu(Composite composite) {
        MenuManager menuManager = new MenuManager();
        this.linearTimeAction = new LinearScaleAction();
        this.logTimeAction = new LogScaleAction();
        menuManager.add((IAction)this.linearTimeAction);
        menuManager.add((IAction)this.logTimeAction);
        menuManager.add((IContributionItem)new Separator("additions"));
        this.viewLegend = new LegendViewAction();
        this.hideLegend = new LegendHideAction();
        menuManager.add((IAction)this.viewLegend);
        menuManager.add((IAction)this.hideLegend);
        menuManager.add((IContributionItem)new Separator("additions"));
        this.popUpMenu = menuManager.createContextMenu((Control)composite);
        composite.setMenu(this.popUpMenu);
    }

    private void updateContextMenu(Composite composite) {
        this.popUpMenu.dispose();
        MenuManager menuManager = new MenuManager();
        this.linearTimeAction = new LinearScaleAction();
        this.logTimeAction = new LogScaleAction();
        menuManager.add((IAction)this.linearTimeAction);
        menuManager.add((IAction)this.logTimeAction);
        menuManager.add((IContributionItem)new Separator("additions"));
        this.viewLegend = new LegendViewAction();
        this.hideLegend = new LegendHideAction();
        menuManager.add((IAction)this.viewLegend);
        menuManager.add((IAction)this.hideLegend);
        menuManager.add((IContributionItem)new Separator("additions"));
        int n = 0;
        while (n < this.control.getNumProperties(this.chartIndex)) {
            String string = this.control.getProperty(this.chartIndex, n);
            DataSeries dataSeries = this.dataSeriesMap.get(string);
            DisplayableProperty displayableProperty = new DisplayableProperty(string, dataSeries.isVisible());
            menuManager.add((IAction)displayableProperty);
            ++n;
        }
        menuManager.add((IContributionItem)new Separator("additions"));
        Menu menu = menuManager.createContextMenu((Control)composite);
        composite.setMenu(menu);
    }

    public static void setColorDefs(List<String> list, List<LineSeries> list2) {
        Map map = VisualizationPreferencePage.getColorMapping();
        int n = 0;
        while (n < list2.size()) {
            ColorDefinition colorDefinition = ColorDefinitionImpl.BLUE();
            if (list != null && list.size() > n) {
                String string = list.get(n);
                if (map.containsKey(string)) {
                    Color color = (Color)map.get(string);
                    colorDefinition = ColorDefinitionImpl.create((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue());
                }
                list2.get(n).setSeriesIdentifier((Object)string);
                list2.get(n).getLineAttributes().setColor(colorDefinition);
            } else if (list2.get(n) != null) {
                list2.get(n).setSeriesIdentifier((Object)" ");
                list2.get(n).getLineAttributes().setColor(colorDefinition);
            }
            ++n;
        }
    }

    public void dispose() {
        super.dispose();
    }

    public void reset() {
        this.resetData();
        this.redraw();
    }

    protected void resetData() {
        this.clearData();
        this.cycleNumbers.add(new Integer(0));
    }

    private void clearData() {
        Iterator<String> iterator = this.dataSeriesMap.keySet().iterator();
        while (iterator != null && iterator.hasNext()) {
            String string = iterator.next();
            DataSeries dataSeries = this.dataSeriesMap.get(string);
            dataSeries.relativeValues.clear();
            dataSeries.addValue(new Double(0.0));
        }
        this.cycleNumbers.clear();
    }

    void toggleAxisScale() {
        if (this.useLinearTimeScale) {
            this.logTimeAction.setChecked(true);
            this.linearTimeAction.setChecked(false);
            this.yAxisPrimary.getScale().setMin(null);
            this.yAxisPrimary.getScale().setMax(null);
            this.yAxisPrimary.getScale().unsetStep();
            this.yAxisPrimary.getScale().unsetStepNumber();
        } else {
            this.logTimeAction.setChecked(false);
            this.linearTimeAction.setChecked(true);
            this.yAxisPrimary.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
            this.yAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)1.0));
            this.yAxisPrimary.getScale().setStep(0.25);
        }
        this.useLinearTimeScale = !this.useLinearTimeScale;
        this.draw();
    }

    void toggleLegend() {
        if (this.showLegend) {
            this.viewLegend.setChecked(false);
            this.hideLegend.setChecked(true);
            this.legend.setVisible(false);
        } else {
            this.viewLegend.setChecked(true);
            this.hideLegend.setChecked(false);
            this.legend.setVisible(true);
        }
        this.showLegend = !this.showLegend;
        this.draw();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DataSeries {
        public String propertyName = "";
        public List<Double> relativeValues = new ArrayList<Double>();
        public Series lineSeries = null;
        private boolean visible = true;
        private SeriesDefinition sdY = null;
        private int seriesIndex = 0;
        private boolean overlayMode = false;

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean bl) {
            this.visible = bl;
        }

        public void toggleVisible() {
            this.visible = !this.visible;
        }

        public DataSeries(String string, int n, boolean bl) {
            this.propertyName = string;
            this.seriesIndex = n;
            this.overlayMode = bl;
            this.relativeValues = new ArrayList<Double>();
            this.relativeValues.add(new Double(0.0));
            this.addLineSeries(string);
        }

        public void addValue(Double d) {
            if (this.relativeValues == null) {
                this.relativeValues = new ArrayList<Double>();
            }
            this.relativeValues.add(d);
        }

        public void addLineSeries(String string) {
            NumberDataSet numberDataSet = NumberDataSetImpl.create(this.relativeValues);
            if (this.lineSeries == null) {
                this.lineSeries = ScatterSeriesImpl.create();
            }
            this.lineSeries.setDataSet((DataSet)numberDataSet);
            ((LineSeries)this.lineSeries).getLineAttributes().setVisible(true);
            ((LineSeries)this.lineSeries).getMarker().setVisible(false);
            this.setColorDefs(string);
            this.sdY = SeriesDefinitionImpl.create();
            this.sdY.getSeriesPalette().update(-2);
            this.sdY.getSeries().add((Object)this.lineSeries);
            TimeSeriesCanvas.this.yAxisPrimary.getSeriesDefinitions().add((Object)this.sdY);
        }

        public void hide() {
            this.lineSeries.setVisible(false);
            this.visible = false;
        }

        public void show() {
            this.lineSeries.setVisible(true);
            this.visible = true;
        }

        public void setColorDefs(String string) {
            Map map = VisualizationPreferencePage.getColorMapping();
            int n = this.seriesIndex % colorDefault.length;
            ColorDefinition colorDefinition = colorDefault[n];
            String string2 = string.substring(0, 1);
            if (map.containsKey(string2)) {
                Color color = (Color)map.get(string2);
                colorDefinition = ColorDefinitionImpl.create((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue());
            }
            this.lineSeries.setSeriesIdentifier((Object)string);
            if (this.overlayMode) {
                if (string.indexOf("*") >= 1) {
                    ((LineSeries)this.lineSeries).getLineAttributes().setColor(colorDefinition);
                } else {
                    ((LineSeries)this.lineSeries).getLineAttributes().setColor(ColorDefinitionImpl.GREY());
                    ((LineSeries)this.lineSeries).getLineAttributes().setStyle(LineStyle.DOTTED_LITERAL);
                }
            } else {
                ((LineSeries)this.lineSeries).getLineAttributes().setColor(colorDefinition);
            }
        }

        public int getDataSize() {
            return this.relativeValues.size();
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public void setPropertyName(String string) {
            this.propertyName = string;
        }

        public List<Double> getRelativeValues() {
            return this.relativeValues;
        }

        public void setRelativeValues(List<Double> list) {
            this.relativeValues = list;
        }

        public void setLineSeries(LineSeries lineSeries) {
            this.lineSeries = lineSeries;
        }
    }

    protected class DisplayableProperty
    extends Action {
        String property;

        public DisplayableProperty(String string, boolean bl) {
            super(string, 2);
            this.property = null;
            this.property = string;
            this.setChecked(bl);
        }

        public String getText() {
            return this.property;
        }

        public void run() {
            DataSeries dataSeries = TimeSeriesCanvas.this.dataSeriesMap.get(this.property);
            dataSeries.toggleVisible();
            TimeSeriesCanvas.this.dataSeriesMap.put(this.property, dataSeries);
            this.setChecked(dataSeries.isVisible());
            TimeSeriesCanvas.this.draw();
        }
    }

    class LegendHideAction
    extends Action {
        public LegendHideAction() {
            super(Messages.getString("ContextMenu.HideLegend"), 2);
            this.setChecked(!TimeSeriesCanvas.this.showLegend);
        }

        public String getText() {
            return Messages.getString("ContextMenu.HideLegend");
        }

        public void run() {
            if (!TimeSeriesCanvas.this.showLegend) {
                this.setChecked(true);
            } else {
                TimeSeriesCanvas.this.toggleLegend();
            }
            TimeSeriesCanvas.this.draw();
        }
    }

    protected class LegendViewAction
    extends Action {
        public LegendViewAction() {
            super(Messages.getString("ContextMenu.ShowLegend"), 2);
            this.setChecked(TimeSeriesCanvas.this.showLegend);
        }

        public String getText() {
            return Messages.getString("ContextMenu.ShowLegend");
        }

        public void run() {
            if (TimeSeriesCanvas.this.showLegend) {
                this.setChecked(true);
            } else {
                TimeSeriesCanvas.this.toggleLegend();
            }
            TimeSeriesCanvas.this.draw();
        }
    }

    protected class LinearScaleAction
    extends Action {
        public LinearScaleAction() {
            super(Messages.getString("ContextMenu.LinearTimeScale"), 2);
            this.setChecked(TimeSeriesCanvas.this.useLinearTimeScale);
        }

        public String getText() {
            return Messages.getString("ContextMenu.LinearTimeScale");
        }

        public void run() {
            if (TimeSeriesCanvas.this.useLinearTimeScale) {
                this.setChecked(true);
            } else {
                TimeSeriesCanvas.this.toggleAxisScale();
            }
            TimeSeriesCanvas.this.draw();
        }
    }

    class LogScaleAction
    extends Action {
        public LogScaleAction() {
            super(Messages.getString("ContextMenu.LogTimeScale"), 2);
            this.setChecked(!TimeSeriesCanvas.this.useLinearTimeScale);
        }

        public String getText() {
            return Messages.getString("ContextMenu.LogTimeScale");
        }

        public void run() {
            if (!TimeSeriesCanvas.this.useLinearTimeScale) {
                this.setChecked(true);
            } else {
                TimeSeriesCanvas.this.toggleAxisScale();
            }
            TimeSeriesCanvas.this.draw();
        }
    }
}

