/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Anchor;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Marker;
import org.eclipse.birt.chart.model.attribute.MarkerType;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.MarkerImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.ScatterSeries;
import org.eclipse.birt.chart.model.type.impl.ScatterSeriesImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.stem.ui.preferences.VisualizationPreferencePage;
import org.eclipse.stem.util.analysis.Activator;
import org.eclipse.stem.util.analysis.views.AnalysisControl;
import org.eclipse.stem.util.analysis.views.Messages;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XYSeriesCanvas
extends Canvas {
    protected IDeviceRenderer idr = null;
    protected Chart cm = null;
    private AnalysisControl control = null;
    protected int chartIndex = 0;
    private static final String DEFAULT_KEY_PREFIX = "XY";
    private static String defaultKey = "XY";
    protected static final int[][] colorDefault;
    private int seriesCount = 0;
    Menu popUpMenu = null;
    private LinearScaleAction linearTimeAction;
    private LogScaleAction logTimeAction;
    protected boolean useLinearTimeScale = true;
    private LegendViewAction viewLegend;
    private LegendHideAction hideLegend;
    protected boolean showLegend = true;
    protected Legend legend = null;
    protected final Map<String, DataXYSeries> dataSeriesMap = new HashMap<String, DataXYSeries>();
    Generator gr;
    Axis yAxisPrimary;
    Axis xAxisPrimary;
    double maxY = Double.MIN_VALUE;
    double maxX = Double.MIN_VALUE;
    private double minY = Double.MAX_VALUE;
    private double minX = Double.MAX_VALUE;
    public String Ordinate_LEGEND = "Y";
    public String Ordinate_AXIS = "Y";
    protected ColorDefinition foreGround = ColorDefinitionImpl.WHITE();
    private ColorDefinition backgroundGround = ColorDefinitionImpl.BLACK();
    private ColorDefinition frameColor = ColorDefinitionImpl.create((int)180, (int)180, (int)200);
    Image imgChart = null;

    static {
        int[][] nArrayArray = new int[8][];
        int[] nArray = new int[3];
        nArray[2] = 255;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = 255;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[1] = 255;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[3];
        nArray4[0] = 255;
        nArray4[1] = 255;
        nArrayArray[3] = nArray4;
        nArrayArray[4] = new int[3];
        nArrayArray[5] = new int[]{127, 127, 127};
        nArrayArray[6] = new int[]{255, 255, 255};
        nArrayArray[7] = new int[]{255, 197, 41};
        colorDefault = nArrayArray;
    }

    public XYSeriesCanvas(AnalysisControl analysisControl, Composite composite, String string, String string2, ColorDefinition colorDefinition, ColorDefinition colorDefinition2, ColorDefinition colorDefinition3, int n) {
        super(composite, 0x20000800);
        this.Ordinate_LEGEND = string;
        this.Ordinate_AXIS = string2;
        defaultKey = DEFAULT_KEY_PREFIX + n;
        this.foreGround = colorDefinition;
        this.backgroundGround = colorDefinition2;
        this.frameColor = colorDefinition3;
        this.chartIndex = n;
        this.gr = Generator.instance();
        try {
            this.idr = PluginSettings.instance().getDevice("dv.SWT");
        }
        catch (ChartException chartException) {
            Activator.logError("Problem initializing chart", chartException);
            return;
        }
        this.control = analysisControl;
        this.cm = this.createSimpleLineChart(this.dataSeriesMap, Messages.getString("CC.title"));
        this.resetData();
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                Composite composite = (Composite)paintEvent.getSource();
                Rectangle rectangle = composite.getClientArea();
                if (XYSeriesCanvas.this.imgChart != null) {
                    XYSeriesCanvas.this.imgChart.dispose();
                }
                XYSeriesCanvas.this.imgChart = new Image((Device)composite.getDisplay(), rectangle);
                XYSeriesCanvas.this.idr.setProperty("device.output.context", (Object)new GC((Drawable)XYSeriesCanvas.this.imgChart));
                Bounds bounds = BoundsImpl.create((double)rectangle.x, (double)rectangle.y, (double)rectangle.width, (double)rectangle.height);
                bounds.scale(72.0 / (double)XYSeriesCanvas.this.idr.getDisplayServer().getDpiResolution());
                try {
                    XYSeriesCanvas.this.gr.render(XYSeriesCanvas.this.idr, XYSeriesCanvas.this.gr.build(XYSeriesCanvas.this.idr.getDisplayServer(), XYSeriesCanvas.this.cm, bounds, null, null, null));
                    paintEvent.gc.drawImage(XYSeriesCanvas.this.imgChart, rectangle.x, rectangle.y);
                }
                catch (ChartException chartException) {
                    Activator.logError("Problem rendering chart", chartException);
                }
            }
        });
        this.createContextMenu((Composite)this);
    }

    public XYSeriesCanvas(Composite composite, String string, String string2, ColorDefinition colorDefinition, ColorDefinition colorDefinition2, ColorDefinition colorDefinition3, int n) {
        super(composite, 0x20000800);
        this.Ordinate_LEGEND = string;
        this.Ordinate_AXIS = string2;
        defaultKey = DEFAULT_KEY_PREFIX + n;
        this.foreGround = colorDefinition;
        this.backgroundGround = colorDefinition2;
        this.frameColor = colorDefinition3;
        this.chartIndex = n;
        this.gr = Generator.instance();
        try {
            this.idr = PluginSettings.instance().getDevice("dv.SWT");
        }
        catch (ChartException chartException) {
            Activator.logError("Problem initializing chart", chartException);
            return;
        }
        this.control = (AnalysisControl)composite;
        this.cm = this.createSimpleLineChart(this.dataSeriesMap, Messages.getString("CC.title"));
        this.resetData();
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                Composite composite = (Composite)paintEvent.getSource();
                Rectangle rectangle = composite.getClientArea();
                if (XYSeriesCanvas.this.imgChart != null) {
                    XYSeriesCanvas.this.imgChart.dispose();
                }
                XYSeriesCanvas.this.imgChart = new Image((Device)composite.getDisplay(), rectangle);
                XYSeriesCanvas.this.idr.setProperty("device.output.context", (Object)new GC((Drawable)XYSeriesCanvas.this.imgChart));
                Bounds bounds = BoundsImpl.create((double)rectangle.x, (double)rectangle.y, (double)rectangle.width, (double)rectangle.height);
                bounds.scale(72.0 / (double)XYSeriesCanvas.this.idr.getDisplayServer().getDpiResolution());
                try {
                    XYSeriesCanvas.this.gr.render(XYSeriesCanvas.this.idr, XYSeriesCanvas.this.gr.build(XYSeriesCanvas.this.idr.getDisplayServer(), XYSeriesCanvas.this.cm, bounds, null, null, null));
                    paintEvent.gc.drawImage(XYSeriesCanvas.this.imgChart, rectangle.x, rectangle.y);
                }
                catch (ChartException chartException) {
                    Activator.logError("Problem rendering chart", chartException);
                }
            }
        });
        this.createContextMenu((Composite)this);
    }

    public void draw() {
        this.resetData();
        this.maxY = -1.0;
        this.minY = 0.0;
        this.maxX = -1.0;
        this.minX = 0.0;
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        while (n <= 1) {
            DataXYSeries dataXYSeries;
            String string = DEFAULT_KEY_PREFIX + this.chartIndex;
            if (n == 1) {
                string = "FIT" + this.chartIndex;
            }
            if (!this.dataSeriesMap.containsKey(string)) {
                dataXYSeries = new DataXYSeries(string);
                ++this.seriesCount;
                this.dataSeriesMap.put(string, dataXYSeries);
            }
            if ((dataXYSeries = this.dataSeriesMap.get(string)).isVisible()) {
                dataXYSeries.show();
            } else {
                dataXYSeries.hide();
            }
            int n2 = 0;
            double[] dArray = this.control.getValues(this.chartIndex, 2 * n + 2);
            double[] dArray2 = this.control.getValues(this.chartIndex, 2 * n + 3);
            int n3 = 0;
            while (n3 < dArray.length) {
                double d3;
                if (dArray2[n3] <= this.minY) {
                    this.minY = dArray2[n3];
                    this.minY = Math.round(this.minY);
                }
                if (dArray[n3] <= this.minX) {
                    this.minX = dArray[n3];
                    this.minX = Math.round(this.minX);
                }
                if (dArray2[n3] >= this.maxY) {
                    this.maxY = dArray2[n3];
                    d3 = Math.floor(Math.log10(this.maxY));
                    d = Math.ceil(this.maxY / Math.pow(10.0, d3)) * Math.pow(10.0, d3);
                }
                if (dArray[n3] >= this.maxX) {
                    this.maxX = 1.02 * dArray[n3];
                    d3 = Math.floor(Math.log10(this.maxX));
                    d2 = Math.ceil(this.maxX / Math.pow(10.0, d3)) * Math.pow(10.0, d3);
                }
                ++n3;
            }
            this.xAxisPrimary.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
            this.xAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)d2));
            double d4 = d2 / 10.0;
            this.xAxisPrimary.getScale().setStep(d4);
            this.xAxisPrimary.setType(AxisType.LINEAR_LITERAL);
            this.yAxisPrimary.getScale().setMin((DataElement)NumberDataElementImpl.create((double)this.minY));
            this.yAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)d));
            double d5 = d / 10.0;
            this.yAxisPrimary.getScale().setStep(d5);
            this.yAxisPrimary.setType(AxisType.LINEAR_LITERAL);
            if (dArray.length > 0) {
                if (n2 < dArray.length) {
                    n2 = dArray.length;
                }
                int n4 = 0;
                while (n4 < dArray.length) {
                    Double d6 = new Double(dArray[n4]);
                    Double d7 = new Double(dArray2[n4]);
                    dataXYSeries.addValue(d6, d7);
                    ++n4;
                }
            }
            ++n;
        }
        if (!this.isDisposed()) {
            this.redraw();
        }
    }

    public final Chart createSimpleLineChart(Map<String, DataXYSeries> map, String string) {
        ChartWithAxes chartWithAxes = ChartWithAxesImpl.create();
        chartWithAxes.getBlock().setBackground((Fill)this.frameColor);
        Plot plot = chartWithAxes.getPlot();
        plot.getClientArea().setBackground((Fill)this.backgroundGround);
        chartWithAxes.getTitle().setVisible(false);
        this.legend = chartWithAxes.getLegend();
        LineAttributes lineAttributes = this.legend.getOutline();
        this.legend.getText().getFont().setSize(8.0f);
        lineAttributes.setStyle(LineStyle.SOLID_LITERAL);
        this.legend.getInsets().set(10.0, 5.0, 0.0, 0.0);
        this.legend.getOutline().setVisible(false);
        this.legend.setAnchor(Anchor.NORTH_LITERAL);
        this.legend.setPosition(Position.BELOW_LITERAL);
        this.legend.getText().setColor(this.foreGround);
        this.legend.getOutline().setColor(this.foreGround);
        this.xAxisPrimary = chartWithAxes.getPrimaryBaseAxes()[0];
        this.xAxisPrimary.setType(AxisType.TEXT_LITERAL);
        this.xAxisPrimary.getMajorGrid().setTickStyle(TickStyle.BELOW_LITERAL);
        this.xAxisPrimary.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        this.xAxisPrimary.getTitle().setVisible(false);
        this.xAxisPrimary.getTitle().getCaption().getFont().setSize(9.0f);
        this.xAxisPrimary.getTitle().getCaption().setColor(this.foreGround);
        this.xAxisPrimary.getLabel().getCaption().setColor(this.foreGround);
        this.yAxisPrimary = chartWithAxes.getPrimaryOrthogonalAxis(this.xAxisPrimary);
        this.yAxisPrimary.getMajorGrid().setTickStyle(TickStyle.LEFT_LITERAL);
        this.xAxisPrimary.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
        this.xAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)1.0));
        this.xAxisPrimary.getScale().setStep(0.1);
        this.xAxisPrimary.getLabel().getCaption().getFont().setSize(9.0f);
        this.xAxisPrimary.getLabel().getCaption().setColor(this.foreGround);
        this.xAxisPrimary.getTitle().setVisible(true);
        this.xAxisPrimary.getTitle().getCaption().setValue(Messages.getString("TS.TIMELABEL"));
        this.yAxisPrimary.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
        this.yAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)1.0));
        this.yAxisPrimary.getScale().setStep(0.1);
        this.yAxisPrimary.getLabel().getCaption().getFont().setSize(9.0f);
        this.yAxisPrimary.getLabel().getCaption().setColor(this.foreGround);
        this.yAxisPrimary.getTitle().getCaption().setValue(this.Ordinate_AXIS);
        this.yAxisPrimary.getTitle().setVisible(true);
        if (!map.containsKey(defaultKey)) {
            DataXYSeries dataXYSeries = new DataXYSeries(defaultKey);
            ++this.seriesCount;
            map.put(defaultKey, dataXYSeries);
        }
        return chartWithAxes;
    }

    protected void createContextMenu(Composite composite) {
        MenuManager menuManager = new MenuManager();
        this.linearTimeAction = new LinearScaleAction();
        this.logTimeAction = new LogScaleAction();
        menuManager.add((IAction)this.linearTimeAction);
        menuManager.add((IAction)this.logTimeAction);
        menuManager.add((IContributionItem)new Separator("additions"));
        this.viewLegend = new LegendViewAction();
        this.hideLegend = new LegendHideAction();
        menuManager.add((IAction)this.viewLegend);
        menuManager.add((IAction)this.hideLegend);
        menuManager.add((IContributionItem)new Separator("additions"));
        this.popUpMenu = menuManager.createContextMenu((Control)composite);
        composite.setMenu(this.popUpMenu);
    }

    private void updateContextMenu(Composite composite) {
        this.popUpMenu.dispose();
        MenuManager menuManager = new MenuManager();
        this.linearTimeAction = new LinearScaleAction();
        this.logTimeAction = new LogScaleAction();
        menuManager.add((IAction)this.linearTimeAction);
        menuManager.add((IAction)this.logTimeAction);
        menuManager.add((IContributionItem)new Separator("additions"));
        this.viewLegend = new LegendViewAction();
        this.hideLegend = new LegendHideAction();
        menuManager.add((IAction)this.viewLegend);
        menuManager.add((IAction)this.hideLegend);
        menuManager.add((IContributionItem)new Separator("additions"));
        int n = 0;
        while (n < this.control.getNumProperties(this.chartIndex)) {
            String string = this.control.getProperty(this.chartIndex, n);
            DataXYSeries dataXYSeries = this.dataSeriesMap.get(string);
            DisplayableProperty displayableProperty = new DisplayableProperty(string, dataXYSeries.isVisible());
            menuManager.add((IAction)displayableProperty);
            ++n;
        }
        menuManager.add((IContributionItem)new Separator("additions"));
        Menu menu = menuManager.createContextMenu((Control)composite);
        composite.setMenu(menu);
    }

    public static void setColorDefs(List<String> list, List<ScatterSeries> list2) {
        Map map = VisualizationPreferencePage.getColorMapping();
        int n = 0;
        while (n < list2.size()) {
            ColorDefinition colorDefinition = ColorDefinitionImpl.BLUE();
            if (list != null && list.size() > n) {
                String string = list.get(n);
                if (map.containsKey(string)) {
                    Color color = (Color)map.get(string);
                    colorDefinition = ColorDefinitionImpl.create((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue());
                }
                list2.get(n).setSeriesIdentifier((Object)string);
                list2.get(n).getLineAttributes().setColor(colorDefinition);
            } else if (list2.get(n) != null) {
                list2.get(n).setSeriesIdentifier((Object)" ");
                list2.get(n).getLineAttributes().setColor(colorDefinition);
            }
            ++n;
        }
    }

    public void dispose() {
        super.dispose();
    }

    public void reset() {
        this.resetData();
        this.redraw();
    }

    protected void resetData() {
        this.clearData();
    }

    private void clearData() {
        Iterator<String> iterator = this.dataSeriesMap.keySet().iterator();
        while (iterator != null && iterator.hasNext()) {
            String string = iterator.next();
            DataXYSeries dataXYSeries = this.dataSeriesMap.get(string);
            dataXYSeries.yValues.clear();
            dataXYSeries.xValues.clear();
            dataXYSeries.addValue(new Double(0.0), new Double(0.0));
        }
    }

    void toggleAxisScale() {
    }

    void toggleLegend() {
        if (this.showLegend) {
            this.viewLegend.setChecked(false);
            this.hideLegend.setChecked(true);
            this.legend.setVisible(false);
        } else {
            this.viewLegend.setChecked(true);
            this.hideLegend.setChecked(false);
            this.legend.setVisible(true);
        }
        this.showLegend = !this.showLegend;
        this.draw();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DataXYSeries {
        public String propertyName = "";
        public List<Double> yValues = new ArrayList<Double>();
        public List<Double> xValues = new ArrayList<Double>();
        public Series seriesX = null;
        public ScatterSeries scatterSeriesY = null;
        private boolean visible = true;
        private SeriesDefinition sdY = null;
        private SeriesDefinition sdX = null;

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean bl) {
            this.visible = bl;
        }

        public void toggleVisible() {
            this.visible = !this.visible;
        }

        public DataXYSeries(String string) {
            this.propertyName = string;
            this.yValues = new ArrayList<Double>();
            this.yValues.add(new Double(0.0));
            this.xValues = new ArrayList<Double>();
            this.xValues.add(new Double(0.0));
            this.addScatterSeries(string);
        }

        public void addValue(Double d, Double d2) {
            if (this.yValues == null) {
                this.yValues = new ArrayList<Double>();
            }
            if (this.xValues == null) {
                this.xValues = new ArrayList<Double>();
            }
            this.xValues.add(d);
            this.yValues.add(d2);
        }

        public void addScatterSeries(String string) {
            NumberDataSet numberDataSet = NumberDataSetImpl.create(this.yValues);
            NumberDataSet numberDataSet2 = NumberDataSetImpl.create(this.xValues);
            this.sdX = SeriesDefinitionImpl.create();
            XYSeriesCanvas.this.xAxisPrimary.getSeriesDefinitions().add((Object)this.sdX);
            if (this.scatterSeriesY == null) {
                this.sdY = SeriesDefinitionImpl.create();
                this.scatterSeriesY = (ScatterSeries)ScatterSeriesImpl.create();
                this.seriesX = SeriesImpl.create();
            }
            this.seriesX.getLabel().getCaption().setColor(XYSeriesCanvas.this.foreGround);
            this.seriesX.getLabel().getOutline().setColor(XYSeriesCanvas.this.foreGround);
            this.seriesX.setDataSet((DataSet)numberDataSet2);
            this.sdX.getSeries().add((Object)this.seriesX);
            this.scatterSeriesY.setDataSet((DataSet)numberDataSet);
            this.setColorDefs(string);
            ColorDefinition colorDefinition = ColorDefinitionImpl.create((int)colorDefault[XYSeriesCanvas.this.chartIndex][0], (int)colorDefault[XYSeriesCanvas.this.chartIndex][1], (int)colorDefault[XYSeriesCanvas.this.chartIndex][2]);
            this.sdY.getSeriesPalette().update((Fill)colorDefinition);
            this.sdY.getSeries().add((Object)this.scatterSeriesY);
            XYSeriesCanvas.this.yAxisPrimary.getSeriesDefinitions().add((Object)this.sdY);
        }

        public void hide() {
            this.scatterSeriesY.setVisible(false);
            this.visible = false;
        }

        public void show() {
            this.scatterSeriesY.setVisible(true);
            this.visible = true;
        }

        public void setColorDefs(String string) {
            this.scatterSeriesY.setSeriesIdentifier((Object)string);
            if (string.indexOf(XYSeriesCanvas.DEFAULT_KEY_PREFIX) >= 0) {
                this.scatterSeriesY.setPaletteLineColor(true);
                Marker marker = MarkerImpl.create((MarkerType)MarkerType.CIRCLE_LITERAL, (int)2);
                this.scatterSeriesY.getMarkers().clear();
                this.scatterSeriesY.getMarkers().add((Object)marker);
                this.scatterSeriesY.getLineAttributes().setVisible(false);
            } else {
                this.scatterSeriesY.getLineAttributes().setColor(ColorDefinitionImpl.BLACK());
                this.scatterSeriesY.getLineAttributes().setStyle(LineStyle.DOTTED_LITERAL);
                this.scatterSeriesY.getLineAttributes().setVisible(true);
                if (!this.scatterSeriesY.getMarkers().isEmpty()) {
                    Marker marker = (Marker)this.scatterSeriesY.getMarkers().get(0);
                    marker.setVisible(false);
                }
            }
        }

        public int getDataSize() {
            return this.yValues.size();
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public void setPropertyName(String string) {
            this.propertyName = string;
        }

        public List<Double> getyValues() {
            return this.yValues;
        }

        public void setyValues(List<Double> list) {
            this.yValues = list;
        }

        public void setScatterSeries(ScatterSeries scatterSeries) {
            this.scatterSeriesY = scatterSeries;
        }
    }

    protected class DisplayableProperty
    extends Action {
        String property;

        public DisplayableProperty(String string, boolean bl) {
            super(string, 2);
            this.property = null;
            this.property = string;
            this.setChecked(bl);
        }

        public String getText() {
            return this.property;
        }

        public void run() {
            DataXYSeries dataXYSeries = XYSeriesCanvas.this.dataSeriesMap.get(this.property);
            dataXYSeries.toggleVisible();
            XYSeriesCanvas.this.dataSeriesMap.put(this.property, dataXYSeries);
            this.setChecked(dataXYSeries.isVisible());
            XYSeriesCanvas.this.draw();
        }
    }

    class LegendHideAction
    extends Action {
        public LegendHideAction() {
            super(Messages.getString("ContextMenu.HideLegend"), 2);
            this.setChecked(!XYSeriesCanvas.this.showLegend);
        }

        public String getText() {
            return Messages.getString("ContextMenu.HideLegend");
        }

        public void run() {
            if (!XYSeriesCanvas.this.showLegend) {
                this.setChecked(true);
            } else {
                XYSeriesCanvas.this.toggleLegend();
            }
            XYSeriesCanvas.this.draw();
        }
    }

    protected class LegendViewAction
    extends Action {
        public LegendViewAction() {
            super(Messages.getString("ContextMenu.ShowLegend"), 2);
            this.setChecked(XYSeriesCanvas.this.showLegend);
        }

        public String getText() {
            return Messages.getString("ContextMenu.ShowLegend");
        }

        public void run() {
            if (XYSeriesCanvas.this.showLegend) {
                this.setChecked(true);
            } else {
                XYSeriesCanvas.this.toggleLegend();
            }
            XYSeriesCanvas.this.draw();
        }
    }

    protected class LinearScaleAction
    extends Action {
        public LinearScaleAction() {
            super(Messages.getString("ContextMenu.LinearTimeScale"), 2);
            this.setChecked(XYSeriesCanvas.this.useLinearTimeScale);
        }

        public String getText() {
            return Messages.getString("ContextMenu.LinearTimeScale");
        }

        public void run() {
            if (XYSeriesCanvas.this.useLinearTimeScale) {
                this.setChecked(true);
            } else {
                XYSeriesCanvas.this.toggleAxisScale();
            }
            XYSeriesCanvas.this.draw();
        }
    }

    class LogScaleAction
    extends Action {
        public LogScaleAction() {
            super(Messages.getString("ContextMenu.LogTimeScale"), 2);
            this.setChecked(!XYSeriesCanvas.this.useLinearTimeScale);
        }

        public String getText() {
            return Messages.getString("ContextMenu.LogTimeScale");
        }

        public void run() {
            if (!XYSeriesCanvas.this.useLinearTimeScale) {
                this.setChecked(true);
            } else {
                XYSeriesCanvas.this.toggleAxisScale();
            }
            XYSeriesCanvas.this.draw();
        }
    }
}

