/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.solvers.fd.impl;

import java.util.Iterator;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.graph.IntegrationLabelValue;
import org.eclipse.stem.core.graph.LabelValue;
import org.eclipse.stem.core.graph.SimpleDataExchangeLabelValue;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.IntegrationDecorator;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.solver.impl.SolverImpl;
import org.eclipse.stem.core.trigger.Trigger;
import org.eclipse.stem.solvers.fd.FdPackage;
import org.eclipse.stem.solvers.fd.FiniteDifference;
import org.eclipse.stem.solvers.fd.impl.FdJob;
import org.eclipse.stem.ui.Activator;

public class FiniteDifferenceImpl
extends SolverImpl
implements FiniteDifference {
    private FdJob[] jobs;
    private short num_threads;
    private static final int MAX_PROGRESS_REPORTS = 5;

    public void step(STEMTime sTEMTime, long l, int n) {
        FdJob[] fdJobArray;
        Activator activator;
        if (!this.isInitialized()) {
            this.initialize(sTEMTime);
        }
        if ((activator = Activator.getDefault()) != null) {
            Preferences preferences = activator.getPluginPreferences();
            this.num_threads = (short)preferences.getInt("simulationThreads");
        } else {
            this.num_threads = (short)2;
        }
        for (Preferences preferences : this.getDecorators()) {
            if (!(preferences instanceof Trigger)) continue;
            preferences.updateLabels(sTEMTime, l, n);
        }
        for (Preferences preferences : this.getDecorators()) {
            EList eList = preferences.getLabelsToUpdate();
            fdJobArray = eList.iterator();
            while (fdJobArray.hasNext()) {
                if (!(preferences instanceof IntegrationDecorator)) continue;
                IntegrationLabel integrationLabel = (IntegrationLabel)fdJobArray.next();
                ((IntegrationLabelValue)integrationLabel.getProbeValue()).set((IntegrationLabelValue)integrationLabel.getCurrentValue());
                ((IntegrationLabelValue)integrationLabel.getTempValue()).set((IntegrationLabelValue)integrationLabel.getCurrentValue());
            }
        }
        if (this.jobs == null || this.jobs.length != this.num_threads) {
            this.jobs = new FdJob[this.num_threads];
            int n2 = 0;
            while (n2 < this.num_threads) {
                short s = (short)n2;
                this.jobs[n2] = new FdJob("Finite Difference Worker " + n2, s, this);
                ++n2;
            }
        }
        fdJobArray = this.jobs;
        int n3 = this.jobs.length;
        int n4 = 0;
        while (n4 < n3) {
            FdJob fdJob = fdJobArray[n4];
            fdJob.cycle = n;
            fdJob.time = sTEMTime;
            fdJob.timeDelta = l;
            ++n4;
        }
        fdJobArray = this.jobs;
        n3 = this.jobs.length;
        n4 = 0;
        while (n4 < n3) {
            FdJob fdJob = fdJobArray[n4];
            fdJob.schedule();
            ++n4;
        }
        fdJobArray = this.jobs;
        n3 = this.jobs.length;
        n4 = 0;
        while (n4 < n3) {
            FdJob fdJob = fdJobArray[n4];
            try {
                fdJob.join();
            }
            catch (InterruptedException interruptedException) {
                Activator.logError((String)interruptedException.getMessage(), (Throwable)interruptedException);
            }
            ++n4;
        }
    }

    protected void _step(STEMTime sTEMTime, long l, int n, short s) {
        BasicEList basicEList = new BasicEList();
        for (Iterator iterator : this.getDecorators()) {
            if (!iterator.isEnabled() || !(iterator instanceof IntegrationDecorator)) continue;
            basicEList.add((Object)((IntegrationDecorator)iterator));
        }
        for (Iterator iterator : basicEList) {
            iterator.calculateDelta(sTEMTime, l, ((Decorator)iterator).getLabelsToUpdate((int)s, (int)this.num_threads));
        }
        for (Iterator iterator : basicEList) {
            iterator.applyExternalDeltas(sTEMTime, l, ((Decorator)iterator).getLabelsToUpdate((int)s, (int)this.num_threads));
        }
        for (Iterator iterator : basicEList) {
            this.updateStandardDiseaseModelLabels((Decorator)iterator, sTEMTime, l, n, s);
        }
    }

    protected void updateStandardDiseaseModelLabels(Decorator decorator, STEMTime sTEMTime, long l, int n, short s) {
        EList eList = decorator.getLabelsToUpdate((int)s, (int)this.num_threads);
        IntegrationDecorator integrationDecorator = (IntegrationDecorator)decorator;
        int n2 = eList.size();
        int n3 = this.num_threads * n2 / 5;
        if (n3 == 0) {
            n3 = 1;
        }
        int n4 = 0;
        for (IntegrationLabel integrationLabel : eList) {
            IntegrationLabelValue integrationLabelValue = (IntegrationLabelValue)integrationLabel.getNextValue();
            IntegrationLabelValue integrationLabelValue2 = (IntegrationLabelValue)integrationLabel.getDeltaValue();
            integrationLabelValue2.adjustDelta((IntegrationLabelValue)integrationLabel.getCurrentValue());
            integrationLabelValue.set(integrationLabelValue2);
            integrationLabelValue.add((IntegrationLabelValue)integrationLabel.getCurrentValue());
            integrationDecorator.doModelSpecificAdjustments((LabelValue)integrationLabelValue);
            integrationLabel.setNextValueValid(true);
            double d = (double)n4 / (double)n2;
            this.jobs[s].setProgress(d);
            if (n4 % n3 == 0) {
                int n5 = 0;
                while (n5 < this.num_threads) {
                    if (n5 != s && this.jobs[n5] != null) {
                        d += this.jobs[n5].getProgress();
                    }
                    ++n5;
                }
                decorator.setProgress(d /= (double)this.num_threads);
            }
            ++n4;
        }
    }

    private void initialize(STEMTime sTEMTime) {
        IntegrationLabel integrationLabel;
        EList eList;
        BasicEList basicEList = new BasicEList();
        boolean bl = false;
        for (Decorator decorator : this.getDecorators()) {
            if (decorator instanceof IntegrationDecorator) {
                eList = decorator.getLabelsToUpdate();
                for (DynamicLabel dynamicLabel : eList) {
                    if (!(dynamicLabel instanceof IntegrationLabel)) continue;
                    integrationLabel = (IntegrationLabel)dynamicLabel;
                    integrationLabel.reset(sTEMTime);
                    if (!(((SimpleDataExchangeLabelValue)integrationLabel.getDeltaValue()).getAdditions() > 0.0) && !(((SimpleDataExchangeLabelValue)integrationLabel.getDeltaValue()).getSubstractions() > 0.0)) continue;
                    bl = true;
                }
            }
            if (bl) continue;
            basicEList.add((Object)decorator);
        }
        if (bl) {
            for (Decorator decorator : basicEList) {
                if (!(decorator instanceof IntegrationDecorator)) continue;
                eList = decorator.getLabelsToUpdate();
                for (DynamicLabel dynamicLabel : eList) {
                    if (!(dynamicLabel instanceof IntegrationLabel)) continue;
                    integrationLabel = (IntegrationLabel)dynamicLabel;
                    integrationLabel.reset(sTEMTime);
                }
            }
        }
        this.setInitialized(true);
    }

    public void reset() {
        this.setInitialized(false);
    }

    protected EClass eStaticClass() {
        return FdPackage.Literals.FINITE_DIFFERENCE;
    }
}

