/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.forcing.impl;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.diseasemodels.forcing.ForcingDiseaseModel;
import org.eclipse.stem.diseasemodels.forcing.ForcingPackage;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.SILabelValue;
import org.eclipse.stem.diseasemodels.standard.SIRLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.impl.SIRLabelValueImpl;
import org.eclipse.stem.diseasemodels.standard.impl.StochasticSIRDiseaseModelImpl;

public class ForcingDiseaseModelImpl
extends StochasticSIRDiseaseModelImpl
implements ForcingDiseaseModel {
    protected static final double SEASONAL_MODULATION_EXPONENT_EDEFAULT = 2.0;
    protected double seasonalModulationExponent = 2.0;
    protected static final double MODULATION_PERIOD_EDEFAULT = 365.256363051;
    protected double modulationPeriod = 365.256363051;
    protected static final double MODULATION_PHASE_SHIFT_EDEFAULT = 0.0;
    protected double modulationPhaseShift = 0.0;
    protected static final double SEASONAL_MODULATION_FLOOR_EDEFAULT = 0.6;
    protected double seasonalModulationFloor = 0.6;
    protected static final double ATTENUATION_EDEFAULT = 0.1;
    protected double attenuation = 0.1;
    private static final double MILLIS_PER_DAY = 8.64E7;
    private final Calendar calendar = Calendar.getInstance();
    private static Map<Integer, Integer> signalMap = new HashMap<Integer, Integer>();

    static {
        signalMap.put(1999, 1);
        signalMap.put(2000, 1);
        signalMap.put(2001, 1);
        signalMap.put(2002, 1);
        signalMap.put(2003, 1);
        signalMap.put(2004, 1);
        signalMap.put(2005, 1);
        signalMap.put(2006, 1);
        signalMap.put(2007, 1);
        signalMap.put(2008, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StandardDiseaseModelLabelValue computeDiseaseDeltas(STEMTime sTEMTime, StandardDiseaseModelLabelValue standardDiseaseModelLabelValue, StandardDiseaseModelLabel standardDiseaseModelLabel, long l, DiseaseModelLabelValue diseaseModelLabelValue) {
        SIRLabelValue sIRLabelValue = (SIRLabelValue)standardDiseaseModelLabelValue;
        double d = sTEMTime.getTime().getTime();
        double d2 = this.getSeasonalModulationExponent();
        double d3 = this.getSeasonalModulationFloor();
        double d4 = this.getModulationPeriod();
        double d5 = this.getModulationPhaseShift();
        long l2 = (long)(d + d4 * 8.64E7 * d5 / Math.PI);
        int n = 0;
        Calendar calendar = this.calendar;
        synchronized (calendar) {
            this.calendar.setTimeInMillis(l2);
            n = this.calendar.get(1);
        }
        double d6 = 1.0;
        if (signalMap.containsKey(n)) {
            d6 = signalMap.get(n) == 0 ? this.getAttenuation() : 1.0;
        }
        double d7 = d3 + (1.0 - d3) * Math.pow(Math.abs(Math.sin(d5 + Math.PI * d / (d4 * 8.64E7))), d2);
        double d8 = d7 * d6 * this.getAdjustedTransmissionRate(l);
        if (!this.isFrequencyDependent()) {
            d8 *= this.getTransmissionRateScaleFactor(standardDiseaseModelLabel);
        }
        double d9 = this.getNormalizedEffectiveInfectious(standardDiseaseModelLabel.getNode(), standardDiseaseModelLabel, sIRLabelValue.getI());
        double d10 = this.getAdjustedRecoveryRate(l) * sIRLabelValue.getI();
        double d11 = this.getAdjustedImmunityLossRate(l) * sIRLabelValue.getR();
        double d12 = 0.0;
        d12 = this.getNonLinearityCoefficient() != 1.0 && d9 >= 0.0 ? d8 * sIRLabelValue.getS() * Math.pow(d9, this.getNonLinearityCoefficient()) : d8 * sIRLabelValue.getS() * d9;
        double d13 = d11 - d12;
        double d14 = d12 - d10;
        double d15 = d10 - d11;
        SIRLabelValueImpl sIRLabelValueImpl = (SIRLabelValueImpl)diseaseModelLabelValue;
        sIRLabelValueImpl.setS(d13);
        sIRLabelValueImpl.setI(d14);
        sIRLabelValueImpl.setIncidence(d10);
        sIRLabelValueImpl.setR(d15);
        sIRLabelValueImpl.setDiseaseDeaths(0.0);
        return sIRLabelValueImpl;
    }

    public void doModelSpecificAdjustments(StandardDiseaseModelLabelValue standardDiseaseModelLabelValue) {
        SILabelValue sILabelValue = (SILabelValue)standardDiseaseModelLabelValue;
        double d = sILabelValue.getI();
        double d2 = sILabelValue.getI() * this.computeNoise();
        double d3 = d - d2;
        sILabelValue.setI(d2);
        double d4 = sILabelValue.getS() + d3;
        if (d4 < 0.0) {
            double d5 = (sILabelValue.getS() + d4) / sILabelValue.getS();
            sILabelValue.setI(d2 * d5);
        } else {
            sILabelValue.setS(d4);
        }
    }

    protected EClass eStaticClass() {
        return ForcingPackage.Literals.FORCING_DISEASE_MODEL;
    }

    public double getSeasonalModulationExponent() {
        return this.seasonalModulationExponent;
    }

    public void setSeasonalModulationExponent(double d) {
        double d2 = this.seasonalModulationExponent;
        this.seasonalModulationExponent = d;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 31, d2, this.seasonalModulationExponent));
        }
    }

    public double getModulationPeriod() {
        return this.modulationPeriod;
    }

    public void setModulationPeriod(double d) {
        double d2 = this.modulationPeriod;
        this.modulationPeriod = d;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 32, d2, this.modulationPeriod));
        }
    }

    public double getModulationPhaseShift() {
        return this.modulationPhaseShift;
    }

    public void setModulationPhaseShift(double d) {
        double d2 = this.modulationPhaseShift;
        this.modulationPhaseShift = d;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 33, d2, this.modulationPhaseShift));
        }
    }

    public double getSeasonalModulationFloor() {
        return this.seasonalModulationFloor;
    }

    public void setSeasonalModulationFloor(double d) {
        double d2 = this.seasonalModulationFloor;
        this.seasonalModulationFloor = d;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 34, d2, this.seasonalModulationFloor));
        }
    }

    public double getAttenuation() {
        return this.attenuation;
    }

    public void setAttenuation(double d) {
        double d2 = this.attenuation;
        this.attenuation = d;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 35, d2, this.attenuation));
        }
    }

    public Object eGet(int n, boolean bl, boolean bl2) {
        switch (n) {
            case 31: {
                return new Double(this.getSeasonalModulationExponent());
            }
            case 32: {
                return new Double(this.getModulationPeriod());
            }
            case 33: {
                return new Double(this.getModulationPhaseShift());
            }
            case 34: {
                return new Double(this.getSeasonalModulationFloor());
            }
            case 35: {
                return new Double(this.getAttenuation());
            }
        }
        return super.eGet(n, bl, bl2);
    }

    public void eSet(int n, Object object) {
        switch (n) {
            case 31: {
                this.setSeasonalModulationExponent((Double)object);
                return;
            }
            case 32: {
                this.setModulationPeriod((Double)object);
                return;
            }
            case 33: {
                this.setModulationPhaseShift((Double)object);
                return;
            }
            case 34: {
                this.setSeasonalModulationFloor((Double)object);
                return;
            }
            case 35: {
                this.setAttenuation((Double)object);
                return;
            }
        }
        super.eSet(n, object);
    }

    public void eUnset(int n) {
        switch (n) {
            case 31: {
                this.setSeasonalModulationExponent(2.0);
                return;
            }
            case 32: {
                this.setModulationPeriod(365.256363051);
                return;
            }
            case 33: {
                this.setModulationPhaseShift(0.0);
                return;
            }
            case 34: {
                this.setSeasonalModulationFloor(0.6);
                return;
            }
            case 35: {
                this.setAttenuation(0.1);
                return;
            }
        }
        super.eUnset(n);
    }

    public boolean eIsSet(int n) {
        switch (n) {
            case 31: {
                return this.seasonalModulationExponent != 2.0;
            }
            case 32: {
                return this.modulationPeriod != 365.256363051;
            }
            case 33: {
                return this.modulationPhaseShift != 0.0;
            }
            case 34: {
                return this.seasonalModulationFloor != 0.6;
            }
            case 35: {
                return this.attenuation != 0.1;
            }
        }
        return super.eIsSet(n);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(" (seasonalModulationExponent: ");
        stringBuffer.append(this.seasonalModulationExponent);
        stringBuffer.append(", modulationPeriod: ");
        stringBuffer.append(this.modulationPeriod);
        stringBuffer.append(", modulationPhaseShift: ");
        stringBuffer.append(this.modulationPhaseShift);
        stringBuffer.append(", seasonalModulationFloor: ");
        stringBuffer.append(this.seasonalModulationFloor);
        stringBuffer.append(", attenuation: ");
        stringBuffer.append(this.attenuation);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

