/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.internal.data.geography.population.human.models;

import java.io.File;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.stem.core.Utility;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.model.Model;
import org.eclipse.stem.core.model.ModelPackage;
import org.eclipse.stem.data.geography.ISOKey;
import org.eclipse.stem.definitions.labels.LabelsPackage;
import org.eclipse.stem.internal.data.generatedplugin.DublinCore;
import org.eclipse.stem.internal.data.geography.specifications.AdminLevelSet;
import org.eclipse.stem.internal.data.specifications.GraphPropertyFileSpecification;
import org.eclipse.stem.internal.data.specifications.ModelSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PopulationModelSpecification
extends ModelSpecification
implements Comparable<PopulationModelSpecification> {
    private final ModelPackage modelPackage = ModelPackage.eINSTANCE;
    private final LabelsPackage labelsPackage = LabelsPackage.eINSTANCE;
    private final ISOKey isoKey;
    private final AdminLevelSet adminLevelSet;
    private final DublinCore countryGeographicModelDC;
    private final DublinCore populationGraphDC;

    static {
        String string = System.getProperty("user.dir");
        String string2 = string.substring(0, string.lastIndexOf(File.separator));
        String string3 = String.valueOf(string2) + File.separator + "org.eclipse.stem.data.geography.models" + File.separator;
        String string4 = String.valueOf(string2) + File.separator + "org.eclipse.stem.data.geography.population.human" + File.separator;
        Map map = EcorePlugin.getPlatformResourceMap();
        map.put("org.eclipse.stem.data.geography.models", URI.createFileURI((String)string3));
        map.put("org.eclipse.stem.data.geography.population.human", URI.createFileURI((String)string4));
    }

    public PopulationModelSpecification(ISOKey iSOKey, AdminLevelSet adminLevelSet, DublinCore dublinCore, DublinCore dublinCore2) {
        this.isoKey = iSOKey;
        this.adminLevelSet = adminLevelSet;
        this.countryGeographicModelDC = dublinCore;
        this.populationGraphDC = dublinCore2;
    }

    protected Model createIdentifiableInstance() {
        Model model = super.createIdentifiableInstance();
        model.getModels().add((Object)((Model)Utility.getIdentifiable((URI)PopulationModelSpecification.getIdentifiableProjectURI((DublinCore)this.countryGeographicModelDC))));
        model.getGraphs().add((Object)((Graph)Utility.getIdentifiable((URI)PopulationModelSpecification.getIdentifiableProjectURI((DublinCore)this.populationGraphDC))));
        return model;
    }

    protected String getRelativeSerializationPath() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("country");
        stringBuilder.append(File.separatorChar);
        stringBuilder.append(this.getISOKey().toString());
        return stringBuilder.toString();
    }

    protected String getSerializationFileNameRoot() {
        StringBuilder stringBuilder = new StringBuilder(this.getISOKey().toString());
        stringBuilder.append("_");
        stringBuilder.append(this.adminLevelSet.toString());
        stringBuilder.append("_population");
        return stringBuilder.toString();
    }

    protected String getTargetPluginId() {
        return "org.eclipse.stem.data.geography.population.human.models";
    }

    protected String getTitleDescriptor() {
        StringBuilder stringBuilder = new StringBuilder(this.isoKey.toString());
        stringBuilder.append(" Human Population");
        stringBuilder.append(this.adminLevelSet.getNumAdminLevels() > 1 ? " (Levels: " : " (Level: ");
        stringBuilder.append(this.adminLevelSet.toString(","));
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    protected String createDubinCoreCoverage() {
        return this.countryGeographicModelDC.getCoverage();
    }

    protected String createDubinCoreSubject() {
        return GraphPropertyFileSpecification.createDublinCoreSubjectString((String)ModelPackage.Literals.MODEL.getName(), (String)"population");
    }

    public ISOKey getISOKey() {
        return this.isoKey;
    }

    @Override
    public int compareTo(PopulationModelSpecification populationModelSpecification) {
        return this.adminLevelSet.getNumAdminLevels() > populationModelSpecification.adminLevelSet.getNumAdminLevels() ? 1 : -1;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.isoKey);
        stringBuilder.append(":");
        stringBuilder.append(this.adminLevelSet.toString());
        return stringBuilder.toString();
    }
}

