/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.solvers.fd.presentation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.stem.core.solver.Solver;
import org.eclipse.stem.core.solver.SolverPropertyEditor;
import org.eclipse.stem.solvers.fd.FdFactory;
import org.eclipse.stem.solvers.fd.FdPackage;
import org.eclipse.stem.solvers.fd.FiniteDifference;
import org.eclipse.stem.ui.adapters.propertystrings.PropertyStringProvider;
import org.eclipse.stem.ui.adapters.propertystrings.PropertyStringProviderAdapter;
import org.eclipse.stem.ui.adapters.propertystrings.PropertyStringProviderAdapterFactory;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FdSolverPropertyEditor
extends SolverPropertyEditor {
    protected final Map<EStructuralFeature, Text> map = new HashMap<EStructuralFeature, Text>();
    protected String errorMessage;

    public FdSolverPropertyEditor(Composite composite, int n, Solver solver, ModifyListener modifyListener) {
        super(composite, n);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.setLayout((Layout)gridLayout);
        PropertyStringProviderAdapter propertyStringProviderAdapter = (PropertyStringProviderAdapter)PropertyStringProviderAdapterFactory.INSTANCE.adapt((Notifier)solver, PropertyStringProvider.class);
        ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        IItemPropertySource iItemPropertySource = (IItemPropertySource)composedAdapterFactory.adapt((Notifier)solver, IItemPropertySource.class);
        List list = iItemPropertySource.getPropertyDescriptors((Object)solver);
        for (IItemPropertyDescriptor iItemPropertyDescriptor : list) {
            EStructuralFeature eStructuralFeature = (EStructuralFeature)iItemPropertyDescriptor.getFeature(null);
            if (!FdSolverPropertyEditor.isUserSpecifiedSolverProperty(eStructuralFeature)) continue;
            Label label = new Label((Composite)this, 0);
            label.setText(propertyStringProviderAdapter.getPropertyName(iItemPropertyDescriptor));
            GridData gridData = new GridData(1);
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalAlignment = 4;
            gridData.horizontalIndent = 0;
            label.setLayoutData((Object)gridData);
            String string = this.getPropertyDefaultValueString(iItemPropertyDescriptor);
            Text text = new Text((Composite)this, 133120);
            text.setText(string);
            text.setToolTipText(propertyStringProviderAdapter.getPropertyToolTip(iItemPropertyDescriptor));
            this.map.put(eStructuralFeature, text);
            GridData gridData2 = new GridData(3);
            gridData2.grabExcessHorizontalSpace = true;
            gridData2.horizontalAlignment = 4;
            text.setLayoutData((Object)gridData2);
            text.addModifyListener(modifyListener);
            Label label2 = new Label((Composite)this, 0);
            label2.setText(propertyStringProviderAdapter.getPropertyUnits(iItemPropertyDescriptor));
            GridData gridData3 = new GridData(3);
            gridData3.verticalAlignment = 2;
            label2.setLayoutData((Object)gridData3);
        }
    }

    public static boolean isUserSpecifiedSolverProperty(EStructuralFeature eStructuralFeature) {
        boolean bl = false;
        EClass eClass = eStructuralFeature.getEContainingClass();
        if (eClass.equals(FdPackage.eINSTANCE.getFiniteDifference())) {
            bl = true;
        }
        return bl;
    }

    public FdSolverPropertyEditor(Composite composite, int n) {
        super(composite, n);
    }

    public void populate(Solver solver) {
        super.populate(solver);
        for (Map.Entry<EStructuralFeature, Text> entry : this.map.entrySet()) {
            entry.getKey().getFeatureID();
        }
    }

    public boolean validate() {
        boolean bl = true;
        return bl;
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public Solver createAndPopulateSolver() {
        FiniteDifference finiteDifference = FdFactory.eINSTANCE.createFiniteDifference();
        this.populate((Solver)finiteDifference);
        return finiteDifference;
    }
}

