/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.analysis.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.stem.analysis.AnalysisPackage;
import org.eclipse.stem.analysis.DiseaseType;
import org.eclipse.stem.analysis.ReferenceScenarioDataMap;
import org.eclipse.stem.analysis.States;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceScenarioDataMapImpl
extends EObjectImpl
implements ReferenceScenarioDataMap {
    public static final String ITERATION_KEY = "iteration";
    public static final String INCIDENCE_KEY = "Incidence";
    public static final String TIME_KEY = "time";
    private double maxIncidence = 0.0;
    private String maxIncidenceLocation;
    Map<String, ReferenceScenarioDataInstance> referenceScenarioDataMap = new HashMap<String, ReferenceScenarioDataInstance>();
    private String refDir;
    DiseaseType type;

    protected ReferenceScenarioDataMapImpl() {
    }

    protected EClass eStaticClass() {
        return AnalysisPackage.Literals.REFERENCE_SCENARIO_DATA_MAP;
    }

    public void addInstance(String string, ReferenceScenarioDataInstance referenceScenarioDataInstance) {
        this.referenceScenarioDataMap.put(string, referenceScenarioDataInstance);
    }

    public void findMaxIncidence() {
        Iterator<String> iterator = this.referenceScenarioDataMap.keySet().iterator();
        while (iterator != null && iterator.hasNext()) {
            String string = iterator.next();
            ReferenceScenarioDataInstance referenceScenarioDataInstance = this.referenceScenarioDataMap.get(string);
            double d = this.getTotalIncidence(referenceScenarioDataInstance);
            if (!(d >= this.maxIncidence)) continue;
            this.maxIncidence = d;
            this.maxIncidenceLocation = string;
        }
    }

    public DiseaseType getType() {
        if (this.referenceScenarioDataMap == null || this.referenceScenarioDataMap.size() == 0) {
            return null;
        }
        return this.type;
    }

    public void setType(DiseaseType diseaseType) {
        this.type = diseaseType;
    }

    public int getNumLocations() {
        return this.referenceScenarioDataMap.size();
    }

    public Set<String> getLocations() {
        return this.referenceScenarioDataMap.keySet();
    }

    public double getTotalIncidence(ReferenceScenarioDataInstance referenceScenarioDataInstance) {
        double d = 0.0;
        if (referenceScenarioDataInstance.getData().containsKey(INCIDENCE_KEY)) {
            List<Double> list = referenceScenarioDataInstance.getData().get(INCIDENCE_KEY);
            int n = 0;
            while (n < list.size()) {
                d += list.get(n).doubleValue();
                ++n;
            }
        }
        return d;
    }

    public boolean containsLocation(String string) {
        return this.referenceScenarioDataMap.containsKey(string);
    }

    public ReferenceScenarioDataInstance getLocation(String string) {
        return this.referenceScenarioDataMap.get(string);
    }

    public ReferenceScenarioDataInstance aggregateScenarioData(IRunnableContext iRunnableContext) {
        final ReferenceScenarioDataInstance referenceScenarioDataInstance = new ReferenceScenarioDataInstance(this);
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) {
                iProgressMonitor.beginTask("Aggregating data...", ReferenceScenarioDataMapImpl.this.referenceScenarioDataMap.size());
                Iterator<String> iterator = ReferenceScenarioDataMapImpl.this.referenceScenarioDataMap.keySet().iterator();
                while (iterator != null && iterator.hasNext()) {
                    iProgressMonitor.worked(1);
                    if (iProgressMonitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    String string = iterator.next();
                    ReferenceScenarioDataInstance referenceScenarioDataInstance2 = ReferenceScenarioDataMapImpl.this.referenceScenarioDataMap.get(string);
                    referenceScenarioDataInstance.integrateData(referenceScenarioDataInstance2.instance);
                }
                iProgressMonitor.done();
            }
        };
        try {
            iRunnableContext.run(true, true, iRunnableWithProgress);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
        return referenceScenarioDataInstance;
    }

    public String getReferenceDirectory() {
        return this.refDir;
    }

    public void setReferenceDirectory(String string) {
        this.refDir = string;
    }

    public double getMaxIncidence() {
        return this.maxIncidence;
    }

    public String getMaxIncidenceLocation() {
        return this.maxIncidenceLocation;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ReferenceScenarioDataInstance
    implements Cloneable {
        private double maxS = 0.0;
        private double maxE = 0.0;
        private double maxI = 0.0;
        private double maxR = 0.0;
        public Map<String, List<String>> instance;
        protected ReferenceScenarioDataMapImpl dataMap;

        public ReferenceScenarioDataInstance(Map<String, List<String>> map, ReferenceScenarioDataMapImpl referenceScenarioDataMapImpl2) {
            this.instance = map;
            this.dataMap = referenceScenarioDataMapImpl2;
        }

        public ReferenceScenarioDataInstance(ReferenceScenarioDataMapImpl referenceScenarioDataMapImpl2) {
            this.instance = new HashMap<String, List<String>>();
            this.dataMap = referenceScenarioDataMapImpl2;
        }

        public ReferenceScenarioDataInstance clone() {
            this.getData();
            ReferenceScenarioDataInstance referenceScenarioDataInstance = new ReferenceScenarioDataInstance(this.dataMap);
            for (String string : this.instance.keySet()) {
                List<String> list = this.instance.get(string);
                ArrayList<String> arrayList = new ArrayList<String>();
                int n = 0;
                while (n < list.size()) {
                    String string2 = list.get(n);
                    arrayList.add(string2);
                    ++n;
                }
                referenceScenarioDataInstance.instance.put(string, arrayList);
            }
            referenceScenarioDataInstance.getData();
            return referenceScenarioDataInstance;
        }

        public void integrateData(Map<String, List<String>> map) {
            Iterator<String> iterator = map.keySet().iterator();
            while (iterator != null && iterator.hasNext()) {
                String string = iterator.next();
                List<String> list = map.get(string);
                if (list.size() < 1) continue;
                List<Object> list2 = new ArrayList();
                if (this.instance.containsKey(string)) {
                    list2 = this.instance.get(string);
                } else {
                    int n = 0;
                    while (n < list.size()) {
                        list2.add("0.0");
                        ++n;
                    }
                    this.instance.put(string, list2);
                }
                String string2 = list.get(0);
                boolean bl = true;
                try {
                    new Double(string2).doubleValue();
                }
                catch (NumberFormatException numberFormatException) {
                    bl = false;
                }
                int n = 0;
                while (n < list.size()) {
                    String string3 = list.get(n);
                    if (bl) {
                        double d = new Double(string3);
                        double d2 = new Double((String)list2.get(n));
                        d2 = string.indexOf(ReferenceScenarioDataMapImpl.ITERATION_KEY) == -1 ? (d2 += d) : d;
                        list2.set(n, "" + d2);
                        this.instance.put(string, list2);
                    } else {
                        list2.set(n, string3);
                        this.instance.put(string, list2);
                    }
                    ++n;
                }
            }
        }

        public List<String> getData(String string) {
            return this.instance.get(string);
        }

        public boolean containsParameter(String string) {
            return this.instance.containsKey(string);
        }

        public Map<String, List<String>> getInstance() {
            return this.instance;
        }

        public void findMaxValues() {
            double d;
            int n;
            List<String> list = this.getData(States.statesToFit[0]);
            List<String> list2 = null;
            List<String> list3 = this.getData(States.statesToFit[2]);
            List<String> list4 = null;
            if (this.dataMap.getType() == DiseaseType.SEIR) {
                list2 = this.getData(States.statesToFit[1]);
            }
            if (this.dataMap.getType() != DiseaseType.SI) {
                list4 = this.getData(States.statesToFit[3]);
            }
            if (list != null) {
                this.maxS = new Double(list.get(0));
                n = 0;
                while (n < list.size()) {
                    d = new Double(list.get(n));
                    if (d > this.maxS) {
                        this.maxS = d;
                    }
                    ++n;
                }
            }
            if (list2 != null) {
                this.maxE = new Double(list2.get(0));
                n = 0;
                while (n < list2.size()) {
                    d = new Double(list2.get(n));
                    if (d > this.maxE) {
                        this.maxE = d;
                    }
                    ++n;
                }
            }
            if (list3 != null) {
                this.maxI = new Double(list3.get(0));
                n = 0;
                while (n < list3.size()) {
                    d = new Double(list3.get(n));
                    if (d > this.maxI) {
                        this.maxI = d;
                    }
                    ++n;
                }
            }
            if (list4 != null) {
                this.maxR = new Double(list4.get(0));
                n = 0;
                while (n < list4.size()) {
                    d = new Double(list4.get(n));
                    if (d > this.maxR) {
                        this.maxR = d;
                    }
                    ++n;
                }
            }
        }

        public Map<String, List<Double>> getData() {
            HashMap<String, List<Double>> hashMap = new HashMap<String, List<Double>>();
            for (String string : this.instance.keySet()) {
                ArrayList<Double> arrayList = new ArrayList<Double>();
                if (string.equalsIgnoreCase(ReferenceScenarioDataMapImpl.TIME_KEY)) continue;
                for (String string2 : this.instance.get(string)) {
                    arrayList.add(Double.parseDouble(string2));
                }
                hashMap.put(string, arrayList);
            }
            return hashMap;
        }

        public double getMaxS() {
            return this.maxS;
        }

        public double getMaxE() {
            return this.maxE;
        }

        public double getMaxI() {
            return this.maxI;
        }

        public double getMaxR() {
            return this.maxR;
        }

        public int getSize() {
            if (this.instance.size() == 0) {
                return 0;
            }
            return this.instance.values().iterator().next().size();
        }
    }
}

