/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.analysis.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.stem.analysis.Activator;
import org.eclipse.stem.analysis.AnalysisFactory;
import org.eclipse.stem.analysis.DiseaseType;
import org.eclipse.stem.analysis.ScenarioInitializationException;
import org.eclipse.stem.analysis.impl.AnalysisFactoryImpl;
import org.eclipse.stem.analysis.impl.ReferenceScenarioDataMapImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVscenarioLoader {
    private String directory = "";
    private static final String CSV_EXTENSION = ".csv";
    private List<File> diseaseData = new ArrayList<File>();
    private final Map<String, String> runParameters = new HashMap<String, String>();
    public static final String RUN_PARAMETER_FILE_NAME = "runparameters.csv";
    public static final String RUN_PARAMETER_FILE_NAME_OLD = "runparamters.csv";
    private AnalysisFactory aFactory = new AnalysisFactoryImpl();

    public CSVscenarioLoader(String string) throws ScenarioInitializationException {
        this.directory = string;
        this.diseaseData = this.getDataFiles();
    }

    public CSVscenarioLoader() {
    }

    private List<File> getDataFiles() throws ScenarioInitializationException {
        ArrayList<File> arrayList = new ArrayList<File>();
        File[] fileArray = new File[]{};
        File file = new File(this.directory);
        if (!file.exists() || !file.isDirectory()) {
            throw new ScenarioInitializationException("Cannot find file: " + file);
        }
        fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            File file2 = fileArray[n];
            if (this.isDataFile(file2)) {
                arrayList.add(file2);
            }
            if (this.isRunParameterFile(file2)) {
                this.readRunParameters(file2);
            }
            ++n;
        }
        if (arrayList.size() == 0) {
            throw new ScenarioInitializationException("No data files found!");
        }
        return arrayList;
    }

    public static boolean validate(String string) {
        File file = new File(string);
        return file.exists();
    }

    private boolean isDataFile(File file) {
        boolean bl = true;
        String string = file.getName();
        if (string.indexOf(RUN_PARAMETER_FILE_NAME) >= 0 || string.indexOf(RUN_PARAMETER_FILE_NAME_OLD) >= 0) {
            bl = false;
        }
        if (string.indexOf(CSV_EXTENSION) < 0) {
            bl = false;
        }
        return bl;
    }

    private boolean isRunParameterFile(File file) {
        boolean bl = false;
        String string = file.getName();
        if (string.indexOf(RUN_PARAMETER_FILE_NAME) >= 0 || string.indexOf(RUN_PARAMETER_FILE_NAME_OLD) >= 0) {
            bl = true;
        }
        return bl;
    }

    private void readRunParameters(File file) {
        block9: {
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                if (bufferedReader == null) break block9;
                String string = null;
                StringTokenizer stringTokenizer = null;
                StringTokenizer stringTokenizer2 = null;
                int n = 0;
                while (!CSVscenarioLoader.EOF(string = bufferedReader.readLine())) {
                    if (n == 0) {
                        stringTokenizer = new StringTokenizer(string, ",");
                    } else {
                        stringTokenizer2 = new StringTokenizer(string, ",");
                    }
                    ++n;
                }
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = null;
                    try {
                        string2 = stringTokenizer2.nextToken();
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        Activator.logError("Mismatch between columns and values in run parameter file", noSuchElementException);
                        return;
                    }
                    this.runParameters.put(stringTokenizer.nextToken(), string2);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                Activator.logError("CVSscenarioLoader.readRunParametersFile() run parameters file not found: ", fileNotFoundException);
            }
            catch (IOException iOException) {
                Activator.logError("CVSscenarioLoader.readRunParametersFile() io exception: ", iOException);
            }
        }
    }

    public ReferenceScenarioDataMapImpl parseAllFiles(Set<String> set, int n) throws ScenarioInitializationException {
        DiseaseType diseaseType;
        ReferenceScenarioDataMapImpl referenceScenarioDataMapImpl = (ReferenceScenarioDataMapImpl)this.aFactory.createReferenceScenarioDataMap();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        while (n2 < this.diseaseData.size()) {
            File file = this.diseaseData.get(n2);
            String string = file.getName();
            int n3 = string.lastIndexOf(95);
            int n4 = string.lastIndexOf(46);
            if (n3 >= 0 && n4 >= 0 && n4 >= n3) {
                String string2 = string.substring(0, n3);
                if (!arrayList.contains(string2)) {
                    arrayList.add(string2);
                }
                int n5 = Integer.parseInt(string.substring(n3 + 1, n4));
                if (n == -1 || n5 == n) {
                    this.processAndFilterFiles(set, referenceScenarioDataMapImpl, string2, file);
                }
            }
            ++n2;
        }
        referenceScenarioDataMapImpl.setReferenceDirectory(this.directory);
        if (arrayList.contains("S") && arrayList.contains("E") && arrayList.contains("I") && arrayList.contains("R")) {
            diseaseType = DiseaseType.SEIR;
        } else if (arrayList.contains("S") && arrayList.contains("I") && arrayList.contains("R")) {
            diseaseType = DiseaseType.SIR;
        } else if (arrayList.contains("S") && arrayList.contains("I")) {
            diseaseType = DiseaseType.SI;
        } else {
            throw new ScenarioInitializationException("Disease type not recognized in directory: " + this.directory);
        }
        referenceScenarioDataMapImpl.setType(diseaseType);
        return referenceScenarioDataMapImpl;
    }

    public ReferenceScenarioDataMapImpl parseAllFiles(int n) throws ScenarioInitializationException {
        DiseaseType diseaseType;
        ReferenceScenarioDataMapImpl referenceScenarioDataMapImpl = (ReferenceScenarioDataMapImpl)this.aFactory.createReferenceScenarioDataMap();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        while (n2 < this.diseaseData.size()) {
            File file = this.diseaseData.get(n2);
            String string = file.getName();
            int n3 = string.lastIndexOf(95);
            int n4 = string.lastIndexOf(46);
            if (n3 >= 0 && n4 >= 0 && n4 >= n3) {
                String string2 = string.substring(0, n3);
                if (!arrayList.contains(string2)) {
                    arrayList.add(string2);
                }
                int n5 = Integer.parseInt(string.substring(n3 + 1, n4));
                if (n == -1 || n5 == n) {
                    this.processFile(referenceScenarioDataMapImpl, string2, file);
                }
            }
            ++n2;
        }
        referenceScenarioDataMapImpl.setReferenceDirectory(this.directory);
        if (arrayList.contains("S") && arrayList.contains("E") && arrayList.contains("I") && arrayList.contains("R")) {
            diseaseType = DiseaseType.SEIR;
        } else if (arrayList.contains("S") && arrayList.contains("I") && arrayList.contains("R")) {
            diseaseType = DiseaseType.SIR;
        } else if (arrayList.contains("S") && arrayList.contains("I")) {
            diseaseType = DiseaseType.SI;
        } else {
            throw new ScenarioInitializationException("Disease type not recognized in directory: " + this.directory);
        }
        referenceScenarioDataMapImpl.setType(diseaseType);
        return referenceScenarioDataMapImpl;
    }

    public ReferenceScenarioDataMapImpl parseAllFiles() throws ScenarioInitializationException {
        return this.parseAllFiles(null, -1);
    }

    public DiseaseType getType() throws ScenarioInitializationException {
        DiseaseType diseaseType;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < this.diseaseData.size()) {
            String string;
            File file = this.diseaseData.get(n);
            String string2 = file.getName();
            int n2 = string2.lastIndexOf(95);
            int n3 = string2.lastIndexOf(46);
            if (n2 >= 0 && n3 >= 0 && n3 >= n2 && !arrayList.contains(string = string2.substring(0, n2))) {
                arrayList.add(string);
            }
            ++n;
        }
        if (arrayList.contains("S") && arrayList.contains("E") && arrayList.contains("I") && arrayList.contains("R")) {
            diseaseType = DiseaseType.SEIR;
        } else if (arrayList.contains("S") && arrayList.contains("I") && arrayList.contains("R")) {
            diseaseType = DiseaseType.SIR;
        } else if (arrayList.contains("S") && arrayList.contains("I")) {
            diseaseType = DiseaseType.SI;
        } else {
            throw new ScenarioInitializationException("Disease type not recognized in directory: " + this.directory);
        }
        return diseaseType;
    }

    public ArrayList<Integer> getResolutions() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = 0;
        while (n < this.diseaseData.size()) {
            int n2;
            File file = this.diseaseData.get(n);
            String string = file.getName();
            int n3 = string.lastIndexOf(95);
            int n4 = string.lastIndexOf(46);
            if (n3 >= 0 && n4 >= 0 && n4 >= n3 && !arrayList.contains(n2 = Integer.parseInt(string.substring(n3 + 1, n4)))) {
                arrayList.add(n2);
            }
            ++n;
        }
        return arrayList;
    }

    public int getMaxResolution() {
        int n = -1;
        int n2 = 0;
        while (n2 < this.diseaseData.size()) {
            int n3;
            File file = this.diseaseData.get(n2);
            String string = file.getName();
            int n4 = string.lastIndexOf(95);
            int n5 = string.lastIndexOf(46);
            if (n4 >= 0 && n5 >= 0 && n5 >= n4 && n < (n3 = Integer.parseInt(string.substring(n4 + 1, n5)))) {
                n = n3;
            }
            ++n2;
        }
        return n;
    }

    public void processFile(ReferenceScenarioDataMapImpl referenceScenarioDataMapImpl, String string, File file) throws ScenarioInitializationException {
        try {
            String string2;
            Map<String, List<String>> map;
            Object object;
            int n = 0;
            ArrayList<String> arrayList = new ArrayList<String>();
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            String string3 = bufferedReader.readLine();
            if (string3 != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken().trim();
                    arrayList.add(string4);
                }
            }
            int n2 = arrayList.size();
            int n3 = 0;
            while (n3 < n2) {
                String string5 = (String)arrayList.get(n3);
                if (!string5.equals("iteration") && !string5.equals("time")) {
                    object = null;
                    if (!referenceScenarioDataMapImpl.containsLocation(string5)) {
                        map = new HashMap();
                        ReferenceScenarioDataMapImpl referenceScenarioDataMapImpl2 = referenceScenarioDataMapImpl;
                        referenceScenarioDataMapImpl2.getClass();
                        object = referenceScenarioDataMapImpl2.new ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance(map, referenceScenarioDataMapImpl);
                        referenceScenarioDataMapImpl.addInstance(string5, (ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance)object);
                    } else {
                        object = referenceScenarioDataMapImpl.getLocation(string5);
                        map = ((ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance)object).getInstance();
                    }
                    map.put(string, new ArrayList());
                }
                ++n3;
            }
            while ((string2 = bufferedReader.readLine()) != null) {
                ++n;
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                int n4 = 0;
                while (stringTokenizer.hasMoreTokens() && n4 < arrayList.size()) {
                    map = stringTokenizer.nextToken();
                    object = (String)arrayList.get(n4);
                    if (((String)object).equals("iteration") || ((String)object).equals("time")) {
                        ++n4;
                        continue;
                    }
                    ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance referenceScenarioDataInstance = referenceScenarioDataMapImpl.getLocation((String)object);
                    Map<String, List<String>> map2 = referenceScenarioDataInstance.getInstance();
                    map2.get(string).add(((String)((Object)map)).trim());
                    ++n4;
                }
            }
        }
        catch (IOException iOException) {
            Activator.logError(" IOException error!", iOException);
            throw new ScenarioInitializationException(iOException);
        }
    }

    public Set<String> getLocations(int n) throws ScenarioInitializationException {
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        while (n2 < this.diseaseData.size()) {
            File file = this.diseaseData.get(n2);
            String string = file.getName();
            int n3 = string.lastIndexOf(95);
            int n4 = string.lastIndexOf(46);
            if (n3 >= 0 && n4 >= 0 && n4 >= n3) {
                String string2 = string.substring(0, n3);
                if (!arrayList.contains(string2)) {
                    arrayList.add(string2);
                }
                int n5 = Integer.parseInt(string.substring(n3 + 1, n4));
                if (n == -1 || n5 == n) {
                    try {
                        ArrayList<String> arrayList2 = new ArrayList<String>();
                        FileInputStream fileInputStream = new FileInputStream(file);
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
                        String string3 = bufferedReader.readLine();
                        if (string3 != null) {
                            StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                            while (stringTokenizer.hasMoreTokens()) {
                                String string4 = stringTokenizer.nextToken().trim();
                                arrayList2.add(string4);
                            }
                        }
                        int n6 = arrayList2.size();
                        int n7 = 0;
                        while (n7 < n6) {
                            String string5 = (String)arrayList2.get(n7);
                            if (!string5.equals("iteration") && !string5.equals("time")) {
                                hashSet.add(string5);
                            }
                            ++n7;
                        }
                    }
                    catch (IOException iOException) {
                        Activator.logError(" IOException error!", iOException);
                        throw new ScenarioInitializationException(iOException);
                    }
                }
            }
            ++n2;
        }
        return hashSet;
    }

    public void processAndFilterFiles(Set<String> set, ReferenceScenarioDataMapImpl referenceScenarioDataMapImpl, String string, File file) throws ScenarioInitializationException {
        try {
            String string2;
            Map<String, List<String>> map;
            Object object;
            int n = 0;
            ArrayList<String> arrayList = new ArrayList<String>();
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            String string3 = bufferedReader.readLine();
            if (string3 != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken().trim();
                    arrayList.add(string4);
                }
            }
            int n2 = arrayList.size();
            int n3 = 0;
            while (n3 < n2) {
                String string5 = (String)arrayList.get(n3);
                if (!(set != null && !set.contains(string5) || string5.equals("iteration") || string5.equals("time"))) {
                    object = null;
                    if (!referenceScenarioDataMapImpl.containsLocation(string5)) {
                        map = new HashMap();
                        ReferenceScenarioDataMapImpl referenceScenarioDataMapImpl2 = referenceScenarioDataMapImpl;
                        referenceScenarioDataMapImpl2.getClass();
                        object = referenceScenarioDataMapImpl2.new ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance(map, referenceScenarioDataMapImpl);
                        referenceScenarioDataMapImpl.addInstance(string5, (ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance)object);
                    } else {
                        object = referenceScenarioDataMapImpl.getLocation(string5);
                        map = ((ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance)object).getInstance();
                    }
                    map.put(string, new ArrayList());
                }
                ++n3;
            }
            while ((string2 = bufferedReader.readLine()) != null) {
                ++n;
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                int n4 = 0;
                while (stringTokenizer.hasMoreTokens() && n4 < arrayList.size()) {
                    map = stringTokenizer.nextToken();
                    object = (String)arrayList.get(n4);
                    if (set == null || set.contains(object)) {
                        if (((String)object).equals("iteration") || ((String)object).equals("time")) {
                            ++n4;
                            continue;
                        }
                        ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance referenceScenarioDataInstance = referenceScenarioDataMapImpl.getLocation((String)object);
                        Map<String, List<String>> map2 = referenceScenarioDataInstance.getInstance();
                        map2.get(string).add(((String)((Object)map)).trim());
                    }
                    ++n4;
                }
            }
        }
        catch (IOException iOException) {
            Activator.logError(" IOException error!", iOException);
            throw new ScenarioInitializationException(iOException);
        }
    }

    public ReferenceScenarioDataMapImpl parseAggregateFile(String string) throws ScenarioInitializationException {
        ReferenceScenarioDataMapImpl referenceScenarioDataMapImpl = (ReferenceScenarioDataMapImpl)this.aFactory.createReferenceScenarioDataMap();
        File file = new File(string);
        String string2 = file.getName();
        int n = string2.indexOf(".");
        String string3 = string2.substring(0, n);
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        try {
            String string4;
            int n2 = 0;
            ArrayList<String> arrayList = new ArrayList<String>();
            FileInputStream fileInputStream = new FileInputStream(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            String string5 = bufferedReader.readLine();
            if (string5 != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string5);
                while (stringTokenizer.hasMoreTokens()) {
                    String string6 = stringTokenizer.nextToken(",");
                    arrayList.add(string6.trim());
                }
            }
            int n3 = arrayList.size();
            int n4 = 0;
            while (n4 < n3) {
                String string7 = (String)arrayList.get(n4);
                hashMap.put(string7, new ArrayList());
                ++n4;
            }
            while ((string4 = bufferedReader.readLine()) != null) {
                ++n2;
                StringTokenizer stringTokenizer = new StringTokenizer(string4);
                int n5 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    String string8 = stringTokenizer.nextToken(",");
                    String string9 = (String)arrayList.get(n5);
                    hashMap.get(string9).add(string8.trim());
                    ++n5;
                }
            }
        }
        catch (IOException iOException) {
            Activator.logError(" IOException error!", iOException);
            throw new ScenarioInitializationException(iOException);
        }
        ReferenceScenarioDataMapImpl referenceScenarioDataMapImpl2 = referenceScenarioDataMapImpl;
        referenceScenarioDataMapImpl2.getClass();
        referenceScenarioDataMapImpl.addInstance(string3, referenceScenarioDataMapImpl2.new ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance(hashMap, referenceScenarioDataMapImpl));
        return referenceScenarioDataMapImpl;
    }

    public Map<String, List<String>> processIncidenceFile(String string) throws ScenarioInitializationException {
        File file = new File(string);
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        try {
            String string2;
            int n = 0;
            ArrayList<String> arrayList = new ArrayList<String>();
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            String string3 = bufferedReader.readLine();
            if (string3 != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string3);
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken(",");
                    arrayList.add(string4.trim());
                }
            }
            int n2 = arrayList.size();
            int n3 = 0;
            while (n3 < n2) {
                String string5 = (String)arrayList.get(n3);
                hashMap.put(string5, new ArrayList());
                ++n3;
            }
            while ((string2 = bufferedReader.readLine()) != null) {
                ++n;
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                int n4 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    String string6 = stringTokenizer.nextToken(",");
                    String string7 = (String)arrayList.get(n4);
                    hashMap.get(string7).add(string6.trim());
                    ++n4;
                }
            }
        }
        catch (IOException iOException) {
            Activator.logError(" IOException error!", iOException);
            throw new ScenarioInitializationException(iOException);
        }
        return hashMap;
    }

    protected static boolean EOF(String string) {
        return string == null || string.length() == 0;
    }

    public Map<String, String> getRunParameters() {
        return this.runParameters;
    }
}

