/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.internal.data.geography.specifications;

import java.util.Properties;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.data.geography.ISOKey;
import org.eclipse.stem.definitions.labels.LabelsFactory;
import org.eclipse.stem.definitions.labels.PopulationLabel;
import org.eclipse.stem.definitions.labels.impl.PopulationLabelImpl;
import org.eclipse.stem.definitions.nodes.impl.RegionImpl;
import org.eclipse.stem.internal.data.geography.propertydata.PopulationPropertyData;
import org.eclipse.stem.internal.data.geography.specifications.AdminLevel;
import org.eclipse.stem.internal.data.geography.specifications.CountryLabelPropertyFileSpecification;
import org.eclipse.stem.internal.data.propertydata.PropertyData;

public class CountryPopulationLabelPropertyFileSpecification
extends CountryLabelPropertyFileSpecification {
    public static final String POPULATION_LABEL_NAME = "population";
    public static final String POPULATION_PROPERTY = "POPULATION";
    private static final String YEAR_PROPERTY = "YEAR";
    private String populationIdentifier = null;
    private String year;

    public CountryPopulationLabelPropertyFileSpecification() {
        super(POPULATION_LABEL_NAME);
    }

    protected PropertyData createPropertyDataInstanceFromProperty(String string, String string2) {
        return new PopulationPropertyData(new ISOKey(string), string2);
    }

    protected void collectNonDataProperties(Properties properties) {
        super.collectNonDataProperties(properties);
        this.populationIdentifier = properties.getProperty(POPULATION_PROPERTY);
        this.year = properties.getProperty(YEAR_PROPERTY);
        properties.remove(POPULATION_PROPERTY);
        properties.remove(YEAR_PROPERTY);
    }

    protected NodeLabel createLabel(AdminLevel adminLevel, ISOKey iSOKey, PropertyData propertyData) {
        PopulationPropertyData populationPropertyData = (PopulationPropertyData)propertyData;
        String string = populationPropertyData.getISOKey().toString();
        PopulationLabel populationLabel = LabelsFactory.eINSTANCE.createPopulationLabel();
        populationLabel.setURI(PopulationLabelImpl.createPopulationLabelURI((int)adminLevel.intValue(), (String)iSOKey.toString(), (String)this.populationIdentifier, (String)this.year, (String)string));
        populationLabel.setValidYear(Integer.parseInt(this.year));
        populationLabel.setURIOfIdentifiableToBeLabeled(RegionImpl.createRegionNodeURI((String)string));
        populationLabel.setPopulationIdentifier(this.populationIdentifier);
        populationLabel.getCurrentPopulationValue().setCount((double)Long.parseLong(populationPropertyData.getPopulation()));
        if (populationPropertyData.getArea() != null) {
            populationLabel.setPopulatedArea(Double.parseDouble(populationPropertyData.getArea()));
        }
        return populationLabel;
    }

    protected String getTargetPluginId() {
        return "org.eclipse.stem.data.geography.population.human";
    }

    protected String getSerializationFileNameRoot() {
        StringBuilder stringBuilder = new StringBuilder(this.isoKey.toString());
        stringBuilder.append("_");
        stringBuilder.append(this.adminLevel.toString());
        stringBuilder.append("_");
        stringBuilder.append(this.getSerializationContentDescriptor());
        stringBuilder.append("_");
        stringBuilder.append(this.labelName.toLowerCase());
        return stringBuilder.toString();
    }

    protected String getSerializationContentDescriptor() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.populationIdentifier);
        stringBuilder.append("_");
        stringBuilder.append(this.createValidDateRangeString(SERIALIZATION_CONTENT_DESCRIPTOR_DATE_FORMATER, "{0}", "{0}{1}", "{0}"));
        return stringBuilder.toString();
    }
}

