/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.geography;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.eclipse.emf.common.util.URI;
import org.eclipse.stem.geography.Activator;
import org.eclipse.stem.geography.GeographicMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeographicNames
extends GeographicMapper {
    private static final String NAMES_BUNDLE_TYPE = "names";
    public static final String LEVEL_0_ISO_NAMES_ROOT_NAME = "level0ISONames";
    private static final String LEVEL_0_RB_NAME = "org.eclipse.stem.geography.level0ISONames";
    private static ResourceBundle level0RB = null;
    private static Map<String, ResourceBundle> rbMap = new HashMap<String, ResourceBundle>();

    public static String getName(String string) {
        return GeographicNames.getName(string, GeographicNames.keyLevel(string));
    }

    public static String getName(String string, int n) {
        try {
            String string2 = string;
            if (string.length() == 3) {
                string2 = GeographicNames.getAlpha2(string);
            }
            ResourceBundle resourceBundle = GeographicNames.getResourceBundle(string2, n, "org.eclipse.stem.geography", NAMES_BUNDLE_TYPE, LEVEL_0_RB_NAME, level0RB, rbMap);
            return resourceBundle.getString(string2).trim();
        }
        catch (MissingResourceException missingResourceException) {
            return String.valueOf('!') + string + '!';
        }
        catch (NullPointerException nullPointerException) {
            return String.valueOf('!') + string + '!';
        }
    }

    public static String getName(URI uRI) {
        return GeographicNames.getName(uRI.lastSegment().toString());
    }

    public static String getReverseHierarchyName(String string) {
        StringBuilder stringBuilder = new StringBuilder(GeographicNames.getName(string));
        String string2 = string;
        int n = string2.lastIndexOf("-");
        while (n > 0) {
            string2 = string.substring(0, n);
            stringBuilder.append(", ");
            stringBuilder.append(GeographicNames.getName(string2));
            n = string2.lastIndexOf("-");
        }
        return stringBuilder.toString();
    }

    public static Object[] getSubISOKeys(String string, int n) {
        Object[] objectArray = new Object[]{};
        if (string.equals("ZZZ")) {
            Properties properties = GeographicNames.getAlpha2ToAlpha3Map();
            if (properties != null) {
                objectArray = properties.values().toArray();
            }
        } else {
            try {
                ResourceBundle resourceBundle = GeographicNames.getResourceBundle(string, n, "org.eclipse.stem.geography", NAMES_BUNDLE_TYPE, LEVEL_0_RB_NAME, level0RB, rbMap);
                ArrayList<String> arrayList = new ArrayList<String>();
                Enumeration<String> enumeration = resourceBundle.getKeys();
                while (enumeration.hasMoreElements()) {
                    String string2 = enumeration.nextElement();
                    if (!string2.startsWith(string) || GeographicNames.keyLevel(string2) != n) continue;
                    arrayList.add(string2);
                }
                objectArray = arrayList.toArray(new String[0]);
            }
            catch (MissingResourceException missingResourceException) {
                Activator.logError(missingResourceException.getMessage(), missingResourceException);
            }
        }
        return objectArray;
    }

    protected static ResourceBundle getResourceBundle(String string, int n, String string2, String string3, String string4, ResourceBundle resourceBundle, Map<String, ResourceBundle> map) {
        ResourceBundle resourceBundle2 = null;
        if (n == -1 || n == 0) {
            if (resourceBundle == null) {
                resourceBundle = ResourceBundle.getBundle(string4);
            }
            resourceBundle2 = resourceBundle;
        } else {
            String string5 = string.substring(0, 2);
            resourceBundle2 = map.get(string5);
            if (resourceBundle2 == null) {
                resourceBundle2 = GeographicNames.readResourceBundle(string5, string2, string3);
                if (resourceBundle2 == null) {
                    Activator.logError("Could not read Resource Bundle of type " + string3 + " for \"" + string5 + "\"", null);
                } else {
                    map.put(string5, resourceBundle2);
                }
            }
        }
        return resourceBundle2;
    }
}

