/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.definitions.adapters.spatial.geo;

import java.text.NumberFormat;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.URI;
import org.eclipse.stem.definitions.Activator;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLong;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLongDataProvider;

public class InlineLatLongDataProvider
implements LatLongDataProvider {
    public static final String INLINE_SCHEME = "inline";
    private static final int NUMBER_OF_FACTIONAL_DIGITS = 2;
    private static NumberFormat formatter = null;

    public LatLong getLatLong(URI uRI) {
        LatLong latLong = new LatLong();
        String[] stringArray = uRI.segments();
        try {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                LatLong.SegmentBuilder segmentBuilder = new LatLong.SegmentBuilder();
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (stringTokenizer.hasMoreTokens()) {
                        segmentBuilder.add(string2, stringTokenizer.nextToken());
                        continue;
                    }
                    Activator.logError("Inline lat/long data \"" + string + "\" is missing a longitude match for the latitude \"" + string2 + "\"", null);
                    segmentBuilder.clear();
                    break;
                }
                if (segmentBuilder.size() > 0) {
                    latLong.add(segmentBuilder.toSegment());
                }
                ++n2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            Activator.logError("Inline lat/long data is not properly formatted", numberFormatException);
        }
        return latLong;
    }

    public LatLong getLatLongNoWait(URI uRI) {
        return this.getLatLong(uRI);
    }

    public static String createSpatialInlineURIString(LatLong latLong) {
        StringBuilder stringBuilder = new StringBuilder("stemspatial:");
        stringBuilder.append(InlineLatLongDataProvider.createInlineURIString(latLong));
        return stringBuilder.toString();
    }

    public static String createInlineURIString(LatLong latLong) {
        StringBuilder stringBuilder = new StringBuilder(INLINE_SCHEME);
        stringBuilder.append("://");
        for (LatLong.Segment segment : latLong.getSegments()) {
            stringBuilder.append("/");
            stringBuilder.append(segment.toInlineURIString());
        }
        return stringBuilder.toString();
    }

    private static NumberFormat getFormatter() {
        if (formatter == null) {
            formatter = NumberFormat.getNumberInstance();
            formatter.setMaximumFractionDigits(2);
            formatter.setMinimumFractionDigits(2);
        }
        return formatter;
    }
}

