/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.definitions.adapters.spatial.geo;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LatLong {
    private static final int NUMBER_OF_FACTIONAL_DIGITS = 2;
    static NumberFormat formatter = null;
    private final List<Segment> segments = new ArrayList<Segment>();

    public void add(Segment segment) {
        this.segments.add(segment);
    }

    public void add(List<Segment> list) {
        this.segments.addAll(list);
    }

    public void add(LatLong latLong) {
        this.segments.addAll(latLong.getSegments());
    }

    public final List<Segment> getSegments() {
        return this.segments;
    }

    public final int size() {
        return this.segments.size();
    }

    public String toString() {
        return Integer.toString(this.size());
    }

    static NumberFormat getFormatter() {
        if (formatter == null) {
            formatter = NumberFormat.getNumberInstance();
            formatter.setMaximumFractionDigits(2);
            formatter.setMinimumFractionDigits(2);
        }
        return formatter;
    }

    public static class Segment {
        static final int LATITUDE_INDEX = 0;
        static final int LONGITUDE_INDEX = 1;
        private double[][] data = null;

        public Segment(double[][] dArray) {
            this.data = dArray;
        }

        public double latitude(int n) {
            return this.data[n][0];
        }

        public double longitude(int n) {
            return this.data[n][1];
        }

        public int size() {
            return this.data.length;
        }

        public boolean isPolygon() {
            int n = this.data.length;
            return n > 2 && this.data[0][0] == this.data[n - 1][0] && this.data[0][1] == this.data[n - 1][1];
        }

        public String toInlineURIString() {
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            while (n < this.data.length) {
                stringBuilder.append(LatLong.getFormatter().format(this.data[n][0]));
                stringBuilder.append(",");
                stringBuilder.append(LatLong.getFormatter().format(this.data[n][1]));
                if (n < this.data.length - 1) {
                    stringBuilder.append(",");
                }
                ++n;
            }
            return stringBuilder.toString();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.data.length > 0) {
                stringBuilder.append(LatLong.getFormatter().format(this.data[0][0]));
                stringBuilder.append(",");
                stringBuilder.append(LatLong.getFormatter().format(this.data[0][1]));
                if (this.data.length > 2) {
                    stringBuilder.append("...<" + (this.data.length - 2) + ">...");
                }
                if (this.data.length > 1) {
                    stringBuilder.append(LatLong.getFormatter().format(this.data[this.data.length - 1][0]));
                    stringBuilder.append(",");
                    stringBuilder.append(LatLong.getFormatter().format(this.data[this.data.length - 1][1]));
                }
            }
            return stringBuilder.toString();
        }

        public int hashCode() {
            double d = 1.0;
            double[][] dArray = this.data;
            int n = this.data.length;
            int n2 = 0;
            while (n2 < n) {
                double[] dArray2 = dArray[n2];
                d += Math.abs(dArray2[0] + dArray2[1]);
                ++n2;
            }
            int n3 = (int)d * 31;
            return n3 + this.data.length;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Segment segment = (Segment)object;
            if (this.data.length != segment.data.length) {
                return false;
            }
            double[][] dArray = this.data;
            int n = this.data.length;
            int n2 = 0;
            while (n2 < n) {
                double[] dArray2 = dArray[n2];
                if (dArray2[0] != dArray2[0]) {
                    return false;
                }
                if (dArray2[1] != dArray2[1]) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SegmentBuilder {
        private final List<LatLongPair> collectedPairs = new ArrayList<LatLongPair>();

        public void add(String string, String string2) {
            this.add(Double.parseDouble(string), Double.parseDouble(string2));
        }

        public void add(double d, double d2) {
            this.collectedPairs.add(new LatLongPair(d, d2));
        }

        public int size() {
            return this.collectedPairs.size();
        }

        public void clear() {
            this.collectedPairs.clear();
        }

        public Segment toSegment() {
            return this.toSegment(this.collectedPairs);
        }

        public Segment toSegment(int n) {
            return this.toSegment(this.createDownSampledPairs(n, this.collectedPairs));
        }

        private final List<LatLongPair> createDownSampledPairs(int n, List<LatLongPair> list) {
            ArrayList<LatLongPair> arrayList = new ArrayList<LatLongPair>();
            if (n >= 1) {
                int n2 = this.collectedPairs.size() - 1;
                if (n < n2) {
                    int n3 = 0;
                    for (LatLongPair latLongPair : list) {
                        if (n3 % n == 0 || n3 == n2) {
                            arrayList.add(latLongPair);
                        }
                        ++n3;
                    }
                } else {
                    arrayList.add(list.get(0));
                    arrayList.add(list.get(list.size() / 2));
                    arrayList.add(list.get(n2));
                }
            } else {
                throw new IllegalArgumentException("Sample frequency \"" + n + "\" must be 1 or greater");
            }
            return arrayList;
        }

        private Segment toSegment(List<LatLongPair> list) {
            double[][] dArray = new double[list.size()][2];
            int n = 0;
            for (LatLongPair latLongPair : list) {
                dArray[n][0] = latLongPair.latitude;
                dArray[n][1] = latLongPair.longitude;
                ++n;
            }
            return new Segment(dArray);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.size() > 0) {
                stringBuilder.append(this.collectedPairs.get(0).toString());
                if (this.size() > 2) {
                    stringBuilder.append("...<" + (this.size() - 2) + ">...");
                }
                if (this.size() > 1) {
                    stringBuilder.append(this.collectedPairs.get(this.size() - 1).toString());
                }
            }
            return stringBuilder.toString();
        }

        private static class LatLongPair {
            double latitude = 0.0;
            double longitude = 0.0;

            protected LatLongPair(double d, double d2) {
                assert (d2 >= -180.0 && d2 <= 180.0);
                assert (d >= -90.0 && d <= 90.0);
                this.latitude = d;
                this.longitude = d2;
            }

            public String toString() {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(LatLong.getFormatter().format(this.latitude));
                stringBuffer.append(", ");
                stringBuffer.append(LatLong.getFormatter().format(this.longitude));
                return stringBuffer.toString();
            }
        }
    }
}

